/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.particle;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Queue;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.Barrier;
import net.minecraft.client.particle.IParticleFactory;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleBreaking;
import net.minecraft.client.particle.ParticleBubble;
import net.minecraft.client.particle.ParticleBubbleColumnUp;
import net.minecraft.client.particle.ParticleBubblePop;
import net.minecraft.client.particle.ParticleCloud;
import net.minecraft.client.particle.ParticleCrit;
import net.minecraft.client.particle.ParticleCurrentDown;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleDragonBreath;
import net.minecraft.client.particle.ParticleDrip;
import net.minecraft.client.particle.ParticleEmitter;
import net.minecraft.client.particle.ParticleEnchantmentTable;
import net.minecraft.client.particle.ParticleEndRod;
import net.minecraft.client.particle.ParticleExplosion;
import net.minecraft.client.particle.ParticleExplosionHuge;
import net.minecraft.client.particle.ParticleExplosionLarge;
import net.minecraft.client.particle.ParticleFallingDust;
import net.minecraft.client.particle.ParticleFirework;
import net.minecraft.client.particle.ParticleFlame;
import net.minecraft.client.particle.ParticleHeart;
import net.minecraft.client.particle.ParticleLava;
import net.minecraft.client.particle.ParticleMobAppearance;
import net.minecraft.client.particle.ParticleNote;
import net.minecraft.client.particle.ParticlePortal;
import net.minecraft.client.particle.ParticleRain;
import net.minecraft.client.particle.ParticleRedstone;
import net.minecraft.client.particle.ParticleSmokeLarge;
import net.minecraft.client.particle.ParticleSmokeNormal;
import net.minecraft.client.particle.ParticleSpell;
import net.minecraft.client.particle.ParticleSpit;
import net.minecraft.client.particle.ParticleSplash;
import net.minecraft.client.particle.ParticleSquidInk;
import net.minecraft.client.particle.ParticleSuspend;
import net.minecraft.client.particle.ParticleSuspendedTown;
import net.minecraft.client.particle.ParticleSweepAttack;
import net.minecraft.client.particle.ParticleTotem;
import net.minecraft.client.particle.ParticleWaterWake;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.init.Particles;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ParticleManager {
    private static final ResourceLocation field_110737_b = new ResourceLocation("textures/particle/particles.png");
    protected World field_78878_a;
    private final ArrayDeque<Particle>[][] field_78876_b = new ArrayDeque[4][];
    private final Queue<ParticleEmitter> field_178933_d = Queues.newArrayDeque();
    private final TextureManager field_78877_c;
    private final Random field_78875_d = new Random();
    private final Int2ObjectMap<IParticleFactory<?>> field_178932_g = new Int2ObjectOpenHashMap();
    private final Queue<Particle> field_187241_h = Queues.newArrayDeque();

    public ParticleManager(World worldIn, TextureManager rendererIn) {
        this.field_78878_a = worldIn;
        this.field_78877_c = rendererIn;
        for (int i = 0; i < 4; ++i) {
            this.field_78876_b[i] = new ArrayDeque[2];
            for (int j = 0; j < 2; ++j) {
                this.field_78876_b[i][j] = Queues.newArrayDeque();
            }
        }
        this.func_178930_c();
    }

    private void func_178930_c() {
        this.func_199283_a((ParticleType)Particles.field_197608_a, (IParticleFactory)new ParticleSpell.AmbientMobFactory());
        this.func_199283_a((ParticleType)Particles.field_197609_b, (IParticleFactory)new ParticleHeart.AngryVillagerFactory());
        this.func_199283_a((ParticleType)Particles.field_197610_c, (IParticleFactory)new Barrier.Factory());
        this.func_199283_a((ParticleType)Particles.field_197611_d, (IParticleFactory)new ParticleDigging.Factory());
        this.func_199283_a((ParticleType)Particles.field_197612_e, (IParticleFactory)new ParticleBubble.Factory());
        this.func_199283_a((ParticleType)Particles.field_203220_f, (IParticleFactory)new ParticleBubbleColumnUp.Factory());
        this.func_199283_a((ParticleType)Particles.field_203217_T, (IParticleFactory)new ParticleBubblePop.Factory());
        this.func_199283_a((ParticleType)Particles.field_197613_f, (IParticleFactory)new ParticleCloud.Factory());
        this.func_199283_a((ParticleType)Particles.field_197614_g, (IParticleFactory)new ParticleCrit.Factory());
        this.func_199283_a((ParticleType)Particles.field_203218_U, (IParticleFactory)new ParticleCurrentDown.Factory());
        this.func_199283_a((ParticleType)Particles.field_197615_h, (IParticleFactory)new ParticleCrit.DamageIndicatorFactory());
        this.func_199283_a((ParticleType)Particles.field_197616_i, (IParticleFactory)new ParticleDragonBreath.Factory());
        this.func_199283_a((ParticleType)Particles.field_206864_X, (IParticleFactory)new ParticleSuspendedTown.DolphinSpeedFactory());
        this.func_199283_a((ParticleType)Particles.field_197617_j, (IParticleFactory)new ParticleDrip.LavaFactory());
        this.func_199283_a((ParticleType)Particles.field_197618_k, (IParticleFactory)new ParticleDrip.WaterFactory());
        this.func_199283_a((ParticleType)Particles.field_197619_l, (IParticleFactory)new ParticleRedstone.Factory());
        this.func_199283_a((ParticleType)Particles.field_197620_m, (IParticleFactory)new ParticleSpell.Factory());
        this.func_199283_a((ParticleType)Particles.field_197621_n, (IParticleFactory)new ParticleMobAppearance.Factory());
        this.func_199283_a((ParticleType)Particles.field_197622_o, (IParticleFactory)new ParticleCrit.MagicFactory());
        this.func_199283_a((ParticleType)Particles.field_197623_p, (IParticleFactory)new ParticleEnchantmentTable.EnchantmentTable());
        this.func_199283_a((ParticleType)Particles.field_197624_q, (IParticleFactory)new ParticleEndRod.Factory());
        this.func_199283_a((ParticleType)Particles.field_197625_r, (IParticleFactory)new ParticleSpell.MobFactory());
        this.func_199283_a((ParticleType)Particles.field_197626_s, (IParticleFactory)new ParticleExplosionHuge.Factory());
        this.func_199283_a((ParticleType)Particles.field_197627_t, (IParticleFactory)new ParticleExplosionLarge.Factory());
        this.func_199283_a((ParticleType)Particles.field_197628_u, (IParticleFactory)new ParticleFallingDust.Factory());
        this.func_199283_a((ParticleType)Particles.field_197629_v, (IParticleFactory)new ParticleFirework.Factory());
        this.func_199283_a((ParticleType)Particles.field_197630_w, (IParticleFactory)new ParticleWaterWake.Factory());
        this.func_199283_a((ParticleType)Particles.field_197631_x, (IParticleFactory)new ParticleFlame.Factory());
        this.func_199283_a((ParticleType)Particles.field_197632_y, (IParticleFactory)new ParticleSuspendedTown.HappyVillagerFactory());
        this.func_199283_a((ParticleType)Particles.field_197633_z, (IParticleFactory)new ParticleHeart.Factory());
        this.func_199283_a((ParticleType)Particles.field_197590_A, (IParticleFactory)new ParticleSpell.InstantFactory());
        this.func_199283_a((ParticleType)Particles.field_197591_B, (IParticleFactory)new ParticleBreaking.Factory());
        this.func_199283_a((ParticleType)Particles.field_197592_C, (IParticleFactory)new ParticleBreaking.SlimeFactory());
        this.func_199283_a((ParticleType)Particles.field_197593_D, (IParticleFactory)new ParticleBreaking.SnowballFactory());
        this.func_199283_a((ParticleType)Particles.field_197594_E, (IParticleFactory)new ParticleSmokeLarge.Factory());
        this.func_199283_a((ParticleType)Particles.field_197595_F, (IParticleFactory)new ParticleLava.Factory());
        this.func_199283_a((ParticleType)Particles.field_197596_G, (IParticleFactory)new ParticleSuspendedTown.Factory());
        this.func_199283_a((ParticleType)Particles.field_205167_W, (IParticleFactory)new ParticleEnchantmentTable.NautilusFactory());
        this.func_199283_a((ParticleType)Particles.field_197597_H, (IParticleFactory)new ParticleNote.Factory());
        this.func_199283_a((ParticleType)Particles.field_197598_I, (IParticleFactory)new ParticleExplosion.Factory());
        this.func_199283_a((ParticleType)Particles.field_197599_J, (IParticleFactory)new ParticlePortal.Factory());
        this.func_199283_a((ParticleType)Particles.field_197600_K, (IParticleFactory)new ParticleRain.Factory());
        this.func_199283_a((ParticleType)Particles.field_197601_L, (IParticleFactory)new ParticleSmokeNormal.Factory());
        this.func_199283_a((ParticleType)Particles.field_197602_M, (IParticleFactory)new ParticleSpit.Factory());
        this.func_199283_a((ParticleType)Particles.field_197603_N, (IParticleFactory)new ParticleSweepAttack.Factory());
        this.func_199283_a((ParticleType)Particles.field_197604_O, (IParticleFactory)new ParticleTotem.Factory());
        this.func_199283_a((ParticleType)Particles.field_203219_V, (IParticleFactory)new ParticleSquidInk.Factory());
        this.func_199283_a((ParticleType)Particles.field_197605_P, (IParticleFactory)new ParticleSuspend.Factory());
        this.func_199283_a((ParticleType)Particles.field_197606_Q, (IParticleFactory)new ParticleSplash.Factory());
        this.func_199283_a((ParticleType)Particles.field_197607_R, (IParticleFactory)new ParticleSpell.WitchFactory());
    }

    public <T extends IParticleData> void func_199283_a(ParticleType<T> particleTypeIn, IParticleFactory<T> particleFactoryIn) {
        this.field_178932_g.put(IRegistry.field_212632_u.func_148757_b(particleTypeIn), particleFactoryIn);
    }

    public void func_199282_a(Entity entityIn, IParticleData particleData) {
        this.field_178933_d.add(new ParticleEmitter(this.field_78878_a, entityIn, particleData));
    }

    public void func_199281_a(Entity entityIn, IParticleData dataIn, int lifetimeIn) {
        this.field_178933_d.add(new ParticleEmitter(this.field_78878_a, entityIn, dataIn, lifetimeIn));
    }

    @Nullable
    public Particle func_199280_a(IParticleData particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        Particle particle = this.func_199927_b(particleData, x, y, z, xSpeed, ySpeed, zSpeed);
        if (particle != null) {
            this.func_78873_a(particle);
            return particle;
        }
        return null;
    }

    @Nullable
    private <T extends IParticleData> Particle func_199927_b(T particleData, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
        IParticleFactory iparticlefactory = (IParticleFactory)this.field_178932_g.get(IRegistry.field_212632_u.func_148757_b((ParticleType<? extends IParticleData>)particleData.func_197554_b()));
        return iparticlefactory == null ? null : iparticlefactory.func_199234_a(particleData, this.field_78878_a, x, y, z, xSpeed, ySpeed, zSpeed);
    }

    public void func_78873_a(Particle effect) {
        if (effect == null) {
            return;
        }
        this.field_187241_h.add(effect);
    }

    public void func_78868_a() {
        for (int i = 0; i < 4; ++i) {
            this.func_178922_a(i);
        }
        if (!this.field_178933_d.isEmpty()) {
            ArrayList list = Lists.newArrayList();
            for (ParticleEmitter particleemitter : this.field_178933_d) {
                particleemitter.func_189213_a();
                if (particleemitter.func_187113_k()) continue;
                list.add(particleemitter);
            }
            this.field_178933_d.removeAll(list);
        }
        if (!this.field_187241_h.isEmpty()) {
            Particle particle = this.field_187241_h.poll();
            while (particle != null) {
                int k;
                int j = particle.func_70537_b();
                int n = k = particle.func_187111_c() ? 0 : 1;
                if (this.field_78876_b[j][k].size() >= 16384) {
                    this.field_78876_b[j][k].removeFirst();
                }
                this.field_78876_b[j][k].add(particle);
                particle = this.field_187241_h.poll();
            }
        }
    }

    private void func_178922_a(int layer) {
        this.field_78878_a.field_72984_F.func_76320_a(String.valueOf(layer));
        for (int i = 0; i < 2; ++i) {
            this.field_78878_a.field_72984_F.func_76320_a(String.valueOf(i));
            this.func_187240_a(this.field_78876_b[layer][i]);
            this.field_78878_a.field_72984_F.func_76319_b();
        }
        this.field_78878_a.field_72984_F.func_76319_b();
    }

    private void func_187240_a(Queue<Particle> particlesIn) {
        if (!particlesIn.isEmpty()) {
            Iterator iterator = particlesIn.iterator();
            while (iterator.hasNext()) {
                Particle particle = (Particle)iterator.next();
                this.func_178923_d(particle);
                if (particle.func_187113_k()) continue;
                iterator.remove();
            }
        }
    }

    private void func_178923_d(Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
            int i = particle.func_70537_b();
            crashreportcategory.func_189529_a("Particle", (ICrashReportDetail<String>)((ICrashReportDetail)particle::toString));
            crashreportcategory.func_189529_a("Particle Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
                if (i == 0) {
                    return "MISC_TEXTURE";
                }
                if (i == 1) {
                    return "TERRAIN_TEXTURE";
                }
                return i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i;
            }));
            throw new ReportedException(crashreport);
        }
    }

    public void func_78874_a(Entity entityIn, float partialTicks) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        Particle.field_190016_K = entityIn.func_70676_i(partialTicks);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        for (int i_nf = 0; i_nf < 3; ++i_nf) {
            int i = i_nf;
            for (int j = 0; j < 2; ++j) {
                if (this.field_78876_b[i][j].isEmpty()) continue;
                switch (j) {
                    case 0: {
                        GlStateManager.func_179132_a((boolean)false);
                        break;
                    }
                    case 1: {
                        GlStateManager.func_179132_a((boolean)true);
                    }
                }
                switch (i) {
                    default: {
                        this.field_78877_c.func_110577_a(field_110737_b);
                        break;
                    }
                    case 1: {
                        this.field_78877_c.func_110577_a(TextureMap.field_110575_b);
                    }
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferbuilder = tessellator.func_178180_c();
                bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                for (Particle particle : this.field_78876_b[i][j]) {
                    try {
                        particle.func_180434_a(bufferbuilder, entityIn, partialTicks, f, f4, f1, f2, f3);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.func_85055_a(throwable, "Rendering Particle");
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                        crashreportcategory.func_189529_a("Particle", (ICrashReportDetail<String>)((ICrashReportDetail)particle::toString));
                        crashreportcategory.func_189529_a("Particle Type", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
                            if (i == 0) {
                                return "MISC_TEXTURE";
                            }
                            if (i == 1) {
                                return "TERRAIN_TEXTURE";
                            }
                            return i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i;
                        }));
                        throw new ReportedException(crashreport);
                    }
                }
                tessellator.func_78381_a();
            }
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    public void func_78872_b(Entity entityIn, float partialTick) {
        float f = ActiveRenderInfo.func_178808_b();
        float f1 = ActiveRenderInfo.func_178803_d();
        float f2 = ActiveRenderInfo.func_178805_e();
        float f3 = ActiveRenderInfo.func_178807_f();
        float f4 = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTick;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTick;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTick;
        Particle.field_190016_K = entityIn.func_70676_i(partialTick);
        for (int i = 0; i < 2; ++i) {
            ArrayDeque<Particle> queue = this.field_78876_b[3][i];
            if (queue.isEmpty()) continue;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            for (Particle particle : queue) {
                particle.func_180434_a(bufferbuilder, entityIn, partialTick, f, f4, f1, f2, f3);
            }
        }
    }

    public void func_78870_a(@Nullable World worldIn) {
        this.field_78878_a = worldIn;
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.field_78876_b[i][j].clear();
            }
        }
        this.field_178933_d.clear();
    }

    public void func_180533_a(BlockPos pos, IBlockState state) {
        if (!state.isAir((IBlockReader)this.field_78878_a, pos)) {
            VoxelShape voxelshape = state.func_196954_c((IBlockReader)this.field_78878_a, pos);
            double d0 = 0.25;
            voxelshape.func_197755_b((p_199284_3_, p_199284_5_, p_199284_7_, p_199284_9_, p_199284_11_, p_199284_13_) -> {
                double d1 = Math.min(1.0, p_199284_9_ - p_199284_3_);
                double d2 = Math.min(1.0, p_199284_11_ - p_199284_5_);
                double d3 = Math.min(1.0, p_199284_13_ - p_199284_7_);
                int i = Math.max(2, MathHelper.func_76143_f((double)(d1 / 0.25)));
                int j = Math.max(2, MathHelper.func_76143_f((double)(d2 / 0.25)));
                int k = Math.max(2, MathHelper.func_76143_f((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + p_199284_3_;
                            double d8 = d5 * d2 + p_199284_5_;
                            double d9 = d6 * d3 + p_199284_7_;
                            this.func_78873_a((Particle)new ParticleDigging(this.field_78878_a, (double)pos.func_177958_n() + d7, (double)pos.func_177956_o() + d8, (double)pos.func_177952_p() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, state).func_174846_a(pos));
                        }
                    }
                }
            });
        }
    }

    public void func_180532_a(BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = this.field_78878_a.func_180495_p(pos);
        if (iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = iblockstate.func_196954_c((IBlockReader)this.field_78878_a, pos).func_197752_a();
            double d0 = (double)i + this.field_78875_d.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + this.field_78875_d.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + this.field_78875_d.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            this.func_78873_a(new ParticleDigging(this.field_78878_a, d0, d1, d2, 0.0, 0.0, 0.0, iblockstate).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
    }

    public String func_78869_b() {
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 2; ++k) {
                i += this.field_78876_b[j][k].size();
            }
        }
        return String.valueOf(i);
    }

    public void addBlockHitEffects(BlockPos pos, RayTraceResult target) {
        IBlockState state = this.field_78878_a.func_180495_p(pos);
        if (!state.addHitEffects(this.field_78878_a, target, this)) {
            this.func_180532_a(pos, target.field_178784_b);
        }
    }
}

