/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.multiplayer;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class ChunkProviderClient
implements IChunkProvider {
    private static final Logger field_147436_a = LogManager.getLogger();
    private final Chunk field_73238_a;
    private final Long2ObjectMap<Chunk> field_73236_b = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectOpenHashMap<Chunk>(8192){

        protected void rehash(int p_rehash_1_) {
            if (p_rehash_1_ > this.key.length) {
                super.rehash(p_rehash_1_);
            }
        }
    });
    private final World field_73235_d;

    public ChunkProviderClient(World worldIn) {
        this.field_73238_a = new EmptyChunk(worldIn, 0, 0);
        this.field_73235_d = worldIn;
    }

    public void func_73234_b(int x, int z) {
        Chunk chunk = (Chunk)this.field_73236_b.remove(ChunkPos.func_77272_a((int)x, (int)z));
        if (chunk != null) {
            chunk.func_76623_d();
        }
    }

    @Nullable
    public Chunk func_186025_d(int x, int z, boolean p_186025_3_, boolean p_186025_4_) {
        Chunk chunk = (Chunk)this.field_73236_b.get(ChunkPos.func_77272_a((int)x, (int)z));
        return p_186025_4_ && chunk == null ? this.field_73238_a : chunk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_212474_a(int p_212474_1_, int p_212474_2_, PacketBuffer p_212474_3_, int p_212474_4_, boolean p_212474_5_) {
        Long2ObjectMap<Chunk> long2ObjectMap = this.field_73236_b;
        synchronized (long2ObjectMap) {
            long i = ChunkPos.func_77272_a((int)p_212474_1_, (int)p_212474_2_);
            Chunk chunk = (Chunk)this.field_73236_b.computeIfAbsent(i, p_212475_3_ -> new Chunk(this.field_73235_d, p_212474_1_, p_212474_2_, new Biome[256]));
            chunk.func_186033_a(p_212474_3_, p_212474_4_, p_212474_5_);
            MinecraftForge.EVENT_BUS.post((Event)new ChunkEvent.Load((IChunk)chunk));
            chunk.func_177417_c(true);
            return chunk;
        }
    }

    public boolean func_73156_b(BooleanSupplier p_73156_1_) {
        long i = Util.func_211177_b();
        for (Chunk chunk : this.field_73236_b.values()) {
            chunk.func_150804_b(Util.func_211177_b() - i > 5L);
        }
        if (Util.func_211177_b() - i > 100L) {
            field_147436_a.info("Warning: Clientside chunk ticking took {} ms", (Object)(Util.func_211177_b() - i));
        }
        return false;
    }

    public String func_73148_d() {
        return "MultiplayerChunkCache: " + this.field_73236_b.size() + ", " + this.field_73236_b.size();
    }

    public IChunkGenerator<?> func_201711_g() {
        return null;
    }
}

