/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.advancements;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.advancements.AdvancementTabType;
import net.minecraft.client.gui.advancements.GuiAdvancement;
import net.minecraft.client.gui.advancements.GuiAdvancementTab;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.network.Packet;
import net.minecraft.network.play.client.CPacketSeenAdvancements;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiScreenAdvancements
extends GuiScreen
implements ClientAdvancementManager.IListener {
    private static final ResourceLocation field_191943_f = new ResourceLocation("textures/gui/advancements/window.png");
    private static final ResourceLocation field_191945_g = new ResourceLocation("textures/gui/advancements/tabs.png");
    private final ClientAdvancementManager field_191946_h;
    private final Map<Advancement, GuiAdvancementTab> field_191947_i = Maps.newLinkedHashMap();
    private GuiAdvancementTab field_191940_s;
    private boolean field_191944_v;
    private static int tabPage;
    private static int maxPages;

    public GuiScreenAdvancements(ClientAdvancementManager p_i47383_1_) {
        this.field_191946_h = p_i47383_1_;
    }

    @Override
    protected void func_73866_w_() {
        this.field_191947_i.clear();
        this.field_191940_s = null;
        this.field_191946_h.func_192798_a((ClientAdvancementManager.IListener)this);
        if (this.field_191940_s == null && !this.field_191947_i.isEmpty()) {
            this.field_191946_h.func_194230_a(this.field_191947_i.values().iterator().next().func_193935_c(), true);
        } else {
            this.field_191946_h.func_194230_a(this.field_191940_s == null ? null : this.field_191940_s.func_193935_c(), true);
        }
        if (this.field_191947_i.size() > AdvancementTabType.MAX_TABS) {
            int guiLeft = (this.field_146294_l - 252) / 2;
            int guiTop = (this.field_146295_m - 140) / 2;
            this.func_189646_b(new GuiButton(101, guiLeft, guiTop - 50, 20, 20, "<"){

                @Override
                public void func_194829_a(double mouseX, double mouseY) {
                    tabPage = Math.max(tabPage - 1, 0);
                }
            });
            this.func_189646_b(new GuiButton(102, guiLeft + 252 - 20, guiTop - 50, 20, 20, ">"){

                @Override
                public void func_194829_a(double mouseX, double mouseY) {
                    tabPage = Math.min(tabPage + 1, maxPages);
                }
            });
            maxPages = this.field_191947_i.size() / AdvancementTabType.MAX_TABS;
        }
    }

    @Override
    public void func_146281_b() {
        this.field_191946_h.func_192798_a((ClientAdvancementManager.IListener)null);
        NetHandlerPlayClient nethandlerplayclient = this.field_146297_k.func_147114_u();
        if (nethandlerplayclient != null) {
            nethandlerplayclient.func_147297_a((Packet<?>)CPacketSeenAdvancements.func_194164_a());
        }
    }

    public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (p_mouseClicked_5_ == 0) {
            int i = (this.field_146294_l - 252) / 2;
            int j = (this.field_146295_m - 140) / 2;
            for (GuiAdvancementTab guiadvancementtab : this.field_191947_i.values()) {
                if (guiadvancementtab.getPage() != tabPage || !guiadvancementtab.func_195627_a(i, j, p_mouseClicked_1_, p_mouseClicked_3_)) continue;
                this.field_191946_h.func_194230_a(guiadvancementtab.func_193935_c(), true);
                break;
            }
        }
        return super.mouseClicked(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
    }

    @Override
    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.field_146297_k.field_71474_y.field_194146_ao.func_197976_a(p_keyPressed_1_, p_keyPressed_2_)) {
            this.field_146297_k.func_147108_a(null);
            this.field_146297_k.field_71417_B.func_198034_i();
            return true;
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int i = (this.field_146294_l - 252) / 2;
        int j = (this.field_146295_m - 140) / 2;
        this.func_146276_q_();
        this.func_191936_c(mouseX, mouseY, i, j);
        this.func_191934_b(i, j);
        this.func_191937_d(mouseX, mouseY, i, j);
        if (maxPages != 0) {
            String page = String.format("%d / %d", tabPage + 1, maxPages + 1);
            int width = this.field_146289_q.func_78256_a(page);
            GlStateManager.func_179140_f();
            this.field_146289_q.func_175063_a(page, (float)(i + 126 - width / 2), (float)(j - 44), -1);
        }
    }

    public boolean mouseDragged(double p_mouseDragged_1_, double p_mouseDragged_3_, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (p_mouseDragged_5_ != 0) {
            this.field_191944_v = false;
            return false;
        }
        if (!this.field_191944_v) {
            this.field_191944_v = true;
        } else if (this.field_191940_s != null) {
            this.field_191940_s.func_195626_a(p_mouseDragged_6_, p_mouseDragged_8_);
        }
        return true;
    }

    private void func_191936_c(int p_191936_1_, int p_191936_2_, int p_191936_3_, int p_191936_4_) {
        GuiAdvancementTab guiadvancementtab = this.field_191940_s;
        if (guiadvancementtab == null) {
            GuiScreenAdvancements.func_73734_a((int)(p_191936_3_ + 9), (int)(p_191936_4_ + 18), (int)(p_191936_3_ + 9 + 234), (int)(p_191936_4_ + 18 + 113), (int)-16777216);
            String s = I18n.func_135052_a("advancements.empty", new Object[0]);
            int i = this.field_146289_q.func_78256_a(s);
            this.field_146289_q.func_211126_b(s, (float)(p_191936_3_ + 9 + 117 - i / 2), (float)(p_191936_4_ + 18 + 56 - this.field_146289_q.field_78288_b / 2), -1);
            this.field_146289_q.func_211126_b(":(", (float)(p_191936_3_ + 9 + 117 - this.field_146289_q.func_78256_a(":(") / 2), (float)(p_191936_4_ + 18 + 113 - this.field_146289_q.field_78288_b), -1);
        } else {
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(p_191936_3_ + 9), (float)(p_191936_4_ + 18), (float)-400.0f);
            GlStateManager.func_179126_j();
            guiadvancementtab.func_191799_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179097_i();
        }
    }

    public void func_191934_b(int p_191934_1_, int p_191934_2_) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
        this.field_146297_k.func_110434_K().func_110577_a(field_191943_f);
        this.func_73729_b(p_191934_1_, p_191934_2_, 0, 0, 252, 140);
        if (this.field_191947_i.size() > 1) {
            this.field_146297_k.func_110434_K().func_110577_a(field_191945_g);
            for (GuiAdvancementTab guiadvancementtab : this.field_191947_i.values()) {
                if (guiadvancementtab.getPage() != tabPage) continue;
                guiadvancementtab.func_191798_a(p_191934_1_, p_191934_2_, guiadvancementtab == this.field_191940_s);
            }
            GlStateManager.func_179091_B();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            RenderHelper.func_74520_c();
            for (GuiAdvancementTab guiadvancementtab1 : this.field_191947_i.values()) {
                if (guiadvancementtab1.getPage() != tabPage) continue;
                guiadvancementtab1.func_191796_a(p_191934_1_, p_191934_2_, this.field_146296_j);
            }
            GlStateManager.func_179084_k();
        }
        this.field_146289_q.func_211126_b(I18n.func_135052_a("gui.advancements", new Object[0]), (float)(p_191934_1_ + 8), (float)(p_191934_2_ + 6), 0x404040);
    }

    private void func_191937_d(int p_191937_1_, int p_191937_2_, int p_191937_3_, int p_191937_4_) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.field_191940_s != null) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179126_j();
            GlStateManager.func_179109_b((float)(p_191937_3_ + 9), (float)(p_191937_4_ + 18), (float)400.0f);
            this.field_191940_s.func_192991_a(p_191937_1_ - p_191937_3_ - 9, p_191937_2_ - p_191937_4_ - 18, p_191937_3_, p_191937_4_);
            GlStateManager.func_179097_i();
            GlStateManager.func_179121_F();
        }
        if (this.field_191947_i.size() > 1) {
            for (GuiAdvancementTab guiadvancementtab : this.field_191947_i.values()) {
                if (guiadvancementtab.getPage() != tabPage || !guiadvancementtab.func_195627_a(p_191937_3_, p_191937_4_, p_191937_1_, p_191937_2_)) continue;
                this.func_146279_a(guiadvancementtab.func_191795_d(), p_191937_1_, p_191937_2_);
            }
        }
    }

    public void func_191931_a(Advancement advancementIn) {
        GuiAdvancementTab guiadvancementtab = GuiAdvancementTab.func_193936_a(this.field_146297_k, this, this.field_191947_i.size(), advancementIn);
        if (guiadvancementtab != null) {
            this.field_191947_i.put(advancementIn, guiadvancementtab);
        }
    }

    public void func_191928_b(Advancement advancementIn) {
    }

    public void func_191932_c(Advancement advancementIn) {
        GuiAdvancementTab guiadvancementtab = this.func_191935_f(advancementIn);
        if (guiadvancementtab != null) {
            guiadvancementtab.func_191800_a(advancementIn);
        }
    }

    public void func_191929_d(Advancement advancementIn) {
    }

    public void func_191933_a(Advancement advancementIn, AdvancementProgress progress) {
        GuiAdvancement guiadvancement = this.func_191938_e(advancementIn);
        if (guiadvancement != null) {
            guiadvancement.func_191824_a(progress);
        }
    }

    public void func_193982_e(@Nullable Advancement advancementIn) {
        this.field_191940_s = this.field_191947_i.get(advancementIn);
    }

    public void func_191930_a() {
        this.field_191947_i.clear();
        this.field_191940_s = null;
    }

    @Nullable
    public GuiAdvancement func_191938_e(Advancement p_191938_1_) {
        GuiAdvancementTab guiadvancementtab = this.func_191935_f(p_191938_1_);
        return guiadvancementtab == null ? null : guiadvancementtab.func_191794_b(p_191938_1_);
    }

    @Nullable
    private GuiAdvancementTab func_191935_f(Advancement p_191935_1_) {
        while (p_191935_1_.func_192070_b() != null) {
            p_191935_1_ = p_191935_1_.func_192070_b();
        }
        return this.field_191947_i.get(p_191935_1_);
    }
}

