/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.audio;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.netty.util.internal.ThreadLocalRandom;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ISoundEventListener;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.client.audio.LibraryLWJGL3;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundEventAccessor;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.IRegistry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.client.event.sound.PlayStreamingSourceEvent;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.client.event.sound.SoundSetupEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.SoundSystemLogger;
import paulscode.sound.Source;
import paulscode.sound.codecs.CodecJOrbis;

@OnlyIn(value=Dist.CLIENT)
public class SoundManager {
    private static final Marker field_148623_a = MarkerManager.getMarker((String)"SOUNDS");
    private static final Logger field_148621_b = LogManager.getLogger();
    private static final Set<ResourceLocation> field_188775_c = Sets.newHashSet();
    public final SoundHandler field_148622_c;
    private final GameSettings field_148619_d;
    private SoundSystemStarterThread field_148620_e;
    private boolean field_148617_f;
    private int field_148618_g;
    private final Map<String, ISound> field_148629_h = HashBiMap.create();
    private final Map<ISound, String> field_148630_i = ((BiMap)this.field_148629_h).inverse();
    private final Multimap<SoundCategory, String> field_188776_k = HashMultimap.create();
    private final List<ITickableSound> field_148625_l = Lists.newArrayList();
    private final Map<ISound, Integer> field_148626_m = Maps.newHashMap();
    private final Map<String, Integer> field_148624_n = Maps.newHashMap();
    private final List<ISoundEventListener> field_188777_o = Lists.newArrayList();
    private final List<String> field_189000_p = Lists.newArrayList();
    private final List<Sound> field_204261_q = Lists.newArrayList();

    public SoundManager(SoundHandler handler, GameSettings settings) {
        this.field_148622_c = handler;
        this.field_148619_d = settings;
        try {
            SoundSystemConfig.addLibrary(LibraryLWJGL3.class);
            SoundSystemConfig.setCodec((String)"ogg", CodecJOrbis.class);
            MinecraftForge.EVENT_BUS.post((Event)new SoundSetupEvent(this));
        }
        catch (SoundSystemException soundsystemexception) {
            field_148621_b.error(field_148623_a, "Error linking with the LibraryJavaSound plug-in", (Throwable)soundsystemexception);
        }
    }

    public void func_148596_a() {
        field_188775_c.clear();
        Iterator<SoundEvent> iterator = IRegistry.field_212633_v.iterator();
        while (iterator.hasNext()) {
            SoundEvent soundevent = iterator.next();
            ResourceLocation resourcelocation = soundevent.func_187503_a();
            if (this.field_148622_c.func_184398_a(resourcelocation) != null) continue;
            field_148621_b.warn("Missing sound for event: {}", (Object)IRegistry.field_212633_v.func_177774_c(soundevent));
            field_188775_c.add(resourcelocation);
        }
        this.func_148613_b();
        this.func_148608_i();
        MinecraftForge.EVENT_BUS.post((Event)new SoundLoadEvent(this));
    }

    private synchronized void func_148608_i() {
        if (!this.field_148617_f) {
            try {
                Thread thread = new Thread(() -> {
                    SoundSystemConfig.setLogger((SoundSystemLogger)new SoundSystemLogger(){

                        public void message(String p_message_1_, int p_message_2_) {
                            if (!p_message_1_.isEmpty()) {
                                field_148621_b.info(p_message_1_);
                            }
                        }

                        public void importantMessage(String p_importantMessage_1_, int p_importantMessage_2_) {
                            if (p_importantMessage_1_.startsWith("Author:")) {
                                field_148621_b.info("SoundSystem {}", (Object)p_importantMessage_1_);
                            } else if (!p_importantMessage_1_.isEmpty()) {
                                field_148621_b.warn(p_importantMessage_1_);
                            }
                        }

                        public void errorMessage(String p_errorMessage_1_, String p_errorMessage_2_, int p_errorMessage_3_) {
                            if (!p_errorMessage_2_.isEmpty()) {
                                field_148621_b.error("Error in class '{}'", (Object)p_errorMessage_1_);
                                field_148621_b.error(p_errorMessage_2_);
                            }
                        }
                    });
                    this.field_148620_e = new SoundSystemStarterThread();
                    this.field_148617_f = true;
                    this.field_148620_e.setMasterVolume(this.field_148619_d.func_186711_a(SoundCategory.MASTER));
                    Iterator<Sound> iterator = this.field_204261_q.iterator();
                    while (iterator.hasNext()) {
                        Sound sound = iterator.next();
                        this.func_204260_b(sound);
                        iterator.remove();
                    }
                    field_148621_b.info(field_148623_a, "Sound engine started");
                }, "Sound Library Loader");
                thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_148621_b));
                thread.start();
            }
            catch (RuntimeException runtimeexception) {
                field_148621_b.error(field_148623_a, "Error starting SoundSystem. Turning off sounds & music", (Throwable)runtimeexception);
                this.field_148619_d.func_186712_a(SoundCategory.MASTER, 0.0f);
                this.field_148619_d.func_74303_b();
            }
        }
    }

    private float func_188769_a(SoundCategory category) {
        return category != null && category != SoundCategory.MASTER ? this.field_148619_d.func_186711_a(category) : 1.0f;
    }

    public void func_188771_a(SoundCategory category, float volume) {
        if (this.field_148617_f) {
            if (category == SoundCategory.MASTER) {
                this.field_148620_e.setMasterVolume(volume);
            } else {
                for (String s : this.field_188776_k.get((Object)category)) {
                    ISound isound = this.field_148629_h.get(s);
                    float f = this.func_188770_e(isound);
                    if (f <= 0.0f) {
                        this.func_148602_b(isound);
                        continue;
                    }
                    this.field_148620_e.setVolume(s, f);
                }
            }
        }
    }

    public void func_148613_b() {
        if (this.field_148617_f) {
            this.func_148614_c();
            this.field_148620_e.cleanup();
            this.field_148617_f = false;
        }
    }

    public void func_148614_c() {
        if (this.field_148617_f) {
            for (String s : this.field_148629_h.keySet()) {
                this.field_148620_e.stop(s);
            }
            this.field_148629_h.clear();
            this.field_148626_m.clear();
            this.field_148625_l.clear();
            this.field_189000_p.clear();
            this.field_188776_k.clear();
            this.field_148624_n.clear();
        }
    }

    public void func_188774_a(ISoundEventListener listener) {
        this.field_188777_o.add(listener);
    }

    public void func_188773_b(ISoundEventListener listener) {
        this.field_188777_o.remove(listener);
    }

    public void func_148605_d() {
        ++this.field_148618_g;
        for (ITickableSound itickablesound : this.field_148625_l) {
            itickablesound.func_73660_a();
            if (itickablesound.func_147667_k()) {
                this.func_148602_b((ISound)itickablesound);
                continue;
            }
            String s = this.field_148630_i.get(itickablesound);
            this.field_148620_e.setVolume(s, this.func_188770_e((ISound)itickablesound));
            this.field_148620_e.setPitch(s, this.func_188772_d((ISound)itickablesound));
            this.field_148620_e.setPosition(s, itickablesound.func_147649_g(), itickablesound.func_147654_h(), itickablesound.func_147651_i());
        }
        Iterator<Map.Entry<String, ISound>> iterator = this.field_148629_h.entrySet().iterator();
        while (iterator.hasNext()) {
            int i;
            Map.Entry<String, ISound> entry = iterator.next();
            String s1 = entry.getKey();
            ISound isound = entry.getValue();
            float f = this.field_148619_d.func_186711_a(isound.func_184365_d());
            if (f <= 0.0f) {
                this.func_148602_b(isound);
            }
            if (this.field_148620_e.playing(s1) || (i = this.field_148624_n.get(s1).intValue()) > this.field_148618_g) continue;
            int j = isound.func_147652_d();
            if (isound.func_147657_c() && j > 0) {
                this.field_148626_m.put(isound, this.field_148618_g + j);
            }
            iterator.remove();
            field_148621_b.debug(field_148623_a, "Removed channel {} because it's not playing anymore", (Object)s1);
            this.field_148620_e.removeSource(s1);
            this.field_148624_n.remove(s1);
            try {
                this.field_188776_k.remove((Object)isound.func_184365_d(), (Object)s1);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (!(isound instanceof ITickableSound)) continue;
            this.field_148625_l.remove(isound);
        }
        Iterator<Map.Entry<ISound, Integer>> iterator1 = this.field_148626_m.entrySet().iterator();
        while (iterator1.hasNext()) {
            Map.Entry<ISound, Integer> entry1 = iterator1.next();
            if (this.field_148618_g < entry1.getValue()) continue;
            ISound isound1 = entry1.getKey();
            if (isound1 instanceof ITickableSound) {
                ((ITickableSound)isound1).func_73660_a();
            }
            this.func_148611_c(isound1);
            iterator1.remove();
        }
    }

    public boolean func_148597_a(ISound sound) {
        if (!this.field_148617_f) {
            return false;
        }
        String s = this.field_148630_i.get(sound);
        if (s == null) {
            return false;
        }
        return this.field_148620_e.playing(s) || this.field_148624_n.containsKey(s) && this.field_148624_n.get(s) <= this.field_148618_g;
    }

    public void func_148602_b(ISound sound) {
        String s;
        if (this.field_148617_f && (s = this.field_148630_i.get(sound)) != null) {
            this.field_148620_e.stop(s);
        }
    }

    public void func_148611_c(ISound p_sound) {
        if (this.field_148617_f) {
            if ((p_sound = ForgeHooksClient.playSound((SoundManager)this, (ISound)p_sound)) == null) {
                return;
            }
            SoundEventAccessor soundeventaccessor = p_sound.func_184366_a(this.field_148622_c);
            ResourceLocation resourcelocation = p_sound.func_147650_b();
            if (soundeventaccessor == null) {
                if (field_188775_c.add(resourcelocation)) {
                    field_148621_b.warn(field_148623_a, "Unable to play unknown soundEvent: {}", (Object)resourcelocation);
                }
            } else {
                if (!this.field_188777_o.isEmpty()) {
                    for (ISoundEventListener isoundeventlistener : this.field_188777_o) {
                        isoundeventlistener.func_184067_a(p_sound, soundeventaccessor);
                    }
                }
                if (this.field_148620_e.getMasterVolume() <= 0.0f) {
                    field_148621_b.debug(field_148623_a, "Skipped playing soundEvent: {}, master volume was zero", (Object)resourcelocation);
                } else {
                    Sound sound = p_sound.func_184364_b();
                    if (sound == SoundHandler.field_147700_a) {
                        if (field_188775_c.add(resourcelocation)) {
                            field_148621_b.warn(field_148623_a, "Unable to play empty soundEvent: {}", (Object)resourcelocation);
                        }
                    } else {
                        float f3 = p_sound.func_147653_e();
                        float f = sound.func_206255_j();
                        if (f3 > 1.0f) {
                            f *= f3;
                        }
                        SoundCategory soundcategory = p_sound.func_184365_d();
                        float f1 = this.func_188770_e(p_sound);
                        float f2 = this.func_188772_d(p_sound);
                        if (f1 == 0.0f && !p_sound.func_211503_n()) {
                            field_148621_b.debug(field_148623_a, "Skipped playing sound {}, volume was zero.", (Object)sound.func_188719_a());
                        } else {
                            boolean flag = p_sound.func_147657_c() && p_sound.func_147652_d() == 0;
                            String s = MathHelper.func_180182_a((Random)ThreadLocalRandom.current()).toString();
                            ResourceLocation resourcelocation1 = sound.func_188721_b();
                            if (sound.func_188723_h()) {
                                this.field_148620_e.newStreamingSource(p_sound.func_204200_l(), s, SoundManager.func_148612_a(resourcelocation1), resourcelocation1.toString(), flag, p_sound.func_147649_g(), p_sound.func_147654_h(), p_sound.func_147651_i(), p_sound.func_147656_j().func_148586_a(), f);
                                MinecraftForge.EVENT_BUS.post((Event)new PlayStreamingSourceEvent(this, p_sound, s));
                            } else {
                                this.field_148620_e.newSource(p_sound.func_204200_l(), s, SoundManager.func_148612_a(resourcelocation1), resourcelocation1.toString(), flag, p_sound.func_147649_g(), p_sound.func_147654_h(), p_sound.func_147651_i(), p_sound.func_147656_j().func_148586_a(), f);
                                MinecraftForge.EVENT_BUS.post((Event)new PlaySoundSourceEvent(this, p_sound, s));
                            }
                            field_148621_b.debug(field_148623_a, "Playing sound {} for event {} as channel {}", (Object)sound.func_188719_a(), (Object)resourcelocation, (Object)s);
                            this.field_148620_e.setPitch(s, f2);
                            this.field_148620_e.setVolume(s, f1);
                            this.field_148620_e.play(s);
                            this.field_148624_n.put(s, this.field_148618_g + 20);
                            this.field_148629_h.put(s, p_sound);
                            this.field_188776_k.put((Object)soundcategory, (Object)s);
                            if (p_sound instanceof ITickableSound) {
                                this.field_148625_l.add((ITickableSound)p_sound);
                            }
                        }
                    }
                }
            }
        }
    }

    public void func_204259_a(Sound soundIn) {
        this.field_204261_q.add(soundIn);
    }

    private void func_204260_b(Sound soundIn) {
        ResourceLocation resourcelocation = soundIn.func_188721_b();
        field_148621_b.info(field_148623_a, "Preloading sound {}", (Object)resourcelocation);
        this.field_148620_e.loadSound(SoundManager.func_148612_a(resourcelocation), resourcelocation.toString());
    }

    private float func_188772_d(ISound soundIn) {
        return MathHelper.func_76131_a((float)soundIn.func_147655_f(), (float)0.5f, (float)2.0f);
    }

    private float func_188770_e(ISound soundIn) {
        return MathHelper.func_76131_a((float)(soundIn.func_147653_e() * this.func_188769_a(soundIn.func_184365_d())), (float)0.0f, (float)1.0f);
    }

    public void func_148610_e() {
        for (Map.Entry<String, ISound> entry : this.field_148629_h.entrySet()) {
            String s = entry.getKey();
            boolean flag = this.func_148597_a(entry.getValue());
            if (!flag) continue;
            field_148621_b.debug(field_148623_a, "Pausing channel {}", (Object)s);
            this.field_148620_e.pause(s);
            this.field_189000_p.add(s);
        }
    }

    public void func_148604_f() {
        for (String s : this.field_189000_p) {
            field_148621_b.debug(field_148623_a, "Resuming channel {}", (Object)s);
            this.field_148620_e.play(s);
        }
        this.field_189000_p.clear();
    }

    public void func_148599_a(ISound sound, int delay) {
        this.field_148626_m.put(sound, this.field_148618_g + delay);
    }

    private static URL func_148612_a(final ResourceLocation resource) {
        String s = String.format("%s:%s:%s", "mcsounddomain", resource.func_110624_b(), resource.func_110623_a());
        URLStreamHandler urlstreamhandler = new URLStreamHandler(){

            @Override
            protected URLConnection openConnection(URL p_openConnection_1_) {
                return new URLConnection(p_openConnection_1_){

                    @Override
                    public void connect() {
                    }

                    @Override
                    public InputStream getInputStream() throws IOException {
                        return Minecraft.func_71410_x().func_195551_G().func_199002_a(resource).func_199027_b();
                    }
                };
            }
        };
        try {
            return new URL((URL)null, s, urlstreamhandler);
        }
        catch (MalformedURLException var4) {
            throw new Error("TODO: Sanely handle url exception! :D");
        }
    }

    public void func_148615_a(EntityPlayer player, float partialTicks) {
        this.setListener(player, partialTicks);
    }

    public void setListener(Entity player, float partialTicks) {
        if (this.field_148617_f && player != null) {
            float f = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * partialTicks;
            float f1 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * partialTicks;
            double d0 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double d1 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks + (double)player.func_70047_e();
            double d2 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            float f2 = MathHelper.func_76134_b((float)((f1 + 90.0f) * ((float)Math.PI / 180)));
            float f3 = MathHelper.func_76126_a((float)((f1 + 90.0f) * ((float)Math.PI / 180)));
            float f4 = MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
            float f5 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76134_b((float)((-f + 90.0f) * ((float)Math.PI / 180)));
            float f7 = MathHelper.func_76126_a((float)((-f + 90.0f) * ((float)Math.PI / 180)));
            float f8 = f2 * f4;
            float f9 = f3 * f4;
            float f10 = f2 * f6;
            float f11 = f3 * f6;
            this.field_148620_e.setListenerPosition((float)d0, (float)d1, (float)d2);
            this.field_148620_e.setListenerOrientation(f8, f5, f9, f10, f7, f11);
        }
    }

    public void func_195855_a(@Nullable ResourceLocation soundName, @Nullable SoundCategory category) {
        if (category != null) {
            for (String s : this.field_188776_k.get((Object)category)) {
                ISound isound = this.field_148629_h.get(s);
                if (soundName == null) {
                    this.func_148602_b(isound);
                    continue;
                }
                if (!isound.func_147650_b().equals((Object)soundName)) continue;
                this.func_148602_b(isound);
            }
        } else if (soundName == null) {
            this.func_148614_c();
        } else {
            for (ISound isound1 : this.field_148629_h.values()) {
                if (!isound1.func_147650_b().equals((Object)soundName)) continue;
                this.func_148602_b(isound1);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    class SoundSystemStarterThread
    extends SoundSystem {
        private SoundSystemStarterThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean playing(String p_playing_1_) {
            Object object = SoundSystemConfig.THREAD_SYNC;
            synchronized (object) {
                if (this.soundLibrary == null) {
                    return false;
                }
                HashMap map = this.soundLibrary.getSources();
                if (map == null) {
                    return false;
                }
                Source source = (Source)map.get(p_playing_1_);
                if (source == null) {
                    return false;
                }
                return source.playing() || source.paused() || source.preLoad;
            }
        }
    }
}

