/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import java.io.File;
import java.net.Proxy;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.GameSettings;
import net.minecraft.client.KeyboardListener;
import net.minecraft.client.MainWindow;
import net.minecraft.client.MouseHelper;
import net.minecraft.client.audio.MusicTicker;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.client.gui.GuiConnecting;
import net.minecraft.client.gui.GuiDirtMessageScreen;
import net.minecraft.client.gui.GuiGameOver;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.gui.GuiIngameMenu;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMemoryErrorScreen;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenLoading;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.GuiWinGame;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.IGuiEventListenerDeferred;
import net.minecraft.client.gui.advancements.GuiScreenAdvancements;
import net.minecraft.client.gui.chat.NarratorChatListener;
import net.minecraft.client.gui.fonts.FontResourceManager;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.gui.toasts.GuiToast;
import net.minecraft.client.main.GameConfiguration;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerLoginClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.GlDebugTextUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VirtualScreen;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.DownloadingPackFinder;
import net.minecraft.client.resources.FoliageColorReloadListener;
import net.minecraft.client.resources.GrassColorReloadListener;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.LanguageManager;
import net.minecraft.client.resources.LegacyResourcePackWrapper;
import net.minecraft.client.resources.ResourcePackInfoClient;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.settings.CreativeSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.tutorial.Tutorial;
import net.minecraft.client.util.ISearchTree;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.client.util.RecipeBookClient;
import net.minecraft.client.util.SearchTree;
import net.minecraft.client.util.SearchTreeManager;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ICrashReportDetail;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Bootstrap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.EnumConnectionState;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.handshake.client.CPacketHandshake;
import net.minecraft.network.login.client.CPacketLoginStart;
import net.minecraft.network.play.client.CPacketPlayerDigging;
import net.minecraft.profiler.ISnooperInfo;
import net.minecraft.profiler.Profiler;
import net.minecraft.profiler.Snooper;
import net.minecraft.resources.FolderPackFinder;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.ResourcePackList;
import net.minecraft.resources.ResourcePackType;
import net.minecraft.resources.SimpleReloadableResourceManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.server.management.PlayerProfileCache;
import net.minecraft.stats.StatisticsManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.MovementInputFromOptions;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Session;
import net.minecraft.util.Timer;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DataFixesManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.storage.AnvilSaveConverter;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.dimension.NetherDimension;
import net.minecraft.world.storage.ISaveFormat;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.StartupQuery;
import net.minecraftforge.fml.client.ClientModLoader;
import net.minecraftforge.fml.common.progress.ProgressBar;
import net.minecraftforge.fml.common.progress.StartupProgressManager;
import net.minecraftforge.fml.hooks.BasicEventHooks;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.Version;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;

@OnlyIn(value=Dist.CLIENT)
public class Minecraft
implements IThreadListener,
ISnooperInfo,
IGuiEventListenerDeferred {
    private static final Logger field_147123_G = LogManager.getLogger();
    public static final boolean field_142025_a = Util.func_110647_a() == Util.EnumOS.OSX;
    public static final ResourceLocation field_211502_b = new ResourceLocation("default");
    public static final ResourceLocation field_71464_q = new ResourceLocation("alt");
    public static byte[] field_71444_a = new byte[0xA00000];
    private static int field_211120_F = -1;
    private final File field_130070_K;
    private final PropertyMap field_181038_N;
    private final GameConfiguration.DisplayInformation field_195556_O;
    private ServerData field_71422_O;
    public TextureManager field_71446_o;
    private static Minecraft field_71432_P;
    private final DataFixer field_184131_U;
    public PlayerControllerMP field_71442_b;
    private VirtualScreen field_195557_T;
    public MainWindow field_195558_d;
    private boolean field_71434_R;
    private CrashReport field_71433_S;
    private boolean field_181541_X;
    private final Timer field_71428_T = new Timer(20.0f, 0L);
    private final Snooper field_71427_U = new Snooper("client", (ISnooperInfo)this, Util.func_211177_b());
    public WorldClient field_71441_e;
    public WorldRenderer field_71438_f;
    private RenderManager field_175616_W;
    private ItemRenderer field_175621_X;
    private FirstPersonRenderer field_175620_Y;
    public EntityPlayerSP field_71439_g;
    @Nullable
    private Entity field_175622_Z;
    @Nullable
    public Entity field_147125_j;
    public ParticleManager field_71452_i;
    private final SearchTreeManager field_193995_ae = new SearchTreeManager();
    private final Session field_71449_j;
    private boolean field_71445_n;
    private float field_193996_ah;
    public FontRenderer field_71466_p;
    @Nullable
    public GuiScreen field_71462_r;
    public GameRenderer field_71460_t;
    public DebugRenderer field_184132_p;
    int field_71429_W;
    @Nullable
    private IntegratedServer field_71437_Z;
    public GuiIngame field_71456_v;
    public boolean field_71454_w;
    public RayTraceResult field_71476_x;
    public GameSettings field_71474_y;
    private CreativeSettings field_191950_u;
    public MouseHelper field_71417_B;
    public KeyboardListener field_195559_v;
    public final File field_71412_D;
    private final File field_110446_Y;
    private final String field_110447_Z;
    private final String field_184130_ao;
    private final Proxy field_110453_aa;
    private ISaveFormat field_71469_aa;
    private static int field_71470_ab;
    private int field_71467_ac;
    private String field_71475_ae;
    private int field_71477_af;
    private int field_71457_ai;
    public final FrameTimer field_181542_y = new FrameTimer();
    private long field_181543_z = Util.func_211178_c();
    private final boolean field_147129_ai;
    private final boolean field_71459_aj;
    @Nullable
    private NetworkManager field_71453_ak;
    private boolean field_71455_al;
    public final Profiler field_71424_I = new Profiler();
    private IReloadableResourceManager field_110451_am;
    private final DownloadingPackFinder field_195554_ax;
    private final ResourcePackList<ResourcePackInfoClient> field_110448_aq;
    private LanguageManager field_135017_as;
    private BlockColors field_184127_aH;
    private ItemColors field_184128_aI;
    private Framebuffer field_147124_at;
    private TextureMap field_147128_au;
    private SoundHandler field_147127_av;
    private MusicTicker field_147126_aw;
    private FontResourceManager field_211501_aD;
    private final MinecraftSessionService field_152355_az;
    private SkinManager field_152350_aA;
    private final Queue<FutureTask<?>> field_152351_aB = Queues.newConcurrentLinkedQueue();
    private final Thread field_152352_aC = Thread.currentThread();
    private ModelManager field_175617_aL;
    private BlockRendererDispatcher field_175618_aM;
    private final GuiToast field_193034_aS;
    private volatile boolean field_71425_J = true;
    public String field_71426_K = "";
    public boolean field_175612_E = true;
    private long field_71419_L;
    private int field_71420_M;
    private final Tutorial field_193035_aW;
    boolean field_195555_I;
    private String field_71465_an = "root";

    public Minecraft(GameConfiguration gameConfig) {
        this.field_195556_O = gameConfig.field_178743_b;
        field_71432_P = this;
        ForgeHooksClient.invalidateLog4jThreadCache();
        this.field_71412_D = gameConfig.field_178744_c.field_178760_a;
        this.field_110446_Y = gameConfig.field_178744_c.field_178759_c;
        this.field_130070_K = gameConfig.field_178744_c.field_178758_b;
        this.field_110447_Z = gameConfig.field_178741_d.field_178755_b;
        this.field_184130_ao = gameConfig.field_178741_d.field_187053_c;
        this.field_181038_N = gameConfig.field_178745_a.field_181172_c;
        this.field_195554_ax = new DownloadingPackFinder(new File(this.field_71412_D, "server-resource-packs"), gameConfig.field_178744_c.func_187052_a());
        this.field_110448_aq = new ResourcePackList((p_211818_0_, p_211818_1_, p_211818_2_, p_211818_3_, p_211818_4_, p_211818_5_) -> {
            Supplier<IResourcePack> supplier = p_211818_4_.func_198962_b() < 4 ? () -> Minecraft.lambda$null$0((Supplier)p_211818_2_) : p_211818_2_;
            return new ResourcePackInfoClient(p_211818_0_, p_211818_1_, supplier, p_211818_3_, p_211818_4_, p_211818_5_, p_211818_3_.isHidden());
        });
        this.field_110448_aq.func_198982_a((IPackFinder)this.field_195554_ax);
        this.field_110448_aq.func_198982_a((IPackFinder)new FolderPackFinder(this.field_130070_K));
        this.field_110453_aa = gameConfig.field_178745_a.field_178751_c == null ? Proxy.NO_PROXY : gameConfig.field_178745_a.field_178751_c;
        this.field_152355_az = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString()).createMinecraftSessionService();
        this.field_71449_j = gameConfig.field_178745_a.field_178752_a;
        field_147123_G.info("Setting user: {}", (Object)this.field_71449_j.func_111285_a());
        this.field_71459_aj = gameConfig.field_178741_d.field_178756_a;
        this.field_147129_ai = Minecraft.func_147122_X();
        this.field_71437_Z = null;
        if (gameConfig.field_178742_e.field_178754_a != null) {
            this.field_71475_ae = gameConfig.field_178742_e.field_178754_a;
            this.field_71477_af = gameConfig.field_178742_e.field_178753_b;
        }
        Bootstrap.func_151354_b();
        TextComponentKeybind.field_193637_b = KeyBinding::func_193626_b;
        this.field_184131_U = DataFixesManager.func_210901_a();
        this.field_193034_aS = new GuiToast(this);
        this.field_193035_aW = new Tutorial(this);
    }

    public void func_99999_d() {
        block14: {
            this.field_71425_J = true;
            try {
                this.func_71384_a();
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a(throwable, "Initializing game");
                crashreport.func_85058_a("Initialization");
                this.func_71377_b(this.func_71396_d(crashreport));
                return;
            }
            try {
                while (this.field_71425_J) {
                    if (!this.field_71434_R || this.field_71433_S == null) {
                        try {
                            this.func_195542_b(true);
                        }
                        catch (OutOfMemoryError var9) {
                            this.func_71398_f();
                            this.func_147108_a((GuiScreen)new GuiMemoryErrorScreen());
                            System.gc();
                        }
                        continue;
                    }
                    this.func_71377_b(this.field_71433_S);
                }
            }
            catch (ReportedException reportedexception) {
                this.func_71396_d(reportedexception.func_71575_a());
                this.func_71398_f();
                field_147123_G.fatal("Reported exception thrown!", (Throwable)reportedexception);
                this.func_71377_b(reportedexception.func_71575_a());
                break block14;
            }
            catch (Throwable throwable1) {
                CrashReport crashreport1 = this.func_71396_d(new CrashReport("Unexpected error", throwable1));
                this.func_71398_f();
                field_147123_G.fatal("Unreported exception thrown!", throwable1);
                this.func_71377_b(crashreport1);
                break block14;
            }
            finally {
                this.func_71405_e();
            }
            return;
        }
    }

    private void func_71384_a() {
        this.field_71474_y = new GameSettings(this, this.field_71412_D);
        this.field_191950_u = new CreativeSettings(this.field_71412_D, this.field_184131_U);
        this.func_71389_H();
        field_147123_G.info("LWJGL Version: {}", (Object)Version.getVersion());
        GameConfiguration.DisplayInformation gameconfiguration$displayinformation = this.field_195556_O;
        if (this.field_71474_y.field_92119_C > 0 && this.field_71474_y.field_92118_B > 0) {
            gameconfiguration$displayinformation = new GameConfiguration.DisplayInformation(this.field_71474_y.field_92118_B, this.field_71474_y.field_92119_C, gameconfiguration$displayinformation.field_199045_c, gameconfiguration$displayinformation.field_199046_d, gameconfiguration$displayinformation.field_178763_c);
        }
        this.func_211118_al();
        this.field_195557_T = new VirtualScreen(this);
        this.field_195558_d = this.field_195557_T.func_198053_a(gameconfiguration$displayinformation, this.field_71474_y.field_198019_u);
        OpenGlHelper.func_77474_a();
        GlDebugTextUtils.func_209247_b((int)this.field_71474_y.field_209231_W);
        this.field_147124_at = new Framebuffer(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l(), true);
        this.field_147124_at.func_147604_a(0.0f, 0.0f, 0.0f, 0.0f);
        this.field_110451_am = new SimpleReloadableResourceManager(ResourcePackType.CLIENT_RESOURCES);
        this.field_135017_as = new LanguageManager(this.field_71474_y.field_74363_ab);
        this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_135017_as);
        this.field_71474_y.func_198017_a(this.field_110448_aq);
        ClientModLoader.begin((Minecraft)this, this.field_110448_aq, (IReloadableResourceManager)this.field_110451_am, (DownloadingPackFinder)this.field_195554_ax);
        this.func_110436_a();
        this.field_71446_o = new TextureManager((IResourceManager)this.field_110451_am);
        this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_71446_o);
        this.field_195558_d.func_198098_h();
        this.func_147108_a((GuiScreen)new GuiScreenLoading());
        this.func_195547_ap();
        this.field_152350_aA = new SkinManager(this.field_71446_o, new File(this.field_110446_Y, "skins"), this.field_152355_az);
        this.field_71469_aa = new AnvilSaveConverter(this.field_71412_D.toPath().resolve("saves"), this.field_71412_D.toPath().resolve("backups"), this.field_184131_U);
        this.field_147127_av = new SoundHandler((IResourceManager)this.field_110451_am, this.field_71474_y);
        this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_147127_av);
        this.field_147126_aw = new MusicTicker(this);
        this.field_211501_aD = new FontResourceManager(this.field_71446_o, this.func_211821_e());
        this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_211501_aD);
        this.field_71466_p = this.field_211501_aD.func_211504_a(field_211502_b);
        if (this.field_71474_y.field_74363_ab != null) {
            this.field_71466_p.func_78275_b(this.field_135017_as.func_135044_b());
        }
        this.field_110451_am.func_199006_a((IResourceManagerReloadListener)new GrassColorReloadListener());
        this.field_110451_am.func_199006_a((IResourceManagerReloadListener)new FoliageColorReloadListener());
        try (ProgressBar bar = StartupProgressManager.start((String)"Rendering Setup", (int)5, (boolean)true);){
            bar.step("GL Setup");
            this.field_195558_d.func_198076_a("Startup");
            GlStateManager.func_179098_w();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179151_a((double)1.0);
            GlStateManager.func_179126_j();
            GlStateManager.func_179143_c((int)515);
            GlStateManager.func_179141_d();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n((int)5888);
            this.field_195558_d.func_198076_a("Post startup");
            bar.step("Loading Texture Map");
            this.field_147128_au = new TextureMap("textures");
            this.field_147128_au.func_147633_a(this.field_71474_y.field_151442_I);
            this.field_71446_o.func_110580_a(TextureMap.field_110575_b, this.field_147128_au);
            this.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.field_147128_au.func_174937_a(false, this.field_71474_y.field_151442_I > 0);
            bar.step("Loading Model Manager");
            this.field_175617_aL = new ModelManager(this.field_147128_au);
            this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_175617_aL);
            this.field_184127_aH = BlockColors.func_186723_a();
            this.field_184128_aI = ItemColors.func_186729_a(this.field_184127_aH);
            bar.step("Loading Item Renderer");
            this.field_175621_X = new ItemRenderer(this.field_71446_o, this.field_175617_aL, this.field_184128_aI);
            this.field_175616_W = new RenderManager(this.field_71446_o, this.field_175621_X);
            this.field_175620_Y = new FirstPersonRenderer(this);
            this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_175621_X);
            bar.step("Loading Entity Renderer");
            this.field_71460_t = new GameRenderer(this, (IResourceManager)this.field_110451_am);
            this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_71460_t);
            this.field_175618_aM = new BlockRendererDispatcher(this.field_175617_aL.func_174954_c(), this.field_184127_aH);
            this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_175618_aM);
            this.field_71438_f = new WorldRenderer(this);
            this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_71438_f);
            this.func_193986_ar();
            this.field_110451_am.func_199006_a((IResourceManagerReloadListener)this.field_193995_ae);
            GlStateManager.func_179083_b((int)0, (int)0, (int)this.field_195558_d.func_198109_k(), (int)this.field_195558_d.func_198091_l());
            this.field_71452_i = new ParticleManager(this.field_71441_e, this.field_71446_o);
        }
        ClientModLoader.end();
        this.field_71456_v = new GuiIngameForge(this);
        if (this.field_71475_ae != null) {
            this.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)new GuiMainMenu(), this, this.field_71475_ae, this.field_71477_af));
        } else {
            this.func_147108_a(new GuiMainMenu());
        }
        this.field_184132_p = new DebugRenderer(this);
        GLFW.glfwSetErrorCallback(this::func_195545_a).free();
        ClientModLoader.complete();
        if (this.field_71474_y.field_74353_u && !this.field_195558_d.func_198113_j()) {
            this.field_195558_d.func_198077_g();
        }
        this.field_195558_d.func_209548_c();
        this.field_195558_d.func_198112_b();
        this.field_71438_f.func_174966_b();
    }

    private void func_211118_al() {
        MainWindow.func_211162_a((p_211108_0_, p_211108_1_) -> {
            throw new IllegalStateException(String.format("GLFW error before init: [0x%X]%s", p_211108_0_, p_211108_1_));
        });
        ArrayList list = Lists.newArrayList();
        GLFWErrorCallback glfwerrorcallback = GLFW.glfwSetErrorCallback((p_211100_1_, p_211100_2_) -> list.add(String.format("GLFW error during init: [0x%X] %s", p_211100_1_, GLFWErrorCallback.getDescription((long)p_211100_2_))));
        if (!GLFW.glfwInit()) {
            throw new IllegalStateException("Failed to initialize GLFW, errors: " + Joiner.on((String)",").join((Iterable)list));
        }
        Util.field_211180_a = () -> (long)(GLFW.glfwGetTime() * 1.0E9);
        for (String s : list) {
            field_147123_G.error("GLFW error collected during initialization: {}", (Object)s);
        }
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)glfwerrorcallback).free();
    }

    public void func_193986_ar() {
        SearchTree searchtree = new SearchTree(p_193988_0_ -> p_193988_0_.func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream().map(p_211817_0_ -> TextFormatting.func_110646_a((String)p_211817_0_.getString()).trim()).filter(p_200241_0_ -> !p_200241_0_.isEmpty()).collect(Collectors.toList()), p_193985_0_ -> Collections.singleton(IRegistry.field_212630_s.func_177774_c(p_193985_0_.func_77973_b())));
        NonNullList nonnulllist = NonNullList.func_191196_a();
        Iterator<Item> iterator = IRegistry.field_212630_s.iterator();
        while (iterator.hasNext()) {
            Item item = iterator.next();
            item.func_150895_a(ItemGroup.field_78027_g, (NonNullList<ItemStack>)nonnulllist);
        }
        nonnulllist.forEach(arg_0 -> ((SearchTree)searchtree).func_194043_a(arg_0));
        SearchTree searchtree1 = new SearchTree(p_193990_0_ -> p_193990_0_.func_192711_b().stream().flatMap(p_200240_0_ -> p_200240_0_.func_77571_b().func_82840_a(null, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL).stream()).map(p_200235_0_ -> TextFormatting.func_110646_a((String)p_200235_0_.getString()).trim()).filter(p_200234_0_ -> !p_200234_0_.isEmpty()).collect(Collectors.toList()), p_193992_0_ -> p_193992_0_.func_192711_b().stream().map(p_200237_0_ -> IRegistry.field_212630_s.func_177774_c(p_200237_0_.func_77571_b().func_77973_b())).collect(Collectors.toList()));
        this.field_193995_ae.func_194009_a(SearchTreeManager.field_194011_a, searchtree);
        this.field_193995_ae.func_194009_a(SearchTreeManager.field_194012_b, searchtree1);
    }

    private void func_195545_a(int error, long description) {
        this.field_71474_y.field_74352_v = false;
        this.field_71474_y.func_74303_b();
    }

    private static boolean func_147122_X() {
        String[] astring;
        for (String s : astring = new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
            String s1 = System.getProperty(s);
            if (s1 == null || !s1.contains("64")) continue;
            return true;
        }
        return false;
    }

    public Framebuffer func_147110_a() {
        return this.field_147124_at;
    }

    public String func_175600_c() {
        return this.field_110447_Z;
    }

    public String func_184123_d() {
        return this.field_184130_ao;
    }

    private void func_71389_H() {
        Thread thread = new Thread("Timer hack thread"){

            @Override
            public void run() {
                while (Minecraft.this.field_71425_J) {
                    try {
                        Thread.sleep(Integer.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_147123_G));
        thread.start();
    }

    public void func_71404_a(CrashReport crash) {
        this.field_71434_R = true;
        this.field_71433_S = crash;
    }

    public void func_71377_b(CrashReport crashReportIn) {
        File file1 = new File(Minecraft.func_71410_x().field_71412_D, "crash-reports");
        File file2 = new File(file1, "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-client.txt");
        Bootstrap.func_179870_a(crashReportIn.func_71502_e());
        if (crashReportIn.func_71497_f() != null) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + crashReportIn.func_71497_f());
            ServerLifecycleHooks.handleExit((int)-1);
        } else if (crashReportIn.func_147149_a(file2)) {
            Bootstrap.func_179870_a("#@!@# Game crashed! Crash report saved to: #@!@# " + file2.getAbsolutePath());
            System.exit(-1);
        } else {
            Bootstrap.func_179870_a("#@?@# Game crashed! Crash report could not be saved. #@?@#");
            System.exit(-2);
        }
    }

    public boolean func_211821_e() {
        return this.field_71474_y.field_211842_aO;
    }

    @Deprecated
    public void func_110436_a() {
        this.field_110448_aq.func_198983_a();
        List<IResourcePack> list = this.field_110448_aq.func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
        if (this.field_71437_Z != null) {
            this.field_71437_Z.func_193031_aM();
        }
        try {
            this.field_110451_am.func_199005_a(list);
        }
        catch (RuntimeException runtimeexception) {
            field_147123_G.info("Caught error stitching, removing all assigned resourcepacks", (Throwable)runtimeexception);
            this.field_110448_aq.func_198985_a(Collections.emptyList());
            List list1 = this.field_110448_aq.func_198980_d().stream().map(ResourcePackInfo::func_195796_e).collect(Collectors.toList());
            this.field_110451_am.func_199005_a(list1);
            this.field_71474_y.field_151453_l.clear();
            this.field_71474_y.field_183018_l.clear();
            this.field_71474_y.func_74303_b();
        }
        this.field_135017_as.func_135043_a(list);
        if (this.field_71438_f != null) {
            this.field_71438_f.func_72712_a();
        }
    }

    private void func_195547_ap() {
        this.field_195558_d.func_198094_a();
        this.field_71462_r.func_73863_a(0, 0, 0.0f);
        this.field_195558_d.func_198086_a(false);
    }

    public void func_181536_a(int posX, int posY, int texU, int texV, int width, int height, int red, int green, int blue, int alpha) {
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        bufferbuilder.func_181662_b(posX, posY + height, 0.0).func_187315_a((float)texU * 0.00390625f, (float)(texV + height) * 0.00390625f).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(posX + width, posY + height, 0.0).func_187315_a((float)(texU + width) * 0.00390625f, (float)(texV + height) * 0.00390625f).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(posX + width, posY, 0.0).func_187315_a((float)(texU + width) * 0.00390625f, (float)texV * 0.00390625f).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b(posX, posY, 0.0).func_187315_a((float)texU * 0.00390625f, (float)texV * 0.00390625f).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public ISaveFormat func_71359_d() {
        return this.field_71469_aa;
    }

    @Nullable
    public IGuiEventListener getFocused() {
        return this.field_71462_r;
    }

    public void func_147108_a(@Nullable GuiScreen guiScreenIn) {
        if (guiScreenIn == null && this.field_71441_e == null) {
            guiScreenIn = new GuiMainMenu();
        } else if (guiScreenIn == null && this.field_71439_g.func_110143_aJ() <= 0.0f) {
            guiScreenIn = new GuiGameOver((ITextComponent)null);
        }
        GuiScreen old = this.field_71462_r;
        GuiOpenEvent event = new GuiOpenEvent(guiScreenIn);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return;
        }
        guiScreenIn = event.getGui();
        if (old != null && guiScreenIn != old) {
            old.func_146281_b();
        }
        if (guiScreenIn instanceof GuiMainMenu || guiScreenIn instanceof GuiMultiplayer) {
            this.field_71474_y.field_74330_P = false;
            this.field_71456_v.func_146158_b().func_146231_a(true);
        }
        this.field_71462_r = guiScreenIn;
        if (guiScreenIn != null) {
            this.field_71417_B.func_198032_j();
            KeyBinding.func_74506_a();
            guiScreenIn.func_146280_a(this, this.field_195558_d.func_198107_o(), this.field_195558_d.func_198087_p());
            this.field_71454_w = false;
        } else {
            this.field_147127_av.func_147687_e();
            this.field_71417_B.func_198034_i();
        }
    }

    public void func_71405_e() {
        try {
            field_147123_G.info("Stopping!");
            try {
                this.func_71403_a(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.field_71462_r != null) {
                this.field_71462_r.func_146281_b();
            }
            this.field_147128_au.func_195419_g();
            this.field_71466_p.close();
            this.field_71460_t.close();
            this.field_71438_f.close();
            this.field_147127_av.func_147685_d();
        }
        finally {
            this.field_195557_T.close();
            this.field_195558_d.close();
            if (!this.field_71434_R) {
                System.exit(0);
            }
        }
        System.gc();
    }

    private void func_195542_b(boolean renderWorldIn) {
        boolean flag;
        this.field_195558_d.func_198076_a("Pre render");
        long i = Util.func_211178_c();
        this.field_71424_I.func_76320_a("root");
        if (GLFW.glfwWindowShouldClose((long)this.field_195558_d.func_198092_i())) {
            this.func_71400_g();
        }
        if (renderWorldIn) {
            FutureTask<?> futuretask;
            this.field_71428_T.func_74275_a(Util.func_211177_b());
            this.field_71424_I.func_76320_a("scheduledExecutables");
            while ((futuretask = this.field_152351_aB.poll()) != null) {
                Util.func_181617_a(futuretask, (Logger)field_147123_G);
            }
            this.field_71424_I.func_76319_b();
        }
        long l = Util.func_211178_c();
        if (renderWorldIn) {
            this.field_71424_I.func_76320_a("tick");
            for (int j = 0; j < Math.min(10, this.field_71428_T.field_74280_b); ++j) {
                this.func_71407_l();
            }
        }
        this.field_71417_B.func_198028_a();
        this.field_195558_d.func_198076_a("Render");
        GLFW.glfwPollEvents();
        long i1 = Util.func_211178_c() - l;
        this.field_71424_I.func_76318_c("sound");
        this.field_147127_av.setListener(this.func_175606_aa(), this.field_71428_T.field_194147_b);
        this.field_71424_I.func_76319_b();
        this.field_71424_I.func_76320_a("render");
        GlStateManager.func_179094_E();
        GlStateManager.func_179086_m((int)16640);
        this.field_147124_at.func_147610_a(true);
        this.field_71424_I.func_76320_a("display");
        GlStateManager.func_179098_w();
        this.field_71424_I.func_76319_b();
        if (!this.field_71454_w) {
            BasicEventHooks.onRenderTickStart((float)this.field_71428_T.field_194147_b);
            this.field_71424_I.func_76318_c("gameRenderer");
            this.field_71460_t.func_195458_a(this.field_71445_n ? this.field_193996_ah : this.field_71428_T.field_194147_b, i, renderWorldIn);
            this.field_71424_I.func_76318_c("toasts");
            this.field_193034_aS.func_195625_a();
            this.field_71424_I.func_76319_b();
            BasicEventHooks.onRenderTickEnd((float)this.field_71428_T.field_194147_b);
        }
        this.field_71424_I.func_76319_b();
        if (this.field_71474_y.field_74330_P && this.field_71474_y.field_74329_Q && !this.field_71474_y.field_74319_N) {
            this.field_71424_I.func_199095_a(this.field_71428_T.field_74280_b);
            this.func_203410_as();
        } else {
            this.field_71424_I.func_199098_b();
        }
        this.field_147124_at.func_147609_e();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.field_147124_at.func_147615_c(this.field_195558_d.func_198109_k(), this.field_195558_d.func_198091_l());
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        this.field_71460_t.func_152430_c(this.field_71428_T.field_194147_b);
        GlStateManager.func_179121_F();
        this.field_71424_I.func_76320_a("root");
        this.field_195558_d.func_198086_a(true);
        Thread.yield();
        this.field_195558_d.func_198076_a("Post render");
        ++this.field_71420_M;
        boolean bl = flag = this.func_71356_B() && this.field_71462_r != null && this.field_71462_r.func_73868_f() && !this.field_71437_Z.func_71344_c();
        if (this.field_71445_n != flag) {
            if (this.field_71445_n) {
                this.field_193996_ah = this.field_71428_T.field_194147_b;
            } else {
                this.field_71428_T.field_194147_b = this.field_193996_ah;
            }
            this.field_71445_n = flag;
        }
        long k = Util.func_211178_c();
        this.field_181542_y.func_181747_a(k - this.field_181543_z);
        this.field_181543_z = k;
        while (Util.func_211177_b() >= this.field_71419_L + 1000L) {
            field_71470_ab = this.field_71420_M;
            Object[] objectArray = new Object[8];
            objectArray[0] = field_71470_ab;
            objectArray[1] = RenderChunk.field_178592_a;
            objectArray[2] = RenderChunk.field_178592_a == 1 ? "" : "s";
            objectArray[3] = (double)this.field_71474_y.field_74350_i == GameSettings.Options.FRAMERATE_LIMIT.func_198009_f() ? "inf" : Integer.valueOf(this.field_71474_y.field_74350_i);
            objectArray[4] = this.field_71474_y.field_74352_v ? " vsync" : "";
            Object object = objectArray[5] = this.field_71474_y.field_74347_j ? "" : " fast";
            objectArray[6] = this.field_71474_y.field_74345_l == 0 ? "" : (this.field_71474_y.field_74345_l == 1 ? " fast-clouds" : " fancy-clouds");
            objectArray[7] = OpenGlHelper.func_176075_f() ? " vbo" : "";
            this.field_71426_K = String.format("%d fps (%d chunk update%s) T: %s%s%s%s%s", objectArray);
            RenderChunk.field_178592_a = 0;
            this.field_71419_L += 1000L;
            this.field_71420_M = 0;
            this.field_71427_U.func_76471_b();
            if (this.field_71427_U.func_76468_d()) continue;
            this.field_71427_U.func_76463_a();
        }
        this.field_71424_I.func_76319_b();
    }

    public void func_71398_f() {
        try {
            field_71444_a = new byte[0];
            this.field_71438_f.func_72728_f();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            System.gc();
            this.func_205055_a(null, (GuiScreen)new GuiDirtMessageScreen(I18n.func_135052_a("menu.savingLevel", new Object[0])));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        System.gc();
    }

    void func_71383_b(int keyCount) {
        List list = this.field_71424_I.func_76321_b(this.field_71465_an);
        if (!list.isEmpty()) {
            Profiler.Result profiler$result = (Profiler.Result)list.remove(0);
            if (keyCount == 0) {
                int i;
                if (!profiler$result.field_76331_c.isEmpty() && (i = this.field_71465_an.lastIndexOf(46)) >= 0) {
                    this.field_71465_an = this.field_71465_an.substring(0, i);
                }
            } else if (--keyCount < list.size() && !"unspecified".equals(((Profiler.Result)list.get((int)keyCount)).field_76331_c)) {
                if (!this.field_71465_an.isEmpty()) {
                    this.field_71465_an = this.field_71465_an + ".";
                }
                this.field_71465_an = this.field_71465_an + ((Profiler.Result)list.get((int)keyCount)).field_76331_c;
            }
        }
    }

    private void func_203410_as() {
        if (this.field_71424_I.func_199094_a()) {
            List list = this.field_71424_I.func_76321_b(this.field_71465_an);
            Profiler.Result profiler$result = (Profiler.Result)list.remove(0);
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179142_g();
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)this.field_195558_d.func_198109_k(), (double)this.field_195558_d.func_198091_l(), (double)0.0, (double)1000.0, (double)3000.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-2000.0f);
            GlStateManager.func_187441_d((float)1.0f);
            GlStateManager.func_179090_x();
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            int i = 160;
            int j = this.field_195558_d.func_198109_k() - 160 - 10;
            int k = this.field_195558_d.func_198091_l() - 320;
            GlStateManager.func_179147_l();
            bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            bufferbuilder.func_181662_b((float)j - 176.0f, (float)k - 96.0f - 16.0f, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((float)j - 176.0f, k + 320, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((float)j + 176.0f, k + 320, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
            bufferbuilder.func_181662_b((float)j + 176.0f, (float)k - 96.0f - 16.0f, 0.0).func_181669_b(200, 0, 0, 0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179084_k();
            double d0 = 0.0;
            for (int l = 0; l < list.size(); ++l) {
                Profiler.Result profiler$result1 = (Profiler.Result)list.get(l);
                int i1 = MathHelper.func_76128_c((double)(profiler$result1.field_76332_a / 4.0)) + 1;
                bufferbuilder.func_181668_a(6, DefaultVertexFormats.field_181706_f);
                int j1 = profiler$result1.func_76329_a();
                int k1 = j1 >> 16 & 0xFF;
                int l1 = j1 >> 8 & 0xFF;
                int i2 = j1 & 0xFF;
                bufferbuilder.func_181662_b(j, k, 0.0).func_181669_b(k1, l1, i2, 255).func_181675_d();
                for (int j2 = i1; j2 >= 0; --j2) {
                    float f = (float)((d0 + profiler$result1.field_76332_a * (double)j2 / (double)i1) * 6.2831854820251465 / 100.0);
                    float f1 = MathHelper.func_76126_a((float)f) * 160.0f;
                    float f2 = MathHelper.func_76134_b((float)f) * 160.0f * 0.5f;
                    bufferbuilder.func_181662_b((float)j + f1, (float)k - f2, 0.0).func_181669_b(k1, l1, i2, 255).func_181675_d();
                }
                tessellator.func_78381_a();
                bufferbuilder.func_181668_a(5, DefaultVertexFormats.field_181706_f);
                for (int i3 = i1; i3 >= 0; --i3) {
                    float f3 = (float)((d0 + profiler$result1.field_76332_a * (double)i3 / (double)i1) * 6.2831854820251465 / 100.0);
                    float f4 = MathHelper.func_76126_a((float)f3) * 160.0f;
                    float f5 = MathHelper.func_76134_b((float)f3) * 160.0f * 0.5f;
                    bufferbuilder.func_181662_b((float)j + f4, (float)k - f5, 0.0).func_181669_b(k1 >> 1, l1 >> 1, i2 >> 1, 255).func_181675_d();
                    bufferbuilder.func_181662_b((float)j + f4, (float)k - f5 + 10.0f, 0.0).func_181669_b(k1 >> 1, l1 >> 1, i2 >> 1, 255).func_181675_d();
                }
                tessellator.func_78381_a();
                d0 += profiler$result1.field_76332_a;
            }
            DecimalFormat decimalformat = new DecimalFormat("##0.00");
            decimalformat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
            GlStateManager.func_179098_w();
            String s = "";
            if (!"unspecified".equals(profiler$result.field_76331_c)) {
                s = s + "[0] ";
            }
            s = profiler$result.field_76331_c.isEmpty() ? s + "ROOT " : s + profiler$result.field_76331_c + ' ';
            int l2 = 0xFFFFFF;
            this.field_71466_p.func_175063_a(s, (float)(j - 160), (float)(k - 80 - 16), 0xFFFFFF);
            s = decimalformat.format(profiler$result.field_76330_b) + "%";
            this.field_71466_p.func_175063_a(s, (float)(j + 160 - this.field_71466_p.func_78256_a(s)), (float)(k - 80 - 16), 0xFFFFFF);
            for (int k2 = 0; k2 < list.size(); ++k2) {
                Profiler.Result profiler$result2 = (Profiler.Result)list.get(k2);
                StringBuilder stringbuilder = new StringBuilder();
                if ("unspecified".equals(profiler$result2.field_76331_c)) {
                    stringbuilder.append("[?] ");
                } else {
                    stringbuilder.append("[").append(k2 + 1).append("] ");
                }
                String s1 = stringbuilder.append(profiler$result2.field_76331_c).toString();
                this.field_71466_p.func_175063_a(s1, (float)(j - 160), (float)(k + 80 + k2 * 8 + 20), profiler$result2.func_76329_a());
                s1 = decimalformat.format(profiler$result2.field_76332_a) + "%";
                this.field_71466_p.func_175063_a(s1, (float)(j + 160 - 50 - this.field_71466_p.func_78256_a(s1)), (float)(k + 80 + k2 * 8 + 20), profiler$result2.func_76329_a());
                s1 = decimalformat.format(profiler$result2.field_76330_b) + "%";
                this.field_71466_p.func_175063_a(s1, (float)(j + 160 - this.field_71466_p.func_78256_a(s1)), (float)(k + 80 + k2 * 8 + 20), profiler$result2.func_76329_a());
            }
        }
    }

    public void func_71400_g() {
        this.field_71425_J = false;
    }

    public void func_71385_j() {
        if (this.field_71462_r == null) {
            this.func_147108_a((GuiScreen)new GuiIngameMenu());
            if (this.func_71356_B() && !this.field_71437_Z.func_71344_c()) {
                this.field_147127_av.func_147689_b();
            }
        }
    }

    private void func_147115_a(boolean leftClick) {
        if (!leftClick) {
            this.field_71429_W = 0;
        }
        if (this.field_71429_W <= 0 && !this.field_71439_g.func_184587_cr()) {
            if (leftClick && this.field_71476_x != null && this.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = this.field_71476_x.func_178782_a();
                if (!this.field_71441_e.func_175623_d(blockpos) && this.field_71442_b.func_180512_c(blockpos, this.field_71476_x.field_178784_b)) {
                    this.field_71452_i.addBlockHitEffects(blockpos, this.field_71476_x);
                    this.field_71439_g.func_184609_a(EnumHand.MAIN_HAND);
                }
            } else {
                this.field_71442_b.func_78767_c();
            }
        }
    }

    private void func_147116_af() {
        if (this.field_71429_W <= 0) {
            if (this.field_71476_x == null) {
                field_147123_G.error("Null returned as 'hitResult', this shouldn't happen!");
                if (this.field_71442_b.func_78762_g()) {
                    this.field_71429_W = 10;
                }
            } else if (!this.field_71439_g.func_184838_M()) {
                switch (this.field_71476_x.field_72313_a) {
                    case ENTITY: {
                        this.field_71442_b.func_78764_a(this.field_71439_g, this.field_71476_x.field_72308_g);
                        break;
                    }
                    case BLOCK: {
                        BlockPos blockpos = this.field_71476_x.func_178782_a();
                        if (!this.field_71441_e.func_175623_d(blockpos)) {
                            this.field_71442_b.func_180511_b(blockpos, this.field_71476_x.field_178784_b);
                            break;
                        }
                    }
                    case MISS: {
                        if (this.field_71442_b.func_78762_g()) {
                            this.field_71429_W = 10;
                        }
                        this.field_71439_g.func_184821_cY();
                        ForgeHooks.onEmptyLeftClick((EntityPlayer)this.field_71439_g);
                    }
                }
                this.field_71439_g.func_184609_a(EnumHand.MAIN_HAND);
            }
        }
    }

    private void func_147121_ag() {
        if (!this.field_71442_b.func_181040_m()) {
            this.field_71467_ac = 4;
            if (!this.field_71439_g.func_184838_M()) {
                if (this.field_71476_x == null) {
                    field_147123_G.warn("Null returned as 'hitResult', this shouldn't happen!");
                }
                for (EnumHand enumhand : EnumHand.values()) {
                    ItemStack itemstack = this.field_71439_g.func_184586_b(enumhand);
                    if (this.field_71476_x != null) {
                        switch (this.field_71476_x.field_72313_a) {
                            case ENTITY: {
                                if (this.field_71442_b.func_187102_a(this.field_71439_g, this.field_71476_x.field_72308_g, this.field_71476_x, enumhand) == EnumActionResult.SUCCESS) {
                                    return;
                                }
                                if (this.field_71442_b.func_187097_a(this.field_71439_g, this.field_71476_x.field_72308_g, enumhand) != EnumActionResult.SUCCESS) break;
                                return;
                            }
                            case BLOCK: {
                                BlockPos blockpos = this.field_71476_x.func_178782_a();
                                if (this.field_71441_e.func_180495_p(blockpos).isAir((IBlockReader)this.field_71441_e, blockpos)) break;
                                int i = itemstack.func_190916_E();
                                EnumActionResult enumactionresult = this.field_71442_b.func_187099_a(this.field_71439_g, this.field_71441_e, blockpos, this.field_71476_x.field_178784_b, this.field_71476_x.field_72307_f, enumhand);
                                if (enumactionresult == EnumActionResult.SUCCESS) {
                                    this.field_71439_g.func_184609_a(enumhand);
                                    if (!itemstack.func_190926_b() && (itemstack.func_190916_E() != i || this.field_71442_b.func_78758_h())) {
                                        this.field_71460_t.field_78516_c.func_187460_a(enumhand);
                                    }
                                    return;
                                }
                                if (enumactionresult != EnumActionResult.FAIL) break;
                                return;
                            }
                        }
                    }
                    if (itemstack.func_190926_b() && (this.field_71476_x == null || this.field_71476_x.field_72313_a == RayTraceResult.Type.MISS)) {
                        ForgeHooks.onEmptyClick((EntityPlayer)this.field_71439_g, (EnumHand)enumhand);
                    }
                    if (itemstack.func_190926_b() || this.field_71442_b.func_187101_a(this.field_71439_g, this.field_71441_e, enumhand) != EnumActionResult.SUCCESS) continue;
                    this.field_71460_t.field_78516_c.func_187460_a(enumhand);
                    return;
                }
            }
        }
    }

    public MusicTicker func_181535_r() {
        return this.field_147126_aw;
    }

    public void func_71407_l() {
        if (this.field_71467_ac > 0) {
            --this.field_71467_ac;
        }
        BasicEventHooks.onPreClientTick();
        this.field_71424_I.func_76320_a("gui");
        if (!this.field_71445_n) {
            this.field_71456_v.func_73831_a();
        }
        this.field_71424_I.func_76319_b();
        this.field_71460_t.func_78473_a(1.0f);
        this.field_193035_aW.func_193297_a(this.field_71441_e, this.field_71476_x);
        this.field_71424_I.func_76320_a("gameMode");
        if (!this.field_71445_n && this.field_71441_e != null) {
            this.field_71442_b.func_78765_e();
        }
        this.field_71424_I.func_76318_c("textures");
        if (this.field_71441_e != null) {
            this.field_71446_o.func_110550_d();
        }
        if (this.field_71462_r == null && this.field_71439_g != null) {
            if (this.field_71439_g.func_110143_aJ() <= 0.0f && !(this.field_71462_r instanceof GuiGameOver)) {
                this.func_147108_a(null);
            } else if (this.field_71439_g.func_70608_bn() && this.field_71441_e != null) {
                this.func_147108_a((GuiScreen)((Object)new GuiSleepMP()));
            }
        } else if (this.field_71462_r != null && this.field_71462_r instanceof GuiSleepMP && !this.field_71439_g.func_70608_bn()) {
            this.func_147108_a(null);
        }
        if (this.field_71462_r != null) {
            this.field_71429_W = 10000;
        }
        if (this.field_71462_r != null) {
            GuiScreen.func_195121_a(() -> this.field_71462_r.func_73876_c(), "Ticking screen", ((Object)((Object)this.field_71462_r)).getClass().getCanonicalName());
        }
        if (this.field_71462_r == null || this.field_71462_r.field_146291_p) {
            this.field_71424_I.func_76318_c("GLFW events");
            GLFW.glfwPollEvents();
            this.func_184117_aA();
            if (this.field_71429_W > 0) {
                --this.field_71429_W;
            }
        }
        if (this.field_71441_e != null) {
            if (this.field_71439_g != null) {
                ++this.field_71457_ai;
                if (this.field_71457_ai == 30) {
                    this.field_71457_ai = 0;
                    this.field_71441_e.func_72897_h(this.field_71439_g);
                }
            }
            this.field_71424_I.func_76318_c("gameRenderer");
            if (!this.field_71445_n) {
                this.field_71460_t.func_78464_a();
            }
            this.field_71424_I.func_76318_c("levelRenderer");
            if (!this.field_71445_n) {
                this.field_71438_f.func_72734_e();
            }
            this.field_71424_I.func_76318_c("level");
            if (!this.field_71445_n) {
                if (this.field_71441_e.func_175658_ac() > 0) {
                    this.field_71441_e.func_175702_c(this.field_71441_e.func_175658_ac() - 1);
                }
                this.field_71441_e.func_72939_s();
            }
        } else if (this.field_71460_t.func_147702_a()) {
            this.field_71460_t.func_181022_b();
        }
        if (!this.field_71445_n) {
            this.field_147126_aw.func_73660_a();
            this.field_147127_av.func_73660_a();
        }
        if (this.field_71441_e != null) {
            if (!this.field_71445_n) {
                this.field_71441_e.func_72891_a(this.field_71441_e.func_175659_aa() != EnumDifficulty.PEACEFUL, true);
                this.field_193035_aW.func_193303_d();
                try {
                    this.field_71441_e.func_72835_b(() -> true);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a(throwable, "Exception in world tick");
                    if (this.field_71441_e == null) {
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Affected level");
                        crashreportcategory.func_71507_a("Problem", "Level is null!");
                    } else {
                        this.field_71441_e.func_72914_a(crashreport);
                    }
                    throw new ReportedException(crashreport);
                }
            }
            this.field_71424_I.func_76318_c("animateTick");
            if (!this.field_71445_n && this.field_71441_e != null) {
                this.field_71441_e.func_73029_E(MathHelper.func_76128_c((double)this.field_71439_g.field_70165_t), MathHelper.func_76128_c((double)this.field_71439_g.field_70163_u), MathHelper.func_76128_c((double)this.field_71439_g.field_70161_v));
            }
            this.field_71424_I.func_76318_c("particles");
            if (!this.field_71445_n) {
                this.field_71452_i.func_78868_a();
            }
        } else if (this.field_71453_ak != null) {
            this.field_71424_I.func_76318_c("pendingConnection");
            this.field_71453_ak.func_74428_b();
        }
        this.field_71424_I.func_76318_c("keyboard");
        this.field_195559_v.func_204870_b();
        this.field_71424_I.func_76319_b();
        BasicEventHooks.onPostClientTick();
    }

    private void func_184117_aA() {
        boolean flag2;
        while (this.field_71474_y.field_151457_aa.func_151468_f()) {
            ++this.field_71474_y.field_74320_O;
            if (this.field_71474_y.field_74320_O > 2) {
                this.field_71474_y.field_74320_O = 0;
            }
            if (this.field_71474_y.field_74320_O == 0) {
                this.field_71460_t.func_175066_a(this.func_175606_aa());
            } else if (this.field_71474_y.field_74320_O == 1) {
                this.field_71460_t.func_175066_a(null);
            }
            this.field_71438_f.func_174979_m();
        }
        while (this.field_71474_y.field_151458_ab.func_151468_f()) {
            this.field_71474_y.field_74326_T = !this.field_71474_y.field_74326_T;
        }
        for (int i = 0; i < 9; ++i) {
            boolean flag = this.field_71474_y.field_193629_ap.func_151470_d();
            boolean flag1 = this.field_71474_y.field_193630_aq.func_151470_d();
            if (!this.field_71474_y.field_151456_ac[i].func_151468_f()) continue;
            if (this.field_71439_g.func_175149_v()) {
                this.field_71456_v.func_175187_g().func_175260_a(i);
                continue;
            }
            if (!this.field_71439_g.func_184812_l_() || this.field_71462_r != null || !flag1 && !flag) {
                this.field_71439_g.field_71071_by.field_70461_c = i;
                continue;
            }
            GuiContainerCreative.func_192044_a(this, i, flag1, flag);
        }
        while (this.field_71474_y.field_151445_Q.func_151468_f()) {
            if (this.field_71442_b.func_110738_j()) {
                this.field_71439_g.func_175163_u();
                continue;
            }
            this.field_193035_aW.func_193296_a();
            this.func_147108_a((GuiScreen)new GuiInventory((EntityPlayer)this.field_71439_g));
        }
        while (this.field_71474_y.field_194146_ao.func_151468_f()) {
            this.func_147108_a(new GuiScreenAdvancements(this.field_71439_g.field_71174_a.func_191982_f()));
        }
        while (this.field_71474_y.field_186718_X.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.func_147114_u().func_147297_a((Packet<?>)new CPacketPlayerDigging(CPacketPlayerDigging.Action.SWAP_HELD_ITEMS, BlockPos.field_177992_a, EnumFacing.DOWN));
        }
        while (this.field_71474_y.field_74316_C.func_151468_f()) {
            if (this.field_71439_g.func_175149_v()) continue;
            this.field_71439_g.func_71040_bB(GuiScreen.func_146271_m());
        }
        boolean bl = flag2 = this.field_71474_y.field_74343_n != EntityPlayer.EnumChatVisibility.HIDDEN;
        if (flag2) {
            while (this.field_71474_y.field_74310_D.func_151468_f()) {
                this.func_147108_a((GuiScreen)new GuiChat());
            }
            if (this.field_71462_r == null && this.field_71474_y.field_74323_J.func_151468_f()) {
                this.func_147108_a((GuiScreen)new GuiChat("/"));
            }
        }
        if (this.field_71439_g.func_184587_cr()) {
            if (!this.field_71474_y.field_74313_G.func_151470_d()) {
                this.field_71442_b.func_78766_c(this.field_71439_g);
            }
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
            }
        } else {
            while (this.field_71474_y.field_74312_F.func_151468_f()) {
                this.func_147116_af();
            }
            while (this.field_71474_y.field_74313_G.func_151468_f()) {
                this.func_147121_ag();
            }
            while (this.field_71474_y.field_74322_I.func_151468_f()) {
                this.func_147112_ai();
            }
        }
        if (this.field_71474_y.field_74313_G.func_151470_d() && this.field_71467_ac == 0 && !this.field_71439_g.func_184587_cr()) {
            this.func_147121_ag();
        }
        this.func_147115_a(this.field_71462_r == null && this.field_71474_y.field_74312_F.func_151470_d() && this.field_71417_B.func_198035_h());
    }

    public void func_71371_a(String folderName, String worldName, @Nullable WorldSettings worldSettingsIn) {
        this.func_71403_a(null);
        System.gc();
        ISaveHandler isavehandler = this.field_71469_aa.func_197715_a(folderName, (MinecraftServer)null);
        WorldInfo worldinfo = isavehandler.func_75757_d();
        if (worldinfo == null && worldSettingsIn != null) {
            worldinfo = new WorldInfo(worldSettingsIn, folderName);
            isavehandler.func_75761_a(worldinfo);
        }
        if (worldSettingsIn == null) {
            worldSettingsIn = new WorldSettings(worldinfo);
        }
        try {
            YggdrasilAuthenticationService yggdrasilauthenticationservice = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
            MinecraftSessionService minecraftsessionservice = yggdrasilauthenticationservice.createMinecraftSessionService();
            GameProfileRepository gameprofilerepository = yggdrasilauthenticationservice.createProfileRepository();
            PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
            TileEntitySkull.func_184293_a((PlayerProfileCache)playerprofilecache);
            TileEntitySkull.func_184294_a((MinecraftSessionService)minecraftsessionservice);
            PlayerProfileCache.func_187320_a((boolean)false);
            this.field_71437_Z = new IntegratedServer(this, folderName, worldName, worldSettingsIn, yggdrasilauthenticationservice, minecraftsessionservice, gameprofilerepository, playerprofilecache);
            this.field_71437_Z.func_71256_s();
            this.field_71455_al = true;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a(throwable, "Starting integrated server");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Starting integrated server");
            crashreportcategory.func_71507_a("Level ID", folderName);
            crashreportcategory.func_71507_a("Level Name", worldName);
            throw new ReportedException(crashreport);
        }
        GuiScreenWorking guiscreenworking = new GuiScreenWorking();
        this.func_147108_a((GuiScreen)guiscreenworking);
        guiscreenworking.func_200210_a((ITextComponent)new TextComponentTranslation("menu.loadingLevel", new Object[0]));
        while (!this.field_71437_Z.func_71200_ad()) {
            ITextComponent itextcomponent = this.field_71437_Z.func_200253_h_();
            if (itextcomponent != null) {
                ITextComponent itextcomponent1 = this.field_71437_Z.func_200246_aJ();
                if (itextcomponent1 != null) {
                    guiscreenworking.func_200209_c(itextcomponent1);
                    guiscreenworking.func_73718_a(this.field_71437_Z.func_195566_aK());
                } else {
                    guiscreenworking.func_200209_c(itextcomponent);
                }
            } else {
                guiscreenworking.func_200209_c((ITextComponent)new TextComponentString(""));
            }
            if (!StartupQuery.check() || this.field_71437_Z.func_71241_aa()) {
                this.func_147108_a(null);
                return;
            }
            if (this.field_71462_r == null) {
                this.func_147108_a((GuiScreen)guiscreenworking);
            }
            this.func_195542_b(false);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException itextcomponent1) {
                // empty catch block
            }
            if (!this.field_71434_R || this.field_71433_S == null) continue;
            this.func_71377_b(this.field_71433_S);
            return;
        }
        SocketAddress socketaddress = this.field_71437_Z.func_147137_ag().func_151270_a();
        NetworkManager networkmanager = NetworkManager.func_150722_a(socketaddress);
        networkmanager.func_150719_a((INetHandler)new NetHandlerLoginClient(networkmanager, this, null, p_209507_0_ -> {}));
        networkmanager.func_179290_a(new CPacketHandshake(socketaddress.toString(), 0, EnumConnectionState.LOGIN));
        GameProfile gameProfile = this.func_110432_I().func_148256_e();
        if (!this.func_110432_I().hasCachedProperties()) {
            gameProfile = this.field_152355_az.fillProfileProperties(gameProfile, true);
            this.func_110432_I().setProperties(gameProfile.getProperties());
        }
        networkmanager.func_179290_a((Packet<?>)new CPacketLoginStart(gameProfile));
        this.field_71453_ak = networkmanager;
    }

    public void func_71403_a(@Nullable WorldClient worldClientIn) {
        GuiScreenWorking guiscreenworking = new GuiScreenWorking();
        if (worldClientIn != null) {
            guiscreenworking.func_200210_a((ITextComponent)new TextComponentTranslation("connect.joining", new Object[0]));
        }
        this.func_205055_a(worldClientIn, (GuiScreen)guiscreenworking);
    }

    public void func_205055_a(@Nullable WorldClient worldIn, GuiScreen loadingScreen) {
        if (this.field_71441_e != null) {
            MinecraftForge.EVENT_BUS.post((Event)new WorldEvent.Unload((IWorld)this.field_71441_e));
        }
        if (worldIn == null) {
            NetHandlerPlayClient nethandlerplayclient = this.func_147114_u();
            if (nethandlerplayclient != null) {
                this.field_152351_aB.clear();
                nethandlerplayclient.func_147296_c();
            }
            this.field_71437_Z = null;
            this.field_71460_t.func_190564_k();
            this.field_71442_b = null;
            NarratorChatListener.field_193643_a.func_193642_b();
        }
        this.field_147126_aw.func_209200_a();
        this.field_147127_av.func_147690_c();
        this.field_175622_Z = null;
        this.field_71453_ak = null;
        this.func_147108_a(loadingScreen);
        this.func_195542_b(false);
        if (worldIn == null && this.field_71441_e != null) {
            this.field_195554_ax.func_195749_c();
            this.field_71456_v.func_181029_i();
            this.func_71351_a(null);
            this.field_71455_al = false;
        }
        this.field_71441_e = worldIn;
        if (this.field_71438_f != null) {
            this.field_71438_f.func_72732_a(worldIn);
        }
        if (this.field_71452_i != null) {
            this.field_71452_i.func_78870_a(worldIn);
        }
        TileEntityRendererDispatcher.field_147556_a.func_147543_a(worldIn);
        MinecraftForgeClient.clearRenderCache();
        if (worldIn != null) {
            if (!this.field_71455_al) {
                YggdrasilAuthenticationService authenticationservice = new YggdrasilAuthenticationService(this.field_110453_aa, UUID.randomUUID().toString());
                MinecraftSessionService minecraftsessionservice = authenticationservice.createMinecraftSessionService();
                GameProfileRepository gameprofilerepository = authenticationservice.createProfileRepository();
                PlayerProfileCache playerprofilecache = new PlayerProfileCache(gameprofilerepository, new File(this.field_71412_D, MinecraftServer.field_152367_a.getName()));
                TileEntitySkull.func_184293_a((PlayerProfileCache)playerprofilecache);
                TileEntitySkull.func_184294_a((MinecraftSessionService)minecraftsessionservice);
                PlayerProfileCache.func_187320_a((boolean)false);
            }
            if (this.field_71439_g == null) {
                this.field_71439_g = this.field_71442_b.func_199681_a(worldIn, new StatisticsManager(), new RecipeBookClient(worldIn.func_199532_z()));
                this.field_71442_b.func_78745_b(this.field_71439_g);
                if (this.field_71437_Z != null) {
                    this.field_71437_Z.func_211527_b(this.field_71439_g.func_110124_au());
                }
            }
            this.field_71439_g.func_70065_x();
            worldIn.func_72838_d(this.field_71439_g);
            this.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_71474_y);
            this.field_71442_b.func_78748_a(this.field_71439_g);
            this.field_175622_Z = this.field_71439_g;
        } else {
            this.field_71439_g = null;
        }
        System.gc();
    }

    public void func_212315_a(DimensionType p_212315_1_) {
        this.field_71441_e.func_72974_f();
        this.field_71441_e.func_73022_a();
        int i = 0;
        String s = null;
        if (this.field_71439_g != null) {
            i = this.field_71439_g.func_145782_y();
            this.field_71441_e.func_72900_e(this.field_71439_g);
            s = this.field_71439_g.func_142021_k();
        }
        this.field_175622_Z = null;
        EntityPlayerSP entityplayersp = this.field_71439_g;
        this.field_71439_g = this.field_71442_b.func_199681_a(this.field_71441_e, this.field_71439_g == null ? new StatisticsManager() : this.field_71439_g.func_146107_m(), this.field_71439_g == null ? new RecipeBookClient(new RecipeManager()) : this.field_71439_g.func_199507_B());
        this.field_71439_g.func_184212_Q().func_187218_a(entityplayersp.func_184212_Q().func_187231_c());
        this.field_71439_g.updateSyncFields(entityplayersp);
        this.field_71439_g.field_71093_bK = p_212315_1_;
        this.field_175622_Z = this.field_71439_g;
        this.field_71439_g.func_70065_x();
        this.field_71439_g.func_175158_f(s);
        this.field_71441_e.func_72838_d(this.field_71439_g);
        this.field_71442_b.func_78745_b(this.field_71439_g);
        this.field_71439_g.field_71158_b = new MovementInputFromOptions(this.field_71474_y);
        this.field_71439_g.func_145769_d(i);
        this.field_71442_b.func_78748_a(this.field_71439_g);
        this.field_71439_g.func_175150_k(entityplayersp.func_175140_cp());
        if (this.field_71462_r instanceof GuiGameOver) {
            this.func_147108_a(null);
        }
    }

    public final boolean func_71355_q() {
        return this.field_71459_aj;
    }

    @Nullable
    public NetHandlerPlayClient func_147114_u() {
        return this.field_71439_g == null ? null : this.field_71439_g.field_71174_a;
    }

    public static boolean func_71382_s() {
        return field_71432_P == null || !Minecraft.field_71432_P.field_71474_y.field_74319_N;
    }

    public static boolean func_71375_t() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74347_j;
    }

    public static boolean func_71379_u() {
        return field_71432_P != null && Minecraft.field_71432_P.field_71474_y.field_74348_k != 0;
    }

    private void func_147112_ai() {
        if (this.field_71476_x != null && this.field_71476_x.field_72313_a != RayTraceResult.Type.MISS) {
            ForgeHooks.onPickBlock((RayTraceResult)this.field_71476_x, (EntityPlayer)this.field_71439_g, (World)this.field_71441_e);
        }
    }

    public ItemStack func_184119_a(ItemStack stack, TileEntity te) {
        NBTTagCompound nbttagcompound = te.func_189515_b(new NBTTagCompound());
        if (stack.func_77973_b() instanceof ItemSkull && nbttagcompound.func_74764_b("Owner")) {
            NBTTagCompound nbttagcompound2 = nbttagcompound.func_74775_l("Owner");
            stack.func_196082_o().func_74782_a("SkullOwner", nbttagcompound2);
            return stack;
        }
        stack.func_77983_a("BlockEntityTag", nbttagcompound);
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        NBTTagList nbttaglist = new NBTTagList();
        nbttaglist.add((INBTBase)new NBTTagString("(+NBT)"));
        nbttagcompound1.func_74782_a("Lore", (INBTBase)nbttaglist);
        stack.func_77983_a("display", nbttagcompound1);
        return stack;
    }

    public CrashReport func_71396_d(CrashReport theCrash) {
        CrashReportCategory crashreportcategory = theCrash.func_85056_g();
        crashreportcategory.func_189529_a("Launched Version", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_110447_Z));
        crashreportcategory.func_189529_a("LWJGL", (ICrashReportDetail<String>)((ICrashReportDetail)Version::getVersion));
        crashreportcategory.func_189529_a("OpenGL", (ICrashReportDetail<String>)((ICrashReportDetail)() -> GLFW.glfwGetCurrentContext() == 0L ? "NO CONTEXT" : GlStateManager.func_187416_u((int)7937) + " GL version " + GlStateManager.func_187416_u((int)7938) + ", " + GlStateManager.func_187416_u((int)7936)));
        crashreportcategory.func_189529_a("GL Caps", (ICrashReportDetail<String>)((ICrashReportDetail)OpenGlHelper::func_153172_c));
        crashreportcategory.func_189529_a("Using VBOs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_71474_y.field_178881_t ? "Yes" : "No"));
        crashreportcategory.func_189529_a("Is Modded", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            String s = ClientBrandRetriever.getClientModName();
            if (!"vanilla".equals(s)) {
                return "Definitely; Client brand changed to '" + s + "'";
            }
            return Minecraft.class.getSigners() == null ? "Very likely; Jar signature invalidated" : "Probably not. Jar signature remains and client brand is untouched.";
        }));
        crashreportcategory.func_71507_a("Type", "Client (map_client.txt)");
        crashreportcategory.func_189529_a("Resource Packs", (ICrashReportDetail<String>)((ICrashReportDetail)() -> {
            StringBuilder stringbuilder = new StringBuilder();
            for (String s : this.field_71474_y.field_151453_l) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append(", ");
                }
                stringbuilder.append(s);
                if (!this.field_71474_y.field_183018_l.contains(s)) continue;
                stringbuilder.append(" (incompatible)");
            }
            return stringbuilder.toString();
        }));
        crashreportcategory.func_189529_a("Current Language", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_135017_as.func_135041_c().toString()));
        crashreportcategory.func_189529_a("Profiler Position", (ICrashReportDetail<String>)((ICrashReportDetail)() -> this.field_71424_I.func_199094_a() ? this.field_71424_I.func_76322_c() : "N/A (disabled)"));
        crashreportcategory.func_189529_a("CPU", (ICrashReportDetail<String>)((ICrashReportDetail)OpenGlHelper::func_183029_j));
        if (this.field_71441_e != null) {
            this.field_71441_e.func_72914_a(theCrash);
        }
        return theCrash;
    }

    public static Minecraft func_71410_x() {
        return field_71432_P;
    }

    @Deprecated
    public ListenableFuture<Object> func_175603_A() {
        return this.func_152344_a(this::func_110436_a);
    }

    public void func_70000_a(Snooper playerSnooper) {
        playerSnooper.func_152768_a("fps", (Object)field_71470_ab);
        playerSnooper.func_152768_a("vsync_enabled", (Object)this.field_71474_y.field_74352_v);
        long i = GLFW.glfwGetWindowMonitor((long)this.field_195558_d.func_198092_i());
        if (i == 0L) {
            i = GLFW.glfwGetPrimaryMonitor();
        }
        playerSnooper.func_152768_a("display_frequency", (Object)GLFW.glfwGetVideoMode((long)i).refreshRate());
        playerSnooper.func_152768_a("display_type", (Object)(this.field_195558_d.func_198113_j() ? "fullscreen" : "windowed"));
        playerSnooper.func_152768_a("run_time", (Object)((Util.func_211177_b() - playerSnooper.func_130105_g()) / 60L * 1000L));
        playerSnooper.func_152768_a("current_action", (Object)this.func_181538_aA());
        playerSnooper.func_152768_a("language", (Object)(this.field_71474_y.field_74363_ab == null ? "en_us" : this.field_71474_y.field_74363_ab));
        String s = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "little" : "big";
        playerSnooper.func_152768_a("endianness", (Object)s);
        playerSnooper.func_152768_a("subtitles", (Object)this.field_71474_y.field_186717_N);
        playerSnooper.func_152768_a("touch", (Object)(this.field_71474_y.field_85185_A ? "touch" : "mouse"));
        int j = 0;
        for (ResourcePackInfoClient resourcepackinfoclient : this.field_110448_aq.func_198980_d()) {
            if (resourcepackinfoclient.func_195797_g() || resourcepackinfoclient.func_195798_h()) continue;
            playerSnooper.func_152768_a("resource_pack[" + j++ + "]", (Object)resourcepackinfoclient.func_195790_f());
        }
        playerSnooper.func_152768_a("resource_packs", (Object)j);
        if (this.field_71437_Z != null && this.field_71437_Z.func_80003_ah() != null) {
            playerSnooper.func_152768_a("snooper_partner", (Object)this.field_71437_Z.func_80003_ah().func_80006_f());
        }
    }

    private String func_181538_aA() {
        if (this.field_71437_Z != null) {
            return this.field_71437_Z.func_71344_c() ? "hosting_lan" : "singleplayer";
        }
        if (this.field_71422_O != null) {
            return this.field_71422_O.func_181041_d() ? "playing_lan" : "multiplayer";
        }
        return "out_of_game";
    }

    public static int func_71369_N() {
        if (field_211120_F == -1) {
            for (int i = 16384; i > 0; i >>= 1) {
                GlStateManager.func_187419_a((int)32868, (int)0, (int)6408, (int)i, (int)i, (int)0, (int)6408, (int)5121, (IntBuffer)null);
                int j = GlStateManager.func_187411_c((int)32868, (int)0, (int)4096);
                if (j == 0) continue;
                field_211120_F = i;
                return i;
            }
        }
        return field_211120_F;
    }

    public boolean func_70002_Q() {
        return this.field_71474_y.field_74355_t;
    }

    public void func_71351_a(ServerData serverDataIn) {
        this.field_71422_O = serverDataIn;
    }

    @Nullable
    public ServerData func_147104_D() {
        return this.field_71422_O;
    }

    public boolean func_71387_A() {
        return this.field_71455_al;
    }

    public boolean func_71356_B() {
        return this.field_71455_al && this.field_71437_Z != null;
    }

    @Nullable
    public IntegratedServer func_71401_C() {
        return this.field_71437_Z;
    }

    public static void func_71363_D() {
        IntegratedServer integratedserver;
        if (field_71432_P != null && (integratedserver = field_71432_P.func_71401_C()) != null) {
            integratedserver.func_71260_j();
        }
    }

    public Snooper func_71378_E() {
        return this.field_71427_U;
    }

    public Session func_110432_I() {
        return this.field_71449_j;
    }

    public PropertyMap func_181037_M() {
        if (this.field_181038_N.isEmpty()) {
            GameProfile gameprofile = this.func_152347_ac().fillProfileProperties(this.field_71449_j.func_148256_e(), false);
            this.field_181038_N.putAll((Multimap)gameprofile.getProperties());
        }
        return this.field_181038_N;
    }

    public Proxy func_110437_J() {
        return this.field_110453_aa;
    }

    public TextureManager func_110434_K() {
        return this.field_71446_o;
    }

    public IResourceManager func_195551_G() {
        return this.field_110451_am;
    }

    public ResourcePackList<ResourcePackInfoClient> func_195548_H() {
        return this.field_110448_aq;
    }

    public DownloadingPackFinder func_195541_I() {
        return this.field_195554_ax;
    }

    public File func_195549_J() {
        return this.field_130070_K;
    }

    public LanguageManager func_135016_M() {
        return this.field_135017_as;
    }

    public TextureMap func_147117_R() {
        return this.field_147128_au;
    }

    public boolean func_147111_S() {
        return this.field_147129_ai;
    }

    public boolean func_147113_T() {
        return this.field_71445_n;
    }

    public SoundHandler func_147118_V() {
        return this.field_147127_av;
    }

    public MusicTicker.MusicType func_147109_W() {
        MusicTicker.MusicType type;
        MusicTicker.MusicType musicType = type = this.field_71441_e == null || this.field_71441_e.field_73011_w == null ? null : this.field_71441_e.field_73011_w.getMusicType();
        if (type != null) {
            return type;
        }
        if (this.field_71462_r instanceof GuiWinGame) {
            return MusicTicker.MusicType.CREDITS;
        }
        if (this.field_71439_g == null) {
            return MusicTicker.MusicType.MENU;
        }
        if (this.field_71439_g.field_70170_p.field_73011_w instanceof NetherDimension) {
            return MusicTicker.MusicType.NETHER;
        }
        if (this.field_71439_g.field_70170_p.field_73011_w instanceof EndDimension) {
            return this.field_71456_v.func_184046_j().func_184054_d() ? MusicTicker.MusicType.END_BOSS : MusicTicker.MusicType.END;
        }
        Biome.Category biome$category = this.field_71439_g.field_70170_p.func_180494_b(new BlockPos(this.field_71439_g.field_70165_t, this.field_71439_g.field_70163_u, this.field_71439_g.field_70161_v)).func_201856_r();
        if (!this.field_147126_aw.func_209100_b(MusicTicker.MusicType.UNDER_WATER) && (!this.field_71439_g.func_204231_K() || this.field_147126_aw.func_209100_b(MusicTicker.MusicType.GAME) || biome$category != Biome.Category.OCEAN && biome$category != Biome.Category.RIVER)) {
            return this.field_71439_g.field_71075_bZ.field_75098_d && this.field_71439_g.field_71075_bZ.field_75101_c ? MusicTicker.MusicType.CREATIVE : MusicTicker.MusicType.GAME;
        }
        return MusicTicker.MusicType.UNDER_WATER;
    }

    public MinecraftSessionService func_152347_ac() {
        return this.field_152355_az;
    }

    public SkinManager func_152342_ad() {
        return this.field_152350_aA;
    }

    @Nullable
    public Entity func_175606_aa() {
        return this.field_175622_Z;
    }

    public void func_175607_a(Entity viewingEntity) {
        this.field_175622_Z = viewingEntity;
        this.field_71460_t.func_175066_a(viewingEntity);
    }

    public <V> ListenableFuture<V> func_152343_a(Callable<V> callableToSchedule) {
        Validate.notNull(callableToSchedule);
        if (this.func_152345_ab()) {
            try {
                return Futures.immediateFuture(callableToSchedule.call());
            }
            catch (Exception exception) {
                return Futures.immediateFailedCheckedFuture((Exception)exception);
            }
        }
        ListenableFutureTask listenablefuturetask = ListenableFutureTask.create(callableToSchedule);
        this.field_152351_aB.add((FutureTask<?>)listenablefuturetask);
        return listenablefuturetask;
    }

    public ListenableFuture<Object> func_152344_a(Runnable runnableToSchedule) {
        Validate.notNull((Object)runnableToSchedule);
        return this.func_152343_a(Executors.callable(runnableToSchedule));
    }

    public boolean func_152345_ab() {
        return Thread.currentThread() == this.field_152352_aC;
    }

    public BlockRendererDispatcher func_175602_ab() {
        return this.field_175618_aM;
    }

    public RenderManager func_175598_ae() {
        return this.field_175616_W;
    }

    public ItemRenderer func_175599_af() {
        return this.field_175621_X;
    }

    public FirstPersonRenderer func_175597_ag() {
        return this.field_175620_Y;
    }

    public <T> ISearchTree<T> func_193987_a(SearchTreeManager.Key<T> key) {
        return this.field_193995_ae.func_194010_a(key);
    }

    public static int func_175610_ah() {
        return field_71470_ab;
    }

    public FrameTimer func_181539_aj() {
        return this.field_181542_y;
    }

    public boolean func_181540_al() {
        return this.field_181541_X;
    }

    public void func_181537_a(boolean isConnected) {
        this.field_181541_X = isConnected;
    }

    public DataFixer func_184126_aj() {
        return this.field_184131_U;
    }

    public float func_184121_ak() {
        return this.field_71428_T.field_194147_b;
    }

    public float func_193989_ak() {
        return this.field_71428_T.field_194148_c;
    }

    public BlockColors func_184125_al() {
        return this.field_184127_aH;
    }

    public boolean func_189648_am() {
        return this.field_71439_g != null && this.field_71439_g.func_175140_cp() || this.field_71474_y.field_178879_v;
    }

    public GuiToast func_193033_an() {
        return this.field_193034_aS;
    }

    public Tutorial func_193032_ao() {
        return this.field_193035_aW;
    }

    public boolean func_195544_aj() {
        return this.field_195555_I;
    }

    public CreativeSettings func_199403_al() {
        return this.field_191950_u;
    }

    public ModelManager func_209506_al() {
        return this.field_175617_aL;
    }

    public FontResourceManager func_211500_ak() {
        return this.field_211501_aD;
    }

    public ItemColors getItemColors() {
        return this.field_184128_aI;
    }

    public SearchTreeManager getSearchTreeManager() {
        return this.field_193995_ae;
    }

    private static /* synthetic */ IResourcePack lambda$null$0(Supplier p_211818_2_) {
        return new LegacyResourcePackWrapper((IResourcePack)p_211818_2_.get(), LegacyResourcePackWrapper.field_211853_a);
    }
}

