/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.BlockFourWay;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockWall
extends BlockFourWay {
    public static final BooleanProperty field_176256_a = BlockStateProperties.field_208149_B;
    private final VoxelShape[] field_196422_D;
    private final VoxelShape[] field_196423_E;

    public BlockWall(Block.Properties builder) {
        super(0.0f, 3.0f, 0.0f, 14.0f, 24.0f, builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_176256_a, Boolean.valueOf(true))).func_206870_a((IProperty)field_196409_a, Boolean.valueOf(false))).func_206870_a((IProperty)field_196411_b, Boolean.valueOf(false))).func_206870_a((IProperty)field_196413_c, Boolean.valueOf(false))).func_206870_a((IProperty)field_196414_y, Boolean.valueOf(false))).func_206870_a((IProperty)field_204514_u, Boolean.valueOf(false)));
        this.field_196422_D = this.func_196408_a(4.0f, 3.0f, 16.0f, 0.0f, 14.0f);
        this.field_196423_E = this.func_196408_a(4.0f, 3.0f, 24.0f, 0.0f, 24.0f);
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)field_176256_a) != false ? this.field_196422_D[this.func_196406_i(state)] : super.func_196244_b(state, worldIn, pos);
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)field_176256_a) != false ? this.field_196423_E[this.func_196406_i(state)] : super.func_196268_f(state, worldIn, pos);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }

    private boolean func_196421_a(IBlockState p_196421_1_, BlockFaceShape p_196421_2_) {
        Block block = p_196421_1_.func_177230_c();
        boolean flag = p_196421_2_ == BlockFaceShape.MIDDLE_POLE_THICK || p_196421_2_ == BlockFaceShape.MIDDLE_POLE && block instanceof BlockFenceGate;
        return !BlockWall.func_194143_e(block) && p_196421_2_ == BlockFaceShape.SOLID || flag;
    }

    public boolean canBeConnectedTo(IBlockState state, IBlockReader world, BlockPos pos, EnumFacing facing) {
        IBlockState other = world.func_180495_p(pos.func_177972_a(facing));
        return this.func_196421_a(other, other.func_193401_d(world, pos.func_177972_a(facing), facing.func_176734_d()));
    }

    private boolean canWallConnectTo(IBlockReader world, BlockPos pos, EnumFacing facing) {
        BlockPos off = pos.func_177972_a(facing);
        IBlockState other = world.func_180495_p(off);
        return other.canBeConnectedTo(world, off, facing.func_176734_d()) || this.func_196421_a(other, other.func_193401_d(world, off, facing.func_176734_d()));
    }

    public static boolean func_194143_e(Block p_194143_0_) {
        return Block.func_193382_c(p_194143_0_) || p_194143_0_ == Blocks.field_180401_cv || p_194143_0_ == Blocks.field_150440_ba || p_194143_0_ == Blocks.field_150423_aK || p_194143_0_ == Blocks.field_196625_cS || p_194143_0_ == Blocks.field_196628_cT || p_194143_0_ == Blocks.field_185778_de || p_194143_0_ == Blocks.field_150335_W;
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        World iworldreaderbase = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean flag = this.canWallConnectTo((IBlockReader)iworldreaderbase, blockpos, EnumFacing.NORTH);
        boolean flag1 = this.canWallConnectTo((IBlockReader)iworldreaderbase, blockpos, EnumFacing.EAST);
        boolean flag2 = this.canWallConnectTo((IBlockReader)iworldreaderbase, blockpos, EnumFacing.SOUTH);
        boolean flag3 = this.canWallConnectTo((IBlockReader)iworldreaderbase, blockpos, EnumFacing.WEST);
        boolean flag4 = !(flag && !flag1 && flag2 && !flag3 || !flag && flag1 && !flag2 && flag3);
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.func_176223_P().func_206870_a((IProperty)field_176256_a, Boolean.valueOf(flag4 || !iworldreaderbase.func_175623_d(blockpos.func_177984_a())))).func_206870_a((IProperty)field_196409_a, Boolean.valueOf(flag))).func_206870_a((IProperty)field_196411_b, Boolean.valueOf(flag1))).func_206870_a((IProperty)field_196413_c, Boolean.valueOf(flag2))).func_206870_a((IProperty)field_196414_y, Boolean.valueOf(flag3))).func_206870_a((IProperty)field_204514_u, Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_204514_u)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
        }
        if (facing == EnumFacing.DOWN) {
            return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        }
        boolean flag = facing == EnumFacing.NORTH ? this.func_196421_a(facingState, facingState.func_193401_d((IBlockReader)worldIn, facingPos, facing.func_176734_d())) : ((Boolean)stateIn.func_177229_b((IProperty)field_196409_a)).booleanValue();
        boolean flag1 = facing == EnumFacing.EAST ? this.func_196421_a(facingState, facingState.func_193401_d((IBlockReader)worldIn, facingPos, facing.func_176734_d())) : ((Boolean)stateIn.func_177229_b((IProperty)field_196411_b)).booleanValue();
        boolean flag2 = facing == EnumFacing.SOUTH ? this.func_196421_a(facingState, facingState.func_193401_d((IBlockReader)worldIn, facingPos, facing.func_176734_d())) : ((Boolean)stateIn.func_177229_b((IProperty)field_196413_c)).booleanValue();
        boolean flag3 = facing == EnumFacing.WEST ? this.func_196421_a(facingState, facingState.func_193401_d((IBlockReader)worldIn, facingPos, facing.func_176734_d())) : ((Boolean)stateIn.func_177229_b((IProperty)field_196414_y)).booleanValue();
        boolean flag4 = !(flag && !flag1 && flag2 && !flag3 || !flag && flag1 && !flag2 && flag3);
        return (IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)stateIn.func_206870_a((IProperty)field_176256_a, Boolean.valueOf(flag4 || !worldIn.func_175623_d(currentPos.func_177984_a())))).func_206870_a((IProperty)field_196409_a, Boolean.valueOf(flag))).func_206870_a((IProperty)field_196411_b, Boolean.valueOf(flag1))).func_206870_a((IProperty)field_196413_c, Boolean.valueOf(flag2))).func_206870_a((IProperty)field_196414_y, Boolean.valueOf(flag3));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176256_a, field_196409_a, field_196411_b, field_196414_y, field_196413_c, field_204514_u});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face != EnumFacing.UP && face != EnumFacing.DOWN ? BlockFaceShape.MIDDLE_POLE_THICK : BlockFaceShape.CENTER_BIG;
    }
}

