/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.Half;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;

public class BlockTrapDoor
extends BlockHorizontal
implements IBucketPickupHandler,
ILiquidContainer {
    public static final BooleanProperty field_176283_b = BlockStateProperties.field_208193_t;
    public static final EnumProperty<Half> field_176285_M = BlockStateProperties.field_208164_Q;
    public static final BooleanProperty field_196381_c = BlockStateProperties.field_208194_u;
    public static final BooleanProperty field_204614_t = BlockStateProperties.field_208198_y;
    protected static final VoxelShape field_185734_d = Block.func_208617_a(0.0, 0.0, 0.0, 3.0, 16.0, 16.0);
    protected static final VoxelShape field_185735_e = Block.func_208617_a(13.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185736_f = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 3.0);
    protected static final VoxelShape field_185737_g = Block.func_208617_a(0.0, 0.0, 13.0, 16.0, 16.0, 16.0);
    protected static final VoxelShape field_185732_B = Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 3.0, 16.0);
    protected static final VoxelShape field_185733_C = Block.func_208617_a(0.0, 13.0, 0.0, 16.0, 16.0, 16.0);

    protected BlockTrapDoor(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)((Object)EnumFacing.NORTH))).func_206870_a((IProperty)field_176283_b, Boolean.valueOf(false))).func_206870_a((IProperty)field_176285_M, (Comparable)Half.BOTTOM)).func_206870_a((IProperty)field_196381_c, Boolean.valueOf(false))).func_206870_a((IProperty)field_204614_t, Boolean.valueOf(false)));
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        if (!((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue()) {
            return state.func_177229_b((IProperty)field_176285_M) == Half.TOP ? field_185733_C : field_185732_B;
        }
        switch ((EnumFacing)((Object)state.func_177229_b((IProperty)field_185512_D))) {
            default: {
                return field_185737_g;
            }
            case SOUTH: {
                return field_185736_f;
            }
            case WEST: {
                return field_185735_e;
            }
            case EAST: 
        }
        return field_185734_d;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        switch (type) {
            case LAND: {
                return (Boolean)state.func_177229_b((IProperty)field_176283_b);
            }
            case WATER: {
                return (Boolean)state.func_177229_b((IProperty)field_204614_t);
            }
            case AIR: {
                return (Boolean)state.func_177229_b((IProperty)field_176283_b);
            }
        }
        return false;
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.field_149764_J == Material.field_151573_f) {
            return false;
        }
        state = (IBlockState)state.func_177231_a((IProperty)field_176283_b);
        worldIn.func_180501_a(pos, state, 2);
        if (((Boolean)state.func_177229_b((IProperty)field_204614_t)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
        }
        this.func_185731_a(player, worldIn, pos, (Boolean)state.func_177229_b((IProperty)field_176283_b));
        return true;
    }

    protected void func_185731_a(@Nullable EntityPlayer player, World worldIn, BlockPos pos, boolean p_185731_4_) {
        if (p_185731_4_) {
            int i = this.field_149764_J == Material.field_151573_f ? 1037 : 1007;
            worldIn.func_180498_a(player, i, pos, 0);
        } else {
            int j = this.field_149764_J == Material.field_151573_f ? 1036 : 1013;
            worldIn.func_180498_a(player, j, pos, 0);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        boolean flag;
        if (!worldIn.field_72995_K && (flag = worldIn.func_175640_z(pos)) != (Boolean)state.func_177229_b((IProperty)field_196381_c)) {
            if ((Boolean)state.func_177229_b((IProperty)field_176283_b) != flag) {
                state = (IBlockState)state.func_206870_a((IProperty)field_176283_b, Boolean.valueOf(flag));
                this.func_185731_a(null, worldIn, pos, flag);
            }
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_196381_c, Boolean.valueOf(flag)), 2);
            if (((Boolean)state.func_177229_b((IProperty)field_204614_t)).booleanValue()) {
                worldIn.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
            }
        }
    }

    public IBlockState func_196258_a(BlockItemUseContext context) {
        IBlockState iblockstate = this.func_176223_P();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        EnumFacing enumfacing = context.func_196000_l();
        iblockstate = !context.func_196012_c() && enumfacing.func_176740_k().func_176722_c() ? (IBlockState)((IBlockState)iblockstate.func_206870_a((IProperty)field_185512_D, (Comparable)((Object)enumfacing))).func_206870_a((IProperty)field_176285_M, (Comparable)(context.func_195993_n() > 0.5f ? Half.TOP : Half.BOTTOM)) : (IBlockState)((IBlockState)iblockstate.func_206870_a((IProperty)field_185512_D, (Comparable)((Object)context.func_195992_f().func_176734_d()))).func_206870_a((IProperty)field_176285_M, (Comparable)(enumfacing == EnumFacing.UP ? Half.BOTTOM : Half.TOP));
        if (context.func_195991_k().func_175640_z(context.func_195995_a())) {
            iblockstate = (IBlockState)((IBlockState)iblockstate.func_206870_a((IProperty)field_176283_b, Boolean.valueOf(true))).func_206870_a((IProperty)field_196381_c, Boolean.valueOf(true));
        }
        return (IBlockState)iblockstate.func_206870_a((IProperty)field_204614_t, Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, field_176283_b, field_176285_M, field_196381_c, field_204614_t});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return (face == EnumFacing.UP && state.func_177229_b((IProperty)field_176285_M) == Half.TOP || face == EnumFacing.DOWN && state.func_177229_b((IProperty)field_176285_M) == Half.BOTTOM) && (Boolean)state.func_177229_b((IProperty)field_176283_b) == false ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public Fluid func_204508_a(IWorld worldIn, BlockPos pos, IBlockState state) {
        if (((Boolean)state.func_177229_b((IProperty)field_204614_t)).booleanValue()) {
            worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_204614_t, Boolean.valueOf(false)), 3);
            return Fluids.field_204546_a;
        }
        return Fluids.field_204541_a;
    }

    public IFluidState func_204507_t(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_204614_t) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, IBlockState state, Fluid fluidIn) {
        return (Boolean)state.func_177229_b((IProperty)field_204614_t) == false && fluidIn == Fluids.field_204546_a;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, IBlockState state, IFluidState fluidStateIn) {
        if (!((Boolean)state.func_177229_b((IProperty)field_204614_t)).booleanValue() && fluidStateIn.func_206886_c() == Fluids.field_204546_a) {
            if (!worldIn.func_201670_d()) {
                worldIn.func_180501_a(pos, (IBlockState)state.func_206870_a((IProperty)field_204614_t, Boolean.valueOf(true)), 3);
                worldIn.func_205219_F_().func_205360_a(pos, (Object)fluidStateIn.func_206886_c(), fluidStateIn.func_206886_c().func_205569_a(worldIn));
            }
            return true;
        }
        return false;
    }

    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_204614_t)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
        }
        return super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public boolean isLadder(IBlockState state, IWorldReader world, BlockPos pos, EntityLivingBase entity) {
        IBlockState down;
        if (((Boolean)state.func_177229_b((IProperty)field_176283_b)).booleanValue() && (down = world.func_180495_p(pos.func_177977_b())).func_177230_c() == Blocks.field_150468_ap) {
            return down.func_177229_b((IProperty)BlockLadder.field_176382_a) == state.func_177229_b((IProperty)field_185512_D);
        }
        return false;
    }
}

