/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSeaGrassTall;
import net.minecraft.block.IGrowable;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.init.Items;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

public class BlockSeaGrass
extends BlockBush
implements IGrowable,
ILiquidContainer,
IShearable {
    protected static final VoxelShape field_207798_a = Block.func_208617_a(2.0, 0.0, 2.0, 14.0, 12.0, 14.0);

    protected BlockSeaGrass(Block.Properties builder) {
        super(builder);
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_207798_a;
    }

    @Override
    protected boolean func_200014_a_(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return Block.func_208061_a(state.func_196952_d(worldIn, pos), EnumFacing.UP) && state.func_177230_c() != Blocks.field_196814_hQ;
    }

    @Override
    @Nullable
    public IBlockState func_196258_a(BlockItemUseContext context) {
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        return ifluidstate.func_206884_a(FluidTags.field_206959_a) && ifluidstate.func_206882_g() == 8 ? super.func_196258_a(context) : null;
    }

    @Override
    public IBlockState func_196271_a(IBlockState stateIn, EnumFacing facing, IBlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        IBlockState iblockstate = super.func_196271_a(stateIn, facing, facingState, worldIn, currentPos, facingPos);
        if (!iblockstate.func_196958_f()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReaderBase)worldIn));
        }
        return iblockstate;
    }

    @Override
    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    @Override
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Items.field_190931_a;
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    @Override
    public IFluidState func_204507_t(IBlockState state) {
        return Fluids.field_204546_a.func_207204_a(false);
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        IBlockState iblockstate = Blocks.field_203199_aR.func_176223_P();
        IBlockState iblockstate1 = (IBlockState)iblockstate.func_206870_a((IProperty)BlockSeaGrassTall.field_208065_c, (Comparable)DoubleBlockHalf.UPPER);
        BlockPos blockpos = pos.func_177984_a();
        if (worldIn.func_180495_p(blockpos).func_177230_c() == Blocks.field_150355_j) {
            worldIn.func_180501_a(pos, iblockstate, 2);
            worldIn.func_180501_a(blockpos, iblockstate1, 2);
        }
    }

    public boolean func_204510_a(IBlockReader worldIn, BlockPos pos, IBlockState state, Fluid fluidIn) {
        return false;
    }

    public boolean func_204509_a(IWorld worldIn, BlockPos pos, IBlockState state, IFluidState fluidStateIn) {
        return false;
    }

    @Override
    public int func_200011_d(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return Blocks.field_150355_j.func_176223_P().func_200016_a(worldIn, pos);
    }

    public boolean isShearable(ItemStack item, IWorldReader world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
        return Arrays.asList(new ItemStack(this));
    }
}

