/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockRedstoneTorch
extends BlockTorch {
    public static final BooleanProperty field_196528_a = BlockStateProperties.field_208190_q;
    private static final Map<IBlockReader, List<Toggle>> field_196529_b = new WeakHashMap<IBlockReader, List<Toggle>>();

    protected BlockRedstoneTorch(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_196528_a, Boolean.valueOf(true)));
    }

    @Override
    public int func_149738_a(IWorldReaderBase worldIn) {
        return 2;
    }

    @Override
    public void func_196259_b(IBlockState state, World worldIn, BlockPos pos, IBlockState oldState) {
        for (EnumFacing enumfacing : EnumFacing.values()) {
            worldIn.func_195593_d(pos.func_177972_a(enumfacing), this);
        }
    }

    @Override
    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (!isMoving) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                worldIn.func_195593_d(pos.func_177972_a(enumfacing), this);
            }
        }
    }

    @Override
    public int func_180656_a(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return (Boolean)blockState.func_177229_b((IProperty)field_196528_a) != false && EnumFacing.UP != side ? 15 : 0;
    }

    protected boolean func_176597_g(World worldIn, BlockPos pos, IBlockState state) {
        return worldIn.func_175709_b(pos.func_177977_b(), EnumFacing.DOWN);
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        BlockRedstoneTorch.func_196527_a(state, worldIn, pos, random, this.func_176597_g(worldIn, pos, state));
    }

    public static void func_196527_a(IBlockState p_196527_0_, World p_196527_1_, BlockPos p_196527_2_, Random p_196527_3_, boolean p_196527_4_) {
        List<Toggle> list = field_196529_b.get(p_196527_1_);
        while (list != null && !list.isEmpty() && p_196527_1_.func_82737_E() - list.get(0).field_150844_d > 60L) {
            list.remove(0);
        }
        if (((Boolean)p_196527_0_.func_177229_b((IProperty)field_196528_a)).booleanValue()) {
            if (p_196527_4_) {
                p_196527_1_.func_180501_a(p_196527_2_, (IBlockState)p_196527_0_.func_206870_a((IProperty)field_196528_a, Boolean.valueOf(false)), 3);
                if (BlockRedstoneTorch.func_176598_a(p_196527_1_, p_196527_2_, true)) {
                    p_196527_1_.func_184133_a(null, p_196527_2_, SoundEvents.field_187745_eA, SoundCategory.BLOCKS, 0.5f, 2.6f + (p_196527_1_.field_73012_v.nextFloat() - p_196527_1_.field_73012_v.nextFloat()) * 0.8f);
                    for (int i = 0; i < 5; ++i) {
                        double d0 = (double)p_196527_2_.func_177958_n() + p_196527_3_.nextDouble() * 0.6 + 0.2;
                        double d1 = (double)p_196527_2_.func_177956_o() + p_196527_3_.nextDouble() * 0.6 + 0.2;
                        double d2 = (double)p_196527_2_.func_177952_p() + p_196527_3_.nextDouble() * 0.6 + 0.2;
                        p_196527_1_.func_195594_a((IParticleData)Particles.field_197601_L, d0, d1, d2, 0.0, 0.0, 0.0);
                    }
                    p_196527_1_.func_205220_G_().func_205360_a(p_196527_2_, (Object)p_196527_1_.func_180495_p(p_196527_2_).func_177230_c(), 160);
                }
            }
        } else if (!p_196527_4_ && !BlockRedstoneTorch.func_176598_a(p_196527_1_, p_196527_2_, false)) {
            p_196527_1_.func_180501_a(p_196527_2_, (IBlockState)p_196527_0_.func_206870_a((IProperty)field_196528_a, Boolean.valueOf(true)), 3);
        }
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (((Boolean)state.func_177229_b((IProperty)field_196528_a)).booleanValue() == this.func_176597_g(worldIn, pos, state) && !worldIn.func_205220_G_().func_205361_b(pos, (Object)this)) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a(worldIn));
        }
    }

    @Override
    public int func_176211_b(IBlockState blockState, IBlockReader blockAccess, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    @Override
    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)field_196528_a)).booleanValue()) {
            double d0 = (double)pos.func_177958_n() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            double d1 = (double)pos.func_177956_o() + 0.7 + (rand.nextDouble() - 0.5) * 0.2;
            double d2 = (double)pos.func_177952_p() + 0.5 + (rand.nextDouble() - 0.5) * 0.2;
            worldIn.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)field_196528_a) != false ? super.func_149750_m(state) : 0;
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196528_a});
    }

    private static boolean func_176598_a(World p_176598_0_, BlockPos worldIn, boolean pos) {
        ArrayList list = field_196529_b.get(p_176598_0_);
        if (list == null) {
            list = Lists.newArrayList();
            field_196529_b.put((IBlockReader)p_176598_0_, list);
        }
        if (pos) {
            list.add(new Toggle(worldIn.func_185334_h(), p_176598_0_.func_82737_E()));
        }
        int i = 0;
        for (int j = 0; j < list.size(); ++j) {
            Toggle blockredstonetorch$toggle = (Toggle)list.get(j);
            if (!blockredstonetorch$toggle.field_180111_a.equals((Object)worldIn) || ++i < 8) continue;
            return true;
        }
        return false;
    }

    public static class Toggle {
        private final BlockPos field_180111_a;
        private final long field_150844_d;

        public Toggle(BlockPos pos, long time) {
            this.field_180111_a = pos;
            this.field_150844_d = time;
        }
    }
}

