/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockPistonExtension;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.PistonType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityPiston;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Mirror;
import net.minecraft.util.NonNullList;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class BlockPistonMoving
extends BlockContainer {
    public static final DirectionProperty field_196344_a = BlockPistonExtension.field_176387_N;
    public static final EnumProperty<PistonType> field_196345_b = BlockPistonExtension.field_176325_b;

    public BlockPistonMoving(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_196344_a, (Comparable)((Object)EnumFacing.NORTH))).func_206870_a((IProperty)field_196345_b, (Comparable)PistonType.DEFAULT));
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return null;
    }

    public static TileEntity func_196343_a(IBlockState p_196343_0_, EnumFacing p_196343_1_, boolean p_196343_2_, boolean p_196343_3_) {
        return new TileEntityPiston(p_196343_0_, p_196343_1_, p_196343_2_, p_196343_3_);
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            if (tileentity instanceof TileEntityPiston) {
                ((TileEntityPiston)tileentity).func_145866_f();
            } else {
                super.func_196243_a(state, worldIn, pos, newState, isMoving);
            }
        }
    }

    public void func_176206_d(IWorld worldIn, BlockPos pos, IBlockState state) {
        BlockPos blockpos = pos.func_177972_a(((EnumFacing)((Object)state.func_177229_b((IProperty)field_196344_a))).func_176734_d());
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        if (iblockstate.func_177230_c() instanceof BlockPistonBase && ((Boolean)iblockstate.func_177229_b((IProperty)BlockPistonBase.field_176320_b)).booleanValue()) {
            worldIn.func_175698_g(blockpos);
        }
    }

    public boolean func_200124_e(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_196250_a(IBlockState state, World worldIn, BlockPos pos, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) == null) {
            worldIn.func_175698_g(pos);
            return true;
        }
        return false;
    }

    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return Items.field_190931_a;
    }

    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        super.func_196255_a(state, worldIn, pos, 1.0f, fortune);
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        TileEntityPiston te = this.func_196342_a((IBlockReader)world, pos);
        if (te != null) {
            te.func_200230_i().getDrops(drops, world, pos, fortune);
        }
    }

    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return VoxelShapes.func_197880_a();
    }

    public VoxelShape func_196268_f(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        TileEntityPiston tileentitypiston = this.func_196342_a(worldIn, pos);
        return tileentitypiston != null ? tileentitypiston.func_195508_a(worldIn, pos) : VoxelShapes.func_197880_a();
    }

    @Nullable
    private TileEntityPiston func_196342_a(IBlockReader p_196342_1_, BlockPos p_196342_2_) {
        TileEntity tileentity = p_196342_1_.func_175625_s(p_196342_2_);
        return tileentity instanceof TileEntityPiston ? (TileEntityPiston)tileentity : null;
    }

    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return ItemStack.field_190927_a;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return (IBlockState)state.func_206870_a((IProperty)field_196344_a, (Comparable)((Object)rot.func_185831_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_196344_a)))));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((EnumFacing)((Object)state.func_177229_b((IProperty)field_196344_a))));
    }

    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_196344_a, field_196345_b});
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_196266_a(IBlockState state, IBlockReader worldIn, BlockPos pos, PathType type) {
        return false;
    }
}

