/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;

public class BlockCrops
extends BlockBush
implements IGrowable {
    public static final IntegerProperty field_176488_a = BlockStateProperties.field_208170_W;
    private static final VoxelShape[] field_196393_a = new VoxelShape[]{Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 2.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 4.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 6.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 8.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 10.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 12.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 14.0, 16.0), Block.func_208617_a(0.0, 0.0, 0.0, 16.0, 16.0, 16.0)};

    protected BlockCrops(Block.Properties builder) {
        super(builder);
        this.func_180632_j((IBlockState)((IBlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)this.func_185524_e(), Integer.valueOf(0)));
    }

    @Override
    public VoxelShape func_196244_b(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return field_196393_a[(Integer)state.func_177229_b((IProperty)this.func_185524_e())];
    }

    @Override
    protected boolean func_200014_a_(IBlockState state, IBlockReader worldIn, BlockPos pos) {
        return state.func_177230_c() == Blocks.field_150458_ak;
    }

    public IntegerProperty func_185524_e() {
        return field_176488_a;
    }

    public int func_185526_g() {
        return 7;
    }

    protected int func_185527_x(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e());
    }

    public IBlockState func_185528_e(int age) {
        return (IBlockState)this.func_176223_P().func_206870_a((IProperty)this.func_185524_e(), Integer.valueOf(age));
    }

    public boolean func_185525_y(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.func_185524_e()) >= this.func_185526_g();
    }

    @Override
    public void func_196267_b(IBlockState state, World worldIn, BlockPos pos, Random random) {
        float f;
        int i;
        super.func_196267_b(state, worldIn, pos, random);
        if (!worldIn.func_205050_e(pos, 1)) {
            return;
        }
        if (worldIn.func_201669_a(pos.func_177984_a(), 0) >= 9 && (i = this.func_185527_x(state)) < this.func_185526_g() && ForgeHooks.onCropsGrowPre((World)worldIn, (BlockPos)pos, (IBlockState)state, (random.nextInt((int)(25.0f / (f = BlockCrops.func_180672_a(this, (IBlockReader)worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            worldIn.func_180501_a(pos, this.func_185528_e(i + 1), 2);
            ForgeHooks.onCropsGrowPost((World)worldIn, (BlockPos)pos, (IBlockState)state);
        }
    }

    public void func_176487_g(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if (i > (j = this.func_185526_g())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.func_185528_e(i), 2);
    }

    protected int func_185529_b(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    protected static float func_180672_a(Block blockIn, IBlockReader worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.canSustainPlant(worldIn, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    @Override
    public boolean func_196260_a(IBlockState state, IWorldReaderBase worldIn, BlockPos pos) {
        return (worldIn.func_201669_a(pos, 0) >= 8 || worldIn.func_175678_i(pos)) && super.func_196260_a(state, worldIn, pos);
    }

    protected IItemProvider func_199772_f() {
        return Items.field_151014_N;
    }

    protected IItemProvider func_199773_g() {
        return Items.field_151015_O;
    }

    @Override
    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        super.func_196255_a(state, worldIn, pos, chancePerItem, fortune);
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        super.getDrops(state, drops, world, pos, 0);
        int i = this.func_185527_x(state);
        if (i >= this.func_185526_g()) {
            int j = 3 + fortune;
            for (int k = 0; k < j; ++k) {
                if (world.field_73012_v.nextInt(2 * this.func_185526_g()) > i) continue;
                drops.add((Object)new ItemStack(this.func_199772_f()));
            }
        }
    }

    @Override
    public IItemProvider func_199769_a(IBlockState state, World worldIn, BlockPos pos, int fortune) {
        return this.func_185525_y(state) ? this.func_199773_g() : this.func_199772_f();
    }

    @Override
    public ItemStack func_185473_a(IBlockReader worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_199772_f());
    }

    public boolean func_176473_a(IBlockReader worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.func_185525_y(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.func_176487_g(worldIn, pos, state);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, IBlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_176488_a});
    }
}

