/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.block;

import com.mojang.authlib.GameProfile;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockSkull;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class BlockAbstractSkull
extends BlockContainer {
    private final BlockSkull.ISkullType field_196293_a;

    public BlockAbstractSkull(BlockSkull.ISkullType p_i48452_1_, Block.Properties p_i48452_2_) {
        super(p_i48452_2_);
        this.field_196293_a = p_i48452_1_;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_190946_v(IBlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new TileEntitySkull();
    }

    public void func_196255_a(IBlockState state, World worldIn, BlockPos pos, float chancePerItem, int fortune) {
        super.func_196255_a(state, worldIn, pos, chancePerItem, fortune);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (!worldIn.field_72995_K && player.field_71075_bZ.field_75098_d) {
            TileEntitySkull.func_195486_a((IBlockReader)worldIn, (BlockPos)pos);
        }
        this.func_196255_a(state, worldIn, pos, 1.0f, 0);
        super.func_176208_a(worldIn, pos, state, player);
    }

    public BlockFaceShape func_193383_a(IBlockReader worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public void func_196243_a(IBlockState state, World worldIn, BlockPos pos, IBlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c() && !worldIn.field_72995_K) {
            TileEntity tileentity = worldIn.func_175625_s(pos);
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
        }
    }

    public void getDrops(IBlockState state, NonNullList<ItemStack> drops, World world, BlockPos pos, int fortune) {
        TileEntitySkull skull;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntitySkull && (skull = (TileEntitySkull)te).func_195487_d()) {
            ItemStack ret = this.func_185473_a((IBlockReader)world, pos, state);
            Block block = skull.func_195044_w().func_177230_c();
            if ((block == Blocks.field_196710_eS || block == Blocks.field_196709_eR) && skull.func_152108_a() != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTUtil.func_180708_a((NBTTagCompound)nbt, (GameProfile)skull.func_152108_a());
                ret.func_196082_o().func_74782_a("SkullOwner", nbt);
            }
            drops.add((Object)ret);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public BlockSkull.ISkullType func_196292_N_() {
        return this.field_196293_a;
    }
}

