/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.loading.moddiscovery;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraftforge.fml.loading.LogMarkers;
import net.minecraftforge.fml.loading.moddiscovery.CoreModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModFileInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModFileParser {
    private static final Logger LOGGER = LogManager.getLogger();

    public static IModFileInfo readModList(ModFile modFile) {
        LOGGER.debug(LogMarkers.LOADING, "Parsing mod file candidate {}", (Object)modFile.getFilePath());
        Path modsjson = modFile.getLocator().findPath(modFile, "META-INF", "mods.toml");
        if (!Files.exists(modsjson, new LinkOption[0])) {
            LOGGER.warn(LogMarkers.LOADING, "Mod file {} is missing mods.toml file", (Object)modFile);
            return null;
        }
        return ModFileParser.loadModFile(modFile, modsjson);
    }

    public static IModFileInfo loadModFile(ModFile file, Path modsjson) {
        FileConfig fileConfig = FileConfig.builder((Path)modsjson).build();
        fileConfig.load();
        fileConfig.close();
        return new ModFileInfo(file, (UnmodifiableConfig)fileConfig);
    }

    protected static List<CoreModFile> getCoreMods(ModFile modFile) {
        Map coreModPaths;
        try {
            Path coremodsjson = modFile.getLocator().findPath(modFile, "META-INF", "coremods.json");
            if (!Files.exists(coremodsjson, new LinkOption[0])) {
                return Collections.emptyList();
            }
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            Gson gson = new Gson();
            coreModPaths = (Map)gson.fromJson((Reader)Files.newBufferedReader(coremodsjson), type);
        }
        catch (IOException e2) {
            LOGGER.debug(LogMarkers.LOADING, "Failed to read coremod list coremods.json", (Throwable)e2);
            return Collections.emptyList();
        }
        return coreModPaths.entrySet().stream().peek(e -> LOGGER.debug(LogMarkers.LOADING, "Found coremod {} with Javascript path {}", e.getKey(), e.getValue())).map(e -> new CoreModFile((String)e.getKey(), modFile.getLocator().findPath(modFile, (String)e.getValue()), modFile)).collect(Collectors.toList());
    }
}

