/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.items;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class SlotItemHandler
extends Slot {
    private static IInventory emptyInventory = new InventoryBasic((ITextComponent)new TextComponentString("[Null]"), 0);
    private final IItemHandler itemHandler;
    private final int index;

    public SlotItemHandler(IItemHandler itemHandler, int index, int xPosition, int yPosition) {
        super(emptyInventory, index, xPosition, yPosition);
        this.itemHandler = itemHandler;
        this.index = index;
    }

    public boolean func_75214_a(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        return this.itemHandler.isItemValid(this.index, stack);
    }

    @Nonnull
    public ItemStack func_75211_c() {
        return this.getItemHandler().getStackInSlot(this.index);
    }

    public void func_75215_d(@Nonnull ItemStack stack) {
        ((IItemHandlerModifiable)this.getItemHandler()).setStackInSlot(this.index, stack);
        this.func_75218_e();
    }

    public void func_75220_a(@Nonnull ItemStack p_75220_1_, @Nonnull ItemStack p_75220_2_) {
    }

    public int func_75219_a() {
        return this.itemHandler.getSlotLimit(this.index);
    }

    public int func_178170_b(@Nonnull ItemStack stack) {
        ItemStack maxAdd = stack.func_77946_l();
        int maxInput = stack.func_77976_d();
        maxAdd.func_190920_e(maxInput);
        IItemHandler handler = this.getItemHandler();
        ItemStack currentStack = handler.getStackInSlot(this.index);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            handlerModifiable.setStackInSlot(this.index, ItemStack.field_190927_a);
            ItemStack remainder = handlerModifiable.insertItem(this.index, maxAdd, true);
            handlerModifiable.setStackInSlot(this.index, currentStack);
            return maxInput - remainder.func_190916_E();
        }
        ItemStack remainder = handler.insertItem(this.index, maxAdd, true);
        int current = currentStack.func_190916_E();
        int added = maxInput - remainder.func_190916_E();
        return current + added;
    }

    public boolean func_82869_a(EntityPlayer playerIn) {
        return !this.getItemHandler().extractItem(this.index, 1, true).func_190926_b();
    }

    @Nonnull
    public ItemStack func_75209_a(int amount) {
        return this.getItemHandler().extractItem(this.index, amount, false);
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }
}

