/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.network;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ExtensionPoint;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.FMLNetworkConstants;
import net.minecraftforge.fml.network.NetworkRegistry;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FMLStatusPing {
    private static final Logger LOGGER = LogManager.getLogger();
    private transient Map<ResourceLocation, Pair<String, Boolean>> channels;
    private transient Map<String, String> mods;
    private transient int fmlNetworkVer;

    public FMLStatusPing() {
        this.channels = NetworkRegistry.buildChannelVersionsForListPing();
        this.mods = new HashMap<String, String>();
        ModList.get().forEachModContainer((modid, mc) -> this.mods.put((String)modid, mc.getCustomExtension(ExtensionPoint.DISPLAYTEST).map(Pair::getLeft).map(Supplier::get).orElse("OHNOES\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31\ud83d\ude31")));
        this.fmlNetworkVer = 2;
    }

    private FMLStatusPing(Map<ResourceLocation, Pair<String, Boolean>> deserialized, Map<String, String> modMarkers, int fmlNetVer) {
        this.channels = ImmutableMap.copyOf(deserialized);
        this.mods = modMarkers;
        this.fmlNetworkVer = fmlNetVer;
    }

    public Map<ResourceLocation, Pair<String, Boolean>> getRemoteChannels() {
        return this.channels;
    }

    public Map<String, String> getRemoteModData() {
        return this.mods;
    }

    public int getFMLNetworkVersion() {
        return this.fmlNetworkVer;
    }

    public static class Serializer {
        public static FMLStatusPing deserialize(JsonObject forgeData, JsonDeserializationContext ctx) {
            try {
                Map<ResourceLocation, Pair> channels = StreamSupport.stream(JsonUtils.func_151214_t((JsonObject)forgeData, (String)"channels").spliterator(), false).map(JsonElement::getAsJsonObject).collect(Collectors.toMap(jo -> new ResourceLocation(JsonUtils.func_151200_h((JsonObject)jo, (String)"res")), jo -> Pair.of((Object)JsonUtils.func_151200_h((JsonObject)jo, (String)"version"), (Object)JsonUtils.func_151212_i((JsonObject)jo, (String)"required"))));
                Map<String, String> mods = StreamSupport.stream(JsonUtils.func_151214_t((JsonObject)forgeData, (String)"mods").spliterator(), false).map(JsonElement::getAsJsonObject).collect(Collectors.toMap(jo -> JsonUtils.func_151200_h((JsonObject)jo, (String)"modId"), jo -> JsonUtils.func_151200_h((JsonObject)jo, (String)"modmarker")));
                int remoteFMLVersion = JsonUtils.func_151203_m((JsonObject)forgeData, (String)"fmlNetworkVersion");
                return new FMLStatusPing(channels, mods, remoteFMLVersion);
            }
            catch (JsonSyntaxException e) {
                LOGGER.debug(FMLNetworkConstants.NETWORK, "Encountered an error parsing status ping data", (Throwable)e);
                return null;
            }
        }

        public static JsonObject serialize(FMLStatusPing forgeData, JsonSerializationContext ctx) {
            JsonObject obj = new JsonObject();
            JsonArray channels = new JsonArray();
            forgeData.channels.forEach((namespace, version) -> {
                JsonObject mi = new JsonObject();
                mi.addProperty("res", namespace.toString());
                mi.addProperty("version", (String)version.getLeft());
                mi.addProperty("required", (Boolean)version.getRight());
                channels.add((JsonElement)mi);
            });
            obj.add("channels", (JsonElement)channels);
            JsonArray modTestValues = new JsonArray();
            forgeData.mods.forEach((modId, value) -> {
                JsonObject mi = new JsonObject();
                mi.addProperty("modId", modId);
                mi.addProperty("modmarker", value);
                modTestValues.add((JsonElement)mi);
            });
            obj.add("mods", (JsonElement)modTestValues);
            obj.addProperty("fmlNetworkVersion", (Number)forgeData.fmlNetworkVer);
            return obj;
        }
    }
}

