/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.gameevent;

import javax.annotation.Nonnull;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.eventbus.api.Event;

public class PlayerEvent
extends Event {
    private final EntityPlayer player;

    private PlayerEvent(EntityPlayer player) {
        this.player = player;
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public static class PlayerChangedDimensionEvent
    extends PlayerEvent {
        private final DimensionType fromDim;
        private final DimensionType toDim;

        public PlayerChangedDimensionEvent(EntityPlayer player, DimensionType fromDim, DimensionType toDim) {
            super(player);
            this.fromDim = fromDim;
            this.toDim = toDim;
        }

        public DimensionType getFrom() {
            return this.fromDim;
        }

        public DimensionType getTo() {
            return this.toDim;
        }
    }

    public static class PlayerRespawnEvent
    extends PlayerEvent {
        private final boolean endConquered;

        public PlayerRespawnEvent(EntityPlayer player, boolean endConquered) {
            super(player);
            this.endConquered = endConquered;
        }

        public boolean isEndConquered() {
            return this.endConquered;
        }
    }

    public static class PlayerLoggedOutEvent
    extends PlayerEvent {
        public PlayerLoggedOutEvent(EntityPlayer player) {
            super(player);
        }
    }

    public static class PlayerLoggedInEvent
    extends PlayerEvent {
        public PlayerLoggedInEvent(EntityPlayer player) {
            super(player);
        }
    }

    public static class ItemSmeltedEvent
    extends PlayerEvent {
        @Nonnull
        private final ItemStack smelting;

        public ItemSmeltedEvent(EntityPlayer player, @Nonnull ItemStack crafting) {
            super(player);
            this.smelting = crafting;
        }

        @Nonnull
        public ItemStack getSmelting() {
            return this.smelting;
        }
    }

    public static class ItemCraftedEvent
    extends PlayerEvent {
        @Nonnull
        private final ItemStack crafting;
        private final IInventory craftMatrix;

        public ItemCraftedEvent(EntityPlayer player, @Nonnull ItemStack crafting, IInventory craftMatrix) {
            super(player);
            this.crafting = crafting;
            this.craftMatrix = craftMatrix;
        }

        @Nonnull
        public ItemStack getCrafting() {
            return this.crafting;
        }

        public IInventory getInventory() {
            return this.craftMatrix;
        }
    }

    public static class ItemPickupEvent
    extends PlayerEvent {
        private final EntityItem originalEntity;
        private final ItemStack stack;

        public ItemPickupEvent(EntityPlayer player, EntityItem entPickedUp, ItemStack stack) {
            super(player);
            this.originalEntity = entPickedUp;
            this.stack = stack;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public EntityItem getOriginalEntity() {
            return this.originalEntity;
        }
    }
}

