/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.MavenVersionStringHelper;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.client.gui.GuiModList;
import net.minecraftforge.fml.loading.moddiscovery.ModInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class GuiSlotModList
extends GuiListExtended<ModEntry> {
    private static final ResourceLocation VERSION_CHECK_ICONS = new ResourceLocation("forge", "textures/gui/version_check_icons.png");
    private final int listWidth;
    private GuiModList parent;

    public GuiSlotModList(GuiModList parent, int listWidth) {
        super(parent.getMinecraftInstance(), listWidth, parent.field_146295_m, 32, parent.field_146295_m - 67 + 4, parent.getFontRenderer().field_78288_b * 2 + 8);
        this.parent = parent;
        this.listWidth = listWidth;
        this.refreshList();
    }

    protected int func_148137_d() {
        return this.listWidth;
    }

    public int func_148139_c() {
        return this.listWidth;
    }

    void refreshList() {
        this.func_195086_c();
        this.parent.buildModList(arg_0 -> ((GuiSlotModList)this).func_195085_a(arg_0), mod -> new ModEntry((ModInfo)mod, this.parent));
    }

    protected boolean func_148131_a(int index) {
        return this.parent.modIndexSelected(index);
    }

    protected void func_148123_a() {
        this.parent.func_146276_q_();
    }

    class ModEntry
    extends GuiListExtended.IGuiListEntry<ModEntry> {
        private final ModInfo modInfo;
        private final GuiModList parent;

        ModEntry(ModInfo info, GuiModList parent) {
            this.modInfo = info;
            this.parent = parent;
        }

        public void func_194999_a(int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            int top = this.func_195001_c();
            int left = this.func_195002_d();
            String name = StringUtils.func_76338_a((String)this.modInfo.getDisplayName());
            String version = StringUtils.func_76338_a((String)MavenVersionStringHelper.artifactVersionToString(this.modInfo.getVersion()));
            VersionChecker.CheckResult vercheck = VersionChecker.getResult((IModInfo)this.modInfo);
            FontRenderer font = this.parent.getFontRenderer();
            font.func_211126_b(font.func_78269_a(name, GuiSlotModList.this.listWidth), (float)(left + 3), (float)(top + 2), 0xFFFFFF);
            font.func_211126_b(font.func_78269_a(version, GuiSlotModList.this.listWidth), (float)(left + 3), (float)(top + 2 + font.field_78288_b), 0xCCCCCC);
            if (vercheck.status.shouldDraw()) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(VERSION_CHECK_ICONS);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179094_E();
                Gui.func_146110_a((int)(GuiSlotModList.this.field_148151_d - (GuiSlotModList.this.field_148158_l / 2 + 4)), (int)(GuiSlotModList.this.field_148153_b + (GuiSlotModList.this.field_148158_l / 2 - 4)), (float)(vercheck.status.getSheetOffset() * 8), (float)(vercheck.status.isAnimated() && (System.currentTimeMillis() / 800L & 1L) == 1L ? 8.0f : 0.0f), (int)8, (int)8, (float)64.0f, (float)16.0f);
                GlStateManager.func_179121_F();
            }
        }

        public boolean mouseClicked(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
            this.parent.selectModIndex(this.func_195003_b());
            return false;
        }
    }
}

