/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.SidedProvider;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.lifecycle.ModLifecycleEvent;

public enum ModLoadingStage {
    ERROR(null),
    VALIDATE(null),
    CONSTRUCT(null),
    CREATE_REGISTRIES(null),
    LOAD_REGISTRIES(null),
    COMMON_SETUP(() -> FMLCommonSetupEvent::new),
    SIDED_SETUP(SidedProvider.SIDED_SETUP_EVENT::get),
    ENQUEUE_IMC(() -> InterModEnqueueEvent::new),
    PROCESS_IMC(() -> InterModProcessEvent::new),
    COMPLETE(() -> FMLLoadCompleteEvent::new),
    DONE(null);

    private final Supplier<Function<ModContainer, ModLifecycleEvent>> modLifecycleEventFunction;

    private ModLoadingStage(Supplier<Function<ModContainer, ModLifecycleEvent>> modLifecycleEventFunction) {
        this.modLifecycleEventFunction = modLifecycleEventFunction;
    }

    public ModLifecycleEvent getModEvent(ModContainer modContainer) {
        return this.modLifecycleEventFunction.get().apply(modContainer);
    }
}

