/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fluids.capability.wrappers;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBucketMilk;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidBucketWrapper
implements IFluidHandlerItem,
ICapabilityProvider {
    private final LazyOptional<IFluidHandlerItem> holder = LazyOptional.of(() -> this);
    @Nonnull
    protected ItemStack container;

    public FluidBucketWrapper(@Nonnull ItemStack container) {
        this.container = container;
    }

    @Override
    @Nonnull
    public ItemStack getContainer() {
        return this.container;
    }

    public boolean canFillFluidType(FluidStack fluid) {
        return false;
    }

    @Nullable
    public FluidStack getFluid() {
        Item item = this.container.func_77973_b();
        if (item == ForgeMod.getInstance().universalBucket) {
            return ForgeMod.getInstance().universalBucket.getFluid(this.container);
        }
        return null;
    }

    protected void setFluid(@Nullable FluidStack fluidStack) {
        this.container = fluidStack == null ? new ItemStack((IItemProvider)Items.field_151133_ar) : FluidUtil.getFilledBucket(fluidStack);
    }

    @Override
    public IFluidTankProperties[] getTankProperties() {
        return new FluidTankProperties[]{new FluidTankProperties(this.getFluid(), 1000)};
    }

    @Override
    public int fill(FluidStack resource, boolean doFill) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 1000 || this.container.func_77973_b() instanceof ItemBucketMilk || this.getFluid() != null || !this.canFillFluidType(resource)) {
            return 0;
        }
        if (doFill) {
            this.setFluid(resource);
        }
        return 1000;
    }

    @Override
    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || resource == null || resource.amount < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null && fluidStack.isFluidEqual(resource)) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    @Override
    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.container.func_190916_E() != 1 || maxDrain < 1000) {
            return null;
        }
        FluidStack fluidStack = this.getFluid();
        if (fluidStack != null) {
            if (doDrain) {
                this.setFluid(null);
            }
            return fluidStack;
        }
        return null;
    }

    @Override
    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        return CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.orEmpty(capability, this.holder);
    }
}

