/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.living;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public class LivingSpawnEvent
extends LivingEvent {
    private final IWorld world;
    private final double x;
    private final double y;
    private final double z;

    public LivingSpawnEvent(EntityLiving entity, IWorld world, double x, double y, double z) {
        super((EntityLivingBase)entity);
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public IWorld getWorld() {
        return this.world;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    @Event.HasResult
    public static class AllowDespawn
    extends LivingSpawnEvent {
        public AllowDespawn(EntityLiving entity) {
            super(entity, (IWorld)entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
    }

    @Cancelable
    public static class SpecialSpawn
    extends LivingSpawnEvent {
        @Nullable
        private final MobSpawnerBaseLogic spawner;

        public SpecialSpawn(EntityLiving entity, World world, double x, double y, double z, @Nullable MobSpawnerBaseLogic spawner) {
            super(entity, (IWorld)world, x, y, z);
            this.spawner = spawner;
        }

        @Nullable
        public MobSpawnerBaseLogic getSpawner() {
            return this.spawner;
        }
    }

    @Event.HasResult
    public static class CheckSpawn
    extends LivingSpawnEvent {
        @Nullable
        private final MobSpawnerBaseLogic spawner;

        public CheckSpawn(EntityLiving entity, IWorld world, double x, double y, double z, @Nullable MobSpawnerBaseLogic spawner) {
            super(entity, world, x, y, z);
            this.spawner = spawner;
        }

        public boolean isSpawner() {
            return this.spawner != null;
        }

        @Nullable
        public MobSpawnerBaseLogic getSpawner() {
            return this.spawner;
        }
    }
}

