/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.extensions;

import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.HorseArmorType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public interface IForgeItemStack
extends ICapabilitySerializable<NBTTagCompound> {
    default public ItemStack getStack() {
        return (ItemStack)this;
    }

    default public ItemStack getContainerItem() {
        return this.getStack().func_77973_b().getContainerItem(this.getStack());
    }

    default public boolean hasContainerItem() {
        return this.getStack().func_77973_b().hasContainerItem(this.getStack());
    }

    default public int getBurnTime() {
        return this.getStack().func_77973_b().getBurnTime(this.getStack());
    }

    default public int getHarvestLevel(ToolType tool, @Nullable EntityPlayer player, @Nullable IBlockState state) {
        return this.getStack().func_77973_b().getHarvestLevel(this.getStack(), tool, player, state);
    }

    default public Set<ToolType> getToolTypes() {
        return this.getStack().func_77973_b().getToolTypes(this.getStack());
    }

    default public EnumActionResult onItemUseFirst(ItemUseContext context) {
        EntityPlayer entityplayer = context.func_195999_j();
        BlockPos blockpos = context.func_195995_a();
        BlockWorldState blockworldstate = new BlockWorldState((IWorldReaderBase)context.func_195991_k(), blockpos, false);
        if (entityplayer != null && !entityplayer.field_71075_bZ.field_75099_e && !this.getStack().func_206847_b(context.func_195991_k().func_205772_D(), blockworldstate)) {
            return EnumActionResult.PASS;
        }
        Item item = this.getStack().func_77973_b();
        EnumActionResult enumactionresult = item.onItemUseFirst(this.getStack(), context);
        if (entityplayer != null && enumactionresult == EnumActionResult.SUCCESS) {
            entityplayer.func_71029_a(StatList.field_75929_E.func_199076_b((Object)item));
        }
        return enumactionresult;
    }

    @Override
    default public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        this.getStack().func_77955_b(ret);
        return ret;
    }

    default public boolean onBlockStartBreak(BlockPos pos, EntityPlayer player) {
        return !this.getStack().func_190926_b() && this.getStack().func_77973_b().onBlockStartBreak(this.getStack(), pos, player);
    }

    default public boolean shouldCauseBlockBreakReset(ItemStack newStack) {
        return this.getStack().func_77973_b().shouldCauseBlockBreakReset(this.getStack(), newStack);
    }

    default public boolean canApplyAtEnchantingTable(Enchantment enchantment) {
        return this.getStack().func_77973_b().canApplyAtEnchantingTable(this.getStack(), enchantment);
    }

    default public int getItemEnchantability() {
        return this.getStack().func_77973_b().getItemEnchantability(this.getStack());
    }

    @Nullable
    default public EntityEquipmentSlot getEquipmentSlot() {
        return this.getStack().func_77973_b().getEquipmentSlot(this.getStack());
    }

    default public boolean canDisableShield(ItemStack shield, EntityLivingBase entity, EntityLivingBase attacker) {
        return this.getStack().func_77973_b().canDisableShield(this.getStack(), shield, entity, attacker);
    }

    default public boolean isShield(@Nullable EntityLivingBase entity) {
        return this.getStack().func_77973_b().isShield(this.getStack(), entity);
    }

    default public boolean onEntitySwing(EntityLivingBase entity) {
        return this.getStack().func_77973_b().onEntitySwing(this.getStack(), entity);
    }

    default public void onUsingTick(EntityLivingBase player, int count) {
        this.getStack().func_77973_b().onUsingTick(this.getStack(), player, count);
    }

    default public int getEntityLifespan(World world) {
        return this.getStack().func_77973_b().getEntityLifespan(this.getStack(), world);
    }

    default public boolean onEntityItemUpdate(EntityItem entity) {
        return this.getStack().func_77973_b().onEntityItemUpdate(this.getStack(), entity);
    }

    default public HorseArmorType getHorseArmorType() {
        return this.getStack().func_77973_b().getHorseArmorType(this.getStack());
    }

    default public void onArmorTick(World world, EntityPlayer player) {
        this.getStack().func_77973_b().onArmorTick(this.getStack(), world, player);
    }

    default public void onHorseArmorTick(World world, EntityLiving horse) {
        this.getStack().func_77973_b().onHorseArmorTick(this.getStack(), world, horse);
    }

    default public boolean isBeaconPayment() {
        return this.getStack().func_77973_b().isBeaconPayment(this.getStack());
    }

    default public boolean canEquip(EntityEquipmentSlot armorType, Entity entity) {
        return this.getStack().func_77973_b().canEquip(this.getStack(), armorType, entity);
    }

    default public boolean isBookEnchantable(ItemStack book) {
        return this.getStack().func_77973_b().isBookEnchantable(this.getStack(), book);
    }

    default public boolean onDroppedByPlayer(EntityPlayer player) {
        return this.getStack().func_77973_b().onDroppedByPlayer(this.getStack(), player);
    }

    @Nullable
    default public NBTTagCompound getShareTag() {
        return this.getStack().func_77973_b().getShareTag(this.getStack());
    }

    default public void readShareTag(@Nullable NBTTagCompound nbt) {
        this.getStack().func_77973_b().readShareTag(this.getStack(), nbt);
    }

    default public boolean doesSneakBypassUse(IWorldReader world, BlockPos pos, EntityPlayer player) {
        return this.getStack().func_190926_b() || this.getStack().func_77973_b().doesSneakBypassUse(this.getStack(), world, pos, player);
    }

    default public boolean areShareTagsEqual(ItemStack other) {
        NBTTagCompound shareTagA = this.getStack().getShareTag();
        NBTTagCompound shareTagB = other.getShareTag();
        if (shareTagA == null) {
            return shareTagB == null;
        }
        return shareTagB != null && shareTagA.equals((Object)shareTagB);
    }

    default public boolean equals(ItemStack other, boolean limitTags) {
        if (this.getStack().func_190926_b()) {
            return other.func_190926_b();
        }
        return !other.func_190926_b() && this.getStack().func_190916_E() == other.func_190916_E() && this.getStack().func_77973_b() == other.func_77973_b() && (limitTags ? this.getStack().areShareTagsEqual(other) : ItemStack.func_77970_a((ItemStack)this.getStack(), (ItemStack)other));
    }
}

