/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;

class QueuedChunk {
    final int x;
    final int z;
    final World world;

    public QueuedChunk(int x, int z, World world) {
        this.x = x;
        this.z = z;
        this.world = world;
    }

    public int hashCode() {
        return this.x * 31 + this.z * 29 ^ this.world.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof QueuedChunk) {
            QueuedChunk other = (QueuedChunk)object;
            return this.x == other.x && this.z == other.z && this.world == other.world;
        }
        return false;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        String NEW_LINE = System.getProperty("line.separator");
        result.append(this.getClass().getName() + " {" + NEW_LINE);
        result.append(" x: " + this.x + NEW_LINE);
        result.append(" z: " + this.z + NEW_LINE);
        result.append(" world: " + this.world.func_72912_H().func_76065_j() + NEW_LINE);
        result.append(" dimension: " + DimensionType.func_212678_a((DimensionType)this.world.field_73011_w.func_186058_p()).toString() + NEW_LINE);
        result.append(" provider: " + this.world.field_73011_w.getClass().getName() + NEW_LINE);
        result.append("}");
        return result.toString();
    }
}

