/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraftforge.common.ticket.AABBTicket;
import net.minecraftforge.common.ticket.ChunkTicketManager;
import net.minecraftforge.common.ticket.MultiTicketManager;
import net.minecraftforge.common.ticket.SimpleTicket;

public class FarmlandWaterManager {
    private static final Int2ObjectMap<Map<ChunkPos, ChunkTicketManager<Vec3d>>> customWaterHandler = new Int2ObjectOpenHashMap();

    public static <T extends SimpleTicket<Vec3d>> T addCustomTicket(World world, T ticket, ChunkPos ... chunkPoses) {
        Preconditions.checkArgument((!world.field_72995_K ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Preconditions.checkArgument((chunkPoses.length > 0 ? 1 : 0) != 0, (Object)"Need at least one chunk pos");
        Map ticketMap = (Map)customWaterHandler.computeIfAbsent(world.func_201675_m().func_186058_p().func_186068_a(), id -> new HashMap());
        if (chunkPoses.length == 1) {
            ((SimpleTicket)ticket).setBackend(ticketMap.computeIfAbsent(chunkPoses[0], ChunkTicketManager::new));
        } else {
            ChunkTicketManager[] tickets = new ChunkTicketManager[chunkPoses.length];
            for (int i = 0; i < chunkPoses.length; ++i) {
                tickets[i] = ticketMap.computeIfAbsent(chunkPoses[i], ChunkTicketManager::new);
            }
            ((SimpleTicket)ticket).setBackend(new MultiTicketManager(tickets));
        }
        ((SimpleTicket)ticket).validate();
        return (T)ticket;
    }

    public static AABBTicket addAABBTicket(World world, AxisAlignedBB aabb) {
        ChunkPos leftUp = new ChunkPos((int)aabb.field_72340_a >> 4, (int)aabb.field_72339_c >> 4);
        ChunkPos rightDown = new ChunkPos((int)aabb.field_72336_d >> 4, (int)aabb.field_72334_f >> 4);
        HashSet<ChunkPos> posSet = new HashSet<ChunkPos>();
        for (int x = leftUp.field_77276_a; x <= rightDown.field_77276_a; ++x) {
            for (int z = leftUp.field_77275_b; z <= rightDown.field_77275_b; ++z) {
                posSet.add(new ChunkPos(x, z));
            }
        }
        return FarmlandWaterManager.addCustomTicket(world, new AABBTicket(aabb), posSet.toArray(new ChunkPos[0]));
    }

    public static boolean hasBlockWaterTicket(IWorldReaderBase world, BlockPos pos) {
        ChunkTicketManager<Vec3d> ticketManager = FarmlandWaterManager.getTicketManager(new ChunkPos(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4), world);
        if (ticketManager != null) {
            Vec3d posAsVec3d = new Vec3d((Vec3i)pos);
            for (SimpleTicket<Vec3d> ticket : ticketManager.getTickets()) {
                if (!ticket.matches(posAsVec3d)) continue;
                return true;
            }
        }
        return false;
    }

    static void removeTickets(IChunk chunk) {
        ChunkTicketManager<Vec3d> ticketManager = FarmlandWaterManager.getTicketManager(chunk.func_76632_l(), (IWorldReaderBase)chunk.getWorldForge());
        if (ticketManager != null) {
            for (SimpleTicket<Vec3d> ticket : ticketManager.getTickets()) {
                ticket.invalidate();
            }
        }
    }

    private static ChunkTicketManager<Vec3d> getTicketManager(ChunkPos pos, IWorldReaderBase world) {
        Preconditions.checkArgument((!world.func_201670_d() ? 1 : 0) != 0, (Object)"Water region is only determined server-side");
        Map ticketMap = (Map)customWaterHandler.get(world.func_201675_m().func_186058_p().func_186068_a());
        if (ticketMap == null) {
            return null;
        }
        return (ChunkTicketManager)ticketMap.get(pos);
    }
}

