/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot.conditions;

import com.google.common.collect.Maps;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public class EntityHasScore
implements LootCondition {
    private final Map<String, RandomValueRange> field_186634_a;
    private final LootContext.EntityTarget field_186635_b;

    public EntityHasScore(Map<String, RandomValueRange> map, LootContext.EntityTarget entityTarget) {
        this.field_186634_a = map;
        this.field_186635_b = entityTarget;
    }

    @Override
    public boolean func_186618_a(Random random, LootContext lootContext) {
        Entity entity = lootContext.func_186494_a(this.field_186635_b);
        if (entity == null) {
            return false;
        }
        Scoreboard \u26032 = entity.field_70170_p.func_96441_U();
        for (Map.Entry<String, RandomValueRange> entry : this.field_186634_a.entrySet()) {
            if (this.func_186631_a(entity, \u26032, entry.getKey(), entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean func_186631_a(Entity entity, Scoreboard scoreboard, String string, RandomValueRange randomValueRange) {
        ScoreObjective scoreObjective = scoreboard.func_96518_b(string);
        if (scoreObjective == null) {
            return false;
        }
        String \u26032 = entity.func_195047_I_();
        if (!scoreboard.func_178819_b(\u26032, scoreObjective)) {
            return false;
        }
        return randomValueRange.func_186510_a(scoreboard.func_96529_a(\u26032, scoreObjective).func_96652_c());
    }

    public static class Serializer
    extends LootCondition.Serializer<EntityHasScore> {
        protected Serializer() {
            super(new ResourceLocation("entity_scores"), EntityHasScore.class);
        }

        @Override
        public void func_186605_a(JsonObject jsonObject2, EntityHasScore entityHasScore, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject2;
            JsonObject jsonObject3 = new JsonObject();
            for (Map.Entry entry : entityHasScore.field_186634_a.entrySet()) {
                jsonObject3.add((String)entry.getKey(), jsonSerializationContext.serialize(entry.getValue()));
            }
            jsonObject2.add("scores", (JsonElement)jsonObject3);
            jsonObject2.add("entity", jsonSerializationContext.serialize((Object)entityHasScore.field_186635_b));
        }

        @Override
        public EntityHasScore func_186603_b(JsonObject jsonObject2, JsonDeserializationContext jsonDeserializationContext) {
            JsonObject jsonObject2;
            Set set = JsonUtils.func_152754_s(jsonObject2, "scores").entrySet();
            LinkedHashMap \u26032 = Maps.newLinkedHashMap();
            for (Map.Entry entry : set) {
                \u26032.put(entry.getKey(), JsonUtils.func_188179_a((JsonElement)entry.getValue(), "score", jsonDeserializationContext, RandomValueRange.class));
            }
            return new EntityHasScore(\u26032, JsonUtils.func_188174_a(jsonObject2, "entity", jsonDeserializationContext, LootContext.EntityTarget.class));
        }

        @Override
        public /* synthetic */ LootCondition func_186603_b(JsonObject jsonObject, JsonDeserializationContext jsonDeserializationContext) {
            return this.func_186603_b(jsonObject, jsonDeserializationContext);
        }
    }
}

