/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootEntryEmpty;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootEntryTable;
import net.minecraft.world.storage.loot.conditions.LootCondition;

public abstract class LootEntry {
    protected final int field_186364_c;
    protected final int field_186365_d;
    protected final LootCondition[] field_186366_e;

    protected LootEntry(int n, int n2, LootCondition[] lootConditionArray) {
        this.field_186364_c = n;
        this.field_186365_d = n2;
        this.field_186366_e = lootConditionArray;
    }

    public int func_186361_a(float f) {
        return Math.max(MathHelper.func_76141_d((float)this.field_186364_c + (float)this.field_186365_d * f), 0);
    }

    public abstract void func_186363_a(Collection<ItemStack> var1, Random var2, LootContext var3);

    protected abstract void func_186362_a(JsonObject var1, JsonSerializationContext var2);

    public static class Serializer
    implements JsonDeserializer<LootEntry>,
    JsonSerializer<LootEntry> {
        public LootEntry deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "loot item");
            String \u26032 = JsonUtils.func_151200_h(jsonObject, "type");
            int \u26033 = JsonUtils.func_151208_a(jsonObject, "weight", 1);
            int \u26034 = JsonUtils.func_151208_a(jsonObject, "quality", 0);
            LootCondition[] \u26035 = jsonObject.has("conditions") ? JsonUtils.func_188174_a(jsonObject, "conditions", jsonDeserializationContext, LootCondition[].class) : new LootCondition[]{};
            if ("item".equals(\u26032)) {
                return LootEntryItem.func_186367_a(jsonObject, jsonDeserializationContext, \u26033, \u26034, \u26035);
            }
            if ("loot_table".equals(\u26032)) {
                return LootEntryTable.func_186370_a(jsonObject, jsonDeserializationContext, \u26033, \u26034, \u26035);
            }
            if ("empty".equals(\u26032)) {
                return LootEntryEmpty.func_186372_a(jsonObject, jsonDeserializationContext, \u26033, \u26034, \u26035);
            }
            throw new JsonSyntaxException("Unknown loot entry type '" + \u26032 + "'");
        }

        public JsonElement serialize(LootEntry lootEntry, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("weight", (Number)lootEntry.field_186364_c);
            jsonObject.addProperty("quality", (Number)lootEntry.field_186365_d);
            if (lootEntry.field_186366_e.length > 0) {
                jsonObject.add("conditions", jsonSerializationContext.serialize((Object)lootEntry.field_186366_e));
            }
            if (lootEntry instanceof LootEntryItem) {
                jsonObject.addProperty("type", "item");
            } else if (lootEntry instanceof LootEntryTable) {
                jsonObject.addProperty("type", "loot_table");
            } else if (lootEntry instanceof LootEntryEmpty) {
                jsonObject.addProperty("type", "empty");
            } else {
                throw new IllegalArgumentException("Don't know how to serialize " + lootEntry);
            }
            lootEntry.func_186362_a(jsonObject, jsonSerializationContext);
            return jsonObject;
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((LootEntry)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

