/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketMaps;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.storage.MapBanner;
import net.minecraft.world.storage.MapDecoration;
import net.minecraft.world.storage.MapFrame;
import net.minecraft.world.storage.WorldSavedData;

public class MapData
extends WorldSavedData {
    public int field_76201_a;
    public int field_76199_b;
    public DimensionType field_76200_c;
    public boolean field_186210_e;
    public boolean field_191096_f;
    public byte field_76197_d;
    public byte[] field_76198_e = new byte[16384];
    public List<MapInfo> field_76196_g = Lists.newArrayList();
    private final Map<EntityPlayer, MapInfo> field_76202_j = Maps.newHashMap();
    private final Map<String, MapBanner> field_204270_k = Maps.newHashMap();
    public Map<String, MapDecoration> field_76203_h = Maps.newLinkedHashMap();
    private final Map<String, MapFrame> field_212442_l = Maps.newHashMap();

    public MapData(String string) {
        super(string);
    }

    public void func_212440_a(int n, int n2, int n3, boolean bl, boolean bl2, DimensionType dimensionType) {
        this.field_76197_d = (byte)n3;
        this.func_176054_a(n, n2, this.field_76197_d);
        this.field_76200_c = dimensionType;
        this.field_186210_e = bl;
        this.field_191096_f = bl2;
        this.func_76185_a();
    }

    public void func_176054_a(double d, double d2, int n) {
        \u2603 = 128 * (1 << n);
        \u2603 = MathHelper.func_76128_c((d + 64.0) / (double)\u2603);
        \u2603 = MathHelper.func_76128_c((d2 + 64.0) / (double)\u2603);
        this.field_76201_a = \u2603 * \u2603 + \u2603 / 2 - 64;
        this.field_76199_b = \u2603 * \u2603 + \u2603 / 2 - 64;
    }

    @Override
    public void func_76184_a(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        this.field_76200_c = DimensionType.func_186069_a(nBTTagCompound2.func_74762_e("dimension"));
        this.field_76201_a = nBTTagCompound2.func_74762_e("xCenter");
        this.field_76199_b = nBTTagCompound2.func_74762_e("zCenter");
        this.field_76197_d = (byte)MathHelper.func_76125_a(nBTTagCompound2.func_74771_c("scale"), 0, 4);
        this.field_186210_e = !nBTTagCompound2.func_150297_b("trackingPosition", 1) || nBTTagCompound2.func_74767_n("trackingPosition");
        this.field_191096_f = nBTTagCompound2.func_74767_n("unlimitedTracking");
        this.field_76198_e = nBTTagCompound2.func_74770_j("colors");
        if (this.field_76198_e.length != 16384) {
            this.field_76198_e = new byte[16384];
        }
        NBTTagList nBTTagList = nBTTagCompound2.func_150295_c("banners", 10);
        for (int i = 0; i < nBTTagList.size(); ++i) {
            MapBanner mapBanner = MapBanner.func_204300_a(nBTTagList.func_150305_b(i));
            this.field_204270_k.put(mapBanner.func_204299_f(), mapBanner);
            this.func_191095_a(mapBanner.func_204305_c(), null, mapBanner.func_204299_f(), mapBanner.func_204304_a().func_177958_n(), mapBanner.func_204304_a().func_177952_p(), 180.0, mapBanner.func_204302_d());
        }
        NBTTagList \u26032 = nBTTagCompound2.func_150295_c("frames", 10);
        for (int i = 0; i < \u26032.size(); ++i) {
            MapFrame mapFrame = MapFrame.func_212765_a(\u26032.func_150305_b(i));
            this.field_212442_l.put(mapFrame.func_212767_e(), mapFrame);
            this.func_191095_a(MapDecoration.Type.FRAME, null, "frame-" + mapFrame.func_212769_d(), mapFrame.func_212764_b().func_177958_n(), mapFrame.func_212764_b().func_177952_p(), mapFrame.func_212768_c(), null);
        }
    }

    @Override
    public NBTTagCompound func_189551_b(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        nBTTagCompound2.func_74768_a("dimension", this.field_76200_c.func_186068_a());
        nBTTagCompound2.func_74768_a("xCenter", this.field_76201_a);
        nBTTagCompound2.func_74768_a("zCenter", this.field_76199_b);
        nBTTagCompound2.func_74774_a("scale", this.field_76197_d);
        nBTTagCompound2.func_74773_a("colors", this.field_76198_e);
        nBTTagCompound2.func_74757_a("trackingPosition", this.field_186210_e);
        nBTTagCompound2.func_74757_a("unlimitedTracking", this.field_191096_f);
        NBTTagList nBTTagList = new NBTTagList();
        for (MapBanner mapBanner : this.field_204270_k.values()) {
            nBTTagList.add(mapBanner.func_204303_e());
        }
        nBTTagCompound2.func_74782_a("banners", nBTTagList);
        NBTTagList \u26032 = new NBTTagList();
        for (MapFrame mapFrame : this.field_212442_l.values()) {
            \u26032.add(mapFrame.func_212770_a());
        }
        nBTTagCompound2.func_74782_a("frames", \u26032);
        return nBTTagCompound2;
    }

    public void func_76191_a(EntityPlayer entityPlayer2, ItemStack itemStack2) {
        Object \u26034;
        ItemStack itemStack2;
        Object \u26032;
        EntityPlayer entityPlayer2;
        if (!this.field_76202_j.containsKey(entityPlayer2)) {
            MapInfo mapInfo = new MapInfo(entityPlayer2);
            this.field_76202_j.put(entityPlayer2, mapInfo);
            this.field_76196_g.add(mapInfo);
        }
        if (!entityPlayer2.field_71071_by.func_70431_c(itemStack2)) {
            this.field_76203_h.remove(entityPlayer2.func_200200_C_().getString());
        }
        for (int i = 0; i < this.field_76196_g.size(); ++i) {
            \u26032 = this.field_76196_g.get(i);
            \u26033 = ((MapInfo)\u26032).field_76211_a.func_200200_C_().getString();
            if (((MapInfo)\u26032).field_76211_a.field_70128_L || !((MapInfo)\u26032).field_76211_a.field_71071_by.func_70431_c(itemStack2) && !itemStack2.func_82839_y()) {
                this.field_76202_j.remove(((MapInfo)\u26032).field_76211_a);
                this.field_76196_g.remove(\u26032);
                this.field_76203_h.remove(\u26033);
                continue;
            }
            if (itemStack2.func_82839_y() || ((MapInfo)\u26032).field_76211_a.field_71093_bK != this.field_76200_c || !this.field_186210_e) continue;
            this.func_191095_a(MapDecoration.Type.PLAYER, ((MapInfo)\u26032).field_76211_a.field_70170_p, (String)\u26033, ((MapInfo)\u26032).field_76211_a.field_70165_t, ((MapInfo)\u26032).field_76211_a.field_70161_v, ((MapInfo)\u26032).field_76211_a.field_70177_z, null);
        }
        if (itemStack2.func_82839_y() && this.field_186210_e) {
            EntityItemFrame entityItemFrame = itemStack2.func_82836_z();
            \u26032 = entityItemFrame.func_174857_n();
            Object \u26033 = this.field_212442_l.get(MapFrame.func_212766_a((BlockPos)\u26032));
            if (\u26033 != null && entityItemFrame.func_145782_y() != ((MapFrame)\u26033).func_212769_d() && this.field_212442_l.containsKey(((MapFrame)\u26033).func_212767_e())) {
                this.field_76203_h.remove("frame-" + ((MapFrame)\u26033).func_212769_d());
            }
            \u26034 = new MapFrame((BlockPos)\u26032, entityItemFrame.field_174860_b.func_176736_b() * 90, entityItemFrame.func_145782_y());
            this.func_191095_a(MapDecoration.Type.FRAME, entityPlayer2.field_70170_p, "frame-" + entityItemFrame.func_145782_y(), ((Vec3i)\u26032).func_177958_n(), ((Vec3i)\u26032).func_177952_p(), entityItemFrame.field_174860_b.func_176736_b() * 90, null);
            this.field_212442_l.put(((MapFrame)\u26034).func_212767_e(), (MapFrame)\u26034);
        }
        if ((\u2603 = itemStack2.func_77978_p()) != null && \u2603.func_150297_b("Decorations", 9)) {
            \u26032 = \u2603.func_150295_c("Decorations", 10);
            for (int i = 0; i < ((NBTTagList)\u26032).size(); ++i) {
                \u26034 = ((NBTTagList)\u26032).func_150305_b(i);
                if (this.field_76203_h.containsKey(((NBTTagCompound)\u26034).func_74779_i("id"))) continue;
                this.func_191095_a(MapDecoration.Type.func_191159_a(((NBTTagCompound)\u26034).func_74771_c("type")), entityPlayer2.field_70170_p, ((NBTTagCompound)\u26034).func_74779_i("id"), ((NBTTagCompound)\u26034).func_74769_h("x"), ((NBTTagCompound)\u26034).func_74769_h("z"), ((NBTTagCompound)\u26034).func_74769_h("rot"), null);
            }
        }
    }

    public static void func_191094_a(ItemStack itemStack, BlockPos blockPos, String string, MapDecoration.Type type) {
        NBTTagList nBTTagList;
        if (itemStack.func_77942_o() && itemStack.func_77978_p().func_150297_b("Decorations", 9)) {
            nBTTagList = itemStack.func_77978_p().func_150295_c("Decorations", 10);
        } else {
            nBTTagList = new NBTTagList();
            itemStack.func_77983_a("Decorations", nBTTagList);
        }
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74774_a("type", type.func_191163_a());
        nBTTagCompound.func_74778_a("id", string);
        nBTTagCompound.func_74780_a("x", blockPos.func_177958_n());
        nBTTagCompound.func_74780_a("z", blockPos.func_177952_p());
        nBTTagCompound.func_74780_a("rot", 180.0);
        nBTTagList.add(nBTTagCompound);
        if (type.func_191162_c()) {
            \u2603 = itemStack.func_190925_c("display");
            \u2603.func_74768_a("MapColor", type.func_191161_d());
        }
    }

    private void func_191095_a(MapDecoration.Type \u260372, @Nullable IWorld iWorld, String string2, double d, double d2, double d3, @Nullable ITextComponent iTextComponent) {
        String string2;
        MapDecoration.Type \u260372;
        byte \u26036;
        int n = 1 << this.field_76197_d;
        float \u26032 = (float)(d - (double)this.field_76201_a) / (float)n;
        float \u26033 = (float)(d2 - (double)this.field_76199_b) / (float)n;
        byte \u26034 = (byte)((double)(\u26032 * 2.0f) + 0.5);
        byte \u26035 = (byte)((double)(\u26033 * 2.0f) + 0.5);
        \u2603 = 63;
        if (\u26032 >= -63.0f && \u26033 >= -63.0f && \u26032 <= 63.0f && \u26033 <= 63.0f) {
            \u26036 = (byte)((d3 += d3 < 0.0 ? -8.0 : 8.0) * 16.0 / 360.0);
            if (this.field_76200_c == DimensionType.NETHER && iWorld != null) {
                int n2 = (int)(iWorld.func_72912_H().func_76073_f() / 10L);
                \u26036 = (byte)(n2 * n2 * 34187121 + n2 * 121 >> 15 & 0xF);
            }
        } else if (\u260372 == MapDecoration.Type.PLAYER) {
            \u2603 = 320;
            if (Math.abs(\u26032) < 320.0f && Math.abs(\u26033) < 320.0f) {
                \u260372 = MapDecoration.Type.PLAYER_OFF_MAP;
            } else if (this.field_191096_f) {
                \u260372 = MapDecoration.Type.PLAYER_OFF_LIMITS;
            } else {
                this.field_76203_h.remove(string2);
                return;
            }
            \u26036 = 0;
            if (\u26032 <= -63.0f) {
                \u26034 = -128;
            }
            if (\u26033 <= -63.0f) {
                \u26035 = -128;
            }
            if (\u26032 >= 63.0f) {
                \u26034 = 127;
            }
            if (\u26033 >= 63.0f) {
                \u26035 = 127;
            }
        } else {
            this.field_76203_h.remove(string2);
            return;
        }
        this.field_76203_h.put(string2, new MapDecoration(\u260372, \u26034, \u26035, \u26036, iTextComponent));
    }

    @Nullable
    public Packet<?> func_176052_a(ItemStack itemStack, IBlockReader iBlockReader, EntityPlayer entityPlayer) {
        MapInfo mapInfo = this.field_76202_j.get(entityPlayer);
        if (mapInfo == null) {
            return null;
        }
        return mapInfo.func_176101_a(itemStack);
    }

    public void func_176053_a(int n, int n2) {
        this.func_76185_a();
        for (MapInfo mapInfo : this.field_76196_g) {
            mapInfo.func_176102_a(n, n2);
        }
    }

    public MapInfo func_82568_a(EntityPlayer entityPlayer) {
        MapInfo mapInfo = this.field_76202_j.get(entityPlayer);
        if (mapInfo == null) {
            mapInfo = new MapInfo(entityPlayer);
            this.field_76202_j.put(entityPlayer, mapInfo);
            this.field_76196_g.add(mapInfo);
        }
        return mapInfo;
    }

    public void func_204269_a(IWorld iWorld, BlockPos blockPos) {
        float f = (float)blockPos.func_177958_n() + 0.5f;
        \u2603 = (float)blockPos.func_177952_p() + 0.5f;
        int \u26032 = 1 << this.field_76197_d;
        \u2603 = (f - (float)this.field_76201_a) / (float)\u26032;
        \u2603 = (\u2603 - (float)this.field_76199_b) / (float)\u26032;
        int \u26033 = 63;
        boolean \u26034 = false;
        if (\u2603 >= -63.0f && \u2603 >= -63.0f && \u2603 <= 63.0f && \u2603 <= 63.0f) {
            MapBanner mapBanner = MapBanner.func_204301_a(iWorld, blockPos);
            if (mapBanner == null) {
                return;
            }
            boolean \u26035 = true;
            if (this.field_204270_k.containsKey(mapBanner.func_204299_f()) && this.field_204270_k.get(mapBanner.func_204299_f()).equals(mapBanner)) {
                this.field_204270_k.remove(mapBanner.func_204299_f());
                this.field_76203_h.remove(mapBanner.func_204299_f());
                \u26035 = false;
                \u26034 = true;
            }
            if (\u26035) {
                this.field_204270_k.put(mapBanner.func_204299_f(), mapBanner);
                this.func_191095_a(mapBanner.func_204305_c(), iWorld, mapBanner.func_204299_f(), f, \u2603, 180.0, mapBanner.func_204302_d());
                \u26034 = true;
            }
            if (\u26034) {
                this.func_76185_a();
            }
        }
    }

    public void func_204268_a(IBlockReader iBlockReader, int n, int n2) {
        Iterator<MapBanner> iterator = this.field_204270_k.values().iterator();
        while (iterator.hasNext()) {
            MapBanner mapBanner = iterator.next();
            if (mapBanner.func_204304_a().func_177958_n() != n || mapBanner.func_204304_a().func_177952_p() != n2 || mapBanner.equals(\u2603 = MapBanner.func_204301_a(iBlockReader, mapBanner.func_204304_a()))) continue;
            iterator.remove();
            this.field_76203_h.remove(mapBanner.func_204299_f());
        }
    }

    public void func_212441_a(BlockPos blockPos, int n) {
        this.field_76203_h.remove("frame-" + n);
        this.field_212442_l.remove(MapFrame.func_212766_a(blockPos));
    }

    public class MapInfo {
        public final EntityPlayer field_76211_a;
        private boolean field_176105_d = true;
        private int field_176106_e;
        private int field_176103_f;
        private int field_176104_g = 127;
        private int field_176108_h = 127;
        private int field_176109_i;
        public int field_82569_d;

        public MapInfo(EntityPlayer entityPlayer) {
            this.field_76211_a = entityPlayer;
        }

        @Nullable
        public Packet<?> func_176101_a(ItemStack itemStack) {
            if (this.field_176105_d) {
                this.field_176105_d = false;
                return new SPacketMaps(ItemMap.func_195949_f(itemStack), MapData.this.field_76197_d, MapData.this.field_186210_e, MapData.this.field_76203_h.values(), MapData.this.field_76198_e, this.field_176106_e, this.field_176103_f, this.field_176104_g + 1 - this.field_176106_e, this.field_176108_h + 1 - this.field_176103_f);
            }
            if (this.field_176109_i++ % 5 == 0) {
                return new SPacketMaps(ItemMap.func_195949_f(itemStack), MapData.this.field_76197_d, MapData.this.field_186210_e, MapData.this.field_76203_h.values(), MapData.this.field_76198_e, 0, 0, 0, 0);
            }
            return null;
        }

        public void func_176102_a(int n, int n2) {
            if (this.field_176105_d) {
                this.field_176106_e = Math.min(this.field_176106_e, n);
                this.field_176103_f = Math.min(this.field_176103_f, n2);
                this.field_176104_g = Math.max(this.field_176104_g, n);
                this.field_176108_h = Math.max(this.field_176108_h, n2);
            } else {
                this.field_176105_d = true;
                this.field_176106_e = n;
                this.field_176103_f = n2;
                this.field_176104_g = n;
                this.field_176108_h = n2;
            }
        }
    }
}

