/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.tasks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.IOException;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.crash.ReportedException;
import net.minecraft.util.ExpiringMap;
import net.minecraft.util.ITaskType;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.Scheduler;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.UpgradeData;
import net.minecraft.world.chunk.storage.IChunkLoader;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.storage.SessionLockException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProtoChunkScheduler
extends Scheduler<ChunkPos, ChunkStatus, ChunkPrimer> {
    private static final Logger field_202873_b = LogManager.getLogger();
    private final World field_202874_c;
    private final IChunkGenerator<?> field_202875_d;
    private final IChunkLoader field_202876_e;
    private final IThreadListener field_202877_f;
    private final Long2ObjectMap<Scheduler.FutureWrapper> field_202878_g = new ExpiringMap<Scheduler.FutureWrapper>(8192, 5000){

        @Override
        protected boolean func_205609_a_(Scheduler.FutureWrapper futureWrapper) {
            ChunkPrimer chunkPrimer = (ChunkPrimer)futureWrapper.func_202917_a();
            return !chunkPrimer.func_205748_B() && !chunkPrimer.func_201593_f();
        }
    };

    public ProtoChunkScheduler(int n, World world, IChunkGenerator<?> iChunkGenerator, IChunkLoader iChunkLoader, IThreadListener iThreadListener) {
        super("WorldGen", n, ChunkStatus.FINALIZED, () -> new EnumMap(ChunkStatus.class), () -> new EnumMap(ChunkStatus.class));
        this.field_202874_c = world;
        this.field_202875_d = iChunkGenerator;
        this.field_202876_e = iChunkLoader;
        this.field_202877_f = iThreadListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    protected Scheduler.FutureWrapper func_212252_a_(ChunkPos chunkPos, boolean bl) {
        IChunkLoader iChunkLoader = this.field_202876_e;
        synchronized (iChunkLoader) {
            if (bl) {
                return (Scheduler.FutureWrapper)this.field_202878_g.computeIfAbsent(chunkPos.func_201841_a(), l -> {
                    ChunkPrimer chunkPrimer;
                    try {
                        chunkPrimer = this.field_202876_e.func_202152_b(this.field_202874_c, chunkPos.field_77276_a, chunkPos.field_77275_b, iChunk -> {});
                    }
                    catch (ReportedException reportedException) {
                        throw reportedException;
                    }
                    catch (Exception exception) {
                        field_202873_b.error("Couldn't load protochunk", (Throwable)exception);
                        chunkPrimer = null;
                    }
                    if (chunkPrimer != null) {
                        chunkPrimer.func_177432_b(this.field_202874_c.func_82737_E());
                        return new Scheduler.FutureWrapper((Scheduler)this, (Object)chunkPos, (Object)chunkPrimer, (ITaskType)chunkPrimer.func_201589_g());
                    }
                    return new Scheduler.FutureWrapper((Scheduler)this, (Object)chunkPos, (Object)new ChunkPrimer(chunkPos, UpgradeData.field_196994_a), (ITaskType)ChunkStatus.EMPTY);
                });
            }
            return (Scheduler.FutureWrapper)this.field_202878_g.get(chunkPos.func_201841_a());
        }
    }

    @Override
    protected ChunkPrimer func_201493_a_(ChunkPos chunkPos, ChunkStatus chunkStatus, Map<ChunkPos, ChunkPrimer> map) {
        return chunkStatus.func_202126_a(this.field_202874_c, this.field_202875_d, map, chunkPos.field_77276_a, chunkPos.field_77275_b);
    }

    @Override
    protected Scheduler.FutureWrapper func_205606_a_(ChunkPos chunkPos, Scheduler.FutureWrapper futureWrapper) {
        ((ChunkPrimer)futureWrapper.func_202917_a()).func_205747_a(1);
        return futureWrapper;
    }

    @Override
    protected void func_205607_b_(ChunkPos chunkPos, Scheduler.FutureWrapper futureWrapper) {
        ((ChunkPrimer)futureWrapper.func_202917_a()).func_205747_a(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_208484_a(BooleanSupplier booleanSupplier2) {
        IChunkLoader iChunkLoader = this.field_202876_e;
        synchronized (iChunkLoader) {
            for (Scheduler.FutureWrapper futureWrapper : this.field_202878_g.values()) {
                BooleanSupplier booleanSupplier2;
                ChunkPrimer chunkPrimer = (ChunkPrimer)futureWrapper.func_202917_a();
                if (chunkPrimer.func_201593_f() && chunkPrimer.func_201589_g().func_202129_d() == ChunkStatus.Type.PROTOCHUNK) {
                    try {
                        chunkPrimer.func_177432_b(this.field_202874_c.func_82737_E());
                        this.field_202876_e.func_75816_a(this.field_202874_c, chunkPrimer);
                        chunkPrimer.func_177427_f(false);
                    }
                    catch (IOException iOException) {
                        field_202873_b.error("Couldn't save chunk", (Throwable)iOException);
                    }
                    catch (SessionLockException sessionLockException) {
                        field_202873_b.error("Couldn't save chunk; already in use by another instance of Minecraft?", (Throwable)sessionLockException);
                    }
                }
                if (booleanSupplier2.getAsBoolean()) continue;
                return;
            }
        }
    }
}

