/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockFurnace;
import net.minecraft.block.BlockGlassPane;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorchWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class VillagePieces {
    public static void func_143016_a() {
        StructureIO.func_143031_a(House1.class, "ViBH");
        StructureIO.func_143031_a(Field1.class, "ViDF");
        StructureIO.func_143031_a(Field2.class, "ViF");
        StructureIO.func_143031_a(Torch.class, "ViL");
        StructureIO.func_143031_a(Hall.class, "ViPH");
        StructureIO.func_143031_a(House4Garden.class, "ViSH");
        StructureIO.func_143031_a(WoodHut.class, "ViSmH");
        StructureIO.func_143031_a(Church.class, "ViST");
        StructureIO.func_143031_a(House2.class, "ViS");
        StructureIO.func_143031_a(Start.class, "ViStart");
        StructureIO.func_143031_a(Path.class, "ViSR");
        StructureIO.func_143031_a(House3.class, "ViTRH");
        StructureIO.func_143031_a(Well.class, "ViW");
    }

    public static List<PieceWeight> func_75084_a(Random random, int n) {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.add(new PieceWeight(House4Garden.class, 4, MathHelper.func_76136_a(random, 2 + n, 4 + n * 2)));
        arrayList.add(new PieceWeight(Church.class, 20, MathHelper.func_76136_a(random, 0 + n, 1 + n)));
        arrayList.add(new PieceWeight(House1.class, 20, MathHelper.func_76136_a(random, 0 + n, 2 + n)));
        arrayList.add(new PieceWeight(WoodHut.class, 3, MathHelper.func_76136_a(random, 2 + n, 5 + n * 3)));
        arrayList.add(new PieceWeight(Hall.class, 15, MathHelper.func_76136_a(random, 0 + n, 2 + n)));
        arrayList.add(new PieceWeight(Field1.class, 3, MathHelper.func_76136_a(random, 1 + n, 4 + n)));
        arrayList.add(new PieceWeight(Field2.class, 3, MathHelper.func_76136_a(random, 2 + n, 4 + n * 2)));
        arrayList.add(new PieceWeight(House2.class, 15, MathHelper.func_76136_a(random, 0, 1 + n)));
        arrayList.add(new PieceWeight(House3.class, 8, MathHelper.func_76136_a(random, 0 + n, 3 + n * 2)));
        Iterator \u26032 = arrayList.iterator();
        while (\u26032.hasNext()) {
            if (((PieceWeight)\u26032.next()).field_75087_d != 0) continue;
            \u26032.remove();
        }
        return arrayList;
    }

    private static int func_75079_a(List<PieceWeight> list) {
        boolean bl = false;
        int \u26032 = 0;
        for (PieceWeight pieceWeight2 : list) {
            PieceWeight pieceWeight2;
            if (pieceWeight2.field_75087_d > 0 && pieceWeight2.field_75089_c < pieceWeight2.field_75087_d) {
                bl = true;
            }
            \u26032 += pieceWeight2.field_75088_b;
        }
        return bl ? \u26032 : -1;
    }

    private static Village func_176065_a(Start start, PieceWeight pieceWeight, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
        Class<? extends Village> clazz = pieceWeight.field_75090_a;
        Village \u26032 = null;
        if (clazz == House4Garden.class) {
            \u26032 = House4Garden.func_175858_a(start, list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Church.class) {
            \u26032 = Church.func_175854_a(start, list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == House1.class) {
            \u26032 = House1.func_175850_a(start, list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == WoodHut.class) {
            \u26032 = WoodHut.func_175853_a(start, list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Hall.class) {
            \u26032 = Hall.func_175857_a(start, list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Field1.class) {
            \u26032 = Field1.func_175851_a(start, list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Field2.class) {
            \u26032 = Field2.func_175852_a(start, list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == House2.class) {
            \u26032 = House2.func_175855_a(start, list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == House3.class) {
            \u26032 = House3.func_175849_a(start, list, random, n, n2, n3, enumFacing, n4);
        }
        return \u26032;
    }

    private static Village func_176067_c(Start start2, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
        Start start2;
        \u2603 = VillagePieces.func_75079_a(start2.field_74931_h);
        if (\u2603 <= 0) {
            return null;
        }
        \u2603 = 0;
        block0: while (\u2603 < 5) {
            ++\u2603;
            \u2603 = random.nextInt(\u2603);
            for (PieceWeight pieceWeight : start2.field_74931_h) {
                if ((\u2603 -= pieceWeight.field_75088_b) >= 0) continue;
                if (!pieceWeight.func_75085_a(n4) || pieceWeight == start2.field_74926_d && start2.field_74931_h.size() > 1) continue block0;
                Village village = VillagePieces.func_176065_a(start2, pieceWeight, list, random, n, n2, n3, enumFacing, n4);
                if (village == null) continue;
                ++pieceWeight.field_75089_c;
                start2.field_74926_d = pieceWeight;
                if (!pieceWeight.func_75086_a()) {
                    start2.field_74931_h.remove(pieceWeight);
                }
                return village;
            }
        }
        MutableBoundingBox \u26032 = Torch.func_175856_a(start2, list, random, n, n2, n3, enumFacing);
        if (\u26032 != null) {
            return new Torch(start2, n4, random, \u26032, enumFacing);
        }
        return null;
    }

    private static StructurePiece func_176066_d(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
        if (n4 > 50) {
            return null;
        }
        if (Math.abs(n - start.func_74874_b().field_78897_a) > 112 || Math.abs(n3 - start.func_74874_b().field_78896_c) > 112) {
            return null;
        }
        Village village = VillagePieces.func_176067_c(start, list, random, n, n2, n3, enumFacing, n4 + 1);
        if (village != null) {
            list.add(village);
            start.field_74932_i.add(village);
            return village;
        }
        return null;
    }

    private static StructurePiece func_176069_e(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
        if (n4 > 3 + start.field_74928_c) {
            return null;
        }
        if (Math.abs(n - start.func_74874_b().field_78897_a) > 112 || Math.abs(n3 - start.func_74874_b().field_78896_c) > 112) {
            return null;
        }
        MutableBoundingBox mutableBoundingBox = Path.func_175848_a(start, list, random, n, n2, n3, enumFacing);
        if (mutableBoundingBox != null && mutableBoundingBox.field_78895_b > 10) {
            Path path = new Path(start, n4, random, mutableBoundingBox, enumFacing);
            list.add(path);
            start.field_74930_j.add(path);
            return path;
        }
        return null;
    }

    public static class Torch
    extends Village {
        public Torch() {
        }

        public Torch(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        public static MutableBoundingBox func_175856_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 3, 4, 2, enumFacing);
            if (StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return mutableBoundingBox;
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 2, 3, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(iWorld, iBlockState, 1, 0, 0, mutableBoundingBox);
            this.func_175811_a(iWorld, iBlockState, 1, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld, iBlockState, 1, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196602_ba.func_176223_P(), 1, 3, 0, mutableBoundingBox);
            this.func_189926_a(iWorld, EnumFacing.EAST, 2, 3, 0, mutableBoundingBox);
            this.func_189926_a(iWorld, EnumFacing.NORTH, 1, 3, 1, mutableBoundingBox);
            this.func_189926_a(iWorld, EnumFacing.WEST, 0, 3, 0, mutableBoundingBox);
            this.func_189926_a(iWorld, EnumFacing.SOUTH, 1, 3, -1, mutableBoundingBox);
            return true;
        }
    }

    public static class Field1
    extends Village {
        private IBlockState field_82679_b;
        private IBlockState field_82680_c;
        private IBlockState field_82678_d;
        private IBlockState field_82681_h;

        public Field1() {
        }

        public Field1(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_82679_b = Field2.func_197529_b(random);
            this.field_82680_c = Field2.func_197529_b(random);
            this.field_82678_d = Field2.func_197529_b(random);
            this.field_82681_h = Field2.func_197529_b(random);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74782_a("CA", NBTUtil.func_190009_a(this.field_82679_b));
            nBTTagCompound.func_74782_a("CB", NBTUtil.func_190009_a(this.field_82680_c));
            nBTTagCompound.func_74782_a("CC", NBTUtil.func_190009_a(this.field_82678_d));
            nBTTagCompound.func_74782_a("CD", NBTUtil.func_190009_a(this.field_82681_h));
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_82679_b = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("CA"));
            this.field_82680_c = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("CB"));
            this.field_82678_d = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("CC"));
            this.field_82681_h = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("CD"));
            if (!(this.field_82679_b.func_177230_c() instanceof BlockCrops)) {
                this.field_82679_b = Blocks.field_150464_aj.func_176223_P();
            }
            if (!(this.field_82680_c.func_177230_c() instanceof BlockCrops)) {
                this.field_82680_c = Blocks.field_150459_bM.func_176223_P();
            }
            if (!(this.field_82678_d.func_177230_c() instanceof BlockCrops)) {
                this.field_82678_d = Blocks.field_150469_bN.func_176223_P();
            }
            if (!(this.field_82681_h.func_177230_c() instanceof BlockCrops)) {
                this.field_82681_h = Blocks.field_185773_cZ.func_176223_P();
            }
        }

        public static Field1 func_175851_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 13, 4, 9, enumFacing);
            if (!Field1.func_74895_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Field1(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            int n;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 1, 0, 12, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 7, 0, 1, 8, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 10, 0, 1, 11, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 0, 0, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 0, 0, 6, 0, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 12, 0, 0, 12, 0, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 0, 0, 11, 0, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 0, 8, 11, 0, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 9, 0, 1, 9, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (n = 1; n <= 7; ++n) {
                BlockCrops blockCrops = (BlockCrops)this.field_82679_b.func_177230_c();
                int \u26032 = blockCrops.func_185526_g();
                int \u26033 = \u26032 / 3;
                this.func_175811_a(iWorld, (IBlockState)this.field_82679_b.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26033, \u26032)), 1, 1, n, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)this.field_82679_b.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26033, \u26032)), 2, 1, n, mutableBoundingBox);
                blockCrops = (BlockCrops)this.field_82680_c.func_177230_c();
                int \u26034 = blockCrops.func_185526_g();
                int \u26035 = \u26034 / 3;
                this.func_175811_a(iWorld, (IBlockState)this.field_82680_c.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26035, \u26034)), 4, 1, n, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)this.field_82680_c.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26035, \u26034)), 5, 1, n, mutableBoundingBox);
                blockCrops = (BlockCrops)this.field_82678_d.func_177230_c();
                int \u26036 = blockCrops.func_185526_g();
                int \u26037 = \u26036 / 3;
                this.func_175811_a(iWorld, (IBlockState)this.field_82678_d.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26037, \u26036)), 7, 1, n, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)this.field_82678_d.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26037, \u26036)), 8, 1, n, mutableBoundingBox);
                blockCrops = (BlockCrops)this.field_82681_h.func_177230_c();
                int \u26038 = blockCrops.func_185526_g();
                int \u26039 = \u26038 / 3;
                this.func_175811_a(iWorld, (IBlockState)this.field_82681_h.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26039, \u26038)), 10, 1, n, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)this.field_82681_h.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26039, \u26038)), 11, 1, n, mutableBoundingBox);
            }
            for (n = 0; n < 9; ++n) {
                for (\u2603 = 0; \u2603 < 13; ++\u2603) {
                    this.func_74871_b(iWorld, \u2603, 4, n, mutableBoundingBox);
                    this.func_175808_b(iWorld, Blocks.field_150346_d.func_176223_P(), \u2603, -1, n, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Field2
    extends Village {
        private IBlockState field_82675_b;
        private IBlockState field_82676_c;

        public Field2() {
        }

        public Field2(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_82675_b = Field2.func_197529_b(random);
            this.field_82676_c = Field2.func_197529_b(random);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74782_a("CA", NBTUtil.func_190009_a(this.field_82675_b));
            nBTTagCompound.func_74782_a("CB", NBTUtil.func_190009_a(this.field_82676_c));
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_82675_b = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("CA"));
            this.field_82676_c = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("CB"));
        }

        private static IBlockState func_197529_b(Random random) {
            switch (random.nextInt(10)) {
                default: {
                    return Blocks.field_150464_aj.func_176223_P();
                }
                case 0: 
                case 1: {
                    return Blocks.field_150459_bM.func_176223_P();
                }
                case 2: 
                case 3: {
                    return Blocks.field_150469_bN.func_176223_P();
                }
                case 4: 
            }
            return Blocks.field_185773_cZ.func_176223_P();
        }

        public static Field2 func_175852_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 7, 4, 9, enumFacing);
            if (!Field2.func_74895_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Field2(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            int n;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 4 - 1, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 1, 0, 6, 4, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 0, 1, 2, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 0, 1, 5, 0, 7, Blocks.field_150458_ak.func_176223_P(), Blocks.field_150458_ak.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 0, 0, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 0, 0, 6, 0, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 0, 0, 5, 0, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 0, 8, 5, 0, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 3, 0, 1, 3, 0, 7, Blocks.field_150355_j.func_176223_P(), Blocks.field_150355_j.func_176223_P(), false);
            for (n = 1; n <= 7; ++n) {
                BlockCrops blockCrops = (BlockCrops)this.field_82675_b.func_177230_c();
                int \u26032 = blockCrops.func_185526_g();
                int \u26033 = \u26032 / 3;
                this.func_175811_a(iWorld, (IBlockState)this.field_82675_b.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26033, \u26032)), 1, 1, n, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)this.field_82675_b.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26033, \u26032)), 2, 1, n, mutableBoundingBox);
                blockCrops = (BlockCrops)this.field_82676_c.func_177230_c();
                int \u26034 = blockCrops.func_185526_g();
                int \u26035 = \u26034 / 3;
                this.func_175811_a(iWorld, (IBlockState)this.field_82676_c.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26035, \u26034)), 4, 1, n, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)this.field_82676_c.func_206870_a(blockCrops.func_185524_e(), MathHelper.func_76136_a(random, \u26035, \u26034)), 5, 1, n, mutableBoundingBox);
            }
            for (n = 0; n < 9; ++n) {
                for (\u2603 = 0; \u2603 < 7; ++\u2603) {
                    this.func_74871_b(iWorld, \u2603, 4, n, mutableBoundingBox);
                    this.func_175808_b(iWorld, Blocks.field_150346_d.func_176223_P(), \u2603, -1, n, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class House2
    extends Village {
        private boolean field_74917_c;

        public House2() {
        }

        public House2(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        public static House2 func_175855_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 10, 6, 7, enumFacing);
            if (!House2.func_74895_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new House2(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Chest", this.field_74917_c);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74917_c = nBTTagCompound.func_74767_n("Chest");
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            int n;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld2, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iBlockState = Blocks.field_150347_e.func_176223_P();
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.WEST));
            \u2603 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 0, 9, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 0, 9, 0, 6, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 4, 0, 9, 4, 6, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 0, 9, 5, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 5, 1, 8, 5, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 0, 2, 3, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 0, 0, 4, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 1, 0, 3, 4, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 6, 0, 4, 6, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, \u2603, 3, 3, 1, mutableBoundingBox);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 1, 2, 3, 3, 2, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 1, 3, 5, 3, 3, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 1, 0, 3, 5, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 6, 5, 3, 6, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 1, 0, 5, 3, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 9, 1, 0, 9, 3, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 6, 1, 4, 9, 4, 6, iBlockState, iBlockState, false);
            this.func_175811_a(iWorld2, Blocks.field_150353_l.func_176223_P(), 7, 1, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150353_l.func_176223_P(), 8, 1, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196409_a, true)).func_206870_a(BlockPane.field_196413_c, true), 9, 2, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196409_a, true), 9, 2, 4, mutableBoundingBox);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 2, 4, 8, 2, 5, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(iWorld2, iBlockState, 6, 1, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)Blocks.field_150460_al.func_176223_P().func_206870_a(BlockFurnace.field_176447_a, EnumFacing.SOUTH), 6, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)Blocks.field_150460_al.func_176223_P().func_206870_a(BlockFurnace.field_176447_a, EnumFacing.SOUTH), 6, 3, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)Blocks.field_150333_U.func_176223_P().func_206870_a(BlockSlab.field_196505_a, SlabType.DOUBLE), 8, 1, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 2, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 4, 2, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_196663_cq.func_176223_P(), 2, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 1, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 1, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 1, 4, mutableBoundingBox);
            if (!this.field_74917_c && mutableBoundingBox.func_175898_b(new BlockPos(this.func_74865_a(5, 5), this.func_74862_a(1), this.func_74873_b(5, 5)))) {
                this.field_74917_c = true;
                this.func_186167_a(iWorld2, mutableBoundingBox, random, 5, 1, 5, LootTableList.field_186423_e);
            }
            for (n = 6; n <= 8; ++n) {
                if (!this.func_175807_a(iWorld2, n, 0, -1, mutableBoundingBox).func_196958_f() || this.func_175807_a(iWorld2, n, -1, -1, mutableBoundingBox).func_196958_f()) continue;
                this.func_175811_a(iWorld2, \u2603, n, 0, -1, mutableBoundingBox);
                if (this.func_175807_a(iWorld2, n, -1, -1, mutableBoundingBox).func_177230_c() != Blocks.field_185774_da) continue;
                this.func_175811_a(iWorld2, Blocks.field_196658_i.func_176223_P(), n, -1, -1, mutableBoundingBox);
            }
            for (n = 0; n < 7; ++n) {
                for (\u2603 = 0; \u2603 < 10; ++\u2603) {
                    this.func_74871_b(iWorld2, \u2603, 6, n, mutableBoundingBox);
                    this.func_175808_b(iWorld2, iBlockState, \u2603, -1, n, mutableBoundingBox);
                }
            }
            this.func_74893_a(iWorld2, mutableBoundingBox, 7, 1, 1, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int n, int n2) {
            return 3;
        }
    }

    public static class House3
    extends Village {
        public House3() {
        }

        public House3(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        public static House3 func_175849_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 9, 7, 12, enumFacing);
            if (!House3.func_74895_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new House3(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            int n;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld2, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.SOUTH));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.EAST));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.WEST));
            \u2603 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 0, 5, 8, 0, 10, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, 1, 7, 0, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 0, 0, 3, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 0, 0, 8, 3, 10, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, 0, 7, 2, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, 5, 2, 1, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 0, 6, 2, 3, 10, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 0, 10, 7, 3, 10, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 2, 0, 7, 3, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 2, 5, 2, 3, 5, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 4, 1, 8, 4, 1, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 4, 4, 3, 4, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 2, 8, 5, 3, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, \u2603, 0, 4, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 0, 4, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 4, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 4, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 4, 4, mutableBoundingBox);
            \u2603 = \u2603;
            \u2603 = \u2603;
            \u2603 = \u2603;
            \u2603 = \u2603;
            for (n = -1; n <= 2; ++n) {
                for (\u2603 = 0; \u2603 <= 8; ++\u2603) {
                    this.func_175811_a(iWorld2, \u2603, \u2603, 4 + n, n, mutableBoundingBox);
                    if (n <= -1 && \u2603 > 1 || n <= 0 && \u2603 > 3 || n <= 1 && \u2603 > 4 && \u2603 < 6) continue;
                    this.func_175811_a(iWorld2, \u2603, \u2603, 4 + n, 5 - n, mutableBoundingBox);
                }
            }
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 4, 5, 3, 4, 10, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 4, 2, 7, 4, 10, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 5, 4, 4, 5, 10, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 6, 5, 4, 6, 5, 10, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 6, 3, 5, 6, 10, \u2603, \u2603, false);
            for (n = 4; n >= 1; --n) {
                this.func_175811_a(iWorld2, \u2603, n, 2 + n, 7 - n, mutableBoundingBox);
                for (\u2603 = 8 - n; \u2603 <= 10; ++\u2603) {
                    this.func_175811_a(iWorld2, \u2603, n, 2 + n, \u2603, mutableBoundingBox);
                }
            }
            this.func_175811_a(iWorld2, \u2603, 6, 6, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 7, 5, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 6, 6, 4, mutableBoundingBox);
            for (n = 6; n <= 8; ++n) {
                for (\u2603 = 5; \u2603 <= 10; ++\u2603) {
                    this.func_175811_a(iWorld2, \u2603, n, 12 - n, \u2603, mutableBoundingBox);
                }
            }
            this.func_175811_a(iWorld2, \u2603, 0, 2, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 0, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 4, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 5, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 6, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 2, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 2, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 2, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 2, 7, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 2, 8, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 2, 9, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 2, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 2, 2, 7, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 2, 2, 8, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 2, 9, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 4, 4, 10, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 5, 4, 10, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 6, 4, 10, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 5, 5, 10, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, mutableBoundingBox);
            this.func_189926_a(iWorld2, EnumFacing.NORTH, 2, 3, 1, mutableBoundingBox);
            this.func_189927_a(iWorld2, mutableBoundingBox, random, 2, 1, 0, EnumFacing.NORTH);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, -1, 3, 2, -1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.func_175807_a(iWorld2, 2, 0, -1, mutableBoundingBox).func_196958_f() && !this.func_175807_a(iWorld2, 2, -1, -1, mutableBoundingBox).func_196958_f()) {
                this.func_175811_a(iWorld2, \u2603, 2, 0, -1, mutableBoundingBox);
                if (this.func_175807_a(iWorld2, 2, -1, -1, mutableBoundingBox).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(iWorld2, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, mutableBoundingBox);
                }
            }
            for (n = 0; n < 5; ++n) {
                for (\u2603 = 0; \u2603 < 9; ++\u2603) {
                    this.func_74871_b(iWorld2, \u2603, 7, n, mutableBoundingBox);
                    this.func_175808_b(iWorld2, iBlockState, \u2603, -1, n, mutableBoundingBox);
                }
            }
            for (n = 5; n < 11; ++n) {
                for (\u2603 = 2; \u2603 < 9; ++\u2603) {
                    this.func_74871_b(iWorld2, \u2603, 7, n, mutableBoundingBox);
                    this.func_175808_b(iWorld2, iBlockState, \u2603, -1, n, mutableBoundingBox);
                }
            }
            this.func_74893_a(iWorld2, mutableBoundingBox, 4, 1, 2, 2);
            return true;
        }
    }

    public static class Hall
    extends Village {
        public Hall() {
        }

        public Hall(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        public static Hall func_175857_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 9, 7, 11, enumFacing);
            if (!Hall.func_74895_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Hall(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld2, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 7 - 1, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.SOUTH));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.WEST));
            \u2603 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 1, 7, 4, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 1, 6, 8, 4, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 0, 6, 8, 0, 10, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            this.func_175811_a(iWorld2, iBlockState, 6, 0, 6, mutableBoundingBox);
            \u2603 = (IBlockState)((IBlockState)\u2603.func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            \u2603 = (IBlockState)((IBlockState)\u2603.func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 1, 6, 2, 1, 9, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)\u2603.func_206870_a(BlockFence.field_196413_c, true)).func_206870_a(BlockFence.field_196411_b, true), 2, 1, 10, mutableBoundingBox);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 1, 6, 8, 1, 9, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)\u2603.func_206870_a(BlockFence.field_196413_c, true)).func_206870_a(BlockFence.field_196414_y, true), 8, 1, 10, mutableBoundingBox);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 1, 10, 7, 1, 10, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, 1, 7, 0, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 0, 0, 3, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 0, 0, 8, 3, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, 0, 7, 1, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, 5, 7, 1, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 2, 0, 7, 3, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 2, 5, 7, 3, 5, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 4, 1, 8, 4, 1, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 4, 4, 8, 4, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 2, 8, 5, 3, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, \u2603, 0, 4, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 0, 4, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 4, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 4, 3, mutableBoundingBox);
            \u2603 = \u2603;
            \u2603 = \u2603;
            \u2603 = \u2603;
            for (int i = -1; i <= 2; ++i) {
                for (i = 0; i <= 8; ++i) {
                    this.func_175811_a(iWorld2, \u2603, i, 4 + i, i, mutableBoundingBox);
                    this.func_175811_a(iWorld2, \u2603, i, 4 + i, 5 - i, mutableBoundingBox);
                }
            }
            this.func_175811_a(iWorld2, \u2603, 0, 2, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 0, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 2, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 8, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 2, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 3, 2, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 5, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 1, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_196663_cq.func_176223_P(), 2, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 1, 3, mutableBoundingBox);
            IBlockState \u26032 = (IBlockState)Blocks.field_150333_U.func_176223_P().func_206870_a(BlockSlab.field_196505_a, SlabType.DOUBLE);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 0, 1, 7, 0, 3, \u26032, \u26032, false);
            this.func_175811_a(iWorld2, \u26032, 6, 1, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 6, 1, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, mutableBoundingBox);
            this.func_189926_a(iWorld2, EnumFacing.NORTH, 2, 3, 1, mutableBoundingBox);
            this.func_189927_a(iWorld2, mutableBoundingBox, random, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(iWorld2, 2, 0, -1, mutableBoundingBox).func_196958_f() && !this.func_175807_a(iWorld2, 2, -1, -1, mutableBoundingBox).func_196958_f()) {
                this.func_175811_a(iWorld2, \u2603, 2, 0, -1, mutableBoundingBox);
                if (this.func_175807_a(iWorld2, 2, -1, -1, mutableBoundingBox).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(iWorld2, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, mutableBoundingBox);
                }
            }
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 6, 1, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 6, 2, 5, mutableBoundingBox);
            this.func_189926_a(iWorld2, EnumFacing.SOUTH, 6, 3, 4, mutableBoundingBox);
            this.func_189927_a(iWorld2, mutableBoundingBox, random, 6, 1, 5, EnumFacing.SOUTH);
            for (int i = 0; i < 5; ++i) {
                for (\u2603 = 0; \u2603 < 9; ++\u2603) {
                    this.func_74871_b(iWorld2, \u2603, 7, i, mutableBoundingBox);
                    this.func_175808_b(iWorld2, iBlockState, \u2603, -1, i, mutableBoundingBox);
                }
            }
            this.func_74893_a(iWorld2, mutableBoundingBox, 4, 1, 2, 2);
            return true;
        }

        @Override
        protected int func_180779_c(int n, int n2) {
            if (n == 0) {
                return 4;
            }
            return super.func_180779_c(n, n2);
        }
    }

    public static class WoodHut
    extends Village {
        private boolean field_74909_b;
        private int field_74910_c;

        public WoodHut() {
        }

        public WoodHut(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_74909_b = random.nextBoolean();
            this.field_74910_c = random.nextInt(3);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74768_a("T", this.field_74910_c);
            nBTTagCompound.func_74757_a("C", this.field_74909_b);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74910_c = nBTTagCompound.func_74762_e("T");
            this.field_74909_b = nBTTagCompound.func_74767_n("C");
        }

        public static WoodHut func_175853_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 4, 6, 5, enumFacing);
            if (!WoodHut.func_74895_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new WoodHut(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld2, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 1, 3, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 0, 3, 0, 4, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, 1, 2, 0, 3, Blocks.field_150346_d.func_176223_P(), Blocks.field_150346_d.func_176223_P(), false);
            if (this.field_74909_b) {
                this.func_175804_a(iWorld2, mutableBoundingBox, 1, 4, 1, 2, 4, 3, \u2603, \u2603, false);
            } else {
                this.func_175804_a(iWorld2, mutableBoundingBox, 1, 5, 1, 2, 5, 3, \u2603, \u2603, false);
            }
            this.func_175811_a(iWorld2, \u2603, 1, 4, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 4, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 4, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 4, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 0, 4, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 0, 4, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 0, 4, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 3, 4, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 3, 4, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 3, 4, 3, mutableBoundingBox);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 0, 0, 3, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 1, 0, 3, 3, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 4, 0, 3, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 1, 4, 3, 3, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 1, 0, 3, 3, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 1, 1, 3, 3, 3, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 0, 2, 3, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 4, 2, 3, 4, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 3, 2, 2, mutableBoundingBox);
            if (this.field_74910_c > 0) {
                this.func_175811_a(iWorld2, (IBlockState)((IBlockState)\u2603.func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(this.field_74910_c == 1 ? BlockFence.field_196414_y : BlockFence.field_196411_b, true), this.field_74910_c, 1, 3, mutableBoundingBox);
                this.func_175811_a(iWorld2, Blocks.field_196663_cq.func_176223_P(), this.field_74910_c, 2, 3, mutableBoundingBox);
            }
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, mutableBoundingBox);
            this.func_189927_a(iWorld2, mutableBoundingBox, random, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(iWorld2, 1, 0, -1, mutableBoundingBox).func_196958_f() && !this.func_175807_a(iWorld2, 1, -1, -1, mutableBoundingBox).func_196958_f()) {
                this.func_175811_a(iWorld2, \u2603, 1, 0, -1, mutableBoundingBox);
                if (this.func_175807_a(iWorld2, 1, -1, -1, mutableBoundingBox).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(iWorld2, Blocks.field_196658_i.func_176223_P(), 1, -1, -1, mutableBoundingBox);
                }
            }
            for (int i = 0; i < 5; ++i) {
                for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                    this.func_74871_b(iWorld2, \u2603, 6, i, mutableBoundingBox);
                    this.func_175808_b(iWorld2, iBlockState, \u2603, -1, i, mutableBoundingBox);
                }
            }
            this.func_74893_a(iWorld2, mutableBoundingBox, 1, 1, 2, 1);
            return true;
        }
    }

    public static class House1
    extends Village {
        public House1() {
        }

        public House1(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        public static House1 func_175850_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 9, 9, 6, enumFacing);
            if (!House1.func_74895_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new House1(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld2, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 9 - 1, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.SOUTH));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_150476_ad.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.EAST));
            \u2603 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 1, 7, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 0, 8, 0, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 0, 8, 5, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 6, 1, 8, 6, 4, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 7, 2, 8, 7, 3, iBlockState, iBlockState, false);
            for (int i = -1; i <= 2; ++i) {
                for (i = 0; i <= 8; ++i) {
                    this.func_175811_a(iWorld2, \u2603, i, 6 + i, i, mutableBoundingBox);
                    this.func_175811_a(iWorld2, \u2603, i, 6 + i, 5 - i, mutableBoundingBox);
                }
            }
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 0, 0, 1, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 5, 8, 1, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 1, 0, 8, 1, 4, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 1, 0, 7, 1, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 2, 0, 0, 4, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 2, 5, 0, 4, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 2, 5, 8, 4, 5, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 2, 0, 8, 4, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 2, 1, 0, 4, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 2, 5, 7, 4, 5, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 2, 1, 8, 4, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 2, 0, 7, 4, 0, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 4, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 5, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 6, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 4, 3, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 5, 3, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 6, 3, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 3, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 3, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 3, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 8, 3, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 2, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 3, 2, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 5, 2, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 6, 2, 5, mutableBoundingBox);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 4, 1, 7, 4, 1, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 4, 4, 7, 4, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 3, 4, 7, 3, 4, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            this.func_175811_a(iWorld2, \u2603, 7, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 7, 1, 3, mutableBoundingBox);
            IBlockState \u26032 = \u2603;
            this.func_175811_a(iWorld2, \u26032, 6, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 5, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 4, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 3, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 6, 1, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_196663_cq.func_176223_P(), 6, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 4, 1, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_196663_cq.func_176223_P(), 4, 2, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150462_ai.func_176223_P(), 7, 1, 1, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 1, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 1, 2, 0, mutableBoundingBox);
            this.func_189927_a(iWorld2, mutableBoundingBox, random, 1, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(iWorld2, 1, 0, -1, mutableBoundingBox).func_196958_f() && !this.func_175807_a(iWorld2, 1, -1, -1, mutableBoundingBox).func_196958_f()) {
                this.func_175811_a(iWorld2, \u2603, 1, 0, -1, mutableBoundingBox);
                if (this.func_175807_a(iWorld2, 1, -1, -1, mutableBoundingBox).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(iWorld2, Blocks.field_196658_i.func_176223_P(), 1, -1, -1, mutableBoundingBox);
                }
            }
            for (int i = 0; i < 6; ++i) {
                for (\u2603 = 0; \u2603 < 9; ++\u2603) {
                    this.func_74871_b(iWorld2, \u2603, 9, i, mutableBoundingBox);
                    this.func_175808_b(iWorld2, iBlockState, \u2603, -1, i, mutableBoundingBox);
                }
            }
            this.func_74893_a(iWorld2, mutableBoundingBox, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int n, int n2) {
            return 1;
        }
    }

    public static class Church
    extends Village {
        public Church() {
        }

        public Church(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        public static Church func_175854_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 5, 12, 9, enumFacing);
            if (!Church.func_74895_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Church(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            int n;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld2, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 12 - 1, 0);
            }
            IBlockState iBlockState = Blocks.field_150347_e.func_176223_P();
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.WEST));
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.EAST));
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 1, 3, 3, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 5, 1, 3, 9, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 0, 0, 3, 0, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 0, 3, 10, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 1, 0, 10, 3, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 1, 1, 4, 10, 3, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 4, 0, 4, 7, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 0, 4, 4, 4, 7, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 8, 3, 4, 8, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 5, 4, 3, 10, 4, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 5, 5, 3, 5, 7, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 9, 0, 4, 9, 4, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 4, 0, 4, 4, 4, iBlockState, iBlockState, false);
            this.func_175811_a(iWorld2, iBlockState, 0, 11, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 4, 11, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 2, 11, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 2, 11, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 1, 1, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 1, 1, 7, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 2, 1, 7, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 3, 1, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 3, 1, 7, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 1, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 1, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 3, 1, 5, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 2, 7, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 3, 2, 7, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 3, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 4, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 4, 3, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 6, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 7, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 4, 6, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 4, 7, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 6, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 7, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 6, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 7, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 3, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 4, 3, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 3, 8, mutableBoundingBox);
            this.func_189926_a(iWorld2, EnumFacing.SOUTH, 2, 4, 7, mutableBoundingBox);
            this.func_189926_a(iWorld2, EnumFacing.EAST, 1, 4, 6, mutableBoundingBox);
            this.func_189926_a(iWorld2, EnumFacing.WEST, 3, 4, 6, mutableBoundingBox);
            this.func_189926_a(iWorld2, EnumFacing.NORTH, 2, 4, 5, mutableBoundingBox);
            \u2603 = (IBlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a(BlockLadder.field_176382_a, EnumFacing.WEST);
            for (n = 1; n <= 9; ++n) {
                this.func_175811_a(iWorld2, \u2603, 3, n, 3, mutableBoundingBox);
            }
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 2, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150350_a.func_176223_P(), 2, 2, 0, mutableBoundingBox);
            this.func_189927_a(iWorld2, mutableBoundingBox, random, 2, 1, 0, EnumFacing.NORTH);
            if (this.func_175807_a(iWorld2, 2, 0, -1, mutableBoundingBox).func_196958_f() && !this.func_175807_a(iWorld2, 2, -1, -1, mutableBoundingBox).func_196958_f()) {
                this.func_175811_a(iWorld2, \u2603, 2, 0, -1, mutableBoundingBox);
                if (this.func_175807_a(iWorld2, 2, -1, -1, mutableBoundingBox).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(iWorld2, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, mutableBoundingBox);
                }
            }
            for (n = 0; n < 9; ++n) {
                for (\u2603 = 0; \u2603 < 5; ++\u2603) {
                    this.func_74871_b(iWorld2, \u2603, 12, n, mutableBoundingBox);
                    this.func_175808_b(iWorld2, iBlockState, \u2603, -1, n, mutableBoundingBox);
                }
            }
            this.func_74893_a(iWorld2, mutableBoundingBox, 2, 1, 2, 1);
            return true;
        }

        @Override
        protected int func_180779_c(int n, int n2) {
            return 2;
        }
    }

    public static class House4Garden
    extends Village {
        private boolean field_74913_b;

        public House4Garden() {
        }

        public House4Garden(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_74913_b = random.nextBoolean();
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Terrace", this.field_74913_b);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74913_b = nBTTagCompound.func_74767_n("Terrace");
        }

        public static House4Garden func_175858_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 5, 6, 5, enumFacing);
            if (StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new House4Garden(start, n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            int n;
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld2, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 6 - 1, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            \u2603 = this.func_175847_a((IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH));
            \u2603 = this.func_175847_a(Blocks.field_196617_K.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 0, 4, 0, 4, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 4, 0, 4, 4, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 4, 1, 3, 4, 3, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, iBlockState, 0, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 0, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 0, 3, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 4, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 4, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 4, 3, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 0, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 0, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 0, 3, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 4, 1, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 4, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, iBlockState, 4, 3, 4, mutableBoundingBox);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 1, 0, 3, 3, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 1, 1, 4, 3, 3, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 4, 3, 3, 4, \u2603, \u2603, false);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 0, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196411_b, true)).func_206870_a(BlockGlassPane.field_196414_y, true), 2, 2, 4, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150410_aZ.func_176223_P().func_206870_a(BlockGlassPane.field_196413_c, true)).func_206870_a(BlockGlassPane.field_196409_a, true), 4, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 1, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 1, 3, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 2, 3, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 3, 3, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 3, 2, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u2603, 3, 1, 0, mutableBoundingBox);
            if (this.func_175807_a(iWorld2, 2, 0, -1, mutableBoundingBox).func_196958_f() && !this.func_175807_a(iWorld2, 2, -1, -1, mutableBoundingBox).func_196958_f()) {
                this.func_175811_a(iWorld2, \u2603, 2, 0, -1, mutableBoundingBox);
                if (this.func_175807_a(iWorld2, 2, -1, -1, mutableBoundingBox).func_177230_c() == Blocks.field_185774_da) {
                    this.func_175811_a(iWorld2, Blocks.field_196658_i.func_176223_P(), 2, -1, -1, mutableBoundingBox);
                }
            }
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 1, 3, 3, 3, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            if (this.field_74913_b) {
                n = 0;
                \u2603 = 4;
                for (\u2603 = 0; \u2603 <= 4; ++\u2603) {
                    for (\u2603 = 0; \u2603 <= 4; ++\u2603) {
                        boolean bl = \u2603 == 0 || \u2603 == 4;
                        boolean bl2 = \u2603 = \u2603 == 0 || \u2603 == 4;
                        if (!bl && !\u2603) continue;
                        \u2603 = \u2603 == 0 || \u2603 == 4;
                        \u2603 = \u2603 == 0 || \u2603 == 4;
                        IBlockState \u26032 = (IBlockState)((IBlockState)((IBlockState)((IBlockState)\u2603.func_206870_a(BlockFence.field_196413_c, \u2603 && \u2603 != 0)).func_206870_a(BlockFence.field_196409_a, \u2603 && \u2603 != 4)).func_206870_a(BlockFence.field_196414_y, \u2603 && \u2603 != 0)).func_206870_a(BlockFence.field_196411_b, \u2603 && \u2603 != 4);
                        this.func_175811_a(iWorld2, \u26032, \u2603, 5, \u2603, mutableBoundingBox);
                    }
                }
            }
            if (this.field_74913_b) {
                IBlockState iBlockState2 = (IBlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a(BlockLadder.field_176382_a, EnumFacing.SOUTH);
                this.func_175811_a(iWorld2, iBlockState2, 3, 1, 3, mutableBoundingBox);
                this.func_175811_a(iWorld2, iBlockState2, 3, 2, 3, mutableBoundingBox);
                this.func_175811_a(iWorld2, iBlockState2, 3, 3, 3, mutableBoundingBox);
                this.func_175811_a(iWorld2, iBlockState2, 3, 4, 3, mutableBoundingBox);
            }
            this.func_189926_a(iWorld2, EnumFacing.NORTH, 2, 3, 1, mutableBoundingBox);
            for (n = 0; n < 5; ++n) {
                for (\u2603 = 0; \u2603 < 5; ++\u2603) {
                    this.func_74871_b(iWorld2, \u2603, 6, n, mutableBoundingBox);
                    this.func_175808_b(iWorld2, iBlockState, \u2603, -1, n, mutableBoundingBox);
                }
            }
            this.func_74893_a(iWorld2, mutableBoundingBox, 1, 1, 2, 1);
            return true;
        }
    }

    public static class Path
    extends Road {
        private int field_74934_a;

        public Path() {
        }

        public Path(Start start, int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(start, n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_74934_a = Math.max(mutableBoundingBox.func_78883_b(), mutableBoundingBox.func_78880_d());
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74768_a("Length", this.field_74934_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74934_a = nBTTagCompound.func_74762_e("Length");
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            Object object;
            int n;
            boolean \u26032 = false;
            for (n = random.nextInt(5); n < this.field_74934_a - 8; n += 2 + random.nextInt(5)) {
                object = this.func_74891_a((Start)structurePiece, list, random, 0, n);
                if (object == null) continue;
                n += Math.max(((StructurePiece)object).field_74887_e.func_78883_b(), ((StructurePiece)object).field_74887_e.func_78880_d());
                \u26032 = true;
            }
            for (n = random.nextInt(5); n < this.field_74934_a - 8; n += 2 + random.nextInt(5)) {
                object = this.func_74894_b((Start)structurePiece, list, random, 0, n);
                if (object == null) continue;
                n += Math.max(((StructurePiece)object).field_74887_e.func_78883_b(), ((StructurePiece)object).field_74887_e.func_78880_d());
                \u26032 = true;
            }
            object = this.func_186165_e();
            if (\u26032 && random.nextInt(3) > 0 && object != null) {
                switch (1.field_176064_a[((Enum)object).ordinal()]) {
                    default: {
                        VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.WEST, this.func_74877_c());
                        break;
                    }
                    case 4: {
                        VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            if (\u26032 && random.nextInt(3) > 0 && object != null) {
                switch (1.field_176064_a[((Enum)object).ordinal()]) {
                    default: {
                        VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case 2: {
                        VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 2, EnumFacing.EAST, this.func_74877_c());
                        break;
                    }
                    case 4: {
                        VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78893_d - 2, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                        break;
                    }
                    case 3: {
                        VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
        }

        public static MutableBoundingBox func_175848_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing) {
            for (int i = 7 * MathHelper.func_76136_a(random, 3, 5); i >= 7; i -= 7) {
                MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, 0, 0, 0, 3, 3, i, enumFacing);
                if (StructurePiece.func_74883_a(list, mutableBoundingBox) != null) continue;
                return mutableBoundingBox;
            }
            return null;
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IBlockState iBlockState = this.func_175847_a(Blocks.field_185774_da.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_196662_n.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_150351_n.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
            this.field_74887_e.field_78895_b = 1000;
            this.field_74887_e.field_78894_e = 0;
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (\u2603 = this.field_74887_e.field_78896_c; \u2603 <= this.field_74887_e.field_78892_f; ++\u2603) {
                    \u26032.func_181079_c(i, 64, \u2603);
                    if (!mutableBoundingBox.func_175898_b(\u26032)) continue;
                    \u2603 = iWorld.func_201676_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, \u26032.func_177958_n(), \u26032.func_177952_p());
                    \u26032.func_181079_c(\u26032.func_177958_n(), \u2603, \u26032.func_177952_p()).func_189536_c(EnumFacing.DOWN);
                    if (\u26032.func_177956_o() < iWorld.func_181545_F()) {
                        \u26032.func_185336_p(iWorld.func_181545_F() - 1);
                    }
                    while (\u26032.func_177956_o() >= iWorld.func_181545_F() - 1) {
                        IBlockState iBlockState2 = iWorld.func_180495_p(\u26032);
                        Block \u26033 = iBlockState2.func_177230_c();
                        if (\u26033 == Blocks.field_196658_i && iWorld.func_175623_d(\u26032.func_177984_a())) {
                            iWorld.func_180501_a(\u26032, iBlockState, 2);
                            break;
                        }
                        if (iBlockState2.func_185904_a().func_76224_d()) {
                            iWorld.func_180501_a(new BlockPos(\u26032), \u2603, 2);
                            break;
                        }
                        if (\u26033 == Blocks.field_150354_m || \u26033 == Blocks.field_196611_F || \u26033 == Blocks.field_150322_A || \u26033 == Blocks.field_196583_aj || \u26033 == Blocks.field_196585_ak || \u26033 == Blocks.field_180395_cM || \u26033 == Blocks.field_196583_aj || \u26033 == Blocks.field_196585_ak) {
                            iWorld.func_180501_a(\u26032, \u2603, 2);
                            iWorld.func_180501_a(\u26032.func_177977_b(), \u2603, 2);
                            break;
                        }
                        \u26032.func_189536_c(EnumFacing.DOWN);
                    }
                    this.field_74887_e.field_78895_b = Math.min(this.field_74887_e.field_78895_b, \u26032.func_177956_o());
                    this.field_74887_e.field_78894_e = Math.max(this.field_74887_e.field_78894_e, \u26032.func_177956_o());
                }
            }
            return true;
        }
    }

    public static abstract class Road
    extends Village {
        public Road() {
        }

        protected Road(Start start, int n) {
            super(start, n);
        }
    }

    public static class Start
    extends Well {
        public int field_74928_c;
        public PieceWeight field_74926_d;
        public List<PieceWeight> field_74931_h;
        public List<StructurePiece> field_74932_i = Lists.newArrayList();
        public List<StructurePiece> field_74930_j = Lists.newArrayList();

        public Start() {
        }

        public Start(int n, Random random, int n2, int n3, List<PieceWeight> list, VillageConfig villageConfig) {
            super(null, 0, random, n2, n3);
            this.field_74931_h = list;
            this.field_74928_c = villageConfig.field_202461_a;
            this.field_189928_h = villageConfig.field_202462_b;
            this.func_202579_a(this.field_189928_h);
            this.field_189929_i = random.nextInt(50) == 0;
        }
    }

    public static class Well
    extends Village {
        public Well() {
        }

        public Well(Start start, int n, Random random, int n2, int n3) {
            super(start, n);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new MutableBoundingBox(n2, 64, n3, n2 + 6 - 1, 78, n3 + 6 - 1) : new MutableBoundingBox(n2, 64, n3, n2 + 6 - 1, 78, n3 + 6 - 1);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, this.func_74877_c());
            VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, this.func_74877_c());
            VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            VillagePieces.func_176069_e((Start)structurePiece, list, random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 4, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            if (this.field_143015_k < 0) {
                this.field_143015_k = this.func_74889_b(iWorld, mutableBoundingBox);
                if (this.field_143015_k < 0) {
                    return true;
                }
                this.field_74887_e.func_78886_a(0, this.field_143015_k - this.field_74887_e.field_78894_e + 3, 0);
            }
            IBlockState iBlockState = this.func_175847_a(Blocks.field_150347_e.func_176223_P());
            \u2603 = this.func_175847_a(Blocks.field_180407_aO.func_176223_P());
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 0, 1, 4, 12, 4, iBlockState, Blocks.field_150355_j.func_176223_P(), false);
            this.func_175811_a(iWorld, Blocks.field_150350_a.func_176223_P(), 2, 12, 2, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150350_a.func_176223_P(), 3, 12, 2, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150350_a.func_176223_P(), 2, 12, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150350_a.func_176223_P(), 3, 12, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, \u2603, 1, 13, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, \u2603, 1, 14, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, \u2603, 4, 13, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, \u2603, 4, 14, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, \u2603, 1, 13, 4, mutableBoundingBox);
            this.func_175811_a(iWorld, \u2603, 1, 14, 4, mutableBoundingBox);
            this.func_175811_a(iWorld, \u2603, 4, 13, 4, mutableBoundingBox);
            this.func_175811_a(iWorld, \u2603, 4, 14, 4, mutableBoundingBox);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 15, 1, 4, 15, 4, iBlockState, iBlockState, false);
            for (int i = 0; i <= 5; ++i) {
                for (\u2603 = 0; \u2603 <= 5; ++\u2603) {
                    if (\u2603 != 0 && \u2603 != 5 && i != 0 && i != 5) continue;
                    this.func_175811_a(iWorld, iBlockState, \u2603, 11, i, mutableBoundingBox);
                    this.func_74871_b(iWorld, \u2603, 12, i, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    static abstract class Village
    extends StructurePiece {
        protected int field_143015_k = -1;
        private int field_74896_a;
        protected Type field_189928_h;
        protected boolean field_189929_i;

        public Village() {
        }

        protected Village(Start start, int n) {
            super(n);
            if (start != null) {
                this.field_189928_h = start.field_189928_h;
                this.field_189929_i = start.field_189929_i;
            }
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            nBTTagCompound.func_74768_a("HPos", this.field_143015_k);
            nBTTagCompound.func_74768_a("VCount", this.field_74896_a);
            nBTTagCompound.func_74774_a("Type", (byte)this.field_189928_h.func_202604_a());
            nBTTagCompound.func_74757_a("Zombie", this.field_189929_i);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            this.field_143015_k = nBTTagCompound.func_74762_e("HPos");
            this.field_74896_a = nBTTagCompound.func_74762_e("VCount");
            this.field_189928_h = Type.func_202603_a(nBTTagCompound.func_74771_c("Type"));
            if (nBTTagCompound.func_74767_n("Desert")) {
                this.field_189928_h = Type.SANDSTONE;
            }
            this.field_189929_i = nBTTagCompound.func_74767_n("Zombie");
        }

        @Nullable
        protected StructurePiece func_74891_a(Start start, List<StructurePiece> list, Random random, int n, int n2) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing != null) {
                switch (enumFacing) {
                    default: {
                        return VillagePieces.func_176066_d(start, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return VillagePieces.func_176066_d(start, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return VillagePieces.func_176066_d(start, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return VillagePieces.func_176066_d(start, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
            }
            return null;
        }

        @Nullable
        protected StructurePiece func_74894_b(Start start, List<StructurePiece> list, Random random, int n, int n2) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing != null) {
                switch (enumFacing) {
                    default: {
                        return VillagePieces.func_176066_d(start, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return VillagePieces.func_176066_d(start, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return VillagePieces.func_176066_d(start, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: 
                }
                return VillagePieces.func_176066_d(start, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
            }
            return null;
        }

        protected int func_74889_b(IWorld iWorld, MutableBoundingBox mutableBoundingBox) {
            int n = 0;
            \u2603 = 0;
            BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
            for (\u2603 = this.field_74887_e.field_78896_c; \u2603 <= this.field_74887_e.field_78892_f; ++\u2603) {
                for (\u2603 = this.field_74887_e.field_78897_a; \u2603 <= this.field_74887_e.field_78893_d; ++\u2603) {
                    \u26032.func_181079_c(\u2603, 64, \u2603);
                    if (!mutableBoundingBox.func_175898_b(\u26032)) continue;
                    n += iWorld.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, \u26032).func_177956_o();
                    ++\u2603;
                }
            }
            if (\u2603 == 0) {
                return -1;
            }
            return n / \u2603;
        }

        protected static boolean func_74895_a(MutableBoundingBox mutableBoundingBox) {
            return mutableBoundingBox != null && mutableBoundingBox.field_78895_b > 10;
        }

        protected void func_74893_a(IWorld iWorld2, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4) {
            if (this.field_74896_a >= n4) {
                return;
            }
            for (\u2603 = this.field_74896_a; \u2603 < n4 && mutableBoundingBox.func_175898_b(new BlockPos(\u2603 = this.func_74865_a(n + \u2603, n3), \u2603 = this.func_74862_a(n2), \u2603 = this.func_74873_b(n + \u2603, n3))); ++\u2603) {
                IWorld iWorld2;
                EntityCreature \u26032;
                ++this.field_74896_a;
                if (this.field_189929_i) {
                    \u26032 = new EntityZombieVillager(iWorld2.func_201672_e());
                    \u26032.func_70012_b((double)\u2603 + 0.5, \u2603, (double)\u2603 + 0.5, 0.0f, 0.0f);
                    ((EntityZombieVillager)\u26032).func_204210_a(iWorld2.func_175649_E(new BlockPos(\u26032)), null, null);
                    ((EntityZombieVillager)\u26032).func_190733_a(this.func_180779_c(\u2603, 0));
                    \u26032.func_110163_bv();
                    iWorld2.func_72838_d(\u26032);
                    continue;
                }
                \u26032 = new EntityVillager(iWorld2.func_201672_e());
                \u26032.func_70012_b((double)\u2603 + 0.5, \u2603, (double)\u2603 + 0.5, 0.0f, 0.0f);
                ((EntityVillager)\u26032).func_70938_b(this.func_180779_c(\u2603, iWorld2.func_201674_k().nextInt(6)));
                ((EntityVillager)\u26032).func_190672_a(iWorld2.func_175649_E(new BlockPos(\u26032)), null, null, false);
                iWorld2.func_72838_d(\u26032);
            }
        }

        protected int func_180779_c(int n, int n2) {
            return n2;
        }

        protected IBlockState func_175847_a(IBlockState iBlockState) {
            Block block = iBlockState.func_177230_c();
            if (this.field_189928_h == Type.SANDSTONE) {
                if (block.func_203417_a(BlockTags.field_200031_h) || block == Blocks.field_150347_e) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196585_ak.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (IBlockState)Blocks.field_150372_bz.func_176223_P().func_206870_a(BlockStairs.field_176309_a, iBlockState.func_177229_b(BlockStairs.field_176309_a));
                }
                if (block == Blocks.field_196659_cl) {
                    return (IBlockState)Blocks.field_150372_bz.func_176223_P().func_206870_a(BlockStairs.field_176309_a, iBlockState.func_177229_b(BlockStairs.field_176309_a));
                }
                if (block == Blocks.field_150351_n) {
                    return Blocks.field_150322_A.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196667_cs.func_176223_P();
                }
            } else if (this.field_189928_h == Type.SPRUCE) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return (IBlockState)Blocks.field_196618_L.func_176223_P().func_206870_a(BlockLog.field_176298_M, iBlockState.func_177229_b(BlockLog.field_176298_M));
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196664_o.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (IBlockState)Blocks.field_150485_bF.func_176223_P().func_206870_a(BlockStairs.field_176309_a, iBlockState.func_177229_b(BlockStairs.field_176309_a));
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180408_aP.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196665_cr.func_176223_P();
                }
            } else if (this.field_189928_h == Type.ACACIA) {
                if (block.func_203417_a(BlockTags.field_200031_h)) {
                    return (IBlockState)Blocks.field_196621_O.func_176223_P().func_206870_a(BlockLog.field_176298_M, iBlockState.func_177229_b(BlockLog.field_176298_M));
                }
                if (block.func_203417_a(BlockTags.field_199898_b)) {
                    return Blocks.field_196670_r.func_176223_P();
                }
                if (block == Blocks.field_150476_ad) {
                    return (IBlockState)Blocks.field_150400_ck.func_176223_P().func_206870_a(BlockStairs.field_176309_a, iBlockState.func_177229_b(BlockStairs.field_176309_a));
                }
                if (block == Blocks.field_150347_e) {
                    return (IBlockState)Blocks.field_196621_O.func_176223_P().func_206870_a(BlockLog.field_176298_M, EnumFacing.Axis.Y);
                }
                if (block == Blocks.field_180407_aO) {
                    return Blocks.field_180405_aT.func_176223_P();
                }
                if (block == Blocks.field_196663_cq) {
                    return Blocks.field_196671_cu.func_176223_P();
                }
            }
            return iBlockState;
        }

        protected BlockDoor func_189925_i() {
            if (this.field_189928_h == Type.ACACIA) {
                return (BlockDoor)Blocks.field_180410_as;
            }
            if (this.field_189928_h == Type.SPRUCE) {
                return (BlockDoor)Blocks.field_180414_ap;
            }
            return (BlockDoor)Blocks.field_180413_ao;
        }

        protected void func_189927_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, int n, int n2, int n3, EnumFacing enumFacing) {
            if (!this.field_189929_i) {
                this.func_189915_a(iWorld, mutableBoundingBox, random, n, n2, n3, EnumFacing.NORTH, this.func_189925_i());
            }
        }

        protected void func_189926_a(IWorld iWorld, EnumFacing enumFacing, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
            if (!this.field_189929_i) {
                this.func_175811_a(iWorld, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, enumFacing), n, n2, n3, mutableBoundingBox);
            }
        }

        @Override
        protected void func_175808_b(IWorld iWorld, IBlockState iBlockState, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
            IBlockState iBlockState2 = this.func_175847_a(iBlockState);
            super.func_175808_b(iWorld, iBlockState2, n, n2, n3, mutableBoundingBox);
        }

        protected void func_202579_a(Type type) {
            this.field_189928_h = type;
        }
    }

    public static class PieceWeight {
        public Class<? extends Village> field_75090_a;
        public final int field_75088_b;
        public int field_75089_c;
        public int field_75087_d;

        public PieceWeight(Class<? extends Village> clazz, int n, int n2) {
            this.field_75090_a = clazz;
            this.field_75088_b = n;
            this.field_75087_d = n2;
        }

        public boolean func_75085_a(int n) {
            return this.field_75087_d == 0 || this.field_75089_c < this.field_75087_d;
        }

        public boolean func_75086_a() {
            return this.field_75087_d == 0 || this.field_75089_c < this.field_75087_d;
        }
    }

    public static enum Type {
        OAK(0),
        SANDSTONE(1),
        ACACIA(2),
        SPRUCE(3);

        private final int field_202605_e;

        private Type(int n2) {
            this.field_202605_e = n2;
        }

        public int func_202604_a() {
            return this.field_202605_e;
        }

        public static Type func_202603_a(int n) {
            Type[] typeArray = Type.values();
            if (n >= 0 && n < typeArray.length) {
                return typeArray[n];
            }
            return OAK;
        }
    }
}

