/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.state.IBlockState;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.template.TemplateManager;

public abstract class StructurePiece {
    protected static final IBlockState field_202556_l = Blocks.field_201941_jj.func_176223_P();
    protected MutableBoundingBox field_74887_e;
    @Nullable
    private EnumFacing field_74885_f;
    private Mirror field_186168_b;
    private Rotation field_186169_c;
    protected int field_74886_g;
    private static final Set<Block> field_211413_d = ImmutableSet.builder().add((Object)Blocks.field_150386_bk).add((Object)Blocks.field_150478_aa).add((Object)Blocks.field_196591_bQ).add((Object)Blocks.field_180407_aO).add((Object)Blocks.field_180408_aP).add((Object)Blocks.field_180406_aS).add((Object)Blocks.field_180405_aT).add((Object)Blocks.field_180404_aQ).add((Object)Blocks.field_180403_aR).add((Object)Blocks.field_150468_ap).add((Object)Blocks.field_150411_aY).build();

    public StructurePiece() {
    }

    protected StructurePiece(int n) {
        this.field_74886_g = n;
    }

    public final NBTTagCompound func_143010_b() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74778_a("id", StructureIO.func_143036_a(this));
        nBTTagCompound.func_74782_a("BB", this.field_74887_e.func_151535_h());
        EnumFacing \u26032 = this.func_186165_e();
        nBTTagCompound.func_74768_a("O", \u26032 == null ? -1 : \u26032.func_176736_b());
        nBTTagCompound.func_74768_a("GD", this.field_74886_g);
        this.func_143012_a(nBTTagCompound);
        return nBTTagCompound;
    }

    protected abstract void func_143012_a(NBTTagCompound var1);

    public void func_143009_a(IWorld iWorld, NBTTagCompound nBTTagCompound) {
        if (nBTTagCompound.func_74764_b("BB")) {
            this.field_74887_e = new MutableBoundingBox(nBTTagCompound.func_74759_k("BB"));
        }
        this.func_186164_a((\u2603 = nBTTagCompound.func_74762_e("O")) == -1 ? null : EnumFacing.func_176731_b(\u2603));
        this.field_74886_g = nBTTagCompound.func_74762_e("GD");
        this.func_143011_b(nBTTagCompound, iWorld.func_72860_G().func_186340_h());
    }

    protected abstract void func_143011_b(NBTTagCompound var1, TemplateManager var2);

    public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
    }

    public abstract boolean func_74875_a(IWorld var1, Random var2, MutableBoundingBox var3, ChunkPos var4);

    public MutableBoundingBox func_74874_b() {
        return this.field_74887_e;
    }

    public int func_74877_c() {
        return this.field_74886_g;
    }

    public static StructurePiece func_74883_a(List<StructurePiece> list, MutableBoundingBox mutableBoundingBox) {
        for (StructurePiece structurePiece : list) {
            if (structurePiece.func_74874_b() == null || !structurePiece.func_74874_b().func_78884_a(mutableBoundingBox)) continue;
            return structurePiece;
        }
        return null;
    }

    protected boolean func_74860_a(IBlockReader iBlockReader, MutableBoundingBox mutableBoundingBox) {
        int n = Math.max(this.field_74887_e.field_78897_a - 1, mutableBoundingBox.field_78897_a);
        \u2603 = Math.max(this.field_74887_e.field_78895_b - 1, mutableBoundingBox.field_78895_b);
        \u2603 = Math.max(this.field_74887_e.field_78896_c - 1, mutableBoundingBox.field_78896_c);
        \u2603 = Math.min(this.field_74887_e.field_78893_d + 1, mutableBoundingBox.field_78893_d);
        \u2603 = Math.min(this.field_74887_e.field_78894_e + 1, mutableBoundingBox.field_78894_e);
        \u2603 = Math.min(this.field_74887_e.field_78892_f + 1, mutableBoundingBox.field_78892_f);
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                if (iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                if (iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                if (iBlockReader.func_180495_p(\u26032.func_181079_c(n, \u2603, \u2603)).func_185904_a().func_76224_d()) {
                    return true;
                }
                if (!iBlockReader.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603)).func_185904_a().func_76224_d()) continue;
                return true;
            }
        }
        return false;
    }

    protected int func_74865_a(int n, int n2) {
        EnumFacing enumFacing = this.func_186165_e();
        if (enumFacing == null) {
            return n;
        }
        switch (enumFacing) {
            case NORTH: 
            case SOUTH: {
                return this.field_74887_e.field_78897_a + n;
            }
            case WEST: {
                return this.field_74887_e.field_78893_d - n2;
            }
            case EAST: {
                return this.field_74887_e.field_78897_a + n2;
            }
        }
        return n;
    }

    protected int func_74862_a(int n) {
        if (this.func_186165_e() == null) {
            return n;
        }
        return n + this.field_74887_e.field_78895_b;
    }

    protected int func_74873_b(int n, int n2) {
        EnumFacing enumFacing = this.func_186165_e();
        if (enumFacing == null) {
            return n2;
        }
        switch (enumFacing) {
            case NORTH: {
                return this.field_74887_e.field_78892_f - n2;
            }
            case SOUTH: {
                return this.field_74887_e.field_78896_c + n2;
            }
            case WEST: 
            case EAST: {
                return this.field_74887_e.field_78896_c + n;
            }
        }
        return n2;
    }

    protected void func_175811_a(IWorld iWorld2, IBlockState iBlockState2, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        IWorld iWorld2;
        IBlockState iBlockState2;
        BlockPos blockPos = new BlockPos(this.func_74865_a(n, n3), this.func_74862_a(n2), this.func_74873_b(n, n3));
        if (!mutableBoundingBox.func_175898_b(blockPos)) {
            return;
        }
        if (this.field_186168_b != Mirror.NONE) {
            iBlockState2 = iBlockState2.func_185902_a(this.field_186168_b);
        }
        if (this.field_186169_c != Rotation.NONE) {
            iBlockState2 = iBlockState2.func_185907_a(this.field_186169_c);
        }
        iWorld2.func_180501_a(blockPos, iBlockState2, 2);
        IFluidState \u26032 = iWorld2.func_204610_c(blockPos);
        if (!\u26032.func_206888_e()) {
            iWorld2.func_205219_F_().func_205360_a(blockPos, \u26032.func_206886_c(), 0);
        }
        if (field_211413_d.contains(iBlockState2.func_177230_c())) {
            iWorld2.func_205771_y(blockPos).func_201594_d(blockPos);
        }
    }

    protected IBlockState func_175807_a(IBlockReader iBlockReader, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        int n4 = this.func_74865_a(n, n3);
        BlockPos \u26032 = new BlockPos(n4, \u2603 = this.func_74862_a(n2), \u2603 = this.func_74873_b(n, n3));
        if (!mutableBoundingBox.func_175898_b(\u26032)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return iBlockReader.func_180495_p(\u26032);
    }

    protected boolean func_189916_b(IWorldReaderBase iWorldReaderBase, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        int n4 = this.func_74865_a(n, n3);
        BlockPos \u26032 = new BlockPos(n4, \u2603 = this.func_74862_a(n2 + 1), \u2603 = this.func_74873_b(n, n3));
        if (!mutableBoundingBox.func_175898_b(\u26032)) {
            return false;
        }
        return \u2603 < iWorldReaderBase.func_201676_a(Heightmap.Type.OCEAN_FLOOR_WG, n4, \u2603);
    }

    protected void func_74878_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6) {
        for (\u2603 = n2; \u2603 <= n5; ++\u2603) {
            for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                    this.func_175811_a(iWorld, Blocks.field_150350_a.func_176223_P(), \u2603, \u2603, \u2603, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_175804_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6, IBlockState iBlockState, IBlockState iBlockState2, boolean bl) {
        for (int i = n2; i <= n5; ++i) {
            for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                    if (bl && this.func_175807_a(iWorld, \u2603, i, \u2603, mutableBoundingBox).func_196958_f()) continue;
                    if (i == n2 || i == n5 || \u2603 == n || \u2603 == n4 || \u2603 == n3 || \u2603 == n6) {
                        this.func_175811_a(iWorld, iBlockState, \u2603, i, \u2603, mutableBoundingBox);
                        continue;
                    }
                    this.func_175811_a(iWorld, iBlockState2, \u2603, i, \u2603, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_74882_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, Random random, BlockSelector blockSelector) {
        for (int i = n2; i <= n5; ++i) {
            for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                    if (bl && this.func_175807_a(iWorld, \u2603, i, \u2603, mutableBoundingBox).func_196958_f()) continue;
                    blockSelector.func_75062_a(random, \u2603, i, \u2603, i == n2 || i == n5 || \u2603 == n || \u2603 == n4 || \u2603 == n3 || \u2603 == n6);
                    this.func_175811_a(iWorld, blockSelector.func_180780_a(), \u2603, i, \u2603, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_189914_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, float f, int n, int n2, int n3, int n4, int n5, int n6, IBlockState iBlockState, IBlockState iBlockState2, boolean bl, boolean bl2) {
        for (int i = n2; i <= n5; ++i) {
            for (\u2603 = n; \u2603 <= n4; ++\u2603) {
                for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                    if (random.nextFloat() > f || bl && this.func_175807_a(iWorld, \u2603, i, \u2603, mutableBoundingBox).func_196958_f() || bl2 && !this.func_189916_b(iWorld, \u2603, i, \u2603, mutableBoundingBox)) continue;
                    if (i == n2 || i == n5 || \u2603 == n || \u2603 == n4 || \u2603 == n3 || \u2603 == n6) {
                        this.func_175811_a(iWorld, iBlockState, \u2603, i, \u2603, mutableBoundingBox);
                        continue;
                    }
                    this.func_175811_a(iWorld, iBlockState2, \u2603, i, \u2603, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_175809_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, float f, int n, int n2, int n3, IBlockState iBlockState) {
        if (random.nextFloat() < f) {
            this.func_175811_a(iWorld, iBlockState, n, n2, n3, mutableBoundingBox);
        }
    }

    protected void func_180777_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, int n, int n2, int n3, int n4, int n5, int n6, IBlockState iBlockState, boolean bl) {
        float f = n4 - n + 1;
        \u2603 = n5 - n2 + 1;
        \u2603 = n6 - n3 + 1;
        \u2603 = (float)n + f / 2.0f;
        \u2603 = (float)n3 + \u2603 / 2.0f;
        for (int i = n2; i <= n5; ++i) {
            float f2 = (float)(i - n2) / \u2603;
            for (int j = n; j <= n4; ++j) {
                float f3 = ((float)j - \u2603) / (f * 0.5f);
                for (int k = n3; k <= n6; ++k) {
                    float f4 = ((float)k - \u2603) / (\u2603 * 0.5f);
                    if (bl && this.func_175807_a(iWorld, j, i, k, mutableBoundingBox).func_196958_f() || !((\u2603 = f3 * f3 + f2 * f2 + f4 * f4) <= 1.05f)) continue;
                    this.func_175811_a(iWorld, iBlockState, j, i, k, mutableBoundingBox);
                }
            }
        }
    }

    protected void func_74871_b(IWorld iWorld, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        BlockPos blockPos = new BlockPos(this.func_74865_a(n, n3), this.func_74862_a(n2), this.func_74873_b(n, n3));
        if (!mutableBoundingBox.func_175898_b(blockPos)) {
            return;
        }
        while (!iWorld.func_175623_d(blockPos) && blockPos.func_177956_o() < 255) {
            iWorld.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 2);
            blockPos = blockPos.func_177984_a();
        }
    }

    protected void func_175808_b(IWorld iWorld, IBlockState iBlockState, int n, int n2, int n3, MutableBoundingBox mutableBoundingBox) {
        int n4 = this.func_74865_a(n, n3);
        if (!mutableBoundingBox.func_175898_b(new BlockPos(n4, \u2603 = this.func_74862_a(n2), \u2603 = this.func_74873_b(n, n3)))) {
            return;
        }
        while ((iWorld.func_175623_d(new BlockPos(n4, \u2603, \u2603)) || iWorld.func_180495_p(new BlockPos(n4, \u2603, \u2603)).func_185904_a().func_76224_d()) && \u2603 > 1) {
            iWorld.func_180501_a(new BlockPos(n4, \u2603, \u2603), iBlockState, 2);
            --\u2603;
        }
    }

    protected boolean func_186167_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, int n, int n2, int n3, ResourceLocation resourceLocation) {
        BlockPos blockPos = new BlockPos(this.func_74865_a(n, n3), this.func_74862_a(n2), this.func_74873_b(n, n3));
        return this.func_191080_a(iWorld, mutableBoundingBox, random, blockPos, resourceLocation, null);
    }

    public static IBlockState func_197528_a(IBlockReader iBlockReader, BlockPos blockPos, IBlockState iBlockState) {
        Object object = null;
        for (Object object2 : EnumFacing.Plane.HORIZONTAL) {
            BlockPos blockPos2 = blockPos.func_177972_a((EnumFacing)object2);
            IBlockState \u26032 = iBlockReader.func_180495_p(blockPos2);
            if (\u26032.func_177230_c() == Blocks.field_150486_ae) {
                return iBlockState;
            }
            if (!\u26032.func_200015_d(iBlockReader, blockPos2)) continue;
            if (object == null) {
                object = object2;
                continue;
            }
            object = null;
            break;
        }
        if (object != null) {
            return (IBlockState)iBlockState.func_206870_a(BlockHorizontal.field_185512_D, ((EnumFacing)object).func_176734_d());
        }
        EnumFacing \u26033 = iBlockState.func_177229_b(BlockHorizontal.field_185512_D);
        object2 = blockPos.func_177972_a(\u26033);
        if (iBlockReader.func_180495_p((BlockPos)object2).func_200015_d(iBlockReader, (BlockPos)object2)) {
            \u26033 = \u26033.func_176734_d();
            object2 = blockPos.func_177972_a(\u26033);
        }
        if (iBlockReader.func_180495_p((BlockPos)object2).func_200015_d(iBlockReader, (BlockPos)object2)) {
            \u26033 = \u26033.func_176746_e();
            object2 = blockPos.func_177972_a(\u26033);
        }
        if (iBlockReader.func_180495_p((BlockPos)object2).func_200015_d(iBlockReader, (BlockPos)object2)) {
            \u26033 = \u26033.func_176734_d();
            object2 = blockPos.func_177972_a(\u26033);
        }
        return (IBlockState)iBlockState.func_206870_a(BlockHorizontal.field_185512_D, \u26033);
    }

    protected boolean func_191080_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, BlockPos blockPos, ResourceLocation resourceLocation, @Nullable IBlockState iBlockState) {
        if (!mutableBoundingBox.func_175898_b(blockPos) || iWorld.func_180495_p(blockPos).func_177230_c() == Blocks.field_150486_ae) {
            return false;
        }
        if (iBlockState == null) {
            iBlockState = StructurePiece.func_197528_a(iWorld, blockPos, Blocks.field_150486_ae.func_176223_P());
        }
        iWorld.func_180501_a(blockPos, iBlockState, 2);
        TileEntity tileEntity = iWorld.func_175625_s(blockPos);
        if (tileEntity instanceof TileEntityChest) {
            ((TileEntityChest)tileEntity).func_189404_a(resourceLocation, random.nextLong());
        }
        return true;
    }

    protected boolean func_189419_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, int n, int n2, int n3, EnumFacing enumFacing, ResourceLocation resourceLocation) {
        BlockPos blockPos = new BlockPos(this.func_74865_a(n, n3), this.func_74862_a(n2), this.func_74873_b(n, n3));
        if (mutableBoundingBox.func_175898_b(blockPos) && iWorld.func_180495_p(blockPos).func_177230_c() != Blocks.field_150367_z) {
            this.func_175811_a(iWorld, (IBlockState)Blocks.field_150367_z.func_176223_P().func_206870_a(BlockDispenser.field_176441_a, enumFacing), n, n2, n3, mutableBoundingBox);
            TileEntity tileEntity = iWorld.func_175625_s(blockPos);
            if (tileEntity instanceof TileEntityDispenser) {
                ((TileEntityDispenser)tileEntity).func_189404_a(resourceLocation, random.nextLong());
            }
            return true;
        }
        return false;
    }

    protected void func_189915_a(IWorld iWorld, MutableBoundingBox mutableBoundingBox, Random random, int n, int n2, int n3, EnumFacing enumFacing, BlockDoor blockDoor) {
        this.func_175811_a(iWorld, (IBlockState)blockDoor.func_176223_P().func_206870_a(BlockDoor.field_176520_a, enumFacing), n, n2, n3, mutableBoundingBox);
        this.func_175811_a(iWorld, (IBlockState)((IBlockState)blockDoor.func_176223_P().func_206870_a(BlockDoor.field_176520_a, enumFacing)).func_206870_a(BlockDoor.field_176523_O, DoubleBlockHalf.UPPER), n, n2 + 1, n3, mutableBoundingBox);
    }

    public void func_181138_a(int n, int n2, int n3) {
        this.field_74887_e.func_78886_a(n, n2, n3);
    }

    @Nullable
    public EnumFacing func_186165_e() {
        return this.field_74885_f;
    }

    public void func_186164_a(@Nullable EnumFacing enumFacing) {
        this.field_74885_f = enumFacing;
        if (enumFacing == null) {
            this.field_186169_c = Rotation.NONE;
            this.field_186168_b = Mirror.NONE;
        } else {
            switch (enumFacing) {
                case SOUTH: {
                    this.field_186168_b = Mirror.LEFT_RIGHT;
                    this.field_186169_c = Rotation.NONE;
                    break;
                }
                case WEST: {
                    this.field_186168_b = Mirror.LEFT_RIGHT;
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                case EAST: {
                    this.field_186168_b = Mirror.NONE;
                    this.field_186169_c = Rotation.CLOCKWISE_90;
                    break;
                }
                default: {
                    this.field_186168_b = Mirror.NONE;
                    this.field_186169_c = Rotation.NONE;
                }
            }
        }
    }

    public static abstract class BlockSelector {
        protected IBlockState field_151562_a = Blocks.field_150350_a.func_176223_P();

        protected BlockSelector() {
        }

        public abstract void func_75062_a(Random var1, int var2, int var3, int var4, boolean var5);

        public IBlockState func_180780_a() {
            return this.field_151562_a;
        }
    }
}

