/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.BuriedTreasurePieces;
import net.minecraft.world.gen.feature.structure.BuriedTreasureStructure;
import net.minecraft.world.gen.feature.structure.DesertPyramidPiece;
import net.minecraft.world.gen.feature.structure.DesertPyramidStructure;
import net.minecraft.world.gen.feature.structure.EndCityPieces;
import net.minecraft.world.gen.feature.structure.EndCityStructure;
import net.minecraft.world.gen.feature.structure.FortressPieces;
import net.minecraft.world.gen.feature.structure.FortressStructure;
import net.minecraft.world.gen.feature.structure.IglooPieces;
import net.minecraft.world.gen.feature.structure.IglooStructure;
import net.minecraft.world.gen.feature.structure.JunglePyramidPiece;
import net.minecraft.world.gen.feature.structure.JunglePyramidStructure;
import net.minecraft.world.gen.feature.structure.MineshaftPieces;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanMonumentPieces;
import net.minecraft.world.gen.feature.structure.OceanMonumentStructure;
import net.minecraft.world.gen.feature.structure.OceanRuinPieces;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.ShipwreckPieces;
import net.minecraft.world.gen.feature.structure.ShipwreckStructure;
import net.minecraft.world.gen.feature.structure.StrongholdPieces;
import net.minecraft.world.gen.feature.structure.StrongholdStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.SwampHutPiece;
import net.minecraft.world.gen.feature.structure.SwampHutStructure;
import net.minecraft.world.gen.feature.structure.VillagePieces;
import net.minecraft.world.gen.feature.structure.VillageStructure;
import net.minecraft.world.gen.feature.structure.WoodlandMansionPieces;
import net.minecraft.world.gen.feature.structure.WoodlandMansionStructure;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StructureIO {
    private static final Logger field_151687_a = LogManager.getLogger();
    private static final Map<String, Class<? extends StructureStart>> field_143040_a = Maps.newHashMap();
    private static final Map<Class<? extends StructureStart>, String> field_143038_b = Maps.newHashMap();
    private static final Map<String, Class<? extends StructurePiece>> field_143039_c = Maps.newHashMap();
    private static final Map<Class<? extends StructurePiece>, String> field_143037_d = Maps.newHashMap();

    private static void func_143034_b(Class<? extends StructureStart> clazz, String string) {
        field_143040_a.put(string, clazz);
        field_143038_b.put(clazz, string);
    }

    public static void func_143031_a(Class<? extends StructurePiece> clazz, String string) {
        field_143039_c.put(string, clazz);
        field_143037_d.put(clazz, string);
    }

    public static String func_143033_a(StructureStart structureStart) {
        return field_143038_b.get(structureStart.getClass());
    }

    public static String func_143036_a(StructurePiece structurePiece) {
        return field_143037_d.get(structurePiece.getClass());
    }

    @Nullable
    public static StructureStart func_202602_a(NBTTagCompound nBTTagCompound, IWorld iWorld) {
        StructureStart structureStart = null;
        String \u26032 = nBTTagCompound.func_74779_i("id");
        if ("INVALID".equals(\u26032)) {
            return Structure.field_202376_c;
        }
        try {
            Class<? extends StructureStart> clazz = field_143040_a.get(\u26032);
            if (clazz != null) {
                structureStart = clazz.newInstance();
            }
        }
        catch (Exception exception) {
            field_151687_a.warn("Failed Start with id {}", (Object)\u26032);
            exception.printStackTrace();
        }
        if (structureStart != null) {
            structureStart.func_143020_a(iWorld, nBTTagCompound);
        } else {
            field_151687_a.warn("Skipping Structure with id {}", (Object)\u26032);
        }
        return structureStart;
    }

    public static StructurePiece func_143032_b(NBTTagCompound nBTTagCompound, IWorld iWorld) {
        StructurePiece structurePiece = null;
        try {
            Class<? extends StructurePiece> clazz = field_143039_c.get(nBTTagCompound.func_74779_i("id"));
            if (clazz != null) {
                structurePiece = clazz.newInstance();
            }
        }
        catch (Exception exception) {
            field_151687_a.warn("Failed Piece with id {}", (Object)nBTTagCompound.func_74779_i("id"));
            exception.printStackTrace();
        }
        if (structurePiece != null) {
            structurePiece.func_143009_a(iWorld, nBTTagCompound);
        } else {
            field_151687_a.warn("Skipping Piece with id {}", (Object)nBTTagCompound.func_74779_i("id"));
        }
        return structurePiece;
    }

    static {
        StructureIO.func_143034_b(MineshaftStructure.Start.class, "Mineshaft");
        StructureIO.func_143034_b(VillageStructure.Start.class, "Village");
        StructureIO.func_143034_b(FortressStructure.Start.class, "Fortress");
        StructureIO.func_143034_b(StrongholdStructure.Start.class, "Stronghold");
        StructureIO.func_143034_b(JunglePyramidStructure.Start.class, "Jungle_Pyramid");
        StructureIO.func_143034_b(OceanRuinStructure.Start.class, "Ocean_Ruin");
        StructureIO.func_143034_b(DesertPyramidStructure.Start.class, "Desert_Pyramid");
        StructureIO.func_143034_b(IglooStructure.Start.class, "Igloo");
        StructureIO.func_143034_b(SwampHutStructure.Start.class, "Swamp_Hut");
        StructureIO.func_143034_b(OceanMonumentStructure.Start.class, "Monument");
        StructureIO.func_143034_b(EndCityStructure.Start.class, "EndCity");
        StructureIO.func_143034_b(WoodlandMansionStructure.Start.class, "Mansion");
        StructureIO.func_143034_b(BuriedTreasureStructure.Start.class, "Buried_Treasure");
        StructureIO.func_143034_b(ShipwreckStructure.Start.class, "Shipwreck");
        MineshaftPieces.func_143048_a();
        VillagePieces.func_143016_a();
        FortressPieces.func_143049_a();
        StrongholdPieces.func_143046_a();
        JunglePyramidPiece.func_202585_af_();
        OceanRuinPieces.func_204046_a();
        IglooPieces.func_202591_ae_();
        SwampHutPiece.func_202595_b();
        DesertPyramidPiece.func_202597_ad_();
        OceanMonumentPieces.func_175970_a();
        EndCityPieces.func_186200_a();
        WoodlandMansionPieces.func_191153_a();
        BuriedTreasurePieces.func_204296_a();
        ShipwreckPieces.func_204759_a();
    }
}

