/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockButton;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockEndPortalFrame;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockPane;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorchWall;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class StrongholdPieces {
    private static final PieceWeight[] field_75205_b = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(Prison.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StairsStraight.class, 5, 5), new PieceWeight(Stairs.class, 5, 5), new PieceWeight(Crossing.class, 5, 4), new PieceWeight(ChestCorridor.class, 5, 4), new PieceWeight(Library.class, 10, 2){

        @Override
        public boolean func_75189_a(int n) {
            return super.func_75189_a(n) && n > 4;
        }
    }, new PieceWeight(PortalRoom.class, 20, 1){

        @Override
        public boolean func_75189_a(int n) {
            return super.func_75189_a(n) && n > 5;
        }
    }};
    private static List<PieceWeight> field_75206_c;
    private static Class<? extends Stronghold> field_75203_d;
    private static int field_75207_a;
    private static final Stones field_75204_e;

    public static void func_143046_a() {
        StructureIO.func_143031_a(ChestCorridor.class, "SHCC");
        StructureIO.func_143031_a(Corridor.class, "SHFC");
        StructureIO.func_143031_a(Crossing.class, "SH5C");
        StructureIO.func_143031_a(LeftTurn.class, "SHLT");
        StructureIO.func_143031_a(Library.class, "SHLi");
        StructureIO.func_143031_a(PortalRoom.class, "SHPR");
        StructureIO.func_143031_a(Prison.class, "SHPH");
        StructureIO.func_143031_a(RightTurn.class, "SHRT");
        StructureIO.func_143031_a(RoomCrossing.class, "SHRC");
        StructureIO.func_143031_a(Stairs.class, "SHSD");
        StructureIO.func_143031_a(Stairs2.class, "SHStart");
        StructureIO.func_143031_a(Straight.class, "SHS");
        StructureIO.func_143031_a(StairsStraight.class, "SHSSD");
    }

    public static void func_75198_a() {
        field_75206_c = Lists.newArrayList();
        for (PieceWeight pieceWeight : field_75205_b) {
            pieceWeight.field_75193_c = 0;
            field_75206_c.add(pieceWeight);
        }
        field_75203_d = null;
    }

    private static boolean func_75202_c() {
        boolean bl = false;
        field_75207_a = 0;
        for (PieceWeight pieceWeight2 : field_75206_c) {
            PieceWeight pieceWeight2;
            if (pieceWeight2.field_75191_d > 0 && pieceWeight2.field_75193_c < pieceWeight2.field_75191_d) {
                bl = true;
            }
            field_75207_a += pieceWeight2.field_75192_b;
        }
        return bl;
    }

    private static Stronghold func_175954_a(Class<? extends Stronghold> clazz, List<StructurePiece> list, Random random, int n, int n2, int n3, @Nullable EnumFacing enumFacing, int n4) {
        Stronghold stronghold = null;
        if (clazz == Straight.class) {
            stronghold = Straight.func_175862_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Prison.class) {
            stronghold = Prison.func_175860_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == LeftTurn.class) {
            stronghold = LeftTurn.func_175867_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == RightTurn.class) {
            stronghold = RightTurn.func_175867_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == RoomCrossing.class) {
            stronghold = RoomCrossing.func_175859_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == StairsStraight.class) {
            stronghold = StairsStraight.func_175861_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Stairs.class) {
            stronghold = Stairs.func_175863_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Crossing.class) {
            stronghold = Crossing.func_175866_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == ChestCorridor.class) {
            stronghold = ChestCorridor.func_175868_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Library.class) {
            stronghold = Library.func_175864_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == PortalRoom.class) {
            stronghold = PortalRoom.func_175865_a(list, random, n, n2, n3, enumFacing, n4);
        }
        return stronghold;
    }

    private static Stronghold func_175955_b(Stairs2 stairs2, List<StructurePiece> list2, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
        List<StructurePiece> list2;
        if (!StrongholdPieces.func_75202_c()) {
            return null;
        }
        if (field_75203_d != null) {
            Stronghold stronghold = StrongholdPieces.func_175954_a(field_75203_d, list2, random, n, n2, n3, enumFacing, n4);
            field_75203_d = null;
            if (stronghold != null) {
                return stronghold;
            }
        }
        int n5 = 0;
        block0: while (n5 < 5) {
            ++n5;
            \u2603 = random.nextInt(field_75207_a);
            for (PieceWeight pieceWeight : field_75206_c) {
                if ((\u2603 -= pieceWeight.field_75192_b) >= 0) continue;
                if (!pieceWeight.func_75189_a(n4) || pieceWeight == stairs2.field_75027_a) continue block0;
                Stronghold stronghold = StrongholdPieces.func_175954_a(pieceWeight.field_75194_a, list2, random, n, n2, n3, enumFacing, n4);
                if (stronghold == null) continue;
                ++pieceWeight.field_75193_c;
                stairs2.field_75027_a = pieceWeight;
                if (!pieceWeight.func_75190_a()) {
                    field_75206_c.remove(pieceWeight);
                }
                return stronghold;
            }
        }
        MutableBoundingBox \u26032 = Corridor.func_175869_a(list2, random, n, n2, n3, enumFacing);
        if (\u26032 != null && \u26032.field_78895_b > 1) {
            return new Corridor(n4, random, \u26032, enumFacing);
        }
        return null;
    }

    private static StructurePiece func_175953_c(Stairs2 stairs2, List<StructurePiece> list, Random random, int n, int n2, int n3, @Nullable EnumFacing enumFacing, int n4) {
        if (n4 > 50) {
            return null;
        }
        if (Math.abs(n - stairs2.func_74874_b().field_78897_a) > 112 || Math.abs(n3 - stairs2.func_74874_b().field_78896_c) > 112) {
            return null;
        }
        Stronghold stronghold = StrongholdPieces.func_175955_b(stairs2, list, random, n, n2, n3, enumFacing, n4 + 1);
        if (stronghold != null) {
            list.add(stronghold);
            stairs2.field_75026_c.add(stronghold);
        }
        return stronghold;
    }

    static {
        field_75204_e = new Stones();
    }

    static class Stones
    extends StructurePiece.BlockSelector {
        private Stones() {
        }

        @Override
        public void func_75062_a(Random random, int n, int n2, int n3, boolean bl) {
            this.field_151562_a = bl ? ((\u2603 = random.nextFloat()) < 0.2f ? Blocks.field_196700_dk.func_176223_P() : (\u2603 < 0.5f ? Blocks.field_196698_dj.func_176223_P() : (\u2603 < 0.55f ? Blocks.field_196688_de.func_176223_P() : Blocks.field_196696_di.func_176223_P()))) : Blocks.field_201941_jj.func_176223_P();
        }
    }

    public static class PortalRoom
    extends Stronghold {
        private boolean field_75005_a;

        public PortalRoom() {
        }

        public PortalRoom(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Mob", this.field_75005_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_75005_a = nBTTagCompound.func_74767_n("Mob");
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            if (structurePiece != null) {
                ((Stairs2)structurePiece).field_75025_b = this;
            }
        }

        public static PortalRoom func_175865_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -1, 0, 11, 8, 16, enumFacing);
            if (!PortalRoom.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new PortalRoom(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_74882_a(iWorld, mutableBoundingBox, 0, 0, 0, 10, 7, 15, false, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox, Stronghold.Door.GRATES, 4, 1, 0);
            int n = 6;
            this.func_74882_a(iWorld, mutableBoundingBox, 1, n, 1, 1, n, 14, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 9, n, 1, 9, n, 14, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 2, n, 1, 8, n, 2, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 2, n, 14, 8, n, 14, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 1, 1, 1, 2, 1, 4, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 8, 1, 1, 9, 1, 4, false, random, field_75204_e);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 1, 1, 1, 1, 3, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 9, 1, 1, 9, 1, 3, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            this.func_74882_a(iWorld, mutableBoundingBox, 3, 1, 8, 7, 1, 12, false, random, field_75204_e);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 1, 9, 6, 1, 11, Blocks.field_150353_l.func_176223_P(), Blocks.field_150353_l.func_176223_P(), false);
            IBlockState \u26032 = (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196409_a, true)).func_206870_a(BlockPane.field_196413_c, true);
            IBlockState \u26033 = (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196414_y, true)).func_206870_a(BlockPane.field_196411_b, true);
            for (\u2603 = 3; \u2603 < 14; \u2603 += 2) {
                this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, \u2603, 0, 4, \u2603, \u26032, \u26032, false);
                this.func_175804_a(iWorld, mutableBoundingBox, 10, 3, \u2603, 10, 4, \u2603, \u26032, \u26032, false);
            }
            for (\u2603 = 2; \u2603 < 9; \u2603 += 2) {
                this.func_175804_a(iWorld, mutableBoundingBox, \u2603, 3, 15, \u2603, 4, 15, \u26033, \u26033, false);
            }
            IBlockState \u26034 = (IBlockState)Blocks.field_150390_bg.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH);
            this.func_74882_a(iWorld, mutableBoundingBox, 4, 1, 5, 6, 1, 7, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 4, 2, 6, 6, 2, 7, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 4, 3, 7, 6, 3, 7, false, random, field_75204_e);
            for (\u2603 = 4; \u2603 <= 6; ++\u2603) {
                this.func_175811_a(iWorld, \u26034, \u2603, 1, 4, mutableBoundingBox);
                this.func_175811_a(iWorld, \u26034, \u2603, 2, 5, mutableBoundingBox);
                this.func_175811_a(iWorld, \u26034, \u2603, 3, 6, mutableBoundingBox);
            }
            IBlockState \u26035 = (IBlockState)Blocks.field_150378_br.func_176223_P().func_206870_a(BlockEndPortalFrame.field_176508_a, EnumFacing.NORTH);
            IBlockState \u26036 = (IBlockState)Blocks.field_150378_br.func_176223_P().func_206870_a(BlockEndPortalFrame.field_176508_a, EnumFacing.SOUTH);
            IBlockState \u26037 = (IBlockState)Blocks.field_150378_br.func_176223_P().func_206870_a(BlockEndPortalFrame.field_176508_a, EnumFacing.EAST);
            IBlockState \u26038 = (IBlockState)Blocks.field_150378_br.func_176223_P().func_206870_a(BlockEndPortalFrame.field_176508_a, EnumFacing.WEST);
            boolean \u26039 = true;
            boolean[] \u260310 = new boolean[12];
            for (\u2603 = 0; \u2603 < \u260310.length; ++\u2603) {
                \u260310[\u2603] = random.nextFloat() > 0.9f;
                \u26039 &= \u260310[\u2603];
            }
            this.func_175811_a(iWorld, (IBlockState)\u26035.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[0]), 4, 3, 8, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26035.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[1]), 5, 3, 8, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26035.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[2]), 6, 3, 8, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26036.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[3]), 4, 3, 12, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26036.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[4]), 5, 3, 12, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26036.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[5]), 6, 3, 12, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26037.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[6]), 3, 3, 9, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26037.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[7]), 3, 3, 10, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26037.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[8]), 3, 3, 11, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26038.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[9]), 7, 3, 9, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26038.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[10]), 7, 3, 10, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)\u26038.func_206870_a(BlockEndPortalFrame.field_176507_b, \u260310[11]), 7, 3, 11, mutableBoundingBox);
            if (\u26039) {
                IBlockState iBlockState = Blocks.field_150384_bq.func_176223_P();
                this.func_175811_a(iWorld, iBlockState, 4, 3, 9, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 5, 3, 9, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 6, 3, 9, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 4, 3, 10, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 5, 3, 10, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 6, 3, 10, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 4, 3, 11, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 5, 3, 11, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 6, 3, 11, mutableBoundingBox);
            }
            if (!this.field_75005_a) {
                n = this.func_74862_a(3);
                BlockPos \u260311 = new BlockPos(this.func_74865_a(5, 6), n, this.func_74873_b(5, 6));
                if (mutableBoundingBox.func_175898_b(\u260311)) {
                    this.field_75005_a = true;
                    iWorld.func_180501_a(\u260311, Blocks.field_150474_ac.func_176223_P(), 2);
                    TileEntity tileEntity = iWorld.func_175625_s(\u260311);
                    if (tileEntity instanceof TileEntityMobSpawner) {
                        ((TileEntityMobSpawner)tileEntity).func_145881_a().func_200876_a(EntityType.field_200740_af);
                    }
                }
            }
            return true;
        }
    }

    public static class Crossing
    extends Stronghold {
        private boolean field_74996_b;
        private boolean field_74997_c;
        private boolean field_74995_d;
        private boolean field_74999_h;

        public Crossing() {
        }

        public Crossing(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
            this.field_74996_b = random.nextBoolean();
            this.field_74997_c = random.nextBoolean();
            this.field_74995_d = random.nextBoolean();
            this.field_74999_h = random.nextInt(3) > 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("leftLow", this.field_74996_b);
            nBTTagCompound.func_74757_a("leftHigh", this.field_74997_c);
            nBTTagCompound.func_74757_a("rightLow", this.field_74995_d);
            nBTTagCompound.func_74757_a("rightHigh", this.field_74999_h);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74996_b = nBTTagCompound.func_74767_n("leftLow");
            this.field_74997_c = nBTTagCompound.func_74767_n("leftHigh");
            this.field_74995_d = nBTTagCompound.func_74767_n("rightLow");
            this.field_74999_h = nBTTagCompound.func_74767_n("rightHigh");
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            int n = 3;
            \u2603 = 5;
            EnumFacing \u26032 = this.func_186165_e();
            if (\u26032 == EnumFacing.WEST || \u26032 == EnumFacing.NORTH) {
                n = 8 - n;
                \u2603 = 8 - \u2603;
            }
            this.func_74986_a((Stairs2)structurePiece, list, random, 5, 1);
            if (this.field_74996_b) {
                this.func_74989_b((Stairs2)structurePiece, list, random, n, 1);
            }
            if (this.field_74997_c) {
                this.func_74989_b((Stairs2)structurePiece, list, random, \u2603, 7);
            }
            if (this.field_74995_d) {
                this.func_74987_c((Stairs2)structurePiece, list, random, n, 1);
            }
            if (this.field_74999_h) {
                this.func_74987_c((Stairs2)structurePiece, list, random, \u2603, 7);
            }
        }

        public static Crossing func_175866_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -3, 0, 10, 9, 11, enumFacing);
            if (!Crossing.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Crossing(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_74882_a(iWorld, mutableBoundingBox, 0, 0, 0, 9, 8, 10, true, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox, this.field_143013_d, 4, 3, 0);
            if (this.field_74996_b) {
                this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 1, 0, 5, 3, field_202556_l, field_202556_l, false);
            }
            if (this.field_74995_d) {
                this.func_175804_a(iWorld, mutableBoundingBox, 9, 3, 1, 9, 5, 3, field_202556_l, field_202556_l, false);
            }
            if (this.field_74997_c) {
                this.func_175804_a(iWorld, mutableBoundingBox, 0, 5, 7, 0, 7, 9, field_202556_l, field_202556_l, false);
            }
            if (this.field_74999_h) {
                this.func_175804_a(iWorld, mutableBoundingBox, 9, 5, 7, 9, 7, 9, field_202556_l, field_202556_l, false);
            }
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 1, 10, 7, 3, 10, field_202556_l, field_202556_l, false);
            this.func_74882_a(iWorld, mutableBoundingBox, 1, 2, 1, 8, 2, 6, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 4, 1, 5, 4, 4, 9, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 8, 1, 5, 8, 4, 9, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 1, 4, 7, 3, 4, 9, false, random, field_75204_e);
            this.func_74882_a(iWorld, mutableBoundingBox, 1, 3, 5, 3, 3, 6, false, random, field_75204_e);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 3, 4, 3, 3, 4, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 4, 6, 3, 4, 6, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_74882_a(iWorld, mutableBoundingBox, 5, 1, 7, 7, 1, 8, false, random, field_75204_e);
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 1, 9, 7, 1, 9, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 2, 7, 7, 2, 7, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 5, 7, 4, 5, 9, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 8, 5, 7, 8, 5, 9, Blocks.field_150333_U.func_176223_P(), Blocks.field_150333_U.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 5, 7, 7, 5, 9, (IBlockState)Blocks.field_150333_U.func_176223_P().func_206870_a(BlockSlab.field_196505_a, SlabType.DOUBLE), (IBlockState)Blocks.field_150333_U.func_176223_P().func_206870_a(BlockSlab.field_196505_a, SlabType.DOUBLE), false);
            this.func_175811_a(iWorld, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.SOUTH), 6, 5, 6, mutableBoundingBox);
            return true;
        }
    }

    public static class Library
    extends Stronghold {
        private boolean field_75008_c;

        public Library() {
        }

        public Library(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
            this.field_75008_c = mutableBoundingBox.func_78882_c() > 6;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Tall", this.field_75008_c);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_75008_c = nBTTagCompound.func_74767_n("Tall");
        }

        public static Library func_175864_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -1, 0, 14, 11, 15, enumFacing);
            if (!(Library.func_74991_a(mutableBoundingBox) && StructurePiece.func_74883_a(list, mutableBoundingBox) == null || Library.func_74991_a(mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -1, 0, 14, 6, 15, enumFacing)) && StructurePiece.func_74883_a(list, mutableBoundingBox) == null)) {
                return null;
            }
            return new Library(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            int n = 11;
            if (!this.field_75008_c) {
                n = 6;
            }
            this.func_74882_a(iWorld, mutableBoundingBox, 0, 0, 0, 13, n - 1, 14, true, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox, this.field_143013_d, 4, 1, 0);
            this.func_189914_a(iWorld, mutableBoundingBox, random, 0.07f, 2, 1, 1, 11, 4, 13, Blocks.field_196553_aF.func_176223_P(), Blocks.field_196553_aF.func_176223_P(), false, false);
            boolean \u26032 = true;
            \u2603 = 12;
            for (\u2603 = 1; \u2603 <= 13; ++\u2603) {
                if ((\u2603 - 1) % 4 == 0) {
                    this.func_175804_a(iWorld, mutableBoundingBox, 1, 1, \u2603, 1, 4, \u2603, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                    this.func_175804_a(iWorld, mutableBoundingBox, 12, 1, \u2603, 12, 4, \u2603, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.EAST), 2, 3, \u2603, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.WEST), 11, 3, \u2603, mutableBoundingBox);
                    if (!this.field_75008_c) continue;
                    this.func_175804_a(iWorld, mutableBoundingBox, 1, 6, \u2603, 1, 9, \u2603, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                    this.func_175804_a(iWorld, mutableBoundingBox, 12, 6, \u2603, 12, 9, \u2603, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                    continue;
                }
                this.func_175804_a(iWorld, mutableBoundingBox, 1, 1, \u2603, 1, 4, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 12, 1, \u2603, 12, 4, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                if (!this.field_75008_c) continue;
                this.func_175804_a(iWorld, mutableBoundingBox, 1, 6, \u2603, 1, 9, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 12, 6, \u2603, 12, 9, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            for (\u2603 = 3; \u2603 < 12; \u2603 += 2) {
                this.func_175804_a(iWorld, mutableBoundingBox, 3, 1, \u2603, 4, 3, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 6, 1, \u2603, 7, 3, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 9, 1, \u2603, 10, 3, \u2603, Blocks.field_150342_X.func_176223_P(), Blocks.field_150342_X.func_176223_P(), false);
            }
            if (this.field_75008_c) {
                this.func_175804_a(iWorld, mutableBoundingBox, 1, 5, 1, 3, 5, 13, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 10, 5, 1, 12, 5, 13, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 4, 5, 1, 9, 5, 2, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 4, 5, 12, 9, 5, 13, Blocks.field_196662_n.func_176223_P(), Blocks.field_196662_n.func_176223_P(), false);
                this.func_175811_a(iWorld, Blocks.field_196662_n.func_176223_P(), 9, 5, 11, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196662_n.func_176223_P(), 8, 5, 11, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196662_n.func_176223_P(), 9, 5, 10, mutableBoundingBox);
                IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
                \u2603 = (IBlockState)((IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
                this.func_175804_a(iWorld, mutableBoundingBox, 3, 6, 3, 3, 6, 11, \u2603, \u2603, false);
                this.func_175804_a(iWorld, mutableBoundingBox, 10, 6, 3, 10, 6, 9, \u2603, \u2603, false);
                this.func_175804_a(iWorld, mutableBoundingBox, 4, 6, 2, 9, 6, 2, iBlockState, iBlockState, false);
                this.func_175804_a(iWorld, mutableBoundingBox, 4, 6, 12, 7, 6, 12, iBlockState, iBlockState, false);
                this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196411_b, true), 3, 6, 2, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196413_c, true)).func_206870_a(BlockFence.field_196411_b, true), 3, 6, 12, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196414_y, true), 10, 6, 2, mutableBoundingBox);
                for (int i = 0; i <= 2; ++i) {
                    this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196413_c, true)).func_206870_a(BlockFence.field_196414_y, true), 8 + i, 6, 12 - i, mutableBoundingBox);
                    if (i == 2) continue;
                    this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196411_b, true), 8 + i, 6, 11 - i, mutableBoundingBox);
                }
                IBlockState iBlockState2 = (IBlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a(BlockLadder.field_176382_a, EnumFacing.SOUTH);
                this.func_175811_a(iWorld, iBlockState2, 10, 1, 13, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState2, 10, 2, 13, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState2, 10, 3, 13, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState2, 10, 4, 13, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState2, 10, 5, 13, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState2, 10, 6, 13, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState2, 10, 7, 13, mutableBoundingBox);
                int \u26033 = 7;
                int \u26034 = 7;
                \u2603 = (IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196411_b, true);
                this.func_175811_a(iWorld, \u2603, 6, 9, 7, mutableBoundingBox);
                \u2603 = (IBlockState)Blocks.field_180407_aO.func_176223_P().func_206870_a(BlockFence.field_196414_y, true);
                this.func_175811_a(iWorld, \u2603, 7, 9, 7, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 6, 8, 7, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 7, 8, 7, mutableBoundingBox);
                \u2603 = (IBlockState)((IBlockState)\u2603.func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
                this.func_175811_a(iWorld, \u2603, 6, 7, 7, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 7, 7, 7, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 5, 7, 7, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 8, 7, 7, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)\u2603.func_206870_a(BlockFence.field_196409_a, true), 6, 7, 6, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)\u2603.func_206870_a(BlockFence.field_196413_c, true), 6, 7, 8, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)\u2603.func_206870_a(BlockFence.field_196409_a, true), 7, 7, 6, mutableBoundingBox);
                this.func_175811_a(iWorld, (IBlockState)\u2603.func_206870_a(BlockFence.field_196413_c, true), 7, 7, 8, mutableBoundingBox);
                \u2603 = Blocks.field_150478_aa.func_176223_P();
                this.func_175811_a(iWorld, \u2603, 5, 8, 7, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 8, 8, 7, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 6, 8, 6, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 6, 8, 8, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 7, 8, 6, mutableBoundingBox);
                this.func_175811_a(iWorld, \u2603, 7, 8, 8, mutableBoundingBox);
            }
            this.func_186167_a(iWorld, mutableBoundingBox, random, 3, 3, 5, LootTableList.field_186426_h);
            if (this.field_75008_c) {
                this.func_175811_a(iWorld, field_202556_l, 12, 9, 1, mutableBoundingBox);
                this.func_186167_a(iWorld, mutableBoundingBox, random, 12, 8, 1, LootTableList.field_186426_h);
            }
            return true;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison() {
        }

        public Prison(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
        }

        public static Prison func_175860_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 9, 5, 11, enumFacing);
            if (!Prison.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Prison(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            this.func_74882_a(iWorld2, mutableBoundingBox, 0, 0, 0, 8, 4, 10, true, random, field_75204_e);
            this.func_74990_a(iWorld2, random, mutableBoundingBox, this.field_143013_d, 1, 1, 0);
            this.func_175804_a(iWorld2, mutableBoundingBox, 1, 1, 10, 3, 3, 10, field_202556_l, field_202556_l, false);
            this.func_74882_a(iWorld2, mutableBoundingBox, 4, 1, 1, 4, 3, 1, false, random, field_75204_e);
            this.func_74882_a(iWorld2, mutableBoundingBox, 4, 1, 3, 4, 3, 3, false, random, field_75204_e);
            this.func_74882_a(iWorld2, mutableBoundingBox, 4, 1, 7, 4, 3, 7, false, random, field_75204_e);
            this.func_74882_a(iWorld2, mutableBoundingBox, 4, 1, 9, 4, 3, 9, false, random, field_75204_e);
            for (int i = 1; i <= 3; ++i) {
                this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196409_a, true)).func_206870_a(BlockPane.field_196413_c, true), 4, i, 4, mutableBoundingBox);
                this.func_175811_a(iWorld2, (IBlockState)((IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196409_a, true)).func_206870_a(BlockPane.field_196413_c, true)).func_206870_a(BlockPane.field_196411_b, true), 4, i, 5, mutableBoundingBox);
                this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196409_a, true)).func_206870_a(BlockPane.field_196413_c, true), 4, i, 6, mutableBoundingBox);
                this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196414_y, true)).func_206870_a(BlockPane.field_196411_b, true), 5, i, 5, mutableBoundingBox);
                this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196414_y, true)).func_206870_a(BlockPane.field_196411_b, true), 6, i, 5, mutableBoundingBox);
                this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196414_y, true)).func_206870_a(BlockPane.field_196411_b, true), 7, i, 5, mutableBoundingBox);
            }
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196409_a, true)).func_206870_a(BlockPane.field_196413_c, true), 4, 3, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196409_a, true)).func_206870_a(BlockPane.field_196413_c, true), 4, 3, 8, mutableBoundingBox);
            IBlockState \u26032 = (IBlockState)Blocks.field_150454_av.func_176223_P().func_206870_a(BlockDoor.field_176520_a, EnumFacing.WEST);
            IBlockState \u26033 = (IBlockState)((IBlockState)Blocks.field_150454_av.func_176223_P().func_206870_a(BlockDoor.field_176520_a, EnumFacing.WEST)).func_206870_a(BlockDoor.field_176523_O, DoubleBlockHalf.UPPER);
            this.func_175811_a(iWorld2, \u26032, 4, 1, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26033, 4, 2, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 4, 1, 8, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26033, 4, 2, 8, mutableBoundingBox);
            return true;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        protected int field_75013_b;

        public RoomCrossing() {
        }

        public RoomCrossing(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
            this.field_75013_b = random.nextInt(5);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74768_a("Type", this.field_75013_b);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_75013_b = nBTTagCompound.func_74762_e("Type");
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 4, 1);
            this.func_74989_b((Stairs2)structurePiece, list, random, 1, 4);
            this.func_74987_c((Stairs2)structurePiece, list, random, 1, 4);
        }

        public static RoomCrossing func_175859_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -4, -1, 0, 11, 7, 11, enumFacing);
            if (!RoomCrossing.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new RoomCrossing(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_74882_a(iWorld2, mutableBoundingBox, 0, 0, 0, 10, 6, 10, true, random, field_75204_e);
            this.func_74990_a(iWorld2, random, mutableBoundingBox, this.field_143013_d, 4, 1, 0);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 1, 10, 6, 3, 10, field_202556_l, field_202556_l, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 1, 4, 0, 3, 6, field_202556_l, field_202556_l, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 10, 1, 4, 10, 3, 6, field_202556_l, field_202556_l, false);
            switch (this.field_75013_b) {
                default: {
                    break;
                }
                case 0: {
                    this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 5, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 5, 2, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 5, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.WEST), 4, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.EAST), 6, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.SOUTH), 5, 3, 4, mutableBoundingBox);
                    this.func_175811_a(iWorld2, (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.NORTH), 5, 3, 6, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150333_U.func_176223_P(), 4, 1, 4, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150333_U.func_176223_P(), 4, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150333_U.func_176223_P(), 4, 1, 6, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150333_U.func_176223_P(), 6, 1, 4, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150333_U.func_176223_P(), 6, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150333_U.func_176223_P(), 6, 1, 6, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150333_U.func_176223_P(), 5, 1, 4, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150333_U.func_176223_P(), 5, 1, 6, mutableBoundingBox);
                    break;
                }
                case 1: {
                    IWorld iWorld2;
                    for (int i = 0; i < 5; ++i) {
                        this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 3, 1, 3 + i, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 7, 1, 3 + i, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 3 + i, 1, 3, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 3 + i, 1, 7, mutableBoundingBox);
                    }
                    this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 5, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 5, 2, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_196696_di.func_176223_P(), 5, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150355_j.func_176223_P(), 5, 4, 5, mutableBoundingBox);
                    break;
                }
                case 2: {
                    int n;
                    IWorld iWorld2;
                    for (n = 1; n <= 9; ++n) {
                        this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 1, 3, n, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 9, 3, n, mutableBoundingBox);
                    }
                    for (n = 1; n <= 9; ++n) {
                        this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), n, 3, 1, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), n, 3, 9, mutableBoundingBox);
                    }
                    this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 5, 1, 4, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 5, 1, 6, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 5, 3, 4, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 5, 3, 6, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 4, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 6, 1, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 4, 3, 5, mutableBoundingBox);
                    this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 6, 3, 5, mutableBoundingBox);
                    for (n = 1; n <= 3; ++n) {
                        this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 4, n, 4, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 6, n, 4, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 4, n, 6, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_150347_e.func_176223_P(), 6, n, 6, mutableBoundingBox);
                    }
                    this.func_175811_a(iWorld2, Blocks.field_150478_aa.func_176223_P(), 5, 3, 5, mutableBoundingBox);
                    for (n = 2; n <= 8; ++n) {
                        this.func_175811_a(iWorld2, Blocks.field_196662_n.func_176223_P(), 2, 3, n, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_196662_n.func_176223_P(), 3, 3, n, mutableBoundingBox);
                        if (n <= 3 || n >= 7) {
                            this.func_175811_a(iWorld2, Blocks.field_196662_n.func_176223_P(), 4, 3, n, mutableBoundingBox);
                            this.func_175811_a(iWorld2, Blocks.field_196662_n.func_176223_P(), 5, 3, n, mutableBoundingBox);
                            this.func_175811_a(iWorld2, Blocks.field_196662_n.func_176223_P(), 6, 3, n, mutableBoundingBox);
                        }
                        this.func_175811_a(iWorld2, Blocks.field_196662_n.func_176223_P(), 7, 3, n, mutableBoundingBox);
                        this.func_175811_a(iWorld2, Blocks.field_196662_n.func_176223_P(), 8, 3, n, mutableBoundingBox);
                    }
                    IBlockState iBlockState = (IBlockState)Blocks.field_150468_ap.func_176223_P().func_206870_a(BlockLadder.field_176382_a, EnumFacing.WEST);
                    this.func_175811_a(iWorld2, iBlockState, 9, 1, 3, mutableBoundingBox);
                    this.func_175811_a(iWorld2, iBlockState, 9, 2, 3, mutableBoundingBox);
                    this.func_175811_a(iWorld2, iBlockState, 9, 3, 3, mutableBoundingBox);
                    this.func_186167_a(iWorld2, mutableBoundingBox, random, 3, 4, 8, LootTableList.field_186427_i);
                }
            }
            return true;
        }
    }

    public static class RightTurn
    extends LeftTurn {
        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing == EnumFacing.NORTH || enumFacing == EnumFacing.EAST) {
                this.func_74987_c((Stairs2)structurePiece, list, random, 1, 1);
            } else {
                this.func_74989_b((Stairs2)structurePiece, list, random, 1, 1);
            }
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_74882_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 4, 4, true, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox, this.field_143013_d, 1, 1, 0);
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing == EnumFacing.NORTH || enumFacing == EnumFacing.EAST) {
                this.func_175804_a(iWorld, mutableBoundingBox, 4, 1, 1, 4, 3, 3, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(iWorld, mutableBoundingBox, 0, 1, 1, 0, 3, 3, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class LeftTurn
    extends Stronghold {
        public LeftTurn() {
        }

        public LeftTurn(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing == EnumFacing.NORTH || enumFacing == EnumFacing.EAST) {
                this.func_74989_b((Stairs2)structurePiece, list, random, 1, 1);
            } else {
                this.func_74987_c((Stairs2)structurePiece, list, random, 1, 1);
            }
        }

        public static LeftTurn func_175867_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 5, enumFacing);
            if (!LeftTurn.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new LeftTurn(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_74882_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 4, 4, true, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox, this.field_143013_d, 1, 1, 0);
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing == EnumFacing.NORTH || enumFacing == EnumFacing.EAST) {
                this.func_175804_a(iWorld, mutableBoundingBox, 0, 1, 1, 0, 3, 3, field_202556_l, field_202556_l, false);
            } else {
                this.func_175804_a(iWorld, mutableBoundingBox, 4, 1, 1, 4, 3, 3, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight() {
        }

        public StairsStraight(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
        }

        public static StairsStraight func_175861_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -7, 0, 5, 11, 8, enumFacing);
            if (!StairsStraight.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new StairsStraight(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_74882_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 10, 7, true, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox, this.field_143013_d, 1, 7, 0);
            this.func_74990_a(iWorld, random, mutableBoundingBox, Stronghold.Door.OPENING, 1, 1, 7);
            IBlockState iBlockState = (IBlockState)Blocks.field_196659_cl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.SOUTH);
            for (int i = 0; i < 6; ++i) {
                this.func_175811_a(iWorld, iBlockState, 1, 6 - i, 1 + i, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 2, 6 - i, 1 + i, mutableBoundingBox);
                this.func_175811_a(iWorld, iBlockState, 3, 6 - i, 1 + i, mutableBoundingBox);
                if (i >= 5) continue;
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 1, 5 - i, 1 + i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 2, 5 - i, 1 + i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 3, 5 - i, 1 + i, mutableBoundingBox);
            }
            return true;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        private boolean field_75002_c;

        public ChestCorridor() {
        }

        public ChestCorridor(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Chest", this.field_75002_c);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_75002_c = nBTTagCompound.func_74767_n("Chest");
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
        }

        public static ChestCorridor func_175868_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 7, enumFacing);
            if (!ChestCorridor.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new ChestCorridor(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox2, ChunkPos chunkPos) {
            MutableBoundingBox mutableBoundingBox2;
            this.func_74882_a(iWorld, mutableBoundingBox2, 0, 0, 0, 4, 4, 6, true, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox2, this.field_143013_d, 1, 1, 0);
            this.func_74990_a(iWorld, random, mutableBoundingBox2, Stronghold.Door.OPENING, 1, 1, 6);
            this.func_175804_a(iWorld, mutableBoundingBox2, 3, 1, 2, 3, 1, 4, Blocks.field_196696_di.func_176223_P(), Blocks.field_196696_di.func_176223_P(), false);
            this.func_175811_a(iWorld, Blocks.field_196573_bB.func_176223_P(), 3, 1, 1, mutableBoundingBox2);
            this.func_175811_a(iWorld, Blocks.field_196573_bB.func_176223_P(), 3, 1, 5, mutableBoundingBox2);
            this.func_175811_a(iWorld, Blocks.field_196573_bB.func_176223_P(), 3, 2, 2, mutableBoundingBox2);
            this.func_175811_a(iWorld, Blocks.field_196573_bB.func_176223_P(), 3, 2, 4, mutableBoundingBox2);
            for (int i = 2; i <= 4; ++i) {
                this.func_175811_a(iWorld, Blocks.field_196573_bB.func_176223_P(), 2, 1, i, mutableBoundingBox2);
            }
            if (!this.field_75002_c && mutableBoundingBox2.func_175898_b(new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3)))) {
                this.field_75002_c = true;
                this.func_186167_a(iWorld, mutableBoundingBox2, random, 3, 2, 3, LootTableList.field_186428_j);
            }
            return true;
        }
    }

    public static class Straight
    extends Stronghold {
        private boolean field_75019_b;
        private boolean field_75020_c;

        public Straight() {
        }

        public Straight(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
            this.field_75019_b = random.nextInt(2) == 0;
            this.field_75020_c = random.nextInt(2) == 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Left", this.field_75019_b);
            nBTTagCompound.func_74757_a("Right", this.field_75020_c);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_75019_b = nBTTagCompound.func_74767_n("Left");
            this.field_75020_c = nBTTagCompound.func_74767_n("Right");
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
            if (this.field_75019_b) {
                this.func_74989_b((Stairs2)structurePiece, list, random, 1, 2);
            }
            if (this.field_75020_c) {
                this.func_74987_c((Stairs2)structurePiece, list, random, 1, 2);
            }
        }

        public static Straight func_175862_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 7, enumFacing);
            if (!Straight.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Straight(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_74882_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 4, 6, true, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox, this.field_143013_d, 1, 1, 0);
            this.func_74990_a(iWorld, random, mutableBoundingBox, Stronghold.Door.OPENING, 1, 1, 6);
            IBlockState iBlockState = (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.EAST);
            \u2603 = (IBlockState)Blocks.field_196591_bQ.func_176223_P().func_206870_a(BlockTorchWall.field_196532_a, EnumFacing.WEST);
            this.func_175809_a(iWorld, mutableBoundingBox, random, 0.1f, 1, 2, 1, iBlockState);
            this.func_175809_a(iWorld, mutableBoundingBox, random, 0.1f, 3, 2, 1, \u2603);
            this.func_175809_a(iWorld, mutableBoundingBox, random, 0.1f, 1, 2, 5, iBlockState);
            this.func_175809_a(iWorld, mutableBoundingBox, random, 0.1f, 3, 2, 5, \u2603);
            if (this.field_75019_b) {
                this.func_175804_a(iWorld, mutableBoundingBox, 0, 1, 2, 0, 3, 4, field_202556_l, field_202556_l, false);
            }
            if (this.field_75020_c) {
                this.func_175804_a(iWorld, mutableBoundingBox, 4, 1, 2, 4, 3, 4, field_202556_l, field_202556_l, false);
            }
            return true;
        }
    }

    public static class Stairs2
    extends Stairs {
        public PieceWeight field_75027_a;
        public PortalRoom field_75025_b;
        public List<StructurePiece> field_75026_c = Lists.newArrayList();

        public Stairs2() {
        }

        public Stairs2(int n, Random random, int n2, int n3) {
            super(0, random, n2, n3);
        }
    }

    public static class Stairs
    extends Stronghold {
        private boolean field_75024_a;

        public Stairs() {
        }

        public Stairs(int n, Random random, int n2, int n3) {
            super(n);
            this.field_75024_a = true;
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            this.field_143013_d = Stronghold.Door.OPENING;
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new MutableBoundingBox(n2, 64, n3, n2 + 5 - 1, 74, n3 + 5 - 1) : new MutableBoundingBox(n2, 64, n3, n2 + 5 - 1, 74, n3 + 5 - 1);
        }

        public Stairs(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.field_75024_a = false;
            this.func_186164_a(enumFacing);
            this.field_143013_d = this.func_74988_a(random);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Source", this.field_75024_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_75024_a = nBTTagCompound.func_74767_n("Source");
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            if (this.field_75024_a) {
                field_75203_d = Crossing.class;
            }
            this.func_74986_a((Stairs2)structurePiece, list, random, 1, 1);
        }

        public static Stairs func_175863_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -7, 0, 5, 11, 5, enumFacing);
            if (!Stairs.func_74991_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Stairs(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_74882_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 10, 4, true, random, field_75204_e);
            this.func_74990_a(iWorld, random, mutableBoundingBox, this.field_143013_d, 1, 7, 0);
            this.func_74990_a(iWorld, random, mutableBoundingBox, Stronghold.Door.OPENING, 1, 1, 4);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 2, 6, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 1, 5, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150333_U.func_176223_P(), 1, 6, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 1, 5, 2, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 1, 4, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150333_U.func_176223_P(), 1, 5, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 2, 4, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 3, 3, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150333_U.func_176223_P(), 3, 4, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 3, 3, 2, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 3, 2, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150333_U.func_176223_P(), 3, 3, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 2, 2, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 1, 1, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150333_U.func_176223_P(), 1, 2, 1, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 1, 1, 2, mutableBoundingBox);
            this.func_175811_a(iWorld, Blocks.field_150333_U.func_176223_P(), 1, 1, 3, mutableBoundingBox);
            return true;
        }
    }

    public static class Corridor
    extends Stronghold {
        private int field_74993_a;

        public Corridor() {
        }

        public Corridor(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_74993_a = enumFacing == EnumFacing.NORTH || enumFacing == EnumFacing.SOUTH ? mutableBoundingBox.func_78880_d() : mutableBoundingBox.func_78883_b();
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74768_a("Steps", this.field_74993_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74993_a = nBTTagCompound.func_74762_e("Steps");
        }

        public static MutableBoundingBox func_175869_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing) {
            int n4 = 3;
            MutableBoundingBox \u26032 = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, 4, enumFacing);
            StructurePiece \u26033 = StructurePiece.func_74883_a(list, \u26032);
            if (\u26033 == null) {
                return null;
            }
            if (\u26033.func_74874_b().field_78895_b == \u26032.field_78895_b) {
                for (\u2603 = 3; \u2603 >= 1; --\u2603) {
                    \u26032 = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, \u2603 - 1, enumFacing);
                    if (\u26033.func_74874_b().func_78884_a(\u26032)) continue;
                    return MutableBoundingBox.func_175897_a(n, n2, n3, -1, -1, 0, 5, 5, \u2603, enumFacing);
                }
            }
            return null;
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            for (int i = 0; i < this.field_74993_a; ++i) {
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 0, 0, i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 1, 0, i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 2, 0, i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 3, 0, i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 4, 0, i, mutableBoundingBox);
                for (\u2603 = 1; \u2603 <= 3; ++\u2603) {
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 0, \u2603, i, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_201941_jj.func_176223_P(), 1, \u2603, i, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_201941_jj.func_176223_P(), 2, \u2603, i, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_201941_jj.func_176223_P(), 3, \u2603, i, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 4, \u2603, i, mutableBoundingBox);
                }
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 0, 4, i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 1, 4, i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 2, 4, i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 3, 4, i, mutableBoundingBox);
                this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), 4, 4, i, mutableBoundingBox);
            }
            return true;
        }
    }

    static abstract class Stronghold
    extends StructurePiece {
        protected Door field_143013_d = Door.OPENING;

        public Stronghold() {
        }

        protected Stronghold(int n) {
            super(n);
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            nBTTagCompound.func_74778_a("EntryDoor", this.field_143013_d.name());
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            this.field_143013_d = Door.valueOf(nBTTagCompound.func_74779_i("EntryDoor"));
        }

        protected void func_74990_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, Door door, int n, int n2, int n3) {
            switch (door) {
                case OPENING: {
                    this.func_175804_a(iWorld, mutableBoundingBox, n, n2, n3, n + 3 - 1, n2 + 3 - 1, n3, field_202556_l, field_202556_l, false);
                    break;
                }
                case WOOD_DOOR: {
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n + 1, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n + 2, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n + 2, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n + 2, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_180413_ao.func_176223_P(), n + 1, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_180413_ao.func_176223_P().func_206870_a(BlockDoor.field_176523_O, DoubleBlockHalf.UPPER), n + 1, n2 + 1, n3, mutableBoundingBox);
                    break;
                }
                case GRATES: {
                    this.func_175811_a(iWorld, Blocks.field_201941_jj.func_176223_P(), n + 1, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_201941_jj.func_176223_P(), n + 1, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196414_y, true), n, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196414_y, true), n, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196411_b, true)).func_206870_a(BlockPane.field_196414_y, true), n, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196411_b, true)).func_206870_a(BlockPane.field_196414_y, true), n + 1, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196411_b, true)).func_206870_a(BlockPane.field_196414_y, true), n + 2, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196411_b, true), n + 2, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a(BlockPane.field_196411_b, true), n + 2, n2, n3, mutableBoundingBox);
                    break;
                }
                case IRON_DOOR: {
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n + 1, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n + 2, n2 + 2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n + 2, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_196696_di.func_176223_P(), n + 2, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, Blocks.field_150454_av.func_176223_P(), n + 1, n2, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_150454_av.func_176223_P().func_206870_a(BlockDoor.field_176523_O, DoubleBlockHalf.UPPER), n + 1, n2 + 1, n3, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_150430_aB.func_176223_P().func_206870_a(BlockButton.field_185512_D, EnumFacing.NORTH), n + 2, n2 + 1, n3 + 1, mutableBoundingBox);
                    this.func_175811_a(iWorld, (IBlockState)Blocks.field_150430_aB.func_176223_P().func_206870_a(BlockButton.field_185512_D, EnumFacing.SOUTH), n + 2, n2 + 1, n3 - 1, mutableBoundingBox);
                }
            }
        }

        protected Door func_74988_a(Random random) {
            int n = random.nextInt(5);
            switch (n) {
                default: {
                    return Door.OPENING;
                }
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: 
            }
            return Door.IRON_DOOR;
        }

        @Nullable
        protected StructurePiece func_74986_a(Stairs2 stairs2, List<StructurePiece> list, Random random, int n, int n2) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing != null) {
                switch (enumFacing) {
                    case NORTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c - 1, enumFacing, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78892_f + 1, enumFacing, this.func_74877_c());
                    }
                    case WEST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c + n, enumFacing, this.func_74877_c());
                    }
                    case EAST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c + n, enumFacing, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece func_74989_b(Stairs2 stairs2, List<StructurePiece> list, Random random, int n, int n2) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing != null) {
                switch (enumFacing) {
                    case NORTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.WEST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.WEST, this.func_74877_c());
                    }
                    case WEST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece func_74987_c(Stairs2 stairs2, List<StructurePiece> list, Random random, int n, int n2) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing != null) {
                switch (enumFacing) {
                    case NORTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.EAST, this.func_74877_c());
                    }
                    case SOUTH: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.EAST, this.func_74877_c());
                    }
                    case WEST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                    case EAST: {
                        return StrongholdPieces.func_175953_c(stairs2, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c());
                    }
                }
            }
            return null;
        }

        protected static boolean func_74991_a(MutableBoundingBox mutableBoundingBox) {
            return mutableBoundingBox != null && mutableBoundingBox.field_78895_b > 10;
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    static class PieceWeight {
        public Class<? extends Stronghold> field_75194_a;
        public final int field_75192_b;
        public int field_75193_c;
        public int field_75191_d;

        public PieceWeight(Class<? extends Stronghold> clazz, int n, int n2) {
            this.field_75194_a = clazz;
            this.field_75192_b = n;
            this.field_75191_d = n2;
        }

        public boolean func_75189_a(int n) {
            return this.field_75191_d == 0 || this.field_75193_c < this.field_75191_d;
        }

        public boolean func_75190_a() {
            return this.field_75191_d == 0 || this.field_75193_c < this.field_75191_d;
        }
    }
}

