/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockFence;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.feature.structure.StructureIO;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.storage.loot.LootTableList;

public class FortressPieces {
    private static final PieceWeight[] field_78742_a = new PieceWeight[]{new PieceWeight(Straight.class, 30, 0, true), new PieceWeight(Crossing3.class, 10, 4), new PieceWeight(Crossing.class, 10, 4), new PieceWeight(Stairs.class, 10, 3), new PieceWeight(Throne.class, 5, 2), new PieceWeight(Entrance.class, 5, 1)};
    private static final PieceWeight[] field_78741_b = new PieceWeight[]{new PieceWeight(Corridor5.class, 25, 0, true), new PieceWeight(Crossing2.class, 15, 5), new PieceWeight(Corridor2.class, 5, 10), new PieceWeight(Corridor.class, 5, 10), new PieceWeight(Corridor3.class, 10, 3, true), new PieceWeight(Corridor4.class, 7, 2), new PieceWeight(NetherStalkRoom.class, 5, 2)};

    public static void func_143049_a() {
        StructureIO.func_143031_a(Crossing3.class, "NeBCr");
        StructureIO.func_143031_a(End.class, "NeBEF");
        StructureIO.func_143031_a(Straight.class, "NeBS");
        StructureIO.func_143031_a(Corridor3.class, "NeCCS");
        StructureIO.func_143031_a(Corridor4.class, "NeCTB");
        StructureIO.func_143031_a(Entrance.class, "NeCE");
        StructureIO.func_143031_a(Crossing2.class, "NeSCSC");
        StructureIO.func_143031_a(Corridor.class, "NeSCLT");
        StructureIO.func_143031_a(Corridor5.class, "NeSC");
        StructureIO.func_143031_a(Corridor2.class, "NeSCRT");
        StructureIO.func_143031_a(NetherStalkRoom.class, "NeCSR");
        StructureIO.func_143031_a(Throne.class, "NeMT");
        StructureIO.func_143031_a(Crossing.class, "NeRC");
        StructureIO.func_143031_a(Stairs.class, "NeSR");
        StructureIO.func_143031_a(Start.class, "NeStart");
    }

    private static Piece func_175887_b(PieceWeight pieceWeight, List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
        Class<? extends Piece> clazz = pieceWeight.field_78828_a;
        Piece \u26032 = null;
        if (clazz == Straight.class) {
            \u26032 = Straight.func_175882_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Crossing3.class) {
            \u26032 = Crossing3.func_175885_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Crossing.class) {
            \u26032 = Crossing.func_175873_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Stairs.class) {
            \u26032 = Stairs.func_175872_a(list, random, n, n2, n3, n4, enumFacing);
        } else if (clazz == Throne.class) {
            \u26032 = Throne.func_175874_a(list, random, n, n2, n3, n4, enumFacing);
        } else if (clazz == Entrance.class) {
            \u26032 = Entrance.func_175881_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Corridor5.class) {
            \u26032 = Corridor5.func_175877_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Corridor2.class) {
            \u26032 = Corridor2.func_175876_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Corridor.class) {
            \u26032 = Corridor.func_175879_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Corridor3.class) {
            \u26032 = Corridor3.func_175883_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Corridor4.class) {
            \u26032 = Corridor4.func_175880_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == Crossing2.class) {
            \u26032 = Crossing2.func_175878_a(list, random, n, n2, n3, enumFacing, n4);
        } else if (clazz == NetherStalkRoom.class) {
            \u26032 = NetherStalkRoom.func_175875_a(list, random, n, n2, n3, enumFacing, n4);
        }
        return \u26032;
    }

    public static class Corridor4
    extends Piece {
        public Corridor4() {
        }

        public Corridor4(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            int n = 1;
            EnumFacing \u26032 = this.func_186165_e();
            if (\u26032 == EnumFacing.WEST || \u26032 == EnumFacing.NORTH) {
                n = 5;
            }
            this.func_74961_b((Start)structurePiece, list, random, 0, n, random.nextInt(8) > 0);
            this.func_74965_c((Start)structurePiece, list, random, 0, n, random.nextInt(8) > 0);
        }

        public static Corridor4 func_175880_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -3, 0, 0, 9, 7, 9, enumFacing);
            if (!Corridor4.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Corridor4(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 8, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 8, 5, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 6, 0, 8, 6, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 2, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 2, 0, 8, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 3, 0, 1, 4, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 7, 3, 0, 7, 4, 0, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 4, 8, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 1, 4, 2, 2, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 1, 4, 7, 2, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 3, 8, 7, 3, 8, \u2603, \u2603, false);
            this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196411_b, true)).func_206870_a(BlockFence.field_196413_c, true), 0, 3, 8, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196413_c, true), 8, 3, 8, mutableBoundingBox);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 6, 0, 3, 7, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 8, 3, 6, 8, 3, 7, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 4, 0, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 8, 3, 4, 8, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 3, 5, 2, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 3, 5, 7, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 4, 5, 1, 5, 5, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 7, 4, 5, 7, 5, 5, \u2603, \u2603, false);
            for (int i = 0; i <= 5; ++i) {
                for (\u2603 = 0; \u2603 <= 8; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), \u2603, -1, i, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Corridor3
    extends Piece {
        public Corridor3() {
        }

        public Corridor3(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74963_a((Start)structurePiece, list, random, 1, 0, true);
        }

        public static Corridor3 func_175883_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -7, 0, 5, 14, 10, enumFacing);
            if (!Corridor3.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Corridor3(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IBlockState iBlockState = (IBlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.SOUTH);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            for (int i = 0; i <= 9; ++i) {
                \u2603 = Math.max(1, 7 - i);
                \u2603 = Math.min(Math.max(\u2603 + 5, 14 - i), 13);
                \u2603 = i;
                this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, \u2603, 4, \u2603, \u2603, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 1, \u2603 + 1, \u2603, 3, \u2603 - 1, \u2603, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                if (i <= 6) {
                    this.func_175811_a(iWorld, iBlockState, 1, \u2603 + 1, \u2603, mutableBoundingBox);
                    this.func_175811_a(iWorld, iBlockState, 2, \u2603 + 1, \u2603, mutableBoundingBox);
                    this.func_175811_a(iWorld, iBlockState, 3, \u2603 + 1, \u2603, mutableBoundingBox);
                }
                this.func_175804_a(iWorld, mutableBoundingBox, 0, \u2603, \u2603, 4, \u2603, \u2603, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 0, \u2603 + 1, \u2603, 0, \u2603 - 1, \u2603, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
                this.func_175804_a(iWorld, mutableBoundingBox, 4, \u2603 + 1, \u2603, 4, \u2603 - 1, \u2603, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
                if ((i & 1) == 0) {
                    this.func_175804_a(iWorld, mutableBoundingBox, 0, \u2603 + 2, \u2603, 0, \u2603 + 3, \u2603, \u2603, \u2603, false);
                    this.func_175804_a(iWorld, mutableBoundingBox, 4, \u2603 + 2, \u2603, 4, \u2603 + 3, \u2603, \u2603, \u2603, false);
                }
                for (\u2603 = 0; \u2603 <= 4; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), \u2603, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Corridor
    extends Piece {
        private boolean field_111021_b;

        public Corridor() {
        }

        public Corridor(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_111021_b = random.nextInt(3) == 0;
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_111021_b = nBTTagCompound.func_74767_n("Chest");
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Chest", this.field_111021_b);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74961_b((Start)structurePiece, list, random, 0, 1, true);
        }

        public static Corridor func_175879_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, 0, 0, 5, 7, 5, enumFacing);
            if (!Corridor.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Corridor(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 2, 0, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 3, 1, 4, 4, 1, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 3, 3, 4, 4, 3, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 0, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 4, 3, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 3, 4, 1, 4, 4, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 3, 3, 4, 3, 4, 4, iBlockState, iBlockState, false);
            if (this.field_111021_b && mutableBoundingBox.func_175898_b(new BlockPos(this.func_74865_a(3, 3), this.func_74862_a(2), this.func_74873_b(3, 3)))) {
                this.field_111021_b = false;
                this.func_186167_a(iWorld, mutableBoundingBox, random, 3, 2, 3, LootTableList.field_186425_g);
            }
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u2603 = 0; \u2603 <= 4; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Corridor2
    extends Piece {
        private boolean field_111020_b;

        public Corridor2() {
        }

        public Corridor2(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_111020_b = random.nextInt(3) == 0;
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_111020_b = nBTTagCompound.func_74767_n("Chest");
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Chest", this.field_111020_b);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74965_c((Start)structurePiece, list, random, 0, 1, true);
        }

        public static Corridor2 func_175876_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, 0, 0, 5, 7, 5, enumFacing);
            if (!Corridor2.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Corridor2(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 1, 0, 4, 1, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 3, 0, 4, 3, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 2, 0, 4, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 2, 4, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 3, 4, 1, 4, 4, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 3, 3, 4, 3, 4, 4, iBlockState, iBlockState, false);
            if (this.field_111020_b && mutableBoundingBox.func_175898_b(new BlockPos(this.func_74865_a(1, 3), this.func_74862_a(2), this.func_74873_b(1, 3)))) {
                this.field_111020_b = false;
                this.func_186167_a(iWorld, mutableBoundingBox, random, 1, 2, 3, LootTableList.field_186425_g);
            }
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u2603 = 0; \u2603 <= 4; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Crossing2
    extends Piece {
        public Crossing2() {
        }

        public Crossing2(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74963_a((Start)structurePiece, list, random, 1, 0, true);
            this.func_74961_b((Start)structurePiece, list, random, 0, 1, true);
            this.func_74965_c((Start)structurePiece, list, random, 0, 1, true);
        }

        public static Crossing2 func_175878_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, 0, 0, 5, 7, 5, enumFacing);
            if (!Crossing2.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Crossing2(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 0, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 2, 0, 4, 5, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 4, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 2, 4, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u2603 = 0; \u2603 <= 4; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Corridor5
    extends Piece {
        public Corridor5() {
        }

        public Corridor5(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74963_a((Start)structurePiece, list, random, 1, 0, true);
        }

        public static Corridor5 func_175877_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, 0, 0, 5, 7, 5, enumFacing);
            if (!Corridor5.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Corridor5(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 1, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 4, 5, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 0, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 2, 0, 4, 5, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 1, 0, 4, 1, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 3, 0, 4, 3, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 3, 1, 4, 4, 1, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 3, 3, 4, 4, 3, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 6, 0, 4, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u2603 = 0; \u2603 <= 4; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class NetherStalkRoom
    extends Piece {
        public NetherStalkRoom() {
        }

        public NetherStalkRoom(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74963_a((Start)structurePiece, list, random, 5, 3, true);
            this.func_74963_a((Start)structurePiece, list, random, 5, 11, true);
        }

        public static NetherStalkRoom func_175875_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -5, -3, 0, 13, 14, 13, enumFacing);
            if (!NetherStalkRoom.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new NetherStalkRoom(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            int n;
            int n2;
            IWorld iWorld2;
            int n3;
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 3, 0, 12, 4, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 0, 12, 13, 12, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 0, 1, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 11, 5, 0, 12, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 5, 11, 4, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 5, 11, 10, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 9, 11, 7, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 5, 0, 4, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 5, 0, 10, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 9, 0, 7, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 11, 2, 10, 12, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            \u2603 = (IBlockState)\u2603.func_206870_a(BlockFence.field_196414_y, true);
            \u2603 = (IBlockState)\u2603.func_206870_a(BlockFence.field_196411_b, true);
            for (n3 = 1; n3 <= 11; n3 += 2) {
                this.func_175804_a(iWorld2, mutableBoundingBox, n3, 10, 0, n3, 11, 0, iBlockState, iBlockState, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, n3, 10, 12, n3, 11, 12, iBlockState, iBlockState, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 0, 10, n3, 0, 11, n3, \u2603, \u2603, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 12, 10, n3, 12, 11, n3, \u2603, \u2603, false);
                this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), n3, 13, 0, mutableBoundingBox);
                this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), n3, 13, 12, mutableBoundingBox);
                this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), 0, 13, n3, mutableBoundingBox);
                this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), 12, 13, n3, mutableBoundingBox);
                if (n3 == 11) continue;
                this.func_175811_a(iWorld2, iBlockState, n3 + 1, 13, 0, mutableBoundingBox);
                this.func_175811_a(iWorld2, iBlockState, n3 + 1, 13, 12, mutableBoundingBox);
                this.func_175811_a(iWorld2, \u2603, 0, 13, n3 + 1, mutableBoundingBox);
                this.func_175811_a(iWorld2, \u2603, 12, 13, n3 + 1, mutableBoundingBox);
            }
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196411_b, true), 0, 13, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196413_c, true)).func_206870_a(BlockFence.field_196411_b, true), 0, 13, 12, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196413_c, true)).func_206870_a(BlockFence.field_196414_y, true), 12, 13, 12, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196414_y, true), 12, 13, 0, mutableBoundingBox);
            for (n3 = 3; n3 <= 9; n3 += 2) {
                this.func_175804_a(iWorld2, mutableBoundingBox, 1, 7, n3, 1, 8, n3, \u2603, \u2603, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 11, 7, n3, 11, 8, n3, \u2603, \u2603, false);
            }
            IBlockState iBlockState2 = (IBlockState)Blocks.field_150387_bl.func_176223_P().func_206870_a(BlockStairs.field_176309_a, EnumFacing.NORTH);
            for (n2 = 0; n2 <= 6; ++n2) {
                \u2603 = n2 + 4;
                for (n = 5; n <= 7; ++n) {
                    this.func_175811_a(iWorld2, iBlockState2, n, 5 + n2, \u2603, mutableBoundingBox);
                }
                if (\u2603 >= 5 && \u2603 <= 8) {
                    this.func_175804_a(iWorld2, mutableBoundingBox, 5, 5, \u2603, 7, n2 + 4, \u2603, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
                } else if (\u2603 >= 9 && \u2603 <= 10) {
                    this.func_175804_a(iWorld2, mutableBoundingBox, 5, 8, \u2603, 7, n2 + 4, \u2603, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
                }
                if (n2 < 1) continue;
                this.func_175804_a(iWorld2, mutableBoundingBox, 5, 6 + n2, \u2603, 7, 9 + n2, \u2603, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            for (n2 = 5; n2 <= 7; ++n2) {
                this.func_175811_a(iWorld2, iBlockState2, n2, 12, 11, mutableBoundingBox);
            }
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 6, 7, 5, 7, 7, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 6, 7, 7, 7, 7, \u2603, \u2603, false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 13, 12, 7, 13, 12, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 5, 2, 3, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 5, 9, 3, 5, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 5, 4, 2, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 9, 5, 2, 10, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 9, 5, 9, 10, 5, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 10, 5, 4, 10, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            IBlockState \u26032 = (IBlockState)iBlockState2.func_206870_a(BlockStairs.field_176309_a, EnumFacing.EAST);
            IBlockState \u26033 = (IBlockState)iBlockState2.func_206870_a(BlockStairs.field_176309_a, EnumFacing.WEST);
            this.func_175811_a(iWorld2, \u26033, 4, 5, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26033, 4, 5, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26033, 4, 5, 9, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26033, 4, 5, 10, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 8, 5, 2, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 8, 5, 3, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 8, 5, 9, mutableBoundingBox);
            this.func_175811_a(iWorld2, \u26032, 8, 5, 10, mutableBoundingBox);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 4, 4, 4, 4, 8, Blocks.field_150425_aM.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 4, 4, 9, 4, 8, Blocks.field_150425_aM.func_176223_P(), Blocks.field_150425_aM.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 3, 5, 4, 4, 5, 8, Blocks.field_150388_bm.func_176223_P(), Blocks.field_150388_bm.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 5, 4, 9, 5, 8, Blocks.field_150388_bm.func_176223_P(), Blocks.field_150388_bm.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 2, 0, 8, 2, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 2, 4, 12, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 0, 0, 8, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 0, 9, 8, 1, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 4, 3, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 9, 0, 4, 12, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (n = 4; n <= 8; ++n) {
                for (\u2603 = 0; \u2603 <= 2; ++\u2603) {
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, \u2603, mutableBoundingBox);
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, 12 - \u2603, mutableBoundingBox);
                }
            }
            for (n = 0; n <= 2; ++n) {
                for (\u2603 = 4; \u2603 <= 8; ++\u2603) {
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, \u2603, mutableBoundingBox);
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), 12 - n, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Entrance
    extends Piece {
        public Entrance() {
        }

        public Entrance(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74963_a((Start)structurePiece, list, random, 5, 3, true);
        }

        public static Entrance func_175881_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -5, -3, 0, 13, 14, 13, enumFacing);
            if (!Entrance.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Entrance(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            int n;
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 3, 0, 12, 4, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 0, 12, 13, 12, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 0, 1, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 11, 5, 0, 12, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 5, 11, 4, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 5, 11, 10, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 9, 11, 7, 12, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 5, 0, 4, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 5, 0, 10, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 9, 0, 7, 12, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 2, 11, 2, 10, 12, 10, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 8, 0, 7, 8, 0, Blocks.field_150386_bk.func_176223_P(), Blocks.field_150386_bk.func_176223_P(), false);
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            for (n = 1; n <= 11; n += 2) {
                this.func_175804_a(iWorld2, mutableBoundingBox, n, 10, 0, n, 11, 0, iBlockState, iBlockState, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, n, 10, 12, n, 11, 12, iBlockState, iBlockState, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 0, 10, n, 0, 11, n, \u2603, \u2603, false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 12, 10, n, 12, 11, n, \u2603, \u2603, false);
                this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, 13, 0, mutableBoundingBox);
                this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, 13, 12, mutableBoundingBox);
                this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), 0, 13, n, mutableBoundingBox);
                this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), 12, 13, n, mutableBoundingBox);
                if (n == 11) continue;
                this.func_175811_a(iWorld2, iBlockState, n + 1, 13, 0, mutableBoundingBox);
                this.func_175811_a(iWorld2, iBlockState, n + 1, 13, 12, mutableBoundingBox);
                this.func_175811_a(iWorld2, \u2603, 0, 13, n + 1, mutableBoundingBox);
                this.func_175811_a(iWorld2, \u2603, 12, 13, n + 1, mutableBoundingBox);
            }
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196411_b, true), 0, 13, 0, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196413_c, true)).func_206870_a(BlockFence.field_196411_b, true), 0, 13, 12, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196413_c, true)).func_206870_a(BlockFence.field_196414_y, true), 12, 13, 12, mutableBoundingBox);
            this.func_175811_a(iWorld2, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196414_y, true), 12, 13, 0, mutableBoundingBox);
            for (n = 3; n <= 9; n += 2) {
                this.func_175804_a(iWorld2, mutableBoundingBox, 1, 7, n, 1, 8, n, (IBlockState)\u2603.func_206870_a(BlockFence.field_196414_y, true), (IBlockState)\u2603.func_206870_a(BlockFence.field_196414_y, true), false);
                this.func_175804_a(iWorld2, mutableBoundingBox, 11, 7, n, 11, 8, n, (IBlockState)\u2603.func_206870_a(BlockFence.field_196411_b, true), (IBlockState)\u2603.func_206870_a(BlockFence.field_196411_b, true), false);
            }
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 2, 0, 8, 2, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 2, 4, 12, 2, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 0, 0, 8, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 4, 0, 9, 8, 1, 12, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 4, 3, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 9, 0, 4, 12, 1, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (n = 4; n <= 8; ++n) {
                for (\u2603 = 0; \u2603 <= 2; ++\u2603) {
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, \u2603, mutableBoundingBox);
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, 12 - \u2603, mutableBoundingBox);
                }
            }
            for (n = 0; n <= 2; ++n) {
                for (\u2603 = 4; \u2603 <= 8; ++\u2603) {
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, \u2603, mutableBoundingBox);
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), 12 - n, -1, \u2603, mutableBoundingBox);
                }
            }
            this.func_175804_a(iWorld2, mutableBoundingBox, 5, 5, 5, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 6, 1, 6, 6, 4, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175811_a(iWorld2, Blocks.field_196653_dH.func_176223_P(), 6, 0, 6, mutableBoundingBox);
            this.func_175811_a(iWorld2, Blocks.field_150353_l.func_176223_P(), 6, 5, 6, mutableBoundingBox);
            BlockPos \u26032 = new BlockPos(this.func_74865_a(6, 6), this.func_74862_a(5), this.func_74873_b(6, 6));
            if (mutableBoundingBox.func_175898_b(\u26032)) {
                iWorld2.func_205219_F_().func_205360_a(\u26032, Fluids.field_204547_b, 0);
            }
            return true;
        }
    }

    public static class Throne
    extends Piece {
        private boolean field_74976_a;

        public Throne() {
        }

        public Throne(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74976_a = nBTTagCompound.func_74767_n("Mob");
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74757_a("Mob", this.field_74976_a);
        }

        public static Throne func_175874_a(List<StructurePiece> list, Random random, int n, int n2, int n3, int n4, EnumFacing enumFacing) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -2, 0, 0, 7, 8, 9, enumFacing);
            if (!Throne.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Throne(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 6, 7, 7, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 0, 0, 5, 1, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 2, 1, 5, 2, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 3, 2, 5, 3, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 4, 3, 5, 4, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 2, 0, 1, 4, 2, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 2, 0, 5, 4, 2, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 5, 2, 1, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 5, 2, 5, 5, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 5, 3, 0, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 5, 3, 6, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 5, 8, 5, 5, 8, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            this.func_175811_a(iWorld, (IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true), 1, 6, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196411_b, true), 5, 6, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196411_b, true)).func_206870_a(BlockFence.field_196409_a, true), 0, 6, 3, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196409_a, true), 6, 6, 3, mutableBoundingBox);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 6, 4, 0, 6, 7, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 6, 4, 6, 6, 7, \u2603, \u2603, false);
            this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196411_b, true)).func_206870_a(BlockFence.field_196413_c, true), 0, 6, 8, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196413_c, true), 6, 6, 8, mutableBoundingBox);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 6, 8, 5, 6, 8, iBlockState, iBlockState, false);
            this.func_175811_a(iWorld, (IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196411_b, true), 1, 7, 8, mutableBoundingBox);
            this.func_175804_a(iWorld, mutableBoundingBox, 2, 7, 8, 4, 7, 8, iBlockState, iBlockState, false);
            this.func_175811_a(iWorld, (IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true), 5, 7, 8, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196411_b, true), 2, 8, 8, mutableBoundingBox);
            this.func_175811_a(iWorld, iBlockState, 3, 8, 8, mutableBoundingBox);
            this.func_175811_a(iWorld, (IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true), 4, 8, 8, mutableBoundingBox);
            if (!this.field_74976_a && mutableBoundingBox.func_175898_b(\u2603 = new BlockPos(this.func_74865_a(3, 5), this.func_74862_a(5), this.func_74873_b(3, 5)))) {
                this.field_74976_a = true;
                iWorld.func_180501_a(\u2603, Blocks.field_150474_ac.func_176223_P(), 2);
                TileEntity tileEntity = iWorld.func_175625_s(\u2603);
                if (tileEntity instanceof TileEntityMobSpawner) {
                    ((TileEntityMobSpawner)tileEntity).func_145881_a().func_200876_a(EntityType.field_200792_f);
                }
            }
            for (int i = 0; i <= 6; ++i) {
                for (\u2603 = 0; \u2603 <= 6; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Stairs
    extends Piece {
        public Stairs() {
        }

        public Stairs(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74965_c((Start)structurePiece, list, random, 6, 2, false);
        }

        public static Stairs func_175872_a(List<StructurePiece> list, Random random, int n, int n2, int n3, int n4, EnumFacing enumFacing) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -2, 0, 0, 7, 11, 7, enumFacing);
            if (!Stairs.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Stairs(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 6, 1, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 6, 10, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 1, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 2, 0, 6, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 1, 0, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 2, 1, 6, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 2, 6, 5, 8, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 2, 0, 5, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 3, 2, 6, 5, 2, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 3, 4, 6, 5, 4, \u2603, \u2603, false);
            this.func_175811_a(iWorld, Blocks.field_196653_dH.func_176223_P(), 5, 2, 5, mutableBoundingBox);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 2, 5, 4, 3, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 3, 2, 5, 3, 4, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 2, 2, 5, 2, 5, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 2, 5, 1, 6, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 7, 1, 5, 7, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 8, 2, 6, 8, 4, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 2, 6, 0, 4, 8, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 2, 5, 0, 4, 5, 0, iBlockState, iBlockState, false);
            for (int i = 0; i <= 6; ++i) {
                for (\u2603 = 0; \u2603 <= 6; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Crossing
    extends Piece {
        public Crossing() {
        }

        public Crossing(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74963_a((Start)structurePiece, list, random, 2, 0, false);
            this.func_74961_b((Start)structurePiece, list, random, 0, 2, false);
            this.func_74965_c((Start)structurePiece, list, random, 0, 2, false);
        }

        public static Crossing func_175873_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -2, 0, 0, 7, 9, 7, enumFacing);
            if (!Crossing.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Crossing(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 6, 1, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 6, 7, 6, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 1, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 6, 1, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 2, 0, 6, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 5, 2, 6, 6, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 0, 6, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 5, 0, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 2, 0, 6, 6, 1, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 2, 5, 6, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196414_y, true)).func_206870_a(BlockFence.field_196411_b, true);
            \u2603 = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            this.func_175804_a(iWorld, mutableBoundingBox, 2, 6, 0, 4, 6, 0, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 2, 5, 0, 4, 5, 0, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 2, 6, 6, 4, 6, 6, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 2, 5, 6, 4, 5, 6, iBlockState, iBlockState, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 6, 2, 0, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 5, 2, 0, 5, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 6, 2, 6, 6, 4, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 6, 5, 2, 6, 5, 4, \u2603, \u2603, false);
            for (int i = 0; i <= 6; ++i) {
                for (\u2603 = 0; \u2603 <= 6; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Crossing3
    extends Piece {
        public Crossing3() {
        }

        public Crossing3(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        protected Crossing3(Random random, int n, int n2) {
            super(0);
            this.func_186164_a(EnumFacing.Plane.HORIZONTAL.func_179518_a(random));
            this.field_74887_e = this.func_186165_e().func_176740_k() == EnumFacing.Axis.Z ? new MutableBoundingBox(n, 64, n2, n + 19 - 1, 73, n2 + 19 - 1) : new MutableBoundingBox(n, 64, n2, n + 19 - 1, 73, n2 + 19 - 1);
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74963_a((Start)structurePiece, list, random, 8, 3, false);
            this.func_74961_b((Start)structurePiece, list, random, 3, 8, false);
            this.func_74965_c((Start)structurePiece, list, random, 3, 8, false);
        }

        public static Crossing3 func_175885_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -8, -3, 0, 19, 10, 19, enumFacing);
            if (!Crossing3.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Crossing3(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld2, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            IWorld iWorld2;
            int n;
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 3, 0, 11, 4, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 3, 7, 18, 4, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 8, 5, 0, 10, 7, 18, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 8, 18, 7, 10, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 5, 0, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 5, 11, 7, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 11, 5, 0, 11, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 11, 5, 11, 11, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 7, 7, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 11, 5, 7, 18, 5, 7, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 5, 11, 7, 5, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 11, 5, 11, 18, 5, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 2, 0, 11, 2, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 2, 13, 11, 2, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 0, 0, 11, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 7, 0, 15, 11, 1, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (n = 7; n <= 11; ++n) {
                for (\u2603 = 0; \u2603 <= 2; ++\u2603) {
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, \u2603, mutableBoundingBox);
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, 18 - \u2603, mutableBoundingBox);
                }
            }
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 2, 7, 5, 2, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 13, 2, 7, 18, 2, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 0, 0, 7, 3, 1, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld2, mutableBoundingBox, 15, 0, 7, 18, 1, 11, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (n = 0; n <= 2; ++n) {
                for (\u2603 = 7; \u2603 <= 11; ++\u2603) {
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), n, -1, \u2603, mutableBoundingBox);
                    this.func_175808_b(iWorld2, Blocks.field_196653_dH.func_176223_P(), 18 - n, -1, \u2603, mutableBoundingBox);
                }
            }
            return true;
        }
    }

    public static class End
    extends Piece {
        private int field_74972_a;

        public End() {
        }

        public End(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
            this.field_74972_a = random.nextInt();
        }

        public static End func_175884_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -3, 0, 5, 10, 8, enumFacing);
            if (!End.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new End(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
            super.func_143011_b(nBTTagCompound, templateManager);
            this.field_74972_a = nBTTagCompound.func_74762_e("Seed");
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
            super.func_143012_a(nBTTagCompound);
            nBTTagCompound.func_74768_a("Seed", this.field_74972_a);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            int n;
            int \u26032;
            Random random2 = new Random(this.field_74972_a);
            for (\u26032 = 0; \u26032 <= 4; ++\u26032) {
                for (n = 3; n <= 4; ++n) {
                    \u2603 = random2.nextInt(8);
                    this.func_175804_a(iWorld, mutableBoundingBox, \u26032, n, 0, \u26032, n, \u2603, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
                }
            }
            \u26032 = random2.nextInt(8);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 5, 0, 0, 5, \u26032, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            \u26032 = random2.nextInt(8);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 5, 0, 4, 5, \u26032, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (\u26032 = 0; \u26032 <= 4; ++\u26032) {
                n = random2.nextInt(5);
                this.func_175804_a(iWorld, mutableBoundingBox, \u26032, 2, 0, \u26032, 2, n, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            }
            for (\u26032 = 0; \u26032 <= 4; ++\u26032) {
                for (n = 0; n <= 1; ++n) {
                    \u2603 = random2.nextInt(3);
                    this.func_175804_a(iWorld, mutableBoundingBox, \u26032, n, 0, \u26032, n, \u2603, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
                }
            }
            return true;
        }
    }

    public static class Straight
    extends Piece {
        public Straight() {
        }

        public Straight(int n, Random random, MutableBoundingBox mutableBoundingBox, EnumFacing enumFacing) {
            super(n);
            this.func_186164_a(enumFacing);
            this.field_74887_e = mutableBoundingBox;
        }

        @Override
        public void func_74861_a(StructurePiece structurePiece, List<StructurePiece> list, Random random) {
            this.func_74963_a((Start)structurePiece, list, random, 1, 3, false);
        }

        public static Straight func_175882_a(List<StructurePiece> list, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            MutableBoundingBox mutableBoundingBox = MutableBoundingBox.func_175897_a(n, n2, n3, -1, -3, 0, 5, 10, 19, enumFacing);
            if (!Straight.func_74964_a(mutableBoundingBox) || StructurePiece.func_74883_a(list, mutableBoundingBox) != null) {
                return null;
            }
            return new Straight(n4, random, mutableBoundingBox, enumFacing);
        }

        @Override
        public boolean func_74875_a(IWorld iWorld, Random random, MutableBoundingBox mutableBoundingBox, ChunkPos chunkPos) {
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 0, 4, 4, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 1, 5, 0, 3, 7, 18, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 5, 0, 0, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 5, 0, 4, 5, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 0, 4, 2, 5, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 2, 13, 4, 2, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 0, 4, 1, 3, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 0, 15, 4, 1, 18, Blocks.field_196653_dH.func_176223_P(), Blocks.field_196653_dH.func_176223_P(), false);
            for (int i = 0; i <= 4; ++i) {
                for (\u2603 = 0; \u2603 <= 2; ++\u2603) {
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, \u2603, mutableBoundingBox);
                    this.func_175808_b(iWorld, Blocks.field_196653_dH.func_176223_P(), i, -1, 18 - \u2603, mutableBoundingBox);
                }
            }
            IBlockState iBlockState = (IBlockState)((IBlockState)Blocks.field_150386_bk.func_176223_P().func_206870_a(BlockFence.field_196409_a, true)).func_206870_a(BlockFence.field_196413_c, true);
            \u2603 = (IBlockState)iBlockState.func_206870_a(BlockFence.field_196411_b, true);
            \u2603 = (IBlockState)iBlockState.func_206870_a(BlockFence.field_196414_y, true);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 1, 1, 0, 4, 1, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 4, 0, 4, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 3, 14, 0, 4, 14, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 0, 1, 17, 0, 4, 17, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 1, 1, 4, 4, 1, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 3, 4, 4, 4, 4, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 3, 14, 4, 4, 14, \u2603, \u2603, false);
            this.func_175804_a(iWorld, mutableBoundingBox, 4, 1, 17, 4, 4, 17, \u2603, \u2603, false);
            return true;
        }
    }

    public static class Start
    extends Crossing3 {
        public PieceWeight field_74970_a;
        public List<PieceWeight> field_74968_b;
        public List<PieceWeight> field_74969_c;
        public List<StructurePiece> field_74967_d = Lists.newArrayList();

        public Start() {
        }

        public Start(Random random, int n, int n2) {
            super(random, n, n2);
            this.field_74968_b = Lists.newArrayList();
            for (PieceWeight pieceWeight : field_78742_a) {
                pieceWeight.field_78827_c = 0;
                this.field_74968_b.add(pieceWeight);
            }
            this.field_74969_c = Lists.newArrayList();
            for (PieceWeight pieceWeight : field_78741_b) {
                pieceWeight.field_78827_c = 0;
                this.field_74969_c.add(pieceWeight);
            }
        }
    }

    static abstract class Piece
    extends StructurePiece {
        public Piece() {
        }

        protected Piece(int n) {
            super(n);
        }

        @Override
        protected void func_143011_b(NBTTagCompound nBTTagCompound, TemplateManager templateManager) {
        }

        @Override
        protected void func_143012_a(NBTTagCompound nBTTagCompound) {
        }

        private int func_74960_a(List<PieceWeight> list) {
            boolean bl = false;
            int \u26032 = 0;
            for (PieceWeight pieceWeight2 : list) {
                PieceWeight pieceWeight2;
                if (pieceWeight2.field_78824_d > 0 && pieceWeight2.field_78827_c < pieceWeight2.field_78824_d) {
                    bl = true;
                }
                \u26032 += pieceWeight2.field_78826_b;
            }
            return bl ? \u26032 : -1;
        }

        private Piece func_175871_a(Start start, List<PieceWeight> list, List<StructurePiece> list22, Random random, int n, int n2, int n3, EnumFacing enumFacing, int n4) {
            List<StructurePiece> list22;
            \u2603 = this.func_74960_a(list);
            boolean bl = \u2603 > 0 && n4 <= 30;
            int \u26032 = 0;
            block0: while (\u26032 < 5 && bl) {
                ++\u26032;
                int n5 = random.nextInt(\u2603);
                for (PieceWeight pieceWeight : list) {
                    if ((n5 -= pieceWeight.field_78826_b) >= 0) continue;
                    if (!pieceWeight.func_78822_a(n4) || pieceWeight == start.field_74970_a && !pieceWeight.field_78825_e) continue block0;
                    Piece piece = FortressPieces.func_175887_b(pieceWeight, list22, random, n, n2, n3, enumFacing, n4);
                    if (piece == null) continue;
                    ++pieceWeight.field_78827_c;
                    start.field_74970_a = pieceWeight;
                    if (!pieceWeight.func_78823_a()) {
                        list.remove(pieceWeight);
                    }
                    return piece;
                }
            }
            return End.func_175884_a(list22, random, n, n2, n3, enumFacing, n4);
        }

        private StructurePiece func_175870_a(Start start, List<StructurePiece> list, Random random, int n, int n2, int n3, @Nullable EnumFacing enumFacing, int n4, boolean bl) {
            if (Math.abs(n - start.func_74874_b().field_78897_a) > 112 || Math.abs(n3 - start.func_74874_b().field_78896_c) > 112) {
                return End.func_175884_a(list, random, n, n2, n3, enumFacing, n4);
            }
            List<PieceWeight> list2 = start.field_74968_b;
            if (bl) {
                list2 = start.field_74969_c;
            }
            if ((\u2603 = this.func_175871_a(start, list2, list, random, n, n2, n3, enumFacing, n4 + 1)) != null) {
                list.add(\u2603);
                start.field_74967_d.add(\u2603);
            }
            return \u2603;
        }

        @Nullable
        protected StructurePiece func_74963_a(Start start, List<StructurePiece> list, Random random, int n, int n2, boolean bl) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing != null) {
                switch (enumFacing) {
                    case NORTH: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c - 1, enumFacing, this.func_74877_c(), bl);
                    }
                    case SOUTH: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a + n, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78892_f + 1, enumFacing, this.func_74877_c(), bl);
                    }
                    case WEST: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c + n, enumFacing, this.func_74877_c(), bl);
                    }
                    case EAST: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n2, this.field_74887_e.field_78896_c + n, enumFacing, this.func_74877_c(), bl);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece func_74961_b(Start start, List<StructurePiece> list, Random random, int n, int n2, boolean bl) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing != null) {
                switch (enumFacing) {
                    case NORTH: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.WEST, this.func_74877_c(), bl);
                    }
                    case SOUTH: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.WEST, this.func_74877_c(), bl);
                    }
                    case WEST: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c(), bl);
                    }
                    case EAST: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, this.func_74877_c(), bl);
                    }
                }
            }
            return null;
        }

        @Nullable
        protected StructurePiece func_74965_c(Start start, List<StructurePiece> list, Random random, int n, int n2, boolean bl) {
            EnumFacing enumFacing = this.func_186165_e();
            if (enumFacing != null) {
                switch (enumFacing) {
                    case NORTH: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.EAST, this.func_74877_c(), bl);
                    }
                    case SOUTH: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78896_c + n2, EnumFacing.EAST, this.func_74877_c(), bl);
                    }
                    case WEST: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c(), bl);
                    }
                    case EAST: {
                        return this.func_175870_a(start, list, random, this.field_74887_e.field_78897_a + n2, this.field_74887_e.field_78895_b + n, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, this.func_74877_c(), bl);
                    }
                }
            }
            return null;
        }

        protected static boolean func_74964_a(MutableBoundingBox mutableBoundingBox) {
            return mutableBoundingBox != null && mutableBoundingBox.field_78895_b > 10;
        }
    }

    static class PieceWeight {
        public Class<? extends Piece> field_78828_a;
        public final int field_78826_b;
        public int field_78827_c;
        public int field_78824_d;
        public boolean field_78825_e;

        public PieceWeight(Class<? extends Piece> clazz, int n, int n2, boolean bl) {
            this.field_78828_a = clazz;
            this.field_78826_b = n;
            this.field_78824_d = n2;
            this.field_78825_e = bl;
        }

        public PieceWeight(Class<? extends Piece> clazz, int n, int n2) {
            this(clazz, n, n2, false);
        }

        public boolean func_78822_a(int n) {
            return this.field_78824_d == 0 || this.field_78827_c < this.field_78824_d;
        }

        public boolean func_78823_a() {
            return this.field_78824_d == 0 || this.field_78827_c < this.field_78824_d;
        }
    }
}

