/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumLightType;
import net.minecraft.world.ITickList;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.WorldGenTickList;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraft.world.storage.WorldSavedDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldGenRegion
implements IWorld {
    private static final Logger field_208303_a = LogManager.getLogger();
    private final ChunkPrimer[] field_201684_a;
    private final int field_201685_b;
    private final int field_201686_c;
    private final int field_201687_d;
    private final int field_201688_e;
    private final World field_201689_f;
    private final long field_201690_g;
    private final int field_201691_h;
    private final WorldInfo field_201692_i;
    private final Random field_201693_j;
    private final Dimension field_201694_k;
    private final IChunkGenSettings field_201695_l;
    private final ITickList<Block> field_205336_m = new WorldGenTickList<Block>(blockPos -> this.func_205771_y((BlockPos)blockPos).func_205218_i_());
    private final ITickList<Fluid> field_205337_n = new WorldGenTickList<Fluid>(blockPos -> this.func_205771_y((BlockPos)blockPos).func_212247_j());

    public WorldGenRegion(ChunkPrimer[] chunkPrimerArray, int n, int n2, int n3, int n4, World world) {
        this.field_201684_a = chunkPrimerArray;
        this.field_201685_b = n3;
        this.field_201686_c = n4;
        this.field_201687_d = n;
        this.field_201688_e = n2;
        this.field_201689_f = world;
        this.field_201690_g = world.func_72905_C();
        this.field_201695_l = world.func_72863_F().func_201711_g().func_201496_a_();
        this.field_201691_h = world.func_181545_F();
        this.field_201692_i = world.func_72912_H();
        this.field_201693_j = world.func_201674_k();
        this.field_201694_k = world.func_201675_m();
    }

    public int func_201679_a() {
        return this.field_201685_b;
    }

    public int func_201680_b() {
        return this.field_201686_c;
    }

    public boolean func_201678_a(int n, int n2) {
        ChunkPrimer chunkPrimer = this.field_201684_a[0];
        \u2603 = this.field_201684_a[this.field_201684_a.length - 1];
        return n >= chunkPrimer.func_76632_l().field_77276_a && n <= \u2603.func_76632_l().field_77276_a && n2 >= chunkPrimer.func_76632_l().field_77275_b && n2 <= \u2603.func_76632_l().field_77275_b;
    }

    @Override
    public IChunk func_72964_e(int n, int n2) {
        if (this.func_201678_a(n, n2)) {
            \u2603 = n - this.field_201684_a[0].func_76632_l().field_77276_a;
            \u2603 = n2 - this.field_201684_a[0].func_76632_l().field_77275_b;
            return this.field_201684_a[\u2603 + \u2603 * this.field_201687_d];
        }
        ChunkPrimer chunkPrimer = this.field_201684_a[0];
        \u2603 = this.field_201684_a[this.field_201684_a.length - 1];
        field_208303_a.error("Requested chunk : {} {}", (Object)n, (Object)n2);
        field_208303_a.error("Region bounds : {} {} | {} {}", (Object)chunkPrimer.func_76632_l().field_77276_a, (Object)chunkPrimer.func_76632_l().field_77275_b, (Object)\u2603.func_76632_l().field_77276_a, (Object)\u2603.func_76632_l().field_77275_b);
        throw new RuntimeException(String.format("We are asking a region for a chunk out of bound | %s %s", n, n2));
    }

    @Override
    public IBlockState func_180495_p(BlockPos blockPos) {
        return this.func_205771_y(blockPos).func_180495_p(blockPos);
    }

    @Override
    public IFluidState func_204610_c(BlockPos blockPos) {
        return this.func_205771_y(blockPos).func_204610_c(blockPos);
    }

    @Override
    @Nullable
    public EntityPlayer func_190525_a(double d, double d2, double d3, double d4, Predicate<Entity> predicate) {
        return null;
    }

    @Override
    public int func_175657_ab() {
        return 0;
    }

    @Override
    public boolean func_175623_d(BlockPos blockPos) {
        return this.func_180495_p(blockPos).func_196958_f();
    }

    @Override
    public Biome func_180494_b(BlockPos blockPos) {
        Biome biome = this.func_205771_y(blockPos).func_201590_e()[blockPos.func_177958_n() & 0xF | (blockPos.func_177952_p() & 0xF) << 4];
        if (biome == null) {
            throw new RuntimeException(String.format("Biome is null @ %s", blockPos));
        }
        return biome;
    }

    @Override
    public int func_175642_b(EnumLightType enumLightType, BlockPos blockPos) {
        IChunk iChunk = this.func_205771_y(blockPos);
        return iChunk.func_201587_a(enumLightType, blockPos, this.func_201675_m().func_191066_m());
    }

    @Override
    public int func_201669_a(BlockPos blockPos, int n) {
        return this.func_205771_y(blockPos).func_201586_a(blockPos, n, this.func_201675_m().func_191066_m());
    }

    @Override
    public boolean func_175680_a(int n, int n2, boolean bl) {
        return this.func_201678_a(n, n2);
    }

    @Override
    public boolean func_175655_b(BlockPos blockPos, boolean bl) {
        IBlockState iBlockState = this.func_180495_p(blockPos);
        if (iBlockState.func_196958_f()) {
            return false;
        }
        if (bl) {
            iBlockState.func_196949_c(this.field_201689_f, blockPos, 0);
        }
        return this.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    @Override
    public boolean func_175678_i(BlockPos blockPos) {
        return this.func_205771_y(blockPos).func_177444_d(blockPos);
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        IChunk iChunk = this.func_205771_y(blockPos);
        TileEntity \u26032 = iChunk.func_175625_s(blockPos);
        if (\u26032 != null) {
            return \u26032;
        }
        NBTTagCompound \u26033 = iChunk.func_201579_g(blockPos);
        if (\u26033 != null && (\u26032 = "DUMMY".equals(\u26033.func_74779_i("id")) ? ((ITileEntityProvider)((Object)this.func_180495_p(blockPos).func_177230_c())).func_196283_a_(this.field_201689_f) : TileEntity.func_203403_c(\u26033)) != null) {
            iChunk.func_177426_a(blockPos, \u26032);
            return \u26032;
        }
        if (iChunk.func_180495_p(blockPos).func_177230_c() instanceof ITileEntityProvider) {
            field_208303_a.warn("Tried to access a block entity before it was created. {}", (Object)blockPos);
        }
        return null;
    }

    @Override
    public boolean func_180501_a(BlockPos blockPos, IBlockState iBlockState2, int n) {
        IBlockState iBlockState2;
        IChunk iChunk = this.func_205771_y(blockPos);
        IBlockState \u26032 = iChunk.func_177436_a(blockPos, iBlockState2, false);
        Block \u26033 = iBlockState2.func_177230_c();
        if (\u26033.func_149716_u()) {
            if (iChunk.func_201589_g().func_202129_d() == ChunkStatus.Type.LEVELCHUNK) {
                iChunk.func_177426_a(blockPos, ((ITileEntityProvider)((Object)\u26033)).func_196283_a_(this));
            } else {
                NBTTagCompound nBTTagCompound = new NBTTagCompound();
                nBTTagCompound.func_74768_a("x", blockPos.func_177958_n());
                nBTTagCompound.func_74768_a("y", blockPos.func_177956_o());
                nBTTagCompound.func_74768_a("z", blockPos.func_177952_p());
                nBTTagCompound.func_74778_a("id", "DUMMY");
                iChunk.func_201591_a(nBTTagCompound);
            }
        } else if (\u26032 != null && \u26032.func_177230_c().func_149716_u()) {
            iChunk.func_177425_e(blockPos);
        }
        if (iBlockState2.func_202065_c(this, blockPos)) {
            this.func_201683_l(blockPos);
        }
        return true;
    }

    private void func_201683_l(BlockPos blockPos) {
        this.func_205771_y(blockPos).func_201594_d(blockPos);
    }

    @Override
    public boolean func_72838_d(Entity entity) {
        int n = MathHelper.func_76128_c(entity.field_70165_t / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.field_70161_v / 16.0);
        this.func_72964_e(n, \u2603).func_76612_a(entity);
        return true;
    }

    @Override
    public boolean func_175698_g(BlockPos blockPos) {
        return this.func_180501_a(blockPos, Blocks.field_150350_a.func_176223_P(), 3);
    }

    @Override
    public void func_175653_a(EnumLightType enumLightType, BlockPos blockPos, int n) {
        this.func_205771_y(blockPos).func_201580_a(enumLightType, this.field_201694_k.func_191066_m(), blockPos, n);
    }

    @Override
    public WorldBorder func_175723_af() {
        return this.field_201689_f.func_175723_af();
    }

    @Override
    public boolean func_195585_a(@Nullable Entity entity, VoxelShape voxelShape) {
        return true;
    }

    @Override
    public int func_175627_a(BlockPos blockPos, EnumFacing enumFacing) {
        return this.func_180495_p(blockPos).func_185893_b(this, blockPos, enumFacing);
    }

    @Override
    public boolean func_201670_d() {
        return false;
    }

    @Override
    @Deprecated
    public World func_201672_e() {
        return this.field_201689_f;
    }

    @Override
    public WorldInfo func_72912_H() {
        return this.field_201692_i;
    }

    @Override
    public DifficultyInstance func_175649_E(BlockPos blockPos) {
        if (!this.func_201678_a(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4)) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyInstance(this.field_201689_f.func_175659_aa(), this.field_201689_f.func_72820_D(), 0L, this.field_201689_f.func_130001_d());
    }

    @Override
    @Nullable
    public WorldSavedDataStorage func_175693_T() {
        return this.field_201689_f.func_175693_T();
    }

    @Override
    public IChunkProvider func_72863_F() {
        return this.field_201689_f.func_72863_F();
    }

    @Override
    public ISaveHandler func_72860_G() {
        return this.field_201689_f.func_72860_G();
    }

    @Override
    public long func_72905_C() {
        return this.field_201690_g;
    }

    @Override
    public ITickList<Block> func_205220_G_() {
        return this.field_205336_m;
    }

    @Override
    public ITickList<Fluid> func_205219_F_() {
        return this.field_205337_n;
    }

    @Override
    public int func_181545_F() {
        return this.field_201691_h;
    }

    @Override
    public Random func_201674_k() {
        return this.field_201693_j;
    }

    @Override
    public void func_195592_c(BlockPos blockPos, Block block) {
    }

    @Override
    public int func_201676_a(Heightmap.Type type, int n, int n2) {
        return this.func_72964_e(n >> 4, n2 >> 4).func_201576_a(type, n & 0xF, n2 & 0xF) + 1;
    }

    @Override
    public void func_184133_a(@Nullable EntityPlayer entityPlayer, BlockPos blockPos, SoundEvent soundEvent, SoundCategory soundCategory, float f, float f2) {
    }

    @Override
    public void func_195594_a(IParticleData iParticleData, double d, double d2, double d3, double d4, double d5, double d6) {
    }

    @Override
    public BlockPos func_175694_M() {
        return this.field_201689_f.func_175694_M();
    }

    @Override
    public Dimension func_201675_m() {
        return this.field_201694_k;
    }
}

