/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.PhantomSpawner;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.AbstractChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.structure.SwampHutStructure;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkGeneratorOverworld
extends AbstractChunkGenerator<OverworldGenSettings> {
    private static final Logger field_202111_e = LogManager.getLogger();
    private final NoiseGeneratorOctaves field_185991_j;
    private final NoiseGeneratorOctaves field_185992_k;
    private final NoiseGeneratorOctaves field_185993_l;
    private final NoiseGeneratorPerlin field_185994_m;
    private final OverworldGenSettings field_186000_s;
    private final NoiseGeneratorOctaves field_185983_b;
    private final NoiseGeneratorOctaves field_185984_c;
    private final WorldType field_185997_p;
    private final float[] field_185999_r;
    private final PhantomSpawner field_203230_r = new PhantomSpawner();
    private final IBlockState field_205475_r;
    private final IBlockState field_205476_s;

    public ChunkGeneratorOverworld(IWorld iWorld, BiomeProvider biomeProvider, OverworldGenSettings overworldGenSettings2) {
        super(iWorld, biomeProvider);
        OverworldGenSettings overworldGenSettings2;
        this.field_185997_p = iWorld.func_72912_H().func_76067_t();
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(this.field_202096_b);
        this.field_185991_j = new NoiseGeneratorOctaves(sharedSeedRandom, 16);
        this.field_185992_k = new NoiseGeneratorOctaves(sharedSeedRandom, 16);
        this.field_185993_l = new NoiseGeneratorOctaves(sharedSeedRandom, 8);
        this.field_185994_m = new NoiseGeneratorPerlin(sharedSeedRandom, 4);
        this.field_185983_b = new NoiseGeneratorOctaves(sharedSeedRandom, 10);
        this.field_185984_c = new NoiseGeneratorOctaves(sharedSeedRandom, 16);
        this.field_185999_r = new float[25];
        for (int i = -2; i <= 2; ++i) {
            for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                this.field_185999_r[i + 2 + (\u2603 + 2) * 5] = \u2603 = 10.0f / MathHelper.func_76129_c((float)(i * i + \u2603 * \u2603) + 0.2f);
            }
        }
        this.field_186000_s = overworldGenSettings2;
        this.field_205475_r = this.field_186000_s.func_205532_l();
        this.field_205476_s = this.field_186000_s.func_205533_m();
    }

    @Override
    public void func_202088_a(IChunk iChunk) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        int \u26032 = chunkPos.field_77276_a;
        int \u26033 = chunkPos.field_77275_b;
        SharedSeedRandom \u26034 = new SharedSeedRandom();
        \u26034.func_202422_a(\u26032, \u26033);
        Biome[] \u26035 = this.field_202097_c.func_201539_b(\u26032 * 16, \u26033 * 16, 16, 16);
        iChunk.func_201577_a(\u26035);
        this.func_185976_a(\u26032, \u26033, iChunk);
        iChunk.func_201588_a(Heightmap.Type.WORLD_SURFACE_WG, Heightmap.Type.OCEAN_FLOOR_WG);
        this.func_205471_a(iChunk, \u26035, \u26034, this.field_202095_a.func_181545_F());
        this.func_205472_a(iChunk, \u26034);
        iChunk.func_201588_a(Heightmap.Type.WORLD_SURFACE_WG, Heightmap.Type.OCEAN_FLOOR_WG);
        iChunk.func_201574_a(ChunkStatus.BASE);
    }

    @Override
    public void func_202093_c(WorldGenRegion worldGenRegion) {
        int n = worldGenRegion.func_201679_a();
        \u2603 = worldGenRegion.func_201680_b();
        Biome \u26032 = worldGenRegion.func_72964_e(n, \u2603).func_201590_e()[0];
        SharedSeedRandom \u26033 = new SharedSeedRandom();
        \u26033.func_202424_a(worldGenRegion.func_72905_C(), n << 4, \u2603 << 4);
        WorldEntitySpawner.func_77191_a(worldGenRegion, \u26032, n, \u2603, \u26033);
    }

    public void func_185976_a(int n, int n2, IChunk iChunk) {
        Biome[] biomeArray = this.field_202097_c.func_201535_a(iChunk.func_76632_l().field_77276_a * 4 - 2, iChunk.func_76632_l().field_77275_b * 4 - 2, 10, 10);
        double[] \u26032 = new double[825];
        this.func_202108_a(biomeArray, iChunk.func_76632_l().field_77276_a * 4, 0, iChunk.func_76632_l().field_77275_b * 4, \u26032);
        BlockPos.MutableBlockPos \u26033 = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 4; ++i) {
            \u2603 = i * 5;
            \u2603 = (i + 1) * 5;
            for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                \u2603 = (\u2603 + \u2603) * 33;
                \u2603 = (\u2603 + \u2603 + 1) * 33;
                \u2603 = (\u2603 + \u2603) * 33;
                \u2603 = (\u2603 + \u2603 + 1) * 33;
                for (\u2603 = 0; \u2603 < 32; ++\u2603) {
                    double d = 0.125;
                    \u2603 = \u26032[\u2603 + \u2603];
                    \u2603 = \u26032[\u2603 + \u2603];
                    \u2603 = \u26032[\u2603 + \u2603];
                    \u2603 = \u26032[\u2603 + \u2603];
                    d2 = (\u26032[\u2603 + \u2603 + 1] - \u2603) * 0.125;
                    \u2603 = (\u26032[\u2603 + \u2603 + 1] - \u2603) * 0.125;
                    \u2603 = (\u26032[\u2603 + \u2603 + 1] - \u2603) * 0.125;
                    \u2603 = (\u26032[\u2603 + \u2603 + 1] - \u2603) * 0.125;
                    for (int j = 0; j < 8; ++j) {
                        double d2;
                        double d3 = 0.25;
                        \u2603 = \u2603;
                        \u2603 = \u2603;
                        d4 = (\u2603 - \u2603) * 0.25;
                        \u2603 = (\u2603 - \u2603) * 0.25;
                        for (int k = 0; k < 4; ++k) {
                            double d4;
                            double d5 = 0.25;
                            \u2603 = \u2603;
                            \u2603 = (\u2603 - \u2603) * 0.25;
                            \u2603 -= \u2603;
                            for (int i2 = 0; i2 < 4; ++i2) {
                                double d6;
                                \u26033.func_181079_c(i * 4 + k, \u2603 * 8 + j, \u2603 * 4 + i2);
                                \u2603 += \u2603;
                                if (d6 > 0.0) {
                                    iChunk.func_177436_a(\u26033, this.field_205475_r, false);
                                    continue;
                                }
                                if (\u2603 * 8 + j >= this.field_186000_s.func_202197_m()) continue;
                                iChunk.func_177436_a(\u26033, this.field_205476_s, false);
                            }
                            \u2603 += d4;
                            \u2603 += \u2603;
                        }
                        \u2603 += d2;
                        \u2603 += \u2603;
                        \u2603 += \u2603;
                        \u2603 += \u2603;
                    }
                }
            }
        }
    }

    private void func_202108_a(Biome[] biomeArray, int n, int n2, int n3, double[] dArray) {
        \u2603 = this.field_185984_c.func_202646_a(n, n3, 5, 5, this.field_186000_s.func_202193_n(), this.field_186000_s.func_202194_o(), this.field_186000_s.func_202189_p());
        float f = this.field_186000_s.func_202195_q();
        \u2603 = this.field_186000_s.func_202196_r();
        double[] \u26032 = this.field_185993_l.func_202647_a(n, n2, n3, 5, 33, 5, f / this.field_186000_s.func_202192_s(), \u2603 / this.field_186000_s.func_202190_t(), f / this.field_186000_s.func_202191_u());
        double[] \u26033 = this.field_185991_j.func_202647_a(n, n2, n3, 5, 33, 5, f, \u2603, f);
        double[] \u26034 = this.field_185992_k.func_202647_a(n, n2, n3, 5, 33, 5, f, \u2603, f);
        int \u26035 = 0;
        int \u26036 = 0;
        for (int i = 0; i < 5; ++i) {
            for (\u2603 = 0; \u2603 < 5; ++\u2603) {
                float f2 = 0.0f;
                \u2603 = 0.0f;
                \u2603 = 0.0f;
                int \u26037 = 2;
                Biome \u26038 = biomeArray[i + 2 + (\u2603 + 2) * 10];
                for (int j = -2; j <= 2; ++j) {
                    for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                        Biome biome = biomeArray[i + j + 2 + (\u2603 + \u2603 + 2) * 10];
                        float \u26039 = this.field_186000_s.func_202203_v() + biome.func_185355_j() * this.field_186000_s.func_202202_w();
                        float \u260310 = this.field_186000_s.func_202204_x() + biome.func_185360_m() * this.field_186000_s.func_202205_y();
                        if (this.field_185997_p == WorldType.field_151360_e && \u26039 > 0.0f) {
                            \u26039 = 1.0f + \u26039 * 2.0f;
                            \u260310 = 1.0f + \u260310 * 4.0f;
                        }
                        float \u260311 = this.field_185999_r[j + 2 + (\u2603 + 2) * 5] / (\u26039 + 2.0f);
                        if (biome.func_185355_j() > \u26038.func_185355_j()) {
                            \u260311 /= 2.0f;
                        }
                        f2 += \u260310 * \u260311;
                        \u2603 += \u26039 * \u260311;
                        \u2603 += \u260311;
                    }
                }
                f2 /= \u2603;
                \u2603 /= \u2603;
                f2 = f2 * 0.9f + 0.1f;
                \u2603 = (\u2603 * 4.0f - 1.0f) / 8.0f;
                double \u260312 = \u2603[\u26036] / 8000.0;
                if (\u260312 < 0.0) {
                    \u260312 = -\u260312 * 0.3;
                }
                if ((\u260312 = \u260312 * 3.0 - 2.0) < 0.0) {
                    if ((\u260312 /= 2.0) < -1.0) {
                        \u260312 = -1.0;
                    }
                    \u260312 /= 1.4;
                    \u260312 /= 2.0;
                } else {
                    if (\u260312 > 1.0) {
                        \u260312 = 1.0;
                    }
                    \u260312 /= 8.0;
                }
                ++\u26036;
                double \u260313 = \u2603;
                double \u260314 = f2;
                \u260313 += \u260312 * 0.2;
                \u260313 = \u260313 * this.field_186000_s.func_202201_z() / 8.0;
                double \u260315 = this.field_186000_s.func_202201_z() + \u260313 * 4.0;
                for (int j = 0; j < 33; ++j) {
                    double d = ((double)j - \u260315) * this.field_186000_s.func_202206_A() * 128.0 / 256.0 / \u260314;
                    if (d < 0.0) {
                        d *= 4.0;
                    }
                    \u2603 = \u26033[\u26035] / this.field_186000_s.func_202207_B();
                    \u2603 = \u26034[\u26035] / this.field_186000_s.func_202208_C();
                    \u2603 = (\u26032[\u26035] / 10.0 + 1.0) / 2.0;
                    \u2603 = MathHelper.func_151238_b(\u2603, \u2603, \u2603) - d;
                    if (j > 29) {
                        \u2603 = (float)(j - 29) / 3.0f;
                        \u2603 = \u2603 * (1.0 - \u2603) - 10.0 * \u2603;
                    }
                    dArray[\u26035] = \u2603;
                    ++\u26035;
                }
            }
        }
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        Biome biome = this.field_202095_a.func_180494_b(blockPos);
        if (enumCreatureType == EnumCreatureType.MONSTER && ((SwampHutStructure)Feature.field_202334_l).func_202383_b(this.field_202095_a, blockPos)) {
            return Feature.field_202334_l.func_202279_e();
        }
        if (enumCreatureType == EnumCreatureType.MONSTER && Feature.field_202336_n.func_175796_a(this.field_202095_a, blockPos)) {
            return Feature.field_202336_n.func_202279_e();
        }
        return biome.func_76747_a(enumCreatureType);
    }

    @Override
    public int func_203222_a(World world, boolean bl, boolean bl2) {
        int n = 0;
        return n += this.field_203230_r.func_203232_a(world, bl, bl2);
    }

    @Override
    public OverworldGenSettings func_201496_a_() {
        return this.field_186000_s;
    }

    @Override
    public double[] func_205473_a(int n, int n2) {
        double d = 0.03125;
        return this.field_185994_m.func_202644_a(n << 4, n2 << 4, 16, 16, 0.0625, 0.0625, 1.0);
    }

    @Override
    public int func_205470_d() {
        return this.field_202095_a.func_181545_F() + 1;
    }

    @Override
    public /* synthetic */ IChunkGenSettings func_201496_a_() {
        return this.func_201496_a_();
    }
}

