/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen;

import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.AbstractChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.gen.NoiseGeneratorOctaves;
import net.minecraft.world.gen.WorldGenRegion;
import net.minecraft.world.gen.feature.Feature;

public class ChunkGeneratorNether
extends AbstractChunkGenerator<NetherGenSettings> {
    protected static final IBlockState field_185940_a = Blocks.field_150350_a.func_176223_P();
    protected static final IBlockState field_185941_b = Blocks.field_150424_aL.func_176223_P();
    protected static final IBlockState field_185943_d = Blocks.field_150353_l.func_176223_P();
    private final NoiseGeneratorOctaves field_185957_u;
    private final NoiseGeneratorOctaves field_185958_v;
    private final NoiseGeneratorOctaves field_185959_w;
    private final NoiseGeneratorOctaves field_73177_m;
    private final NoiseGeneratorOctaves field_185946_g;
    private final NoiseGeneratorOctaves field_185947_h;
    private final NetherGenSettings field_202107_q;
    private final IBlockState field_205474_p;
    private final IBlockState field_205604_n;

    public ChunkGeneratorNether(World world, BiomeProvider biomeProvider, NetherGenSettings netherGenSettings) {
        super(world, biomeProvider);
        this.field_202107_q = netherGenSettings;
        this.field_205474_p = this.field_202107_q.func_205532_l();
        this.field_205604_n = this.field_202107_q.func_205533_m();
        SharedSeedRandom sharedSeedRandom = new SharedSeedRandom(this.field_202096_b);
        this.field_185957_u = new NoiseGeneratorOctaves(sharedSeedRandom, 16);
        this.field_185958_v = new NoiseGeneratorOctaves(sharedSeedRandom, 16);
        this.field_185959_w = new NoiseGeneratorOctaves(sharedSeedRandom, 8);
        sharedSeedRandom.func_202423_a(1048);
        this.field_73177_m = new NoiseGeneratorOctaves(sharedSeedRandom, 4);
        this.field_185946_g = new NoiseGeneratorOctaves(sharedSeedRandom, 10);
        this.field_185947_h = new NoiseGeneratorOctaves(sharedSeedRandom, 16);
        world.func_181544_b(63);
    }

    public void func_185936_a(int n, int n2, IChunk iChunk) {
        int n3 = 4;
        \u2603 = this.field_202095_a.func_181545_F() / 2 + 1;
        \u2603 = 5;
        \u2603 = 17;
        \u2603 = 5;
        double[] \u26032 = this.func_202104_a(n * 4, 0, n2 * 4, 5, 17, 5);
        BlockPos.MutableBlockPos \u26033 = new BlockPos.MutableBlockPos();
        for (\u2603 = 0; \u2603 < 4; ++\u2603) {
            for (\u2603 = 0; \u2603 < 4; ++\u2603) {
                for (\u2603 = 0; \u2603 < 16; ++\u2603) {
                    double d = 0.125;
                    \u2603 = \u26032[((\u2603 + 0) * 5 + \u2603 + 0) * 17 + \u2603 + 0];
                    \u2603 = \u26032[((\u2603 + 0) * 5 + \u2603 + 1) * 17 + \u2603 + 0];
                    \u2603 = \u26032[((\u2603 + 1) * 5 + \u2603 + 0) * 17 + \u2603 + 0];
                    \u2603 = \u26032[((\u2603 + 1) * 5 + \u2603 + 1) * 17 + \u2603 + 0];
                    \u2603 = (\u26032[((\u2603 + 0) * 5 + \u2603 + 0) * 17 + \u2603 + 1] - \u2603) * 0.125;
                    \u2603 = (\u26032[((\u2603 + 0) * 5 + \u2603 + 1) * 17 + \u2603 + 1] - \u2603) * 0.125;
                    \u2603 = (\u26032[((\u2603 + 1) * 5 + \u2603 + 0) * 17 + \u2603 + 1] - \u2603) * 0.125;
                    \u2603 = (\u26032[((\u2603 + 1) * 5 + \u2603 + 1) * 17 + \u2603 + 1] - \u2603) * 0.125;
                    for (int i = 0; i < 8; ++i) {
                        double d2 = 0.25;
                        \u2603 = \u2603;
                        \u2603 = \u2603;
                        \u2603 = (\u2603 - \u2603) * 0.25;
                        \u2603 = (\u2603 - \u2603) * 0.25;
                        for (int j = 0; j < 4; ++j) {
                            double d3 = 0.25;
                            \u2603 = \u2603;
                            \u2603 = (\u2603 - \u2603) * 0.25;
                            for (int k = 0; k < 4; ++k) {
                                IBlockState iBlockState = field_185940_a;
                                if (\u2603 * 8 + i < \u2603) {
                                    iBlockState = this.field_205604_n;
                                }
                                if (\u2603 > 0.0) {
                                    iBlockState = this.field_205474_p;
                                }
                                int \u26034 = j + \u2603 * 4;
                                int \u26035 = i + \u2603 * 8;
                                int \u26036 = k + \u2603 * 4;
                                iChunk.func_177436_a(\u26033.func_181079_c(\u26034, \u26035, \u26036), iBlockState, false);
                                \u2603 += \u2603;
                            }
                            \u2603 += \u2603;
                            \u2603 += \u2603;
                        }
                        \u2603 += \u2603;
                        \u2603 += \u2603;
                        \u2603 += \u2603;
                        \u2603 += \u2603;
                    }
                }
            }
        }
    }

    @Override
    protected void func_205472_a(IChunk iChunk, Random random) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        int \u26032 = iChunk.func_76632_l().func_180334_c();
        int \u26033 = iChunk.func_76632_l().func_180333_d();
        for (BlockPos blockPos : BlockPos.func_191532_a(\u26032, 0, \u26033, \u26032 + 16, 0, \u26033 + 16)) {
            int n;
            for (n = 127; n > 122; --n) {
                if (n < 127 - random.nextInt(5)) continue;
                iChunk.func_177436_a(mutableBlockPos.func_181079_c(blockPos.func_177958_n(), n, blockPos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
            for (n = 4; n >= 0; --n) {
                if (n > random.nextInt(5)) continue;
                iChunk.func_177436_a(mutableBlockPos.func_181079_c(blockPos.func_177958_n(), n, blockPos.func_177952_p()), Blocks.field_150357_h.func_176223_P(), false);
            }
        }
    }

    @Override
    public double[] func_205473_a(int n, int n2) {
        double d = 0.03125;
        return this.field_73177_m.func_202647_a(n << 4, n2 << 4, 0, 16, 16, 1, 0.0625, 0.0625, 0.0625);
    }

    @Override
    public void func_202088_a(IChunk iChunk) {
        ChunkPos chunkPos = iChunk.func_76632_l();
        int \u26032 = chunkPos.field_77276_a;
        int \u26033 = chunkPos.field_77275_b;
        SharedSeedRandom \u26034 = new SharedSeedRandom();
        \u26034.func_202422_a(\u26032, \u26033);
        Biome[] \u26035 = this.field_202097_c.func_201539_b(\u26032 * 16, \u26033 * 16, 16, 16);
        iChunk.func_201577_a(\u26035);
        this.func_185936_a(\u26032, \u26033, iChunk);
        this.func_205471_a(iChunk, \u26035, \u26034, this.field_202095_a.func_181545_F());
        this.func_205472_a(iChunk, \u26034);
        iChunk.func_201588_a(Heightmap.Type.WORLD_SURFACE_WG, Heightmap.Type.OCEAN_FLOOR_WG);
        iChunk.func_201574_a(ChunkStatus.BASE);
    }

    private double[] func_202104_a(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        double[] dArray = new double[n4 * n5 * n6];
        double \u26032 = 684.412;
        double \u26033 = 2053.236;
        \u2603 = this.field_185946_g.func_202647_a(n, n2, n3, n4, 1, n6, 1.0, 0.0, 1.0);
        \u2603 = this.field_185947_h.func_202647_a(n, n2, n3, n4, 1, n6, 100.0, 0.0, 100.0);
        \u2603 = this.field_185959_w.func_202647_a(n, n2, n3, n4, n5, n6, 8.555150000000001, 34.2206, 8.555150000000001);
        \u2603 = this.field_185957_u.func_202647_a(n, n2, n3, n4, n5, n6, 684.412, 2053.236, 684.412);
        \u2603 = this.field_185958_v.func_202647_a(n, n2, n3, n4, n5, n6, 684.412, 2053.236, 684.412);
        \u2603 = new double[n5];
        for (n7 = 0; n7 < n5; ++n7) {
            \u2603[n7] = Math.cos((double)n7 * Math.PI * 6.0 / (double)n5) * 2.0;
            double d = n7;
            if (n7 > n5 / 2) {
                d = n5 - 1 - n7;
            }
            if (!(d < 4.0)) continue;
            d = 4.0 - d;
            int n8 = n7;
            \u2603[n8] = \u2603[n8] - d * d * d * 10.0;
        }
        n7 = 0;
        for (\u2603 = 0; \u2603 < n4; ++\u2603) {
            for (\u2603 = 0; \u2603 < n6; ++\u2603) {
                double d = 0.0;
                for (int i = 0; i < n5; ++i) {
                    double d2 = \u2603[i];
                    \u2603 = \u2603[n7] / 512.0;
                    \u2603 = \u2603[n7] / 512.0;
                    \u2603 = (\u2603[n7] / 10.0 + 1.0) / 2.0;
                    \u2603 = \u2603 < 0.0 ? \u2603 : (\u2603 > 1.0 ? \u2603 : \u2603 + (\u2603 - \u2603) * \u2603);
                    \u2603 -= d2;
                    if (i > n5 - 4) {
                        \u2603 = (float)(i - (n5 - 4)) / 3.0f;
                        \u2603 = \u2603 * (1.0 - \u2603) - 10.0 * \u2603;
                    }
                    if ((double)i < 0.0) {
                        \u2603 = (0.0 - (double)i) / 4.0;
                        \u2603 = MathHelper.func_151237_a(\u2603, 0.0, 1.0);
                        \u2603 = \u2603 * (1.0 - \u2603) - 10.0 * \u2603;
                    }
                    dArray[n7] = \u2603;
                    ++n7;
                }
            }
        }
        return dArray;
    }

    @Override
    public void func_202093_c(WorldGenRegion worldGenRegion) {
    }

    @Override
    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType enumCreatureType, BlockPos blockPos) {
        if (enumCreatureType == EnumCreatureType.MONSTER) {
            if (Feature.field_202337_o.func_202366_b(this.field_202095_a, blockPos)) {
                return Feature.field_202337_o.func_202279_e();
            }
            if (Feature.field_202337_o.func_175796_a(this.field_202095_a, blockPos) && this.field_202095_a.func_180495_p(blockPos.func_177977_b()).func_177230_c() == Blocks.field_196653_dH) {
                return Feature.field_202337_o.func_202279_e();
            }
        }
        Biome biome = this.field_202095_a.func_180494_b(blockPos);
        return biome.func_76747_a(enumCreatureType);
    }

    @Override
    public int func_203222_a(World world, boolean bl, boolean bl2) {
        return 0;
    }

    @Override
    public NetherGenSettings func_201496_a_() {
        return this.field_202107_q;
    }

    @Override
    public int func_205470_d() {
        return this.field_202095_a.func_181545_F() + 1;
    }

    @Override
    public int func_207511_e() {
        return 128;
    }

    @Override
    public /* synthetic */ IChunkGenSettings func_201496_a_() {
        return this.func_201496_a_();
    }
}

