/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.end;

import com.google.common.collect.ContiguousSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.pattern.BlockMatcher;
import net.minecraft.block.state.pattern.BlockPattern;
import net.minecraft.block.state.pattern.FactoryBlockPattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.dragon.phase.PhaseType;
import net.minecraft.entity.item.EntityEnderCrystal;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.BossInfo;
import net.minecraft.world.BossInfoServer;
import net.minecraft.world.IWorld;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.end.DragonSpawnState;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.EndCrystalTowerFeature;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.EndPodiumFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.placement.EndSpikes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DragonFightManager {
    private static final Logger field_186107_a = LogManager.getLogger();
    private static final Predicate<Entity> field_186108_b = EntitySelectors.field_94557_a.and(EntitySelectors.func_188443_a(0.0, 128.0, 0.0, 192.0));
    private final BossInfoServer field_186109_c = (BossInfoServer)new BossInfoServer(new TextComponentTranslation("entity.minecraft.ender_dragon", new Object[0]), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186742_b(true).func_186743_c(true);
    private final WorldServer field_186110_d;
    private final List<Integer> field_186111_e = Lists.newArrayList();
    private final BlockPattern field_186112_f;
    private int field_186113_g;
    private int field_186114_h;
    private int field_186115_i;
    private int field_186116_j;
    private boolean field_186117_k;
    private boolean field_186118_l;
    private UUID field_186119_m;
    private boolean field_186120_n = true;
    private BlockPos field_186121_o;
    private DragonSpawnState field_186122_p;
    private int field_186123_q;
    private List<EntityEnderCrystal> field_186124_r;

    public DragonFightManager(WorldServer worldServer2, NBTTagCompound nBTTagCompound) {
        this.field_186110_d = worldServer2;
        if (nBTTagCompound.func_150297_b("DragonKilled", 99)) {
            if (nBTTagCompound.func_186855_b("DragonUUID")) {
                this.field_186119_m = nBTTagCompound.func_186857_a("DragonUUID");
            }
            this.field_186117_k = nBTTagCompound.func_74767_n("DragonKilled");
            this.field_186118_l = nBTTagCompound.func_74767_n("PreviouslyKilled");
            if (nBTTagCompound.func_74767_n("IsRespawning")) {
                this.field_186122_p = DragonSpawnState.START;
            }
            if (nBTTagCompound.func_150297_b("ExitPortalLocation", 10)) {
                this.field_186121_o = NBTUtil.func_186861_c(nBTTagCompound.func_74775_l("ExitPortalLocation"));
            }
        } else {
            this.field_186117_k = true;
            this.field_186118_l = true;
        }
        if (nBTTagCompound.func_150297_b("Gateways", 9)) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Gateways", 3);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                this.field_186111_e.add(nBTTagList.func_186858_c(i));
            }
        } else {
            WorldServer worldServer2;
            this.field_186111_e.addAll((Collection<Integer>)ContiguousSet.create((Range)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(20)), (DiscreteDomain)DiscreteDomain.integers()));
            Collections.shuffle(this.field_186111_e, new Random(worldServer2.func_72905_C()));
        }
        this.field_186112_f = FactoryBlockPattern.func_177660_a().func_177659_a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").func_177659_a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").func_177659_a("       ", "       ", "       ", "   #   ", "       ", "       ", "       ").func_177659_a("  ###  ", " #   # ", "#     #", "#  #  #", "#     #", " #   # ", "  ###  ").func_177659_a("       ", "  ###  ", " ##### ", " ##### ", " ##### ", "  ###  ", "       ").func_177662_a('#', BlockWorldState.func_177510_a(BlockMatcher.func_177642_a(Blocks.field_150357_h))).func_177661_b();
    }

    public NBTTagCompound func_186088_a() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        if (this.field_186119_m != null) {
            nBTTagCompound.func_186854_a("DragonUUID", this.field_186119_m);
        }
        nBTTagCompound.func_74757_a("DragonKilled", this.field_186117_k);
        nBTTagCompound.func_74757_a("PreviouslyKilled", this.field_186118_l);
        if (this.field_186121_o != null) {
            nBTTagCompound.func_74782_a("ExitPortalLocation", NBTUtil.func_186859_a(this.field_186121_o));
        }
        NBTTagList \u26032 = new NBTTagList();
        for (int n : this.field_186111_e) {
            \u26032.add(new NBTTagInt(n));
        }
        nBTTagCompound.func_74782_a("Gateways", \u26032);
        return nBTTagCompound;
    }

    public void func_186105_b() {
        this.field_186109_c.func_186758_d(!this.field_186117_k);
        if (++this.field_186116_j >= 20) {
            this.func_186100_j();
            this.field_186116_j = 0;
        }
        LoadManager loadManager = new LoadManager();
        if (!this.field_186109_c.func_186757_c().isEmpty()) {
            if (this.field_186120_n && loadManager.func_210824_a()) {
                this.func_210827_g();
                this.field_186120_n = false;
            }
            if (this.field_186122_p != null) {
                if (this.field_186124_r == null && loadManager.func_210824_a()) {
                    this.field_186122_p = null;
                    this.func_186106_e();
                }
                this.field_186122_p.func_186079_a(this.field_186110_d, this, this.field_186124_r, this.field_186123_q++, this.field_186121_o);
            }
            if (!this.field_186117_k) {
                if ((this.field_186119_m == null || ++this.field_186113_g >= 1200) && loadManager.func_210824_a()) {
                    this.func_210828_h();
                    this.field_186113_g = 0;
                }
                if (++this.field_186115_i >= 100 && loadManager.func_210824_a()) {
                    this.func_186101_k();
                    this.field_186115_i = 0;
                }
            }
        }
    }

    private void func_210827_g() {
        field_186107_a.info("Scanning for legacy world dragon fight...");
        boolean bl = this.func_186104_g();
        if (bl) {
            field_186107_a.info("Found that the dragon has been killed in this world already.");
            this.field_186118_l = true;
        } else {
            field_186107_a.info("Found that the dragon has not yet been killed in this world.");
            this.field_186118_l = false;
            this.func_186094_a(false);
        }
        List<Entity> \u26032 = this.field_186110_d.func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a);
        if (\u26032.isEmpty()) {
            this.field_186117_k = true;
        } else {
            EntityDragon entityDragon = (EntityDragon)\u26032.get(0);
            this.field_186119_m = entityDragon.func_110124_au();
            field_186107_a.info("Found that there's a dragon still alive ({})", (Object)entityDragon);
            this.field_186117_k = false;
            if (!bl) {
                field_186107_a.info("But we didn't have a portal, let's remove it.");
                entityDragon.func_70106_y();
                this.field_186119_m = null;
            }
        }
        if (!this.field_186118_l && this.field_186117_k) {
            this.field_186117_k = false;
        }
    }

    private void func_210828_h() {
        List<Entity> list = this.field_186110_d.func_175644_a(EntityDragon.class, EntitySelectors.field_94557_a);
        if (list.isEmpty()) {
            field_186107_a.debug("Haven't seen the dragon, respawning it");
            this.func_192445_m();
        } else {
            field_186107_a.debug("Haven't seen our dragon, but found another one to use.");
            this.field_186119_m = ((EntityDragon)list.get(0)).func_110124_au();
        }
    }

    protected void func_186095_a(DragonSpawnState dragonSpawnState2) {
        if (this.field_186122_p == null) {
            throw new IllegalStateException("Dragon respawn isn't in progress, can't skip ahead in the animation.");
        }
        this.field_186123_q = 0;
        if (dragonSpawnState2 == DragonSpawnState.END) {
            this.field_186122_p = null;
            this.field_186117_k = false;
            EntityDragon entityDragon = this.func_192445_m();
            for (EntityPlayerMP entityPlayerMP : this.field_186109_c.func_186757_c()) {
                CriteriaTriggers.field_192133_m.func_192229_a(entityPlayerMP, entityDragon);
            }
        } else {
            DragonSpawnState dragonSpawnState2;
            this.field_186122_p = dragonSpawnState2;
        }
    }

    private boolean func_186104_g() {
        for (int i = -8; i <= 8; ++i) {
            for (\u2603 = -8; \u2603 <= 8; ++\u2603) {
                Chunk chunk = this.field_186110_d.func_72964_e(i, \u2603);
                for (TileEntity tileEntity : chunk.func_177434_r().values()) {
                    if (!(tileEntity instanceof TileEntityEndPortal)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    private BlockPattern.PatternHelper func_186091_h() {
        Object object;
        for (int i = -8; i <= 8; ++i) {
            for (i = -8; i <= 8; ++i) {
                object = this.field_186110_d.func_72964_e(i, i);
                for (TileEntity tileEntity : ((Chunk)object).func_177434_r().values()) {
                    if (!(tileEntity instanceof TileEntityEndPortal) || (\u2603 = this.field_186112_f.func_177681_a(this.field_186110_d, tileEntity.func_174877_v())) == null) continue;
                    BlockPos blockPos = \u2603.func_177670_a(3, 3, 3).func_177508_d();
                    if (this.field_186121_o == null && blockPos.func_177958_n() == 0 && blockPos.func_177952_p() == 0) {
                        this.field_186121_o = blockPos;
                    }
                    return \u2603;
                }
            }
        }
        for (int i = i = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a).func_177956_o(); i >= 0; --i) {
            object = this.field_186112_f.func_177681_a(this.field_186110_d, new BlockPos(EndPodiumFeature.field_186139_a.func_177958_n(), i, EndPodiumFeature.field_186139_a.func_177952_p()));
            if (object == null) continue;
            if (this.field_186121_o == null) {
                this.field_186121_o = ((BlockPattern.PatternHelper)object).func_177670_a(3, 3, 3).func_177508_d();
            }
            return object;
        }
        return null;
    }

    private boolean func_210832_a(int n, int n2, int n3, int n4) {
        if (this.func_210830_b(n, n2, n3, n4)) {
            return true;
        }
        this.func_210831_c(n, n2, n3, n4);
        return false;
    }

    private boolean func_210830_b(int n, int n2, int n3, int n4) {
        boolean bl = true;
        for (int i = n; i <= n2; ++i) {
            for (\u2603 = n3; \u2603 <= n4; ++\u2603) {
                Chunk chunk = this.field_186110_d.func_72964_e(i, \u2603);
                bl &= chunk.func_201589_g() == ChunkStatus.POSTPROCESSED;
            }
        }
        return bl;
    }

    private void func_210831_c(int n, int n2, int n3, int n4) {
        for (\u2603 = n - 1; \u2603 <= n2 + 1; ++\u2603) {
            this.field_186110_d.func_72964_e(\u2603, n3 - 1);
            this.field_186110_d.func_72964_e(\u2603, n4 + 1);
        }
        for (\u2603 = n3 - 1; \u2603 <= n4 + 1; ++\u2603) {
            this.field_186110_d.func_72964_e(n - 1, \u2603);
            this.field_186110_d.func_72964_e(n2 + 1, \u2603);
        }
    }

    private void func_186100_j() {
        HashSet hashSet = Sets.newHashSet();
        for (EntityPlayerMP entityPlayerMP : this.field_186110_d.func_175661_b(EntityPlayerMP.class, field_186108_b)) {
            this.field_186109_c.func_186760_a(entityPlayerMP);
            hashSet.add(entityPlayerMP);
        }
        HashSet hashSet2 = Sets.newHashSet(this.field_186109_c.func_186757_c());
        hashSet2.removeAll(hashSet);
        for (EntityPlayerMP entityPlayerMP : hashSet2) {
            this.field_186109_c.func_186761_b(entityPlayerMP);
        }
    }

    private void func_186101_k() {
        this.field_186115_i = 0;
        this.field_186114_h = 0;
        for (EndCrystalTowerFeature.EndSpike endSpike : EndSpikes.func_202466_a(this.field_186110_d)) {
            this.field_186114_h += this.field_186110_d.func_72872_a(EntityEnderCrystal.class, endSpike.func_186153_f()).size();
        }
        field_186107_a.debug("Found {} end crystals still alive", (Object)this.field_186114_h);
    }

    public void func_186096_a(EntityDragon entityDragon) {
        if (entityDragon.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(0.0f);
            this.field_186109_c.func_186758_d(false);
            this.func_186094_a(true);
            this.func_186097_l();
            if (!this.field_186118_l) {
                this.field_186110_d.func_175656_a(this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING, EndPodiumFeature.field_186139_a), Blocks.field_150380_bt.func_176223_P());
            }
            this.field_186118_l = true;
            this.field_186117_k = true;
        }
    }

    private void func_186097_l() {
        if (this.field_186111_e.isEmpty()) {
            return;
        }
        int n = this.field_186111_e.remove(this.field_186111_e.size() - 1);
        \u2603 = (int)(96.0 * Math.cos(2.0 * (-Math.PI + 0.15707963267948966 * (double)n)));
        \u2603 = (int)(96.0 * Math.sin(2.0 * (-Math.PI + 0.15707963267948966 * (double)n)));
        this.func_186089_a(new BlockPos(\u2603, 75, \u2603));
    }

    private void func_186089_a(BlockPos blockPos) {
        this.field_186110_d.func_175718_b(3000, blockPos, 0);
        Feature.field_202299_as.func_212245_a(this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), blockPos, new EndGatewayConfig(false));
    }

    private void func_186094_a(boolean bl) {
        EndPodiumFeature endPodiumFeature = new EndPodiumFeature(bl);
        if (this.field_186121_o == null) {
            this.field_186121_o = this.field_186110_d.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.field_186139_a).func_177977_b();
            while (this.field_186110_d.func_180495_p(this.field_186121_o).func_177230_c() == Blocks.field_150357_h && this.field_186121_o.func_177956_o() > this.field_186110_d.func_181545_F()) {
                this.field_186121_o = this.field_186121_o.func_177977_b();
            }
        }
        endPodiumFeature.func_212245_a((IWorld)this.field_186110_d, this.field_186110_d.func_72863_F().func_201711_g(), new Random(), this.field_186121_o, IFeatureConfig.field_202429_e);
    }

    private EntityDragon func_192445_m() {
        this.field_186110_d.func_175726_f(new BlockPos(0, 128, 0));
        EntityDragon entityDragon = new EntityDragon(this.field_186110_d);
        entityDragon.func_184670_cT().func_188758_a(PhaseType.field_188741_a);
        entityDragon.func_70012_b(0.0, 128.0, 0.0, this.field_186110_d.field_73012_v.nextFloat() * 360.0f, 0.0f);
        this.field_186110_d.func_72838_d(entityDragon);
        this.field_186119_m = entityDragon.func_110124_au();
        return entityDragon;
    }

    public void func_186099_b(EntityDragon entityDragon) {
        if (entityDragon.func_110124_au().equals(this.field_186119_m)) {
            this.field_186109_c.func_186735_a(entityDragon.func_110143_aJ() / entityDragon.func_110138_aP());
            this.field_186113_g = 0;
            if (entityDragon.func_145818_k_()) {
                this.field_186109_c.func_186739_a(entityDragon.func_145748_c_());
            }
        }
    }

    public int func_186092_c() {
        return this.field_186114_h;
    }

    public void func_186090_a(EntityEnderCrystal entityEnderCrystal, DamageSource damageSource) {
        if (this.field_186122_p != null && this.field_186124_r.contains(entityEnderCrystal)) {
            field_186107_a.debug("Aborting respawn sequence");
            this.field_186122_p = null;
            this.field_186123_q = 0;
            this.func_186087_f();
            this.func_186094_a(true);
        } else {
            this.func_186101_k();
            Entity entity = this.field_186110_d.func_175733_a(this.field_186119_m);
            if (entity instanceof EntityDragon) {
                ((EntityDragon)entity).func_184672_a(entityEnderCrystal, new BlockPos(entityEnderCrystal), damageSource);
            }
        }
    }

    public boolean func_186102_d() {
        return this.field_186118_l;
    }

    public void func_186106_e() {
        if (this.field_186117_k && this.field_186122_p == null) {
            Object object;
            BlockPos \u26032 = this.field_186121_o;
            if (\u26032 == null) {
                field_186107_a.debug("Tried to respawn, but need to find the portal first.");
                object = this.func_186091_h();
                if (object == null) {
                    field_186107_a.debug("Couldn't find a portal, so we made one.");
                    this.func_186094_a(true);
                } else {
                    field_186107_a.debug("Found the exit portal & temporarily using it.");
                }
                \u26032 = this.field_186121_o;
            }
            object = Lists.newArrayList();
            BlockPos \u26033 = \u26032.func_177981_b(1);
            for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                List<EntityEnderCrystal> list = this.field_186110_d.func_72872_a(EntityEnderCrystal.class, new AxisAlignedBB(\u26033.func_177967_a(enumFacing, 2)));
                if (list.isEmpty()) {
                    return;
                }
                object.addAll(list);
            }
            field_186107_a.debug("Found all crystals, respawning dragon.");
            this.func_186093_a((List<EntityEnderCrystal>)object);
        }
    }

    private void func_186093_a(List<EntityEnderCrystal> list2) {
        if (this.field_186117_k && this.field_186122_p == null) {
            List<EntityEnderCrystal> list2;
            BlockPattern.PatternHelper patternHelper = this.func_186091_h();
            while (patternHelper != null) {
                for (int i = 0; i < this.field_186112_f.func_177684_c(); ++i) {
                    for (\u2603 = 0; \u2603 < this.field_186112_f.func_177685_b(); ++\u2603) {
                        for (\u2603 = 0; \u2603 < this.field_186112_f.func_185922_a(); ++\u2603) {
                            BlockWorldState blockWorldState = patternHelper.func_177670_a(i, \u2603, \u2603);
                            if (blockWorldState.func_177509_a().func_177230_c() != Blocks.field_150357_h && blockWorldState.func_177509_a().func_177230_c() != Blocks.field_150384_bq) continue;
                            this.field_186110_d.func_175656_a(blockWorldState.func_177508_d(), Blocks.field_150377_bs.func_176223_P());
                        }
                    }
                }
                patternHelper = this.func_186091_h();
            }
            this.field_186122_p = DragonSpawnState.START;
            this.field_186123_q = 0;
            this.func_186094_a(false);
            this.field_186124_r = list2;
        }
    }

    public void func_186087_f() {
        for (EndCrystalTowerFeature.EndSpike endSpike : EndSpikes.func_202466_a(this.field_186110_d)) {
            List<EntityEnderCrystal> list = this.field_186110_d.func_72872_a(EntityEnderCrystal.class, endSpike.func_186153_f());
            for (EntityEnderCrystal entityEnderCrystal : list) {
                entityEnderCrystal.func_184224_h(false);
                entityEnderCrystal.func_184516_a(null);
            }
        }
    }

    class LoadManager {
        private LoadState field_210826_b = LoadState.UNKNOWN;

        private LoadManager() {
        }

        private boolean func_210824_a() {
            if (this.field_210826_b == LoadState.UNKNOWN) {
                this.field_210826_b = DragonFightManager.this.func_210832_a(-8, 8, -8, 8) ? LoadState.LOADED : LoadState.NOT_LOADED;
            }
            return this.field_210826_b == LoadState.LOADED;
        }
    }

    static enum LoadState {
        UNKNOWN,
        NOT_LOADED,
        LOADED;

    }
}

