/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.dimension;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.CheckerboardBiomeProvider;
import net.minecraft.world.biome.provider.CheckerboardBiomeProviderSettings;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorDebug;
import net.minecraft.world.gen.ChunkGeneratorEnd;
import net.minecraft.world.gen.ChunkGeneratorFlat;
import net.minecraft.world.gen.ChunkGeneratorNether;
import net.minecraft.world.gen.ChunkGeneratorOverworld;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.DebugGenSettings;
import net.minecraft.world.gen.EndGenSettings;
import net.minecraft.world.gen.FlatGenSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.IChunkGenSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.NetherGenSettings;
import net.minecraft.world.gen.OverworldGenSettings;

public class OverworldDimension
extends Dimension {
    @Override
    public DimensionType func_186058_p() {
        return DimensionType.OVERWORLD;
    }

    @Override
    public boolean func_186056_c(int n, int n2) {
        return !this.field_76579_a.func_72916_c(n, n2) && super.func_186056_c(n, n2);
    }

    @Override
    protected void func_76572_b() {
        this.field_191067_f = true;
    }

    public IChunkGenerator<? extends IChunkGenSettings> func_186060_c() {
        WorldType worldType = this.field_76579_a.func_72912_H().func_76067_t();
        ChunkGeneratorType<FlatGenSettings, ChunkGeneratorFlat> \u26032 = ChunkGeneratorType.field_205489_f;
        ChunkGeneratorType<DebugGenSettings, ChunkGeneratorDebug> \u26033 = ChunkGeneratorType.field_205488_e;
        ChunkGeneratorType<NetherGenSettings, ChunkGeneratorNether> \u26034 = ChunkGeneratorType.field_206912_c;
        ChunkGeneratorType<EndGenSettings, ChunkGeneratorEnd> \u26035 = ChunkGeneratorType.field_206913_d;
        ChunkGeneratorType<OverworldGenSettings, ChunkGeneratorOverworld> \u26036 = ChunkGeneratorType.field_206911_b;
        BiomeProviderType<SingleBiomeProviderSettings, SingleBiomeProvider> \u26037 = BiomeProviderType.field_205461_c;
        BiomeProviderType<OverworldBiomeProviderSettings, OverworldBiomeProvider> \u26038 = BiomeProviderType.field_206859_d;
        BiomeProviderType<CheckerboardBiomeProviderSettings, CheckerboardBiomeProvider> \u26039 = BiomeProviderType.field_205460_b;
        if (worldType == WorldType.field_77138_c) {
            FlatGenSettings flatGenSettings = FlatGenSettings.func_210835_a(new Dynamic((DynamicOps)NBTDynamicOps.field_210820_a, (Object)this.field_76579_a.func_72912_H().func_211027_A()));
            SingleBiomeProviderSettings \u260310 = \u26037.func_205458_a().func_205436_a(flatGenSettings.func_82648_a());
            return \u26032.create(this.field_76579_a, \u26037.func_205457_a(\u260310), flatGenSettings);
        }
        if (worldType == WorldType.field_180272_g) {
            SingleBiomeProviderSettings \u260311 = \u26037.func_205458_a().func_205436_a(Biomes.field_76772_c);
            return \u26033.create(this.field_76579_a, \u26037.func_205457_a(\u260311), \u26033.func_205483_a());
        }
        if (worldType == WorldType.field_205394_h) {
            Biome[] \u260316;
            IBlockState \u260315;
            Object object;
            BiomeProvider \u260312 = null;
            JsonElement \u260313 = (JsonElement)Dynamic.convert((DynamicOps)NBTDynamicOps.field_210820_a, (DynamicOps)JsonOps.INSTANCE, (Object)this.field_76579_a.func_72912_H().func_211027_A());
            JsonObject \u260314 = \u260313.getAsJsonObject();
            if (\u260314.has("biome_source") && \u260314.getAsJsonObject("biome_source").has("type") && \u260314.getAsJsonObject("biome_source").has("options")) {
                object = new ResourceLocation(\u260314.getAsJsonObject("biome_source").getAsJsonPrimitive("type").getAsString());
                \u260315 = \u260314.getAsJsonObject("biome_source").getAsJsonObject("options");
                \u260316 = new Biome[]{Biomes.field_76771_b};
                if (\u260315.has("biomes")) {
                    Biome[] biomeArray;
                    \u2603 = \u260315.getAsJsonArray("biomes");
                    if (\u2603.size() > 0) {
                        biomeArray = new Biome[\u2603.size()];
                    } else {
                        Biome[] biomeArray2 = new Biome[1];
                        biomeArray = biomeArray2;
                        biomeArray2[0] = Biomes.field_76771_b;
                    }
                    \u260316 = biomeArray;
                    for (int i = 0; i < \u2603.size(); ++i) {
                        Biome biome = IRegistry.field_212624_m.func_212608_b(new ResourceLocation(\u2603.get(i).getAsString()));
                        \u260316[i] = biome != null ? biome : Biomes.field_76771_b;
                    }
                }
                if (BiomeProviderType.field_205461_c.func_206858_b().equals(object)) {
                    \u2603 = \u26037.func_205458_a().func_205436_a(\u260316[0]);
                    \u260312 = \u26037.func_205457_a((SingleBiomeProviderSettings)\u2603);
                }
                if (BiomeProviderType.field_205460_b.func_206858_b().equals(object)) {
                    int n = \u260315.has("size") ? \u260315.getAsJsonPrimitive("size").getAsInt() : 2;
                    CheckerboardBiomeProviderSettings \u260317 = \u26039.func_205458_a().func_206860_a(\u260316).func_206861_a(n);
                    \u260312 = \u26039.func_205457_a(\u260317);
                }
                if (BiomeProviderType.field_206859_d.func_206858_b().equals(object)) {
                    OverworldBiomeProviderSettings \u260318 = \u26038.func_205458_a().func_205441_a(new OverworldGenSettings()).func_205439_a(this.field_76579_a.func_72912_H());
                    \u260312 = \u26038.func_205457_a(\u260318);
                }
            }
            if (\u260312 == null) {
                \u260312 = \u26037.func_205457_a(\u26037.func_205458_a().func_205436_a(Biomes.field_76771_b));
            }
            object = Blocks.field_150348_b.func_176223_P();
            \u260315 = Blocks.field_150355_j.func_176223_P();
            if (\u260314.has("chunk_generator") && \u260314.getAsJsonObject("chunk_generator").has("options")) {
                if (\u260314.getAsJsonObject("chunk_generator").getAsJsonObject("options").has("default_block") && (\u2603 = IRegistry.field_212618_g.func_82594_a(new ResourceLocation((String)(\u260316 = \u260314.getAsJsonObject("chunk_generator").getAsJsonObject("options").getAsJsonPrimitive("default_block").getAsString())))) != null) {
                    object = \u2603.func_176223_P();
                }
                if (\u260314.getAsJsonObject("chunk_generator").getAsJsonObject("options").has("default_fluid") && (\u2603 = IRegistry.field_212618_g.func_82594_a(new ResourceLocation((String)(\u260316 = \u260314.getAsJsonObject("chunk_generator").getAsJsonObject("options").getAsJsonPrimitive("default_fluid").getAsString())))) != null) {
                    \u260315 = \u2603.func_176223_P();
                }
            }
            if (\u260314.has("chunk_generator") && \u260314.getAsJsonObject("chunk_generator").has("type")) {
                \u260316 = new ResourceLocation(\u260314.getAsJsonObject("chunk_generator").getAsJsonPrimitive("type").getAsString());
                if (ChunkGeneratorType.field_206912_c.func_205482_c().equals(\u260316)) {
                    NetherGenSettings netherGenSettings = \u26034.func_205483_a();
                    netherGenSettings.func_205535_a((IBlockState)object);
                    netherGenSettings.func_205534_b(\u260315);
                    return \u26034.create(this.field_76579_a, \u260312, netherGenSettings);
                }
                if (ChunkGeneratorType.field_206913_d.func_205482_c().equals(\u260316)) {
                    EndGenSettings endGenSettings = \u26035.func_205483_a();
                    endGenSettings.func_205538_a(new BlockPos(0, 64, 0));
                    endGenSettings.func_205535_a((IBlockState)object);
                    endGenSettings.func_205534_b(\u260315);
                    return \u26035.create(this.field_76579_a, \u260312, endGenSettings);
                }
            }
            \u260316 = \u26036.func_205483_a();
            \u260316.func_205535_a((IBlockState)object);
            \u260316.func_205534_b(\u260315);
            return \u26036.create(this.field_76579_a, \u260312, (OverworldGenSettings)\u260316);
        }
        OverworldGenSettings overworldGenSettings = \u26036.func_205483_a();
        OverworldBiomeProviderSettings \u260319 = \u26038.func_205458_a().func_205439_a(this.field_76579_a.func_72912_H()).func_205441_a(overworldGenSettings);
        return \u26036.create(this.field_76579_a, \u26038.func_205457_a(\u260319), overworldGenSettings);
    }

    @Override
    @Nullable
    public BlockPos func_206920_a(ChunkPos chunkPos, boolean bl) {
        for (int i = chunkPos.func_180334_c(); i <= chunkPos.func_180332_e(); ++i) {
            for (\u2603 = chunkPos.func_180333_d(); \u2603 <= chunkPos.func_180330_f(); ++\u2603) {
                BlockPos blockPos = this.func_206921_a(i, \u2603, bl);
                if (blockPos == null) continue;
                return blockPos;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public BlockPos func_206921_a(int n, int n2, boolean bl) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(n, 0, n2);
        Biome \u26032 = this.field_76579_a.func_180494_b(mutableBlockPos);
        IBlockState \u26033 = \u26032.func_203944_q().func_204108_a();
        if (bl && !\u26033.func_177230_c().func_203417_a(BlockTags.field_205599_H)) {
            return null;
        }
        Chunk \u26034 = this.field_76579_a.func_72964_e(n >> 4, n2 >> 4);
        int \u26035 = \u26034.func_201576_a(Heightmap.Type.MOTION_BLOCKING, n & 0xF, n2 & 0xF);
        if (\u26035 < 0) {
            return null;
        }
        if (\u26034.func_201576_a(Heightmap.Type.WORLD_SURFACE, n & 0xF, n2 & 0xF) > \u26034.func_201576_a(Heightmap.Type.OCEAN_FLOOR, n & 0xF, n2 & 0xF)) {
            return null;
        }
        for (int i = \u26035 + 1; i >= 0; --i) {
            mutableBlockPos.func_181079_c(n, i, n2);
            IBlockState iBlockState = this.field_76579_a.func_180495_p(mutableBlockPos);
            if (!iBlockState.func_204520_s().func_206888_e()) break;
            if (!iBlockState.equals(\u26033)) continue;
            return mutableBlockPos.func_177984_a().func_185334_h();
        }
        return null;
    }

    @Override
    public float func_76563_a(long l, float f) {
        int n = (int)(l % 24000L);
        float \u26032 = ((float)n + f) / 24000.0f - 0.25f;
        if (\u26032 < 0.0f) {
            \u26032 += 1.0f;
        }
        if (\u26032 > 1.0f) {
            \u26032 -= 1.0f;
        }
        float \u26033 = \u26032;
        \u26032 = 1.0f - (float)((Math.cos((double)\u26032 * Math.PI) + 1.0) / 2.0);
        \u26032 = \u26033 + (\u26032 - \u26033) / 3.0f;
        return \u26032;
    }

    @Override
    public boolean func_76569_d() {
        return true;
    }

    @Override
    public boolean func_76567_e() {
        return true;
    }
}

