/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk.storage;

import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.IProgressUpdate;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.OverworldBiomeProvider;
import net.minecraft.world.biome.provider.OverworldBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProvider;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.chunk.storage.AnvilSaveHandler;
import net.minecraft.world.chunk.storage.ChunkLoader;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.SaveFormatOld;
import net.minecraft.world.storage.WorldInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AnvilSaveConverter
extends SaveFormatOld {
    private static final Logger field_151480_b = LogManager.getLogger();

    public AnvilSaveConverter(Path path, Path path2, DataFixer dataFixer) {
        super(path, path2, dataFixer);
    }

    protected int func_75812_c() {
        return 19133;
    }

    @Override
    public ISaveHandler func_197715_a(String string, @Nullable MinecraftServer minecraftServer) {
        return new AnvilSaveHandler(this.field_75808_a.toFile(), string, minecraftServer, this.field_186354_b);
    }

    @Override
    public boolean func_75801_b(String string) {
        WorldInfo worldInfo = this.func_75803_c(string);
        return worldInfo != null && worldInfo.func_76088_k() != this.func_75812_c();
    }

    @Override
    public boolean func_75805_a(String string, IProgressUpdate iProgressUpdate) {
        iProgressUpdate.func_73718_a(0);
        ArrayList arrayList = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        \u2603 = Lists.newArrayList();
        File \u26032 = new File(this.field_75808_a.toFile(), string);
        File \u26033 = DimensionType.NETHER.func_212679_a(\u26032);
        File \u26034 = DimensionType.THE_END.func_212679_a(\u26032);
        field_151480_b.info("Scanning folders...");
        this.func_75810_a(\u26032, arrayList);
        if (\u26033.exists()) {
            this.func_75810_a(\u26033, \u2603);
        }
        if (\u26034.exists()) {
            this.func_75810_a(\u26034, \u2603);
        }
        int \u26035 = arrayList.size() + \u2603.size() + \u2603.size();
        field_151480_b.info("Total conversion count is {}", (Object)\u26035);
        WorldInfo \u26036 = this.func_75803_c(string);
        BiomeProviderType<SingleBiomeProviderSettings, SingleBiomeProvider> \u26037 = BiomeProviderType.field_205461_c;
        BiomeProviderType<OverworldBiomeProviderSettings, OverworldBiomeProvider> \u26038 = BiomeProviderType.field_206859_d;
        BiomeProvider \u26039 = \u26036 != null && \u26036.func_76067_t() == WorldType.field_77138_c ? \u26037.func_205457_a(\u26037.func_205458_a().func_205436_a(Biomes.field_76772_c)) : \u26038.func_205457_a(\u26038.func_205458_a().func_205439_a(\u26036).func_205441_a(ChunkGeneratorType.field_206911_b.func_205483_a()));
        this.func_75813_a(new File(\u26032, "region"), arrayList, \u26039, 0, \u26035, iProgressUpdate);
        this.func_75813_a(new File(\u26033, "region"), \u2603, \u26037.func_205457_a(\u26037.func_205458_a().func_205436_a(Biomes.field_76778_j)), arrayList.size(), \u26035, iProgressUpdate);
        this.func_75813_a(new File(\u26034, "region"), \u2603, \u26037.func_205457_a(\u26037.func_205458_a().func_205436_a(Biomes.field_76779_k)), arrayList.size() + \u2603.size(), \u26035, iProgressUpdate);
        \u26036.func_76078_e(19133);
        if (\u26036.func_76067_t() == WorldType.field_77136_e) {
            \u26036.func_76085_a(WorldType.field_77137_b);
        }
        this.func_75809_f(string);
        ISaveHandler \u260310 = this.func_197715_a(string, null);
        \u260310.func_75761_a(\u26036);
        return true;
    }

    private void func_75809_f(String string) {
        File file = new File(this.field_75808_a.toFile(), string);
        if (!file.exists()) {
            field_151480_b.warn("Unable to create level.dat_mcr backup");
            return;
        }
        \u2603 = new File(file, "level.dat");
        if (!\u2603.exists()) {
            field_151480_b.warn("Unable to create level.dat_mcr backup");
            return;
        }
        \u2603 = new File(file, "level.dat_mcr");
        if (!\u2603.renameTo(\u2603)) {
            field_151480_b.warn("Unable to create level.dat_mcr backup");
        }
    }

    private void func_75813_a(File file, Iterable<File> iterable, BiomeProvider biomeProvider, int n, int n2, IProgressUpdate iProgressUpdate) {
        for (File file2 : iterable) {
            this.func_75811_a(file, file2, biomeProvider, n, n2, iProgressUpdate);
            int n3 = (int)Math.round(100.0 * (double)(++n) / (double)n2);
            iProgressUpdate.func_73718_a(n3);
        }
    }

    private void func_75811_a(File file, File file2, BiomeProvider biomeProvider, int n, int n2, IProgressUpdate iProgressUpdate) {
        try {
            String string = file2.getName();
            RegionFile \u26032 = new RegionFile(file2);
            RegionFile \u26033 = new RegionFile(new File(file, string.substring(0, string.length() - ".mcr".length()) + ".mca"));
            for (int i = 0; i < 32; ++i) {
                for (n3 = 0; n3 < 32; ++n3) {
                    if (!\u26032.func_76709_c(i, n3) || \u26033.func_76709_c(i, n3)) continue;
                    DataInputStream dataInputStream = \u26032.func_76704_a(i, n3);
                    if (dataInputStream == null) {
                        field_151480_b.warn("Failed to fetch input stream");
                        continue;
                    }
                    NBTTagCompound \u26034 = CompressedStreamTools.func_74794_a(dataInputStream);
                    dataInputStream.close();
                    NBTTagCompound \u26035 = \u26034.func_74775_l("Level");
                    ChunkLoader.AnvilConverterData \u26036 = ChunkLoader.func_76691_a(\u26035);
                    NBTTagCompound \u26037 = new NBTTagCompound();
                    NBTTagCompound \u26038 = new NBTTagCompound();
                    \u26037.func_74782_a("Level", \u26038);
                    ChunkLoader.func_76690_a(\u26036, \u26038, biomeProvider);
                    DataOutputStream \u26039 = \u26033.func_76710_b(i, n3);
                    CompressedStreamTools.func_74800_a(\u26037, \u26039);
                    \u26039.close();
                }
                int n3 = (int)Math.round(100.0 * (double)(n * 1024) / (double)(n2 * 1024));
                \u2603 = (int)Math.round(100.0 * (double)((i + 1) * 32 + n * 1024) / (double)(n2 * 1024));
                if (\u2603 <= n3) continue;
                iProgressUpdate.func_73718_a(\u2603);
            }
            \u26032.func_76708_c();
            \u26033.func_76708_c();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void func_75810_a(File file2, Collection<File> collection) {
        File file3 = new File(file2, "region");
        File[] \u26032 = file3.listFiles((file, string) -> string.endsWith(".mcr"));
        if (\u26032 != null) {
            Collections.addAll(collection, \u26032);
        }
    }
}

