/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.util.ITaskType;
import net.minecraft.util.Util;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.tasks.BaseChunkTask;
import net.minecraft.world.gen.tasks.CarveChunkTask;
import net.minecraft.world.gen.tasks.ChunkTask;
import net.minecraft.world.gen.tasks.DecorateChunkTask;
import net.minecraft.world.gen.tasks.DummyChunkTask;
import net.minecraft.world.gen.tasks.FinializeChunkTask;
import net.minecraft.world.gen.tasks.LightChunkTask;
import net.minecraft.world.gen.tasks.LiquidCarveChunkTask;
import net.minecraft.world.gen.tasks.SpawnMobsTask;

public enum ChunkStatus implements ITaskType<ChunkPos, ChunkStatus>
{
    EMPTY("empty", null, -1, false, Type.PROTOCHUNK),
    BASE("base", new BaseChunkTask(), 0, false, Type.PROTOCHUNK),
    CARVED("carved", new CarveChunkTask(), 0, false, Type.PROTOCHUNK),
    LIQUID_CARVED("liquid_carved", new LiquidCarveChunkTask(), 1, false, Type.PROTOCHUNK),
    DECORATED("decorated", new DecorateChunkTask(), 1, true, Type.PROTOCHUNK){

        @Override
        public void func_201492_a_(ChunkPos chunkPos, BiConsumer<ChunkPos, ChunkStatus> biConsumer) {
            ChunkPos chunkPos2;
            int n = chunkPos.field_77276_a;
            \u2603 = chunkPos.field_77275_b;
            ITaskType \u26032 = this.func_201497_a_();
            \u2603 = 8;
            for (i = n - 8; i <= n + 8; ++i) {
                if (i >= n - 1 && i <= n + 1) continue;
                for (\u2603 = \u2603 - 8; \u2603 <= \u2603 + 8; ++\u2603) {
                    if (\u2603 >= \u2603 - 1 && \u2603 <= \u2603 + 1) continue;
                    chunkPos2 = new ChunkPos(i, \u2603);
                    biConsumer.accept(chunkPos2, EMPTY);
                }
            }
            for (int i = n - 1; i <= n + 1; ++i) {
                for (\u2603 = \u2603 - 1; \u2603 <= \u2603 + 1; ++\u2603) {
                    chunkPos2 = new ChunkPos(i, \u2603);
                    biConsumer.accept(chunkPos2, (ChunkStatus)\u26032);
                }
            }
        }

        @Override
        @Nullable
        public /* synthetic */ ITaskType func_201497_a_() {
            return super.func_201497_a_();
        }
    }
    ,
    LIGHTED("lighted", new LightChunkTask(), 1, true, Type.PROTOCHUNK),
    MOBS_SPAWNED("mobs_spawned", new SpawnMobsTask(), 0, true, Type.PROTOCHUNK),
    FINALIZED("finalized", new FinializeChunkTask(), 0, true, Type.PROTOCHUNK),
    FULLCHUNK("fullchunk", new DummyChunkTask(), 0, true, Type.LEVELCHUNK),
    POSTPROCESSED("postprocessed", new DummyChunkTask(), 0, true, Type.LEVELCHUNK);

    private static final Map<String, ChunkStatus> field_202131_k;
    private final String field_202130_j;
    @Nullable
    private final ChunkTask field_202132_l;
    private final int field_202133_m;
    private final Type field_202134_n;
    private final boolean field_207795_p;

    private ChunkStatus(String string2, @Nullable ChunkTask chunkTask, int n2, boolean bl, Type type) {
        this.field_202130_j = string2;
        this.field_202132_l = chunkTask;
        this.field_202133_m = n2;
        this.field_202134_n = type;
        this.field_207795_p = bl;
    }

    public String func_202125_b() {
        return this.field_202130_j;
    }

    public ChunkPrimer func_202126_a(World world, IChunkGenerator<?> iChunkGenerator, Map<ChunkPos, ChunkPrimer> map, int n, int n2) {
        return this.field_202132_l.func_202839_a(this, world, iChunkGenerator, map, n, n2);
    }

    @Override
    public void func_201492_a_(ChunkPos chunkPos, BiConsumer<ChunkPos, ChunkStatus> biConsumer) {
        int n = chunkPos.field_77276_a;
        \u2603 = chunkPos.field_77275_b;
        ChunkStatus \u26032 = this.func_201497_a_();
        for (\u2603 = n - this.field_202133_m; \u2603 <= n + this.field_202133_m; ++\u2603) {
            for (\u2603 = \u2603 - this.field_202133_m; \u2603 <= \u2603 + this.field_202133_m; ++\u2603) {
                biConsumer.accept(new ChunkPos(\u2603, \u2603), \u26032);
            }
        }
    }

    public int func_202128_c() {
        return this.field_202133_m;
    }

    public Type func_202129_d() {
        return this.field_202134_n;
    }

    @Nullable
    public static ChunkStatus func_202127_a(String string) {
        return field_202131_k.get(string);
    }

    @Override
    @Nullable
    public ChunkStatus func_201497_a_() {
        if (this.ordinal() == 0) {
            return null;
        }
        return ChunkStatus.values()[this.ordinal() - 1];
    }

    public boolean func_207794_f() {
        return this.field_207795_p;
    }

    public boolean func_209003_a(ChunkStatus chunkStatus) {
        return this.ordinal() >= chunkStatus.ordinal();
    }

    @Override
    @Nullable
    public /* synthetic */ ITaskType func_201497_a_() {
        return this.func_201497_a_();
    }

    static {
        field_202131_k = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
            for (ChunkStatus chunkStatus : ChunkStatus.values()) {
                hashMap.put(chunkStatus.func_202125_b(), chunkStatus);
            }
        });
    }

    public static enum Type {
        PROTOCHUNK,
        LEVELCHUNK;

    }
}

