/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.biome;

import com.google.common.collect.Lists;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.init.Fluids;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.BushConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.IcebergConfig;
import net.minecraft.world.gen.feature.LakesConfig;
import net.minecraft.world.gen.feature.LiquidsConfig;
import net.minecraft.world.gen.feature.MinableConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.RandomDefaultFeatureListConfig;
import net.minecraft.world.gen.feature.SphereReplaceConfig;
import net.minecraft.world.gen.feature.TallGrassConfig;
import net.minecraft.world.gen.feature.structure.MineshaftConfig;
import net.minecraft.world.gen.feature.structure.MineshaftStructure;
import net.minecraft.world.gen.feature.structure.OceanRuinConfig;
import net.minecraft.world.gen.feature.structure.OceanRuinStructure;
import net.minecraft.world.gen.feature.structure.ShipwreckConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.DungeonRoomConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.LakeChanceConfig;
import net.minecraft.world.gen.surfacebuilders.CompositeSurfaceBuilder;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilderConfig;

public final class FrozenOceanBiome
extends Biome {
    protected static final NoiseGeneratorPerlin field_205163_aV = new NoiseGeneratorPerlin(new Random(3456L), 3);

    public FrozenOceanBiome() {
        super(new Biome.BiomeBuilder().func_205416_a(new CompositeSurfaceBuilder<SurfaceBuilderConfig>(field_205160_ax, field_203961_Z)).func_205415_a(Biome.RainType.SNOW).func_205419_a(Biome.Category.OCEAN).func_205421_a(-1.0f).func_205420_b(0.1f).func_205414_c(0.0f).func_205417_d(0.5f).func_205412_a(3750089).func_205413_b(329011).func_205418_a(null));
        this.func_201865_a(Feature.field_204029_o, new OceanRuinConfig(OceanRuinStructure.Type.COLD, 0.3f, 0.9f));
        this.func_201865_a(Feature.field_202329_g, new MineshaftConfig(0.004, MineshaftStructure.Type.NORMAL));
        this.func_201865_a(Feature.field_204751_l, new ShipwreckConfig(false));
        this.func_203609_a(GenerationStage.Carving.AIR, FrozenOceanBiome.func_203606_a(field_201907_b, new ProbabilityConfig(0.06666667f)));
        this.func_203609_a(GenerationStage.Carving.AIR, FrozenOceanBiome.func_203606_a(field_201909_d, new ProbabilityConfig(0.02f)));
        this.func_203609_a(GenerationStage.Carving.LIQUID, FrozenOceanBiome.func_203606_a(field_203612_e, new ProbabilityConfig(0.02f)));
        this.func_203609_a(GenerationStage.Carving.LIQUID, FrozenOceanBiome.func_203606_a(field_203613_f, new ProbabilityConfig(0.06666667f)));
        this.func_203605_a();
        this.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, FrozenOceanBiome.func_201864_a(Feature.field_202289_ai, new LakesConfig(Blocks.field_150355_j), field_201884_D, new LakeChanceConfig(4)));
        this.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, FrozenOceanBiome.func_201864_a(Feature.field_202289_ai, new LakesConfig(Blocks.field_150353_l), field_201883_C, new LakeChanceConfig(80)));
        this.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, FrozenOceanBiome.func_201864_a(Feature.field_205172_ag, new IcebergConfig(Blocks.field_150403_cj.func_176223_P()), field_205161_N, new ChanceConfig(16)));
        this.func_203611_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, FrozenOceanBiome.func_201864_a(Feature.field_205172_ag, new IcebergConfig(Blocks.field_205164_gk.func_176223_P()), field_205161_N, new ChanceConfig(200)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_STRUCTURES, FrozenOceanBiome.func_201864_a(Feature.field_202282_ab, IFeatureConfig.field_202429_e, field_201885_E, new DungeonRoomConfig(8)));
        this.func_203611_a(GenerationStage.Decoration.SURFACE_STRUCTURES, FrozenOceanBiome.func_201864_a(Feature.field_205171_af, IFeatureConfig.field_202429_e, field_205162_x, new CountRangeConfig(20, 30, 32, 64)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_150346_d.func_176223_P(), 33), field_201923_r, new CountRangeConfig(10, 0, 0, 256)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_150351_n.func_176223_P(), 33), field_201923_r, new CountRangeConfig(8, 0, 0, 256)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_196650_c.func_176223_P(), 33), field_201923_r, new CountRangeConfig(10, 0, 0, 80)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_196654_e.func_176223_P(), 33), field_201923_r, new CountRangeConfig(10, 0, 0, 80)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_196656_g.func_176223_P(), 33), field_201923_r, new CountRangeConfig(10, 0, 0, 80)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_150365_q.func_176223_P(), 17), field_201923_r, new CountRangeConfig(20, 0, 0, 128)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_150366_p.func_176223_P(), 9), field_201923_r, new CountRangeConfig(20, 0, 0, 64)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_150352_o.func_176223_P(), 9), field_201923_r, new CountRangeConfig(2, 0, 0, 32)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_150450_ax.func_176223_P(), 8), field_201923_r, new CountRangeConfig(8, 0, 0, 16)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_150482_ag.func_176223_P(), 8), field_201923_r, new CountRangeConfig(1, 0, 0, 16)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202290_aj, new MinableConfig(MinableConfig.field_202441_a, Blocks.field_150369_x.func_176223_P(), 7), field_201929_x, new DepthAverageConfig(1, 16, 16)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202285_ae, new SphereReplaceConfig(Blocks.field_150354_m, 7, 2, Lists.newArrayList((Object[])new Block[]{Blocks.field_150346_d, Blocks.field_196658_i})), field_201911_f, new FrequencyConfig(3)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202285_ae, new SphereReplaceConfig(Blocks.field_150435_aG, 4, 1, Lists.newArrayList((Object[])new Block[]{Blocks.field_150346_d, Blocks.field_150435_aG})), field_201911_f, new FrequencyConfig(1)));
        this.func_203611_a(GenerationStage.Decoration.UNDERGROUND_ORES, FrozenOceanBiome.func_201864_a(Feature.field_202285_ae, new SphereReplaceConfig(Blocks.field_150351_n, 6, 2, Lists.newArrayList((Object[])new Block[]{Blocks.field_150346_d, Blocks.field_196658_i})), field_201911_f, new FrequencyConfig(1)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201864_a(Feature.field_202292_al, new RandomDefaultFeatureListConfig(new Feature[]{Feature.field_202339_q}, new IFeatureConfig[]{IFeatureConfig.field_202429_e}, new float[]{0.1f}, Feature.field_202301_A, IFeatureConfig.field_202429_e), field_201922_q, new AtSurfaceWithExtraConfig(0, 0.1f, 1)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201861_a(Feature.field_202305_E, field_201912_g, new FrequencyConfig(2)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201864_a(Feature.field_202311_K, new TallGrassConfig(Blocks.field_150349_c.func_176223_P()), field_201913_h, new FrequencyConfig(1)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201864_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150338_P), field_201920_o, new ChanceConfig(4)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201864_a(Feature.field_202284_ad, new BushConfig(Blocks.field_150337_Q), field_201920_o, new ChanceConfig(8)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201864_a(Feature.field_202324_X, IFeatureConfig.field_202429_e, field_201913_h, new FrequencyConfig(10)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201864_a(Feature.field_202323_W, IFeatureConfig.field_202429_e, field_201920_o, new ChanceConfig(32)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201864_a(Feature.field_202295_ao, new LiquidsConfig(Fluids.field_204546_a), field_201924_s, new CountRangeConfig(50, 8, 8, 256)));
        this.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, FrozenOceanBiome.func_201864_a(Feature.field_202295_ao, new LiquidsConfig(Fluids.field_204547_b), field_201925_t, new CountRangeConfig(20, 8, 16, 256)));
        this.func_203611_a(GenerationStage.Decoration.TOP_LAYER_MODIFICATION, FrozenOceanBiome.func_201864_a(Feature.field_202325_Y, IFeatureConfig.field_202429_e, field_201917_l, IPlacementConfig.field_202468_e));
        this.func_201866_a(EnumCreatureType.WATER_CREATURE, new Biome.SpawnListEntry(EntityType.field_200749_ao, 1, 1, 4));
        this.func_201866_a(EnumCreatureType.WATER_CREATURE, new Biome.SpawnListEntry(EntityType.field_203778_ae, 15, 1, 5));
        this.func_201866_a(EnumCreatureType.CREATURE, new Biome.SpawnListEntry(EntityType.field_200786_Z, 1, 1, 2));
        this.func_201866_a(EnumCreatureType.AMBIENT, new Biome.SpawnListEntry(EntityType.field_200791_e, 10, 8, 8));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_200748_an, 100, 4, 4));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_200725_aD, 95, 4, 4));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_204724_o, 5, 1, 1));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_200727_aF, 5, 1, 1));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_200741_ag, 100, 4, 4));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_200797_k, 100, 4, 4));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_200743_ai, 100, 4, 4));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_200803_q, 10, 1, 4));
        this.func_201866_a(EnumCreatureType.MONSTER, new Biome.SpawnListEntry(EntityType.field_200759_ay, 5, 1, 1));
    }

    @Override
    public float func_180626_a(BlockPos blockPos) {
        float f = this.func_185353_n();
        double \u26032 = field_205163_aV.func_151601_a((double)blockPos.func_177958_n() * 0.05, (double)blockPos.func_177952_p() * 0.05);
        double \u26033 = \u26032 + (\u2603 = field_180281_af.func_151601_a((double)blockPos.func_177958_n() * 0.2, (double)blockPos.func_177952_p() * 0.2));
        if (\u26033 < 0.3 && (\u2603 = field_180281_af.func_151601_a((double)blockPos.func_177958_n() * 0.09, (double)blockPos.func_177952_p() * 0.09)) < 0.8) {
            f = 0.2f;
        }
        if (blockPos.func_177956_o() > 64) {
            \u2603 = (float)(field_150605_ac.func_151601_a((float)blockPos.func_177958_n() / 8.0f, (float)blockPos.func_177952_p() / 8.0f) * 4.0);
            return f - (\u2603 + (float)blockPos.func_177956_o() - 64.0f) * 0.05f / 30.0f;
        }
        return f;
    }
}

