/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.pathfinding.PathType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class WorldEntitySpawner {
    private static final Logger field_209383_a = LogManager.getLogger();
    private static final int field_180268_a = (int)Math.pow(17.0, 2.0);
    private final Set<ChunkPos> field_77193_b = Sets.newHashSet();

    public int func_77192_a(WorldServer worldServer2, boolean bl, boolean bl2, boolean bl3) {
        Object \u26033;
        Object \u260322;
        if (!bl && !bl2) {
            return 0;
        }
        this.field_77193_b.clear();
        int n = 0;
        for (Object \u260322 : worldServer2.field_73010_i) {
            if (((EntityPlayer)\u260322).func_175149_v()) continue;
            int n2 = MathHelper.func_76128_c(((EntityPlayer)\u260322).field_70165_t / 16.0);
            \u2603 = MathHelper.func_76128_c(((EntityPlayer)\u260322).field_70161_v / 16.0);
            \u2603 = 8;
            for (\u2603 = -8; \u2603 <= 8; ++\u2603) {
                for (n4 = -8; n4 <= 8; ++n4) {
                    \u2603 = \u2603 == -8 || \u2603 == 8 || n4 == -8 || n4 == 8 ? 1 : 0;
                    \u26033 = new ChunkPos(\u2603 + n2, n4 + \u2603);
                    if (this.field_77193_b.contains(\u26033)) continue;
                    ++n;
                    if (\u2603 != 0 || !worldServer2.func_175723_af().func_177730_a((ChunkPos)\u26033) || (\u2603 = worldServer2.func_184164_w().func_187301_b(((ChunkPos)\u26033).field_77276_a, ((ChunkPos)\u26033).field_77275_b)) == null || !\u2603.func_187274_e()) continue;
                    this.field_77193_b.add((ChunkPos)\u26033);
                }
            }
        }
        int n3 = 0;
        \u260322 = worldServer2.func_175694_M();
        for (EnumCreatureType enumCreatureType : EnumCreatureType.values()) {
            if (enumCreatureType.func_75599_d() && !bl2 || !enumCreatureType.func_75599_d() && !bl || enumCreatureType.func_82705_e() && !bl3) continue;
            int n4 = enumCreatureType.func_75601_b() * n / field_180268_a;
            \u2603 = worldServer2.func_72907_a(enumCreatureType.func_75598_a(), n4);
            if (\u2603 > n4) continue;
            \u26033 = new BlockPos.MutableBlockPos();
            block6: for (ChunkPos chunkPos : this.field_77193_b) {
                BlockPos blockPos = WorldEntitySpawner.func_180621_a(worldServer2, chunkPos.field_77276_a, chunkPos.field_77275_b);
                int \u26034 = blockPos.func_177958_n();
                int \u26035 = blockPos.func_177956_o();
                int \u26036 = blockPos.func_177952_p();
                IBlockState \u26037 = worldServer2.func_180495_p(blockPos);
                if (\u26037.func_185915_l()) continue;
                int \u26038 = 0;
                block7: for (int i = 0; i < 3; ++i) {
                    \u2603 = \u26034;
                    \u2603 = \u26035;
                    \u2603 = \u26036;
                    \u2603 = 6;
                    Biome.SpawnListEntry spawnListEntry = null;
                    IEntityLivingData \u26039 = null;
                    int \u260310 = MathHelper.func_76143_f(Math.random() * 4.0);
                    int \u260311 = 0;
                    for (int j = 0; j < \u260310; ++j) {
                        WorldServer worldServer2;
                        ((BlockPos.MutableBlockPos)\u26033).func_181079_c(\u2603 += worldServer2.field_73012_v.nextInt(6) - worldServer2.field_73012_v.nextInt(6), \u2603 += worldServer2.field_73012_v.nextInt(1) - worldServer2.field_73012_v.nextInt(1), \u2603 += worldServer2.field_73012_v.nextInt(6) - worldServer2.field_73012_v.nextInt(6));
                        float f = (float)\u2603 + 0.5f;
                        \u2603 = (float)\u2603 + 0.5f;
                        EntityPlayer \u260312 = worldServer2.func_212817_a(f, \u2603, -1.0);
                        if (\u260312 == null || (\u2603 = \u260312.func_70092_e(f, \u2603, \u2603)) <= 576.0 || ((Vec3i)\u260322).func_177954_c(f, \u2603, \u2603) < 576.0) continue;
                        if (spawnListEntry == null) {
                            spawnListEntry = worldServer2.func_175734_a(enumCreatureType, (BlockPos)\u26033);
                            if (spawnListEntry == null) continue block7;
                            \u260310 = spawnListEntry.field_76301_c + worldServer2.field_73012_v.nextInt(1 + spawnListEntry.field_76299_d - spawnListEntry.field_76301_c);
                        }
                        if (!worldServer2.func_175732_a(enumCreatureType, spawnListEntry, (BlockPos)\u26033) || (\u2603 = EntitySpawnPlacementRegistry.func_209344_a(spawnListEntry.field_200702_b)) == null || !WorldEntitySpawner.func_209382_a(\u2603, worldServer2, (BlockPos)\u26033, spawnListEntry.field_200702_b)) continue;
                        try {
                            EntityLiving entityLiving = spawnListEntry.field_200702_b.func_200721_a(worldServer2);
                        }
                        catch (Exception exception) {
                            field_209383_a.warn("Failed to create mob", (Throwable)exception);
                            return n3;
                        }
                        entityLiving.func_70012_b(f, \u2603, \u2603, worldServer2.field_73012_v.nextFloat() * 360.0f, 0.0f);
                        if ((\u2603 <= 16384.0 || !entityLiving.func_70692_ba()) && entityLiving.func_205020_a(worldServer2, false) && entityLiving.func_205019_a(worldServer2)) {
                            \u26039 = entityLiving.func_204210_a(worldServer2.func_175649_E(new BlockPos(entityLiving)), \u26039, null);
                            if (entityLiving.func_205019_a(worldServer2)) {
                                ++\u26038;
                                ++\u260311;
                                worldServer2.func_72838_d(entityLiving);
                            } else {
                                entityLiving.func_70106_y();
                            }
                            if (\u26038 >= entityLiving.func_70641_bl()) continue block6;
                            if (entityLiving.func_204209_c(\u260311)) continue block7;
                        }
                        n3 += \u26038;
                    }
                }
            }
        }
        return n3;
    }

    private static BlockPos func_180621_a(World world, int n, int n2) {
        Chunk chunk = world.func_72964_e(n, n2);
        int \u26032 = n * 16 + world.field_73012_v.nextInt(16);
        int \u26033 = n2 * 16 + world.field_73012_v.nextInt(16);
        int \u26034 = chunk.func_201576_a(Heightmap.Type.LIGHT_BLOCKING, \u26032, \u26033) + 1;
        int \u26035 = world.field_73012_v.nextInt(\u26034 + 1);
        return new BlockPos(\u26032, \u26035, \u26033);
    }

    public static boolean func_206851_a(IBlockState iBlockState, IFluidState iFluidState) {
        if (iBlockState.func_185898_k()) {
            return false;
        }
        if (iBlockState.func_185897_m()) {
            return false;
        }
        if (!iFluidState.func_206888_e()) {
            return false;
        }
        return !iBlockState.func_203425_a(BlockTags.field_203437_y);
    }

    public static boolean func_209382_a(EntitySpawnPlacementRegistry.SpawnPlacementType spawnPlacementType, IWorldReaderBase iWorldReaderBase, BlockPos blockPos, @Nullable EntityType<? extends EntityLiving> entityType) {
        if (entityType == null || !iWorldReaderBase.func_175723_af().func_177746_a(blockPos)) {
            return false;
        }
        IBlockState iBlockState = iWorldReaderBase.func_180495_p(blockPos);
        IFluidState \u26032 = iWorldReaderBase.func_204610_c(blockPos);
        switch (spawnPlacementType) {
            case IN_WATER: {
                return \u26032.func_206884_a(FluidTags.field_206959_a) && iWorldReaderBase.func_204610_c(blockPos.func_177977_b()).func_206884_a(FluidTags.field_206959_a) && !iWorldReaderBase.func_180495_p(blockPos.func_177984_a()).func_185915_l();
            }
        }
        \u2603 = iWorldReaderBase.func_180495_p(blockPos.func_177977_b());
        if (!(\u2603.func_185896_q() || entityType != null && EntitySpawnPlacementRegistry.func_209345_a(entityType, \u2603))) {
            return false;
        }
        Block \u26033 = \u2603.func_177230_c();
        boolean \u26034 = \u26033 != Blocks.field_150357_h && \u26033 != Blocks.field_180401_cv;
        return \u26034 && WorldEntitySpawner.func_206851_a(iBlockState, \u26032) && WorldEntitySpawner.func_206851_a(iWorldReaderBase.func_180495_p(blockPos.func_177984_a()), iWorldReaderBase.func_204610_c(blockPos.func_177984_a()));
    }

    public static void func_77191_a(IWorld iWorld, Biome biome, int n, int n2, Random random2) {
        List<Biome.SpawnListEntry> list = biome.func_76747_a(EnumCreatureType.CREATURE);
        if (list.isEmpty()) {
            return;
        }
        int \u26032 = n << 4;
        int \u26033 = n2 << 4;
        while (random2.nextFloat() < biome.func_76741_f()) {
            Biome.SpawnListEntry spawnListEntry = WeightedRandom.func_76271_a(random2, list);
            int \u26034 = spawnListEntry.field_76301_c + random2.nextInt(1 + spawnListEntry.field_76299_d - spawnListEntry.field_76301_c);
            IEntityLivingData \u26035 = null;
            int \u26036 = \u26032 + random2.nextInt(16);
            int \u26037 = \u26033 + random2.nextInt(16);
            int \u26038 = \u26036;
            int \u26039 = \u26037;
            for (int i = 0; i < \u26034; ++i) {
                boolean bl = false;
                for (int j = 0; !bl && j < 4; ++j) {
                    Random random2;
                    BlockPos blockPos = WorldEntitySpawner.func_208498_a(iWorld, spawnListEntry.field_200702_b, \u26036, \u26037);
                    if (WorldEntitySpawner.func_209382_a(EntitySpawnPlacementRegistry.SpawnPlacementType.ON_GROUND, iWorld, blockPos, spawnListEntry.field_200702_b)) {
                        try {
                            EntityLiving entityLiving = spawnListEntry.field_200702_b.func_200721_a(iWorld.func_201672_e());
                        }
                        catch (Exception exception) {
                            field_209383_a.warn("Failed to create mob", (Throwable)exception);
                            continue;
                        }
                        double d = MathHelper.func_151237_a(\u26036, (double)\u26032 + (double)entityLiving.field_70130_N, (double)\u26032 + 16.0 - (double)entityLiving.field_70130_N);
                        \u2603 = MathHelper.func_151237_a(\u26037, (double)\u26033 + (double)entityLiving.field_70130_N, (double)\u26033 + 16.0 - (double)entityLiving.field_70130_N);
                        entityLiving.func_70012_b(d, blockPos.func_177956_o(), \u2603, random2.nextFloat() * 360.0f, 0.0f);
                        if (entityLiving.func_205020_a(iWorld, false) && entityLiving.func_205019_a(iWorld)) {
                            \u26035 = entityLiving.func_204210_a(iWorld.func_175649_E(new BlockPos(entityLiving)), \u26035, null);
                            iWorld.func_72838_d(entityLiving);
                            bl = true;
                        }
                    }
                    \u26036 += random2.nextInt(5) - random2.nextInt(5);
                    \u26037 += random2.nextInt(5) - random2.nextInt(5);
                    while (\u26036 < \u26032 || \u26036 >= \u26032 + 16 || \u26037 < \u26033 || \u26037 >= \u26033 + 16) {
                        \u26036 = \u26038 + random2.nextInt(5) - random2.nextInt(5);
                        \u26037 = \u26039 + random2.nextInt(5) - random2.nextInt(5);
                    }
                }
            }
        }
    }

    private static BlockPos func_208498_a(IWorld iWorld, @Nullable EntityType<? extends EntityLiving> entityType, int n, int n2) {
        BlockPos blockPos = new BlockPos(n, iWorld.func_201676_a(EntitySpawnPlacementRegistry.func_209342_b(entityType), n, n2), n2);
        \u2603 = blockPos.func_177977_b();
        if (iWorld.func_180495_p(\u2603).func_196957_g(iWorld, \u2603, PathType.LAND)) {
            return \u2603;
        }
        return blockPos;
    }
}

