/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketEntityStatus;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.Util;

public class GameRules {
    private static final TreeMap<String, ValueDefinition> field_196232_a = Util.func_200696_a(new TreeMap(), treeMap -> {
        treeMap.put("doFireTick", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("mobGriefing", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("keepInventory", new ValueDefinition("false", ValueType.BOOLEAN_VALUE));
        treeMap.put("doMobSpawning", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("doMobLoot", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("doTileDrops", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("doEntityDrops", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("commandBlockOutput", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("naturalRegeneration", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("doDaylightCycle", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("logAdminCommands", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("showDeathMessages", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("randomTickSpeed", new ValueDefinition("3", ValueType.NUMERICAL_VALUE));
        treeMap.put("sendCommandFeedback", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("reducedDebugInfo", new ValueDefinition("false", ValueType.BOOLEAN_VALUE, (minecraftServer, value) -> {
            byte by = value.func_82758_b() ? (byte)22 : (byte)23;
            for (EntityPlayerMP entityPlayerMP : minecraftServer.func_184103_al().func_181057_v()) {
                entityPlayerMP.field_71135_a.func_147359_a(new SPacketEntityStatus(entityPlayerMP, by));
            }
        }));
        treeMap.put("spectatorsGenerateChunks", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("spawnRadius", new ValueDefinition("10", ValueType.NUMERICAL_VALUE));
        treeMap.put("disableElytraMovementCheck", new ValueDefinition("false", ValueType.BOOLEAN_VALUE));
        treeMap.put("maxEntityCramming", new ValueDefinition("24", ValueType.NUMERICAL_VALUE));
        treeMap.put("doWeatherCycle", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
        treeMap.put("doLimitedCrafting", new ValueDefinition("false", ValueType.BOOLEAN_VALUE));
        treeMap.put("maxCommandChainLength", new ValueDefinition("65536", ValueType.NUMERICAL_VALUE));
        treeMap.put("announceAdvancements", new ValueDefinition("true", ValueType.BOOLEAN_VALUE));
    });
    private final TreeMap<String, Value> field_82771_a = new TreeMap();

    public GameRules() {
        for (Map.Entry<String, ValueDefinition> entry : field_196232_a.entrySet()) {
            this.field_82771_a.put(entry.getKey(), entry.getValue().func_199595_a());
        }
    }

    public void func_82764_b(String string, String string2, @Nullable MinecraftServer minecraftServer) {
        Value value = this.field_82771_a.get(string);
        if (value != null) {
            value.func_201200_a(string2, minecraftServer);
        }
    }

    public boolean func_82766_b(String string) {
        Value value = this.field_82771_a.get(string);
        if (value != null) {
            return value.func_82758_b();
        }
        return false;
    }

    public int func_180263_c(String string) {
        Value value = this.field_82771_a.get(string);
        if (value != null) {
            return value.func_180255_c();
        }
        return 0;
    }

    public NBTTagCompound func_82770_a() {
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        for (String string : this.field_82771_a.keySet()) {
            Value value = this.field_82771_a.get(string);
            nBTTagCompound.func_74778_a(string, value.func_82756_a());
        }
        return nBTTagCompound;
    }

    public void func_82768_a(NBTTagCompound nBTTagCompound) {
        Set<String> set = nBTTagCompound.func_150296_c();
        for (String string : set) {
            this.func_82764_b(string, nBTTagCompound.func_74779_i(string), null);
        }
    }

    public Value func_196230_f(String string) {
        return this.field_82771_a.get(string);
    }

    public static TreeMap<String, ValueDefinition> func_196231_c() {
        return field_196232_a;
    }

    public static enum ValueType {
        ANY_VALUE(StringArgumentType::greedyString, (commandContext, string) -> (String)commandContext.getArgument(string, String.class)),
        BOOLEAN_VALUE(BoolArgumentType::bool, (commandContext, string) -> ((Boolean)commandContext.getArgument(string, Boolean.class)).toString()),
        NUMERICAL_VALUE(IntegerArgumentType::integer, (commandContext, string) -> ((Integer)commandContext.getArgument(string, Integer.class)).toString());

        private final Supplier<ArgumentType<?>> field_196228_e;
        private final BiFunction<CommandContext<CommandSource>, String, String> field_196229_f;

        private ValueType(Supplier<ArgumentType<?>> supplier, BiFunction<CommandContext<CommandSource>, String, String> biFunction) {
            this.field_196228_e = supplier;
            this.field_196229_f = biFunction;
        }

        public RequiredArgumentBuilder<CommandSource, ?> func_199809_a(String string) {
            return Commands.func_197056_a(string, this.field_196228_e.get());
        }

        public void func_196222_a(CommandContext<CommandSource> commandContext, String string, Value value) {
            value.func_201200_a(this.field_196229_f.apply(commandContext, string), ((CommandSource)commandContext.getSource()).func_197028_i());
        }
    }

    public static class Value {
        private String field_82762_a;
        private boolean field_82760_b;
        private int field_82761_c;
        private double field_82759_d;
        private final ValueType field_180256_e;
        private final BiConsumer<MinecraftServer, Value> field_201201_f;

        public Value(String string, ValueType valueType, BiConsumer<MinecraftServer, Value> biConsumer) {
            this.field_180256_e = valueType;
            this.field_201201_f = biConsumer;
            this.func_201200_a(string, null);
        }

        public void func_201200_a(String string, @Nullable MinecraftServer minecraftServer) {
            this.field_82762_a = string;
            this.field_82760_b = Boolean.parseBoolean(string);
            this.field_82761_c = this.field_82760_b ? 1 : 0;
            try {
                this.field_82761_c = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.field_82759_d = Double.parseDouble(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (minecraftServer != null) {
                this.field_201201_f.accept(minecraftServer, this);
            }
        }

        public String func_82756_a() {
            return this.field_82762_a;
        }

        public boolean func_82758_b() {
            return this.field_82760_b;
        }

        public int func_180255_c() {
            return this.field_82761_c;
        }

        public ValueType func_180254_e() {
            return this.field_180256_e;
        }
    }

    public static class ValueDefinition {
        private final ValueType field_199596_a;
        private final String field_199597_b;
        private final BiConsumer<MinecraftServer, Value> field_201203_c;

        public ValueDefinition(String string, ValueType valueType) {
            this(string, valueType, (minecraftServer, value) -> {});
        }

        public ValueDefinition(String string, ValueType valueType, BiConsumer<MinecraftServer, Value> biConsumer) {
            this.field_199596_a = valueType;
            this.field_199597_b = string;
            this.field_201203_c = biConsumer;
        }

        public Value func_199595_a() {
            return new Value(this.field_199597_b, this.field_199596_a, this.field_201203_c);
        }

        public ValueType func_199594_b() {
            return this.field_199596_a;
        }
    }
}

