/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.village;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.storage.WorldSavedData;

public class VillageCollection
extends WorldSavedData {
    private World field_75556_a;
    private final List<BlockPos> field_75554_b = Lists.newArrayList();
    private final List<VillageDoorInfo> field_75555_c = Lists.newArrayList();
    private final List<Village> field_75552_d = Lists.newArrayList();
    private int field_75553_e;

    public VillageCollection(String string) {
        super(string);
    }

    public VillageCollection(World world) {
        super(VillageCollection.func_176062_a(world.field_73011_w));
        this.field_75556_a = world;
        this.func_76185_a();
    }

    public void func_82566_a(World world) {
        this.field_75556_a = world;
        for (Village village : this.field_75552_d) {
            village.func_82691_a(world);
        }
    }

    public void func_176060_a(BlockPos blockPos) {
        if (this.field_75554_b.size() > 64) {
            return;
        }
        if (!this.func_176057_e(blockPos)) {
            this.field_75554_b.add(blockPos);
        }
    }

    public void func_75544_a() {
        ++this.field_75553_e;
        for (Village village : this.field_75552_d) {
            village.func_75560_a(this.field_75553_e);
        }
        this.func_75549_c();
        this.func_75543_d();
        this.func_75545_e();
        if (this.field_75553_e % 400 == 0) {
            this.func_76185_a();
        }
    }

    private void func_75549_c() {
        Iterator<Village> iterator = this.field_75552_d.iterator();
        while (iterator.hasNext()) {
            Village village = iterator.next();
            if (!village.func_75566_g()) continue;
            iterator.remove();
            this.func_76185_a();
        }
    }

    public List<Village> func_75540_b() {
        return this.field_75552_d;
    }

    public Village func_176056_a(BlockPos blockPos, int n) {
        Village \u26033 = null;
        double \u26032 = 3.4028234663852886E38;
        for (Village village : this.field_75552_d) {
            double d = village.func_180608_a().func_177951_i(blockPos);
            if (d >= \u26032 || d > (double)((\u2603 = (float)(n + village.func_75568_b())) * \u2603)) continue;
            \u26033 = village;
            \u26032 = d;
        }
        return \u26033;
    }

    private void func_75543_d() {
        if (this.field_75554_b.isEmpty()) {
            return;
        }
        this.func_180609_b(this.field_75554_b.remove(0));
    }

    private void func_75545_e() {
        for (int i = 0; i < this.field_75555_c.size(); ++i) {
            VillageDoorInfo villageDoorInfo = this.field_75555_c.get(i);
            Village \u26032 = this.func_176056_a(villageDoorInfo.func_179852_d(), 32);
            if (\u26032 == null) {
                \u26032 = new Village(this.field_75556_a);
                this.field_75552_d.add(\u26032);
                this.func_76185_a();
            }
            \u26032.func_75576_a(villageDoorInfo);
        }
        this.field_75555_c.clear();
    }

    private void func_180609_b(BlockPos blockPos) {
        int n = 16;
        \u2603 = 4;
        \u2603 = 16;
        BlockPos.MutableBlockPos \u26032 = new BlockPos.MutableBlockPos();
        for (\u2603 = -16; \u2603 < 16; ++\u2603) {
            for (\u2603 = -4; \u2603 < 4; ++\u2603) {
                for (\u2603 = -16; \u2603 < 16; ++\u2603) {
                    \u26032.func_189533_g(blockPos).func_196234_d(\u2603, \u2603, \u2603);
                    IBlockState iBlockState = this.field_75556_a.func_180495_p(\u26032);
                    if (!this.func_195928_a(iBlockState)) continue;
                    VillageDoorInfo \u26033 = this.func_176055_c(\u26032);
                    if (\u26033 == null) {
                        this.func_195927_a(iBlockState, \u26032);
                        continue;
                    }
                    \u26033.func_179849_a(this.field_75553_e);
                }
            }
        }
    }

    @Nullable
    private VillageDoorInfo func_176055_c(BlockPos blockPos) {
        for (VillageDoorInfo villageDoorInfo : this.field_75555_c) {
            if (villageDoorInfo.func_179852_d().func_177958_n() != blockPos.func_177958_n() || villageDoorInfo.func_179852_d().func_177952_p() != blockPos.func_177952_p() || Math.abs(villageDoorInfo.func_179852_d().func_177956_o() - blockPos.func_177956_o()) > 1) continue;
            return villageDoorInfo;
        }
        for (Village village : this.field_75552_d) {
            VillageDoorInfo villageDoorInfo = village.func_179864_e(blockPos);
            if (villageDoorInfo == null) continue;
            return villageDoorInfo;
        }
        return null;
    }

    private void func_195927_a(IBlockState iBlockState, BlockPos blockPos) {
        EnumFacing enumFacing = iBlockState.func_177229_b(BlockDoor.field_176520_a);
        \u2603 = enumFacing.func_176734_d();
        int \u26032 = this.func_176061_a(blockPos, enumFacing, 5);
        if (\u26032 != (\u2603 = this.func_176061_a(blockPos, \u2603, \u26032 + 1))) {
            this.field_75555_c.add(new VillageDoorInfo(blockPos, \u26032 < \u2603 ? enumFacing : \u2603, this.field_75553_e));
        }
    }

    private int func_176061_a(BlockPos blockPos, EnumFacing enumFacing, int n) {
        \u2603 = 0;
        for (\u2603 = 1; \u2603 <= 5; ++\u2603) {
            if (!this.field_75556_a.func_175678_i(blockPos.func_177967_a(enumFacing, \u2603)) || ++\u2603 < n) continue;
            return \u2603;
        }
        return \u2603;
    }

    private boolean func_176057_e(BlockPos blockPos) {
        for (BlockPos blockPos2 : this.field_75554_b) {
            if (!blockPos2.equals(blockPos)) continue;
            return true;
        }
        return false;
    }

    private boolean func_195928_a(IBlockState iBlockState) {
        return iBlockState.func_177230_c() instanceof BlockDoor && iBlockState.func_185904_a() == Material.field_151575_d;
    }

    @Override
    public void func_76184_a(NBTTagCompound nBTTagCompound) {
        this.field_75553_e = nBTTagCompound.func_74762_e("Tick");
        NBTTagList nBTTagList = nBTTagCompound.func_150295_c("Villages", 10);
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = nBTTagList.func_150305_b(i);
            Village \u26032 = new Village();
            \u26032.func_82690_a(nBTTagCompound2);
            this.field_75552_d.add(\u26032);
        }
    }

    @Override
    public NBTTagCompound func_189551_b(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        nBTTagCompound2.func_74768_a("Tick", this.field_75553_e);
        NBTTagList nBTTagList = new NBTTagList();
        for (Village village : this.field_75552_d) {
            NBTTagCompound nBTTagCompound3 = new NBTTagCompound();
            village.func_82689_b(nBTTagCompound3);
            nBTTagList.add(nBTTagCompound3);
        }
        nBTTagCompound2.func_74782_a("Villages", nBTTagList);
        return nBTTagCompound2;
    }

    public static String func_176062_a(Dimension dimension) {
        return "villages" + dimension.func_186058_p().func_186067_c();
    }
}

