/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentScore;
import net.minecraft.util.text.TextComponentSelector;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public class TextComponentUtils {
    public static ITextComponent func_211401_a(ITextComponent iTextComponent, Style style) {
        if (style.func_150229_g()) {
            return iTextComponent;
        }
        if (iTextComponent.func_150256_b().func_150229_g()) {
            return iTextComponent.func_150255_a(style.func_150232_l());
        }
        return new TextComponentString("").func_150257_a(iTextComponent).func_150255_a(style.func_150232_l());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ITextComponent func_197680_a(@Nullable CommandSource commandSource, ITextComponent iTextComponent2, @Nullable Entity entity) throws CommandSyntaxException {
        ITextComponent iTextComponent2;
        ITextComponent iTextComponent3;
        Object object;
        Object[] objectArray;
        if (iTextComponent2 instanceof TextComponentScore && commandSource != null) {
            String \u26032;
            objectArray = (Object[])iTextComponent2;
            if (objectArray.func_197666_h() != null) {
                object = objectArray.func_197666_h().func_197341_b(commandSource);
                if (object.isEmpty()) {
                    \u26032 = objectArray.func_179995_g();
                } else {
                    if (object.size() != 1) throw EntityArgument.field_197098_a.create();
                    \u26032 = ((Entity)object.get(0)).func_195047_I_();
                }
            } else {
                \u26032 = objectArray.func_179995_g();
            }
            object = entity != null && \u26032.equals("*") ? entity.func_195047_I_() : \u26032;
            iTextComponent3 = new TextComponentScore((String)object, objectArray.func_179994_h());
            ((TextComponentScore)iTextComponent3).func_179997_b(objectArray.func_150261_e());
            ((TextComponentScore)iTextComponent3).func_197665_b(commandSource);
        } else if (iTextComponent2 instanceof TextComponentSelector && commandSource != null) {
            iTextComponent3 = ((TextComponentSelector)iTextComponent2).func_197668_a(commandSource);
        } else if (iTextComponent2 instanceof TextComponentString) {
            iTextComponent3 = new TextComponentString(((TextComponentString)iTextComponent2).func_150265_g());
        } else if (iTextComponent2 instanceof TextComponentKeybind) {
            iTextComponent3 = new TextComponentKeybind(((TextComponentKeybind)iTextComponent2).func_193633_h());
        } else {
            if (!(iTextComponent2 instanceof TextComponentTranslation)) return iTextComponent2;
            objectArray = ((TextComponentTranslation)iTextComponent2).func_150271_j();
            for (int i = 0; i < objectArray.length; ++i) {
                object = objectArray[i];
                if (!(object instanceof ITextComponent)) continue;
                objectArray[i] = TextComponentUtils.func_197680_a(commandSource, (ITextComponent)object, entity);
            }
            iTextComponent3 = new TextComponentTranslation(((TextComponentTranslation)iTextComponent2).func_150268_i(), objectArray);
        }
        for (ITextComponent iTextComponent4 : iTextComponent2.func_150253_a()) {
            iTextComponent3.func_150257_a(TextComponentUtils.func_197680_a(commandSource, iTextComponent4, entity));
        }
        return TextComponentUtils.func_211401_a(iTextComponent3, iTextComponent2.func_150256_b());
    }

    public static ITextComponent func_197679_a(GameProfile gameProfile) {
        if (gameProfile.getName() != null) {
            return new TextComponentString(gameProfile.getName());
        }
        if (gameProfile.getId() != null) {
            return new TextComponentString(gameProfile.getId().toString());
        }
        return new TextComponentString("(unknown)");
    }

    public static ITextComponent func_197678_a(Collection<String> collection) {
        return TextComponentUtils.func_197675_a(collection, string -> new TextComponentString((String)string).func_211708_a(TextFormatting.GREEN));
    }

    public static <T extends Comparable<T>> ITextComponent func_197675_a(Collection<T> collection, Function<T, ITextComponent> function) {
        if (collection.isEmpty()) {
            return new TextComponentString("");
        }
        if (collection.size() == 1) {
            return function.apply(collection.iterator().next());
        }
        ArrayList arrayList = Lists.newArrayList(collection);
        arrayList.sort(Comparable::compareTo);
        return TextComponentUtils.func_197677_b(collection, function);
    }

    public static <T> ITextComponent func_197677_b(Collection<T> collection, Function<T, ITextComponent> function) {
        if (collection.isEmpty()) {
            return new TextComponentString("");
        }
        if (collection.size() == 1) {
            return function.apply(collection.iterator().next());
        }
        TextComponentString textComponentString = new TextComponentString("");
        boolean \u26032 = true;
        for (T t : collection) {
            if (!\u26032) {
                textComponentString.func_150257_a(new TextComponentString(", ").func_211708_a(TextFormatting.GRAY));
            }
            textComponentString.func_150257_a(function.apply(t));
            \u26032 = false;
        }
        return textComponentString;
    }

    public static ITextComponent func_197676_a(ITextComponent iTextComponent) {
        return new TextComponentString("[").func_150257_a(iTextComponent).func_150258_a("]");
    }

    public static ITextComponent func_202465_a(Message message) {
        if (message instanceof ITextComponent) {
            return (ITextComponent)message;
        }
        return new TextComponentString(message.getString());
    }
}

