/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.text;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.EnumTypeAdapterFactory;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.Util;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentKeybind;
import net.minecraft.util.text.TextComponentScore;
import net.minecraft.util.text.TextComponentSelector;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public interface ITextComponent
extends Message,
Iterable<ITextComponent> {
    public ITextComponent func_150255_a(Style var1);

    public Style func_150256_b();

    default public ITextComponent func_150258_a(String string) {
        return this.func_150257_a(new TextComponentString(string));
    }

    public ITextComponent func_150257_a(ITextComponent var1);

    public String func_150261_e();

    default public String getString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.func_212640_c().forEach(iTextComponent -> stringBuilder.append(iTextComponent.func_150261_e()));
        return stringBuilder.toString();
    }

    default public String func_212636_a(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator \u26032 = this.func_212640_c().iterator();
        while (\u26032.hasNext() && (\u2603 = n - stringBuilder.length()) > 0) {
            String string = ((ITextComponent)\u26032.next()).func_150261_e();
            stringBuilder.append(string.length() <= \u2603 ? string : string.substring(0, \u2603));
        }
        return stringBuilder.toString();
    }

    default public String func_150254_d() {
        StringBuilder stringBuilder = new StringBuilder();
        String \u26032 = "";
        Iterator \u26033 = this.func_212640_c().iterator();
        while (\u26033.hasNext()) {
            ITextComponent iTextComponent = (ITextComponent)\u26033.next();
            String \u26034 = iTextComponent.func_150261_e();
            if (\u26034.isEmpty()) continue;
            String \u26035 = iTextComponent.func_150256_b().func_150218_j();
            if (!\u26035.equals(\u26032)) {
                if (!\u26032.isEmpty()) {
                    stringBuilder.append((Object)TextFormatting.RESET);
                }
                stringBuilder.append(\u26035);
                \u26032 = \u26035;
            }
            stringBuilder.append(\u26034);
        }
        if (!\u26032.isEmpty()) {
            stringBuilder.append((Object)TextFormatting.RESET);
        }
        return stringBuilder.toString();
    }

    public List<ITextComponent> func_150253_a();

    public Stream<ITextComponent> func_212640_c();

    default public Stream<ITextComponent> func_212637_f() {
        return this.func_212640_c().map(ITextComponent::func_212639_b);
    }

    @Override
    default public Iterator<ITextComponent> iterator() {
        return this.func_212637_f().iterator();
    }

    public ITextComponent func_150259_f();

    default public ITextComponent func_212638_h() {
        ITextComponent iTextComponent = this.func_150259_f();
        iTextComponent.func_150255_a(this.func_150256_b().func_150232_l());
        for (ITextComponent iTextComponent2 : this.func_150253_a()) {
            iTextComponent.func_150257_a(iTextComponent2.func_212638_h());
        }
        return iTextComponent;
    }

    default public ITextComponent func_211710_a(Consumer<Style> consumer) {
        consumer.accept(this.func_150256_b());
        return this;
    }

    default public ITextComponent func_211709_a(TextFormatting ... textFormattingArray) {
        for (TextFormatting textFormatting : textFormattingArray) {
            this.func_211708_a(textFormatting);
        }
        return this;
    }

    default public ITextComponent func_211708_a(TextFormatting textFormatting) {
        Style style = this.func_150256_b();
        if (textFormatting.func_96302_c()) {
            style.func_150238_a(textFormatting);
        }
        if (textFormatting.func_96301_b()) {
            switch (textFormatting) {
                case OBFUSCATED: {
                    style.func_150237_e(true);
                    break;
                }
                case BOLD: {
                    style.func_150227_a(true);
                    break;
                }
                case STRIKETHROUGH: {
                    style.func_150225_c(true);
                    break;
                }
                case UNDERLINE: {
                    style.func_150228_d(true);
                    break;
                }
                case ITALIC: {
                    style.func_150217_b(true);
                    break;
                }
            }
        }
        return this;
    }

    public static ITextComponent func_212639_b(ITextComponent iTextComponent) {
        \u2603 = iTextComponent.func_150259_f();
        \u2603.func_150255_a(iTextComponent.func_150256_b().func_150206_m());
        return \u2603;
    }

    public static class Serializer
    implements JsonDeserializer<ITextComponent>,
    JsonSerializer<ITextComponent> {
        private static final Gson field_150700_a = Util.func_199748_a(() -> {
            GsonBuilder gsonBuilder = new GsonBuilder();
            gsonBuilder.registerTypeHierarchyAdapter(ITextComponent.class, (Object)new Serializer());
            gsonBuilder.registerTypeHierarchyAdapter(Style.class, (Object)new Style.Serializer());
            gsonBuilder.registerTypeAdapterFactory((TypeAdapterFactory)new EnumTypeAdapterFactory());
            return gsonBuilder.create();
        });
        private static final Field field_197674_b = Util.func_199748_a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("pos");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Couldn't get field 'pos' for JsonReader", noSuchFieldException);
            }
        });
        private static final Field field_200530_c = Util.func_199748_a(() -> {
            try {
                new JsonReader((Reader)new StringReader(""));
                Field field = JsonReader.class.getDeclaredField("lineStart");
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new IllegalStateException("Couldn't get field 'lineStart' for JsonReader", noSuchFieldException);
            }
        });

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ITextComponent deserialize(JsonElement jsonElement2, Type type, JsonDeserializationContext jsonDeserializationContext2) throws JsonParseException {
            void var5_15;
            JsonElement jsonElement2;
            if (jsonElement2.isJsonPrimitive()) {
                return new TextComponentString(jsonElement2.getAsString());
            }
            if (jsonElement2.isJsonObject()) {
                JsonDeserializationContext jsonDeserializationContext2;
                void var5_13;
                String string;
                JsonObject jsonObject = jsonElement2.getAsJsonObject();
                if (jsonObject.has("text")) {
                    TextComponentString textComponentString = new TextComponentString(jsonObject.get("text").getAsString());
                } else if (jsonObject.has("translate")) {
                    string = jsonObject.get("translate").getAsString();
                    if (jsonObject.has("with")) {
                        JsonArray jsonArray = jsonObject.getAsJsonArray("with");
                        Object[] \u26032 = new Object[jsonArray.size()];
                        for (int i = 0; i < \u26032.length; ++i) {
                            \u26032[i] = this.deserialize(jsonArray.get(i), type, jsonDeserializationContext2);
                            if (!(\u26032[i] instanceof TextComponentString) || !(\u2603 = (TextComponentString)\u26032[i]).func_150256_b().func_150229_g() || !\u2603.func_150253_a().isEmpty()) continue;
                            \u26032[i] = \u2603.func_150265_g();
                        }
                        TextComponentTranslation textComponentTranslation = new TextComponentTranslation(string, \u26032);
                    } else {
                        TextComponentTranslation textComponentTranslation = new TextComponentTranslation(string, new Object[0]);
                    }
                } else if (jsonObject.has("score")) {
                    string = jsonObject.getAsJsonObject("score");
                    if (!string.has("name") || !string.has("objective")) throw new JsonParseException("A score component needs a least a name and an objective");
                    TextComponentScore textComponentScore = new TextComponentScore(JsonUtils.func_151200_h((JsonObject)string, "name"), JsonUtils.func_151200_h((JsonObject)string, "objective"));
                    if (string.has("value")) {
                        textComponentScore.func_179997_b(JsonUtils.func_151200_h((JsonObject)string, "value"));
                    }
                } else if (jsonObject.has("selector")) {
                    TextComponentSelector textComponentSelector = new TextComponentSelector(JsonUtils.func_151200_h(jsonObject, "selector"));
                } else {
                    if (!jsonObject.has("keybind")) throw new JsonParseException("Don't know how to turn " + jsonElement2 + " into a Component");
                    TextComponentKeybind textComponentKeybind = new TextComponentKeybind(JsonUtils.func_151200_h(jsonObject, "keybind"));
                }
                if (jsonObject.has("extra")) {
                    string = jsonObject.getAsJsonArray("extra");
                    if (string.size() <= 0) throw new JsonParseException("Unexpected empty array of components");
                    for (int i = 0; i < string.size(); ++i) {
                        var5_13.func_150257_a(this.deserialize(string.get(i), type, jsonDeserializationContext2));
                    }
                }
                var5_13.func_150255_a((Style)jsonDeserializationContext2.deserialize(jsonElement2, Style.class));
                return var5_13;
            }
            if (!jsonElement2.isJsonArray()) throw new JsonParseException("Don't know how to turn " + jsonElement2 + " into a Component");
            JsonArray \u26033 = jsonElement2.getAsJsonArray();
            Object var5_14 = null;
            for (JsonElement jsonElement3 : \u26033) {
                ITextComponent iTextComponent = this.deserialize(jsonElement3, jsonElement3.getClass(), jsonDeserializationContext2);
                if (var5_15 == null) {
                    ITextComponent iTextComponent2 = iTextComponent;
                    continue;
                }
                var5_15.func_150257_a(iTextComponent);
            }
            return var5_15;
        }

        private void func_150695_a(Style style, JsonObject jsonObject, JsonSerializationContext jsonSerializationContext) {
            JsonElement jsonElement = jsonSerializationContext.serialize((Object)style);
            if (jsonElement.isJsonObject()) {
                JsonObject jsonObject2 = (JsonObject)jsonElement;
                for (Map.Entry entry : jsonObject2.entrySet()) {
                    jsonObject.add((String)entry.getKey(), (JsonElement)entry.getValue());
                }
            }
        }

        public JsonElement serialize(ITextComponent iTextComponent2, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject \u26032;
            ITextComponent iTextComponent2;
            Object object;
            JsonObject jsonObject = new JsonObject();
            if (!iTextComponent2.func_150256_b().func_150229_g()) {
                this.func_150695_a(iTextComponent2.func_150256_b(), jsonObject, jsonSerializationContext);
            }
            if (!iTextComponent2.func_150253_a().isEmpty()) {
                object = new JsonArray();
                for (ITextComponent iTextComponent3 : iTextComponent2.func_150253_a()) {
                    object.add(this.serialize(iTextComponent3, iTextComponent3.getClass(), jsonSerializationContext));
                }
                jsonObject.add("extra", (JsonElement)object);
            }
            if (iTextComponent2 instanceof TextComponentString) {
                jsonObject.addProperty("text", ((TextComponentString)iTextComponent2).func_150265_g());
            } else if (iTextComponent2 instanceof TextComponentTranslation) {
                object = (TextComponentTranslation)iTextComponent2;
                jsonObject.addProperty("translate", ((TextComponentTranslation)object).func_150268_i());
                if (((TextComponentTranslation)object).func_150271_j() != null && ((TextComponentTranslation)object).func_150271_j().length > 0) {
                    \u26032 = new JsonArray();
                    for (Object object2 : ((TextComponentTranslation)object).func_150271_j()) {
                        if (object2 instanceof ITextComponent) {
                            \u26032.add(this.serialize((ITextComponent)object2, object2.getClass(), jsonSerializationContext));
                            continue;
                        }
                        \u26032.add((JsonElement)new JsonPrimitive(String.valueOf(object2)));
                    }
                    jsonObject.add("with", (JsonElement)\u26032);
                }
            } else if (iTextComponent2 instanceof TextComponentScore) {
                object = (TextComponentScore)iTextComponent2;
                \u26032 = new JsonObject();
                \u26032.addProperty("name", ((TextComponentScore)object).func_179995_g());
                \u26032.addProperty("objective", ((TextComponentScore)object).func_179994_h());
                \u26032.addProperty("value", ((TextComponentScore)object).func_150261_e());
                jsonObject.add("score", (JsonElement)\u26032);
            } else if (iTextComponent2 instanceof TextComponentSelector) {
                object = (TextComponentSelector)iTextComponent2;
                jsonObject.addProperty("selector", ((TextComponentSelector)object).func_179992_g());
            } else if (iTextComponent2 instanceof TextComponentKeybind) {
                object = (TextComponentKeybind)iTextComponent2;
                jsonObject.addProperty("keybind", ((TextComponentKeybind)object).func_193633_h());
            } else {
                throw new IllegalArgumentException("Don't know how to serialize " + iTextComponent2 + " as a Component");
            }
            return jsonObject;
        }

        public static String func_150696_a(ITextComponent iTextComponent) {
            return field_150700_a.toJson((Object)iTextComponent);
        }

        public static JsonElement func_200528_b(ITextComponent iTextComponent) {
            return field_150700_a.toJsonTree((Object)iTextComponent);
        }

        @Nullable
        public static ITextComponent func_150699_a(String string) {
            return JsonUtils.func_188176_a(field_150700_a, string, ITextComponent.class, false);
        }

        @Nullable
        public static ITextComponent func_197672_a(JsonElement jsonElement) {
            return (ITextComponent)field_150700_a.fromJson(jsonElement, ITextComponent.class);
        }

        @Nullable
        public static ITextComponent func_186877_b(String string) {
            return JsonUtils.func_188176_a(field_150700_a, string, ITextComponent.class, true);
        }

        public static ITextComponent func_197671_a(com.mojang.brigadier.StringReader stringReader) {
            try {
                JsonReader jsonReader = new JsonReader((Reader)new StringReader(stringReader.getRemaining()));
                jsonReader.setLenient(false);
                ITextComponent \u26032 = (ITextComponent)field_150700_a.getAdapter(ITextComponent.class).read(jsonReader);
                stringReader.setCursor(stringReader.getCursor() + Serializer.func_197673_a(jsonReader));
                return \u26032;
            }
            catch (IOException iOException) {
                throw new JsonParseException((Throwable)iOException);
            }
        }

        private static int func_197673_a(JsonReader jsonReader) {
            try {
                return field_197674_b.getInt(jsonReader) - field_200530_c.getInt(jsonReader) + 1;
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new IllegalStateException("Couldn't read position of JsonReader", illegalAccessException);
            }
        }

        public /* synthetic */ JsonElement serialize(Object object, Type type, JsonSerializationContext jsonSerializationContext) {
            return this.serialize((ITextComponent)object, type, jsonSerializationContext);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

