/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.storage.RegionFile;
import net.minecraft.world.dimension.DimensionType;

public class WorldChunkEnumerator {
    private static final Pattern field_212158_a = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final File field_212159_b;
    private final Map<DimensionType, List<ChunkPos>> field_212162_e;

    public WorldChunkEnumerator(File file) {
        this.field_212159_b = file;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (DimensionType dimensionType : DimensionType.func_212681_b()) {
            builder.put((Object)dimensionType, this.func_212153_a(dimensionType));
        }
        this.field_212162_e = builder.build();
    }

    private List<ChunkPos> func_212153_a(DimensionType dimensionType) {
        ArrayList arrayList = Lists.newArrayList();
        File \u26032 = dimensionType.func_212679_a(this.field_212159_b);
        List<File> \u26033 = this.func_212155_b(\u26032);
        for (File file : \u26033) {
            arrayList.addAll(this.func_212150_a(file));
        }
        \u26033.sort(File::compareTo);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<ChunkPos> func_212150_a(File file) {
        Matcher \u260343333332;
        RegionFile \u26032;
        block17: {
            ArrayList arrayList = Lists.newArrayList();
            \u26032 = null;
            \u260343333332 = field_212158_a.matcher(file.getName());
            if (\u260343333332.matches()) break block17;
            ArrayList arrayList2 = arrayList;
            if (\u26032 == null) return arrayList2;
            try {
                \u26032.func_76708_c();
                return arrayList2;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return arrayList2;
        }
        int n = Integer.parseInt(\u260343333332.group(1)) << 5;
        n2 = Integer.parseInt(\u260343333332.group(2)) << 5;
        \u26032 = new RegionFile(file);
        for (i = 0; i < 32; ++i) {
            for (j = 0; j < 32; ++j) {
                if (!\u26032.func_212167_b(i, j)) continue;
                arrayList.add(new ChunkPos(i + n, j + n2));
            }
        }
        if (\u26032 == null) return arrayList;
        try {
            \u26032.func_76708_c();
            return arrayList;
        }
        catch (IOException \u260343333332) {}
        return arrayList;
        catch (Throwable \u26033) {
            try {
                ArrayList arrayList2 = Lists.newArrayList();
                return arrayList2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (\u26032 != null) {
                    try {
                        \u26032.func_76708_c();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private List<File> func_212155_b(File file2) {
        \u2603 = new File(file2, "region");
        Object[] objectArray = \u2603.listFiles((file, string) -> string.endsWith(".mca"));
        if (objectArray != null) {
            return Lists.newArrayList((Object[])objectArray);
        }
        return Lists.newArrayList();
    }

    public List<ChunkPos> func_212541_a(DimensionType dimensionType) {
        return this.field_212162_e.get(dimensionType);
    }
}

