/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ITaskType;
import net.minecraft.util.NamedThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Scheduler<K, T extends ITaskType<K, T>, R> {
    private static final Logger field_202856_b = LogManager.getLogger();
    protected final ExecutorService field_202855_a;
    private final ExecutorService field_202857_c;
    private final AtomicInteger field_202858_d = new AtomicInteger(1);
    private final List<CompletableFuture<R>> field_202859_e = Lists.newArrayList();
    private CompletableFuture<R> field_202860_f = CompletableFuture.completedFuture(null);
    private CompletableFuture<R> field_202861_g = CompletableFuture.completedFuture(null);
    private final Supplier<Map<T, CompletableFuture<R>>> field_202862_h;
    private final Supplier<Map<T, CompletableFuture<Void>>> field_202863_i;
    private final T field_202864_j;

    public Scheduler(final String string, int n, T t, Supplier<Map<T, CompletableFuture<R>>> supplier, Supplier<Map<T, CompletableFuture<Void>>> supplier2) {
        this.field_202864_j = t;
        this.field_202862_h = supplier;
        this.field_202863_i = supplier2;
        this.field_202855_a = n == 0 ? MoreExecutors.newDirectExecutorService() : Executors.newSingleThreadExecutor(new NamedThreadFactory(string + "-Scheduler"));
        this.field_202857_c = n <= 1 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(n - 1, forkJoinPool -> new ForkJoinWorkerThread(forkJoinPool){
            {
                super(forkJoinPool);
                this.setName(string + "-Worker-" + Scheduler.this.field_202858_d.getAndIncrement());
            }
        }, (thread, throwable) -> field_202856_b.error(String.format("Caught exception in thread %s", thread), throwable), true);
    }

    public CompletableFuture<R> func_202851_b(K k) {
        CompletableFuture<R> completableFuture2 = this.field_202860_f;
        Supplier<CompletableFuture> \u26032 = () -> this.func_201494_a_(k).func_202914_a(completableFuture2, this.field_202864_j);
        CompletableFuture<CompletableFuture> \u26033 = CompletableFuture.supplyAsync(\u26032, this.field_202855_a);
        CompletionStage \u26034 = \u26033.thenComposeAsync(completableFuture -> completableFuture, (Executor)this.field_202857_c);
        this.field_202859_e.add((CompletableFuture<R>)\u26034);
        return \u26034;
    }

    public CompletableFuture<R> func_202845_a() {
        CompletableFuture completableFuture = this.field_202859_e.remove(this.field_202859_e.size() - 1);
        CompletionStage \u26032 = CompletableFuture.allOf(this.field_202859_e.toArray(new CompletableFuture[0])).thenCompose(void_ -> completableFuture);
        this.field_202861_g = \u26032;
        this.field_202859_e.clear();
        this.field_202860_f = \u26032;
        return \u26032;
    }

    protected FutureWrapper func_201494_a_(K k) {
        return this.func_212252_a_(k, true);
    }

    @Nullable
    protected abstract FutureWrapper func_212252_a_(K var1, boolean var2);

    public void func_202854_b() throws InterruptedException {
        this.field_202855_a.shutdown();
        this.field_202855_a.awaitTermination(1L, TimeUnit.DAYS);
        this.field_202857_c.shutdown();
        this.field_202857_c.awaitTermination(1L, TimeUnit.DAYS);
    }

    protected abstract R func_201493_a_(K var1, T var2, Map<K, R> var3);

    @Nullable
    public R func_212537_b(K k, boolean bl) {
        FutureWrapper futureWrapper = this.func_212252_a_(k, bl);
        if (futureWrapper != null) {
            return futureWrapper.func_202917_a();
        }
        return null;
    }

    public CompletableFuture<R> func_202846_c() {
        CompletableFuture<R> completableFuture = this.field_202861_g;
        return completableFuture.thenApply(object -> object);
    }

    protected abstract void func_205607_b_(K var1, FutureWrapper var2);

    protected abstract FutureWrapper func_205606_a_(K var1, FutureWrapper var2);

    public final class FutureWrapper {
        private final Map<T, CompletableFuture<R>> field_202920_b;
        private final K field_202921_c;
        private final R field_202922_d;

        public FutureWrapper(R r, T t) {
            this.field_202920_b = (Map)Scheduler.this.field_202862_h.get();
            this.field_202921_c = r;
            this.field_202922_d = t;
            while (\u2603 != null) {
                this.field_202920_b.put(\u2603, CompletableFuture.completedFuture(t));
                \u2603 = \u2603.func_201497_a_();
            }
        }

        public R func_202917_a() {
            return this.field_202922_d;
        }

        private CompletableFuture<R> func_202914_a(CompletableFuture<R> completableFuture, T t) {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            return this.field_202920_b.computeIfAbsent(t, iTaskType3 -> {
                if (t.func_201497_a_() == null) {
                    return CompletableFuture.completedFuture(this.field_202922_d);
                }
                t.func_201492_a_(this.field_202921_c, (object, iTaskType) -> concurrentHashMap.put(object, Scheduler.this.func_205606_a_(object, Scheduler.this.func_201494_a_(object)).func_202914_a(completableFuture, iTaskType)));
                CompletableFuture[] completableFutureArray = (CompletableFuture[])Streams.concat((Stream[])new Stream[]{Stream.of(completableFuture), concurrentHashMap.values().stream()}).toArray(CompletableFuture[]::new);
                CompletionStage \u26032 = ((CompletableFuture)CompletableFuture.allOf(completableFutureArray).thenApplyAsync(void_ -> Scheduler.this.func_201493_a_(this.field_202921_c, t, Maps.transformValues((Map)concurrentHashMap, completableFuture -> {
                    try {
                        return completableFuture.get();
                    }
                    catch (InterruptedException | ExecutionException exception) {
                        throw new RuntimeException(exception);
                    }
                })), (Executor)Scheduler.this.field_202857_c)).thenApplyAsync(object2 -> {
                    Object object2;
                    for (Object k : concurrentHashMap.keySet()) {
                        Scheduler.this.func_205607_b_(k, Scheduler.this.func_201494_a_(k));
                    }
                    return object2;
                }, (Executor)Scheduler.this.field_202855_a);
                this.field_202920_b.put(t, (CompletableFuture)\u26032);
                return \u26032;
            });
        }
    }
}

