/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEndPortal;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.EndDimension;
import net.minecraft.world.gen.feature.EndGatewayConfig;
import net.minecraft.world.gen.feature.EndIslandFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TileEntityEndGateway
extends TileEntityEndPortal
implements ITickable {
    private static final Logger field_195503_a = LogManager.getLogger();
    private long field_195504_f;
    private int field_195505_g;
    private BlockPos field_195506_h;
    private boolean field_195507_i;

    public TileEntityEndGateway() {
        super(TileEntityType.field_200991_v);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nBTTagCompound) {
        super.func_189515_b(nBTTagCompound);
        nBTTagCompound.func_74772_a("Age", this.field_195504_f);
        if (this.field_195506_h != null) {
            nBTTagCompound.func_74782_a("ExitPortal", NBTUtil.func_186859_a(this.field_195506_h));
        }
        if (this.field_195507_i) {
            nBTTagCompound.func_74757_a("ExactTeleport", this.field_195507_i);
        }
        return nBTTagCompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.field_195504_f = nBTTagCompound.func_74763_f("Age");
        if (nBTTagCompound.func_150297_b("ExitPortal", 10)) {
            this.field_195506_h = NBTUtil.func_186861_c(nBTTagCompound.func_74775_l("ExitPortal"));
        }
        this.field_195507_i = nBTTagCompound.func_74767_n("ExactTeleport");
    }

    @Override
    public void func_73660_a() {
        boolean bl = this.func_195499_c();
        \u2603 = this.func_195500_d();
        ++this.field_195504_f;
        if (\u2603) {
            --this.field_195505_g;
        } else if (!this.field_145850_b.field_72995_K) {
            List<Entity> list = this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.func_174877_v()));
            if (!list.isEmpty()) {
                this.func_195496_a(list.get(0));
            }
            if (this.field_195504_f % 2400L == 0L) {
                this.func_195490_f();
            }
        }
        if (bl != this.func_195499_c() || \u2603 != this.func_195500_d()) {
            this.func_70296_d();
        }
    }

    public boolean func_195499_c() {
        return this.field_195504_f < 200L;
    }

    public boolean func_195500_d() {
        return this.field_195505_g > 0;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 8, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void func_195490_f() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_195505_g = 40;
            this.field_145850_b.func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 1, 0);
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_145842_c(int n, int n2) {
        if (n == 1) {
            this.field_195505_g = 40;
            return true;
        }
        return super.func_145842_c(n, n2);
    }

    public void func_195496_a(Entity entity) {
        if (this.field_145850_b.field_72995_K || this.func_195500_d()) {
            return;
        }
        this.field_195505_g = 100;
        if (this.field_195506_h == null && this.field_145850_b.field_73011_w instanceof EndDimension) {
            this.func_195501_j();
        }
        if (this.field_195506_h != null) {
            BlockPos blockPos = this.field_195507_i ? this.field_195506_h : this.func_195502_i();
            entity.func_70634_a((double)blockPos.func_177958_n() + 0.5, (double)blockPos.func_177956_o() + 0.5, (double)blockPos.func_177952_p() + 0.5);
        }
        this.func_195490_f();
    }

    private BlockPos func_195502_i() {
        BlockPos blockPos = TileEntityEndGateway.func_195494_a(this.field_145850_b, this.field_195506_h, 5, false);
        field_195503_a.debug("Best exit position for portal at {} is {}", (Object)this.field_195506_h, (Object)blockPos);
        return blockPos.func_177984_a();
    }

    private void func_195501_j() {
        Vec3d vec3d = new Vec3d(this.func_174877_v().func_177958_n(), 0.0, this.func_174877_v().func_177952_p()).func_72432_b();
        \u2603 = vec3d.func_186678_a(1024.0);
        int \u26032 = 16;
        while (TileEntityEndGateway.func_195495_a(this.field_145850_b, \u2603).func_76625_h() > 0 && \u26032-- > 0) {
            field_195503_a.debug("Skipping backwards past nonempty chunk at {}", (Object)\u2603);
            \u2603 = \u2603.func_178787_e(vec3d.func_186678_a(-16.0));
        }
        \u26032 = 16;
        while (TileEntityEndGateway.func_195495_a(this.field_145850_b, \u2603).func_76625_h() == 0 && \u26032-- > 0) {
            field_195503_a.debug("Skipping forward past empty chunk at {}", (Object)\u2603);
            \u2603 = \u2603.func_178787_e(vec3d.func_186678_a(16.0));
        }
        field_195503_a.debug("Found chunk at {}", (Object)\u2603);
        Chunk \u26033 = TileEntityEndGateway.func_195495_a(this.field_145850_b, \u2603);
        this.field_195506_h = TileEntityEndGateway.func_195498_a(\u26033);
        if (this.field_195506_h == null) {
            this.field_195506_h = new BlockPos(\u2603.field_72450_a + 0.5, 75.0, \u2603.field_72449_c + 0.5);
            field_195503_a.debug("Failed to find suitable block, settling on {}", (Object)this.field_195506_h);
            new EndIslandFeature().func_212245_a((IWorld)this.field_145850_b, this.field_145850_b.func_72863_F().func_201711_g(), new Random(this.field_195506_h.func_177986_g()), this.field_195506_h, IFeatureConfig.field_202429_e);
        } else {
            field_195503_a.debug("Found block at {}", (Object)this.field_195506_h);
        }
        this.field_195506_h = TileEntityEndGateway.func_195494_a(this.field_145850_b, this.field_195506_h, 16, true);
        field_195503_a.debug("Creating portal at {}", (Object)this.field_195506_h);
        this.field_195506_h = this.field_195506_h.func_177981_b(10);
        this.func_195492_c(this.field_195506_h);
        this.func_70296_d();
    }

    private static BlockPos func_195494_a(IBlockReader iBlockReader, BlockPos blockPos, int n, boolean bl) {
        Vec3i \u26033 = null;
        for (int i = -n; i <= n; ++i) {
            block1: for (\u2603 = -n; \u2603 <= n; ++\u2603) {
                if (i == 0 && \u2603 == 0 && !bl) continue;
                for (\u2603 = 255; \u2603 > (\u26033 == null ? 0 : \u26033.func_177956_o()); --\u2603) {
                    BlockPos blockPos2 = new BlockPos(blockPos.func_177958_n() + i, \u2603, blockPos.func_177952_p() + \u2603);
                    IBlockState \u26032 = iBlockReader.func_180495_p(blockPos2);
                    if (!\u26032.func_185898_k() || !bl && \u26032.func_177230_c() == Blocks.field_150357_h) continue;
                    \u26033 = blockPos2;
                    continue block1;
                }
            }
        }
        return \u26033 == null ? blockPos : \u26033;
    }

    private static Chunk func_195495_a(World world, Vec3d vec3d) {
        return world.func_72964_e(MathHelper.func_76128_c(vec3d.field_72450_a / 16.0), MathHelper.func_76128_c(vec3d.field_72449_c / 16.0));
    }

    @Nullable
    private static BlockPos func_195498_a(Chunk chunk) {
        BlockPos \u26035;
        BlockPos blockPos = new BlockPos(chunk.field_76635_g * 16, 30, chunk.field_76647_h * 16);
        int \u26032 = chunk.func_76625_h() + 16 - 1;
        \u2603 = new BlockPos(chunk.field_76635_g * 16 + 16 - 1, \u26032, chunk.field_76647_h * 16 + 16 - 1);
        \u26035 = null;
        double \u26033 = 0.0;
        for (BlockPos blockPos2 : BlockPos.func_177980_a(blockPos, \u2603)) {
            IBlockState iBlockState = chunk.func_180495_p(blockPos2);
            if (iBlockState.func_177230_c() != Blocks.field_150377_bs || chunk.func_180495_p(blockPos2.func_177981_b(1)).func_185898_k() || chunk.func_180495_p(blockPos2.func_177981_b(2)).func_185898_k()) continue;
            double \u26034 = blockPos2.func_177957_d(0.0, 0.0, 0.0);
            if (\u26035 != null && !(\u26034 < \u26033)) continue;
            \u26035 = blockPos2;
            \u26033 = \u26034;
        }
        return \u26035;
    }

    private void func_195492_c(BlockPos blockPos2) {
        Feature.field_202299_as.func_212245_a(this.field_145850_b, this.field_145850_b.func_72863_F().func_201711_g(), new Random(), blockPos2, new EndGatewayConfig(false));
        TileEntity tileEntity = this.field_145850_b.func_175625_s(blockPos2);
        if (tileEntity instanceof TileEntityEndGateway) {
            TileEntityEndGateway tileEntityEndGateway = (TileEntityEndGateway)tileEntity;
            tileEntityEndGateway.field_195506_h = new BlockPos(this.func_174877_v());
            tileEntityEndGateway.func_70296_d();
        } else {
            BlockPos blockPos2;
            field_195503_a.warn("Couldn't save exit portal at {}", (Object)blockPos2);
        }
    }

    public void func_195489_b(BlockPos blockPos) {
        this.field_195507_i = true;
        this.field_195506_h = blockPos;
    }
}

