/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tileentity;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;

public class TileEntityConduit
extends TileEntity
implements ITickable {
    private static final Block[] field_205042_e = new Block[]{Blocks.field_180397_cI, Blocks.field_196779_gQ, Blocks.field_180398_cJ, Blocks.field_196781_gR};
    public int field_205041_a;
    private float field_205043_f;
    private boolean field_205045_h;
    private boolean field_207738_h;
    private final List<BlockPos> field_205046_i = Lists.newArrayList();
    private EntityLivingBase field_205047_j;
    private UUID field_205048_k;
    private long field_205740_k;

    public TileEntityConduit() {
        this(TileEntityType.field_205166_z);
    }

    public TileEntityConduit(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    @Override
    public void func_145839_a(NBTTagCompound nBTTagCompound) {
        super.func_145839_a(nBTTagCompound);
        this.field_205048_k = nBTTagCompound.func_74764_b("target_uuid") ? NBTUtil.func_186860_b(nBTTagCompound.func_74775_l("target_uuid")) : null;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nBTTagCompound) {
        super.func_189515_b(nBTTagCompound);
        if (this.field_205047_j != null) {
            nBTTagCompound.func_74782_a("target_uuid", NBTUtil.func_186862_a(this.field_205047_j.func_110124_au()));
        }
        return nBTTagCompound;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 5, this.func_189517_E_());
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void func_73660_a() {
        ++this.field_205041_a;
        long l = this.field_145850_b.func_82737_E();
        if (l % 40L == 0L) {
            this.func_205739_a(this.func_205038_d());
            if (!this.field_145850_b.field_72995_K && this.func_205039_c()) {
                this.func_205030_f();
                this.func_205031_h();
            }
        }
        if (l % 80L == 0L && this.func_205039_c()) {
            this.func_205738_a(SoundEvents.field_206934_aN);
        }
        if (l > this.field_205740_k && this.func_205039_c()) {
            this.field_205740_k = l + 60L + (long)this.field_145850_b.func_201674_k().nextInt(40);
            this.func_205738_a(SoundEvents.field_206935_aO);
        }
        if (this.field_145850_b.field_72995_K) {
            this.func_205040_i();
            this.func_205037_l();
            if (this.func_205039_c()) {
                this.field_205043_f += 1.0f;
            }
        }
    }

    private boolean func_205038_d() {
        int n;
        this.field_205046_i.clear();
        for (n = -1; n <= 1; ++n) {
            for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                for (\u2603 = -1; \u2603 <= 1; ++\u2603) {
                    BlockPos blockPos = this.field_174879_c.func_177982_a(n, \u2603, \u2603);
                    if (this.field_145850_b.func_201671_F(blockPos)) continue;
                    return false;
                }
            }
        }
        for (n = -2; n <= 2; ++n) {
            for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                for (\u2603 = -2; \u2603 <= 2; ++\u2603) {
                    \u2603 = Math.abs(n);
                    \u2603 = Math.abs(\u2603);
                    \u2603 = Math.abs(\u2603);
                    if (\u2603 <= 1 && \u2603 <= 1 && \u2603 <= 1 || (n != 0 || \u2603 != 2 && \u2603 != 2) && (\u2603 != 0 || \u2603 != 2 && \u2603 != 2) && (\u2603 != 0 || \u2603 != 2 && \u2603 != 2)) continue;
                    BlockPos blockPos = this.field_174879_c.func_177982_a(n, \u2603, \u2603);
                    IBlockState \u26032 = this.field_145850_b.func_180495_p(blockPos);
                    for (Block block : field_205042_e) {
                        if (\u26032.func_177230_c() != block) continue;
                        this.field_205046_i.add(blockPos);
                    }
                }
            }
        }
        this.func_207736_b(this.field_205046_i.size() >= 42);
        return this.field_205046_i.size() >= 16;
    }

    private void func_205030_f() {
        int n = this.field_205046_i.size();
        \u2603 = n / 7 * 16;
        \u2603 = this.field_174879_c.func_177958_n();
        AxisAlignedBB \u26032 = new AxisAlignedBB(\u2603, \u2603 = this.field_174879_c.func_177956_o(), \u2603 = this.field_174879_c.func_177952_p(), \u2603 + 1, \u2603 + 1, \u2603 + 1).func_186662_g(\u2603).func_72321_a(0.0, this.field_145850_b.func_72800_K(), 0.0);
        List<EntityPlayer> \u26033 = this.field_145850_b.func_72872_a(EntityPlayer.class, \u26032);
        if (\u26033.isEmpty()) {
            return;
        }
        for (EntityPlayer entityPlayer : \u26033) {
            BlockPos blockPos = new BlockPos(entityPlayer);
            if (!(this.field_174879_c.func_196233_m(blockPos) <= (double)\u2603) || !entityPlayer.func_70026_G()) continue;
            entityPlayer.func_195064_c(new PotionEffect(MobEffects.field_205136_C, 260, 0, true, true));
        }
    }

    private void func_205031_h() {
        List<EntityLivingBase> list;
        EntityLivingBase entityLivingBase2;
        block8: {
            block11: {
                block10: {
                    block9: {
                        block7: {
                            entityLivingBase2 = this.field_205047_j;
                            int \u26032 = this.field_205046_i.size();
                            if (\u26032 >= 42) break block7;
                            this.field_205047_j = null;
                            break block8;
                        }
                        if (this.field_205047_j != null || this.field_205048_k == null) break block9;
                        this.field_205047_j = this.func_205035_k();
                        this.field_205048_k = null;
                        break block8;
                    }
                    if (this.field_205047_j != null) break block10;
                    list = this.field_145850_b.func_175647_a(EntityLivingBase.class, this.func_205034_j(), entityLivingBase -> entityLivingBase instanceof IMob && entityLivingBase.func_70026_G());
                    if (!list.isEmpty()) {
                        this.field_205047_j = (EntityLivingBase)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
                    }
                    break block8;
                }
                if (!this.field_205047_j.func_70089_S()) break block11;
                BlockPos blockPos = new BlockPos(this.field_205047_j);
                if (!(this.field_174879_c.func_196233_m(blockPos) > 8.0)) break block8;
            }
            this.field_205047_j = null;
        }
        if (this.field_205047_j != null) {
            this.field_145850_b.func_184148_a(null, this.field_205047_j.field_70165_t, this.field_205047_j.field_70163_u, this.field_205047_j.field_70161_v, SoundEvents.field_206936_aP, SoundCategory.BLOCKS, 1.0f, 1.0f);
            this.field_205047_j.func_70097_a(DamageSource.field_76376_m, 4.0f);
        }
        if (entityLivingBase2 != this.field_205047_j) {
            list = this.func_195044_w();
            this.field_145850_b.func_184138_a(this.field_174879_c, (IBlockState)((Object)list), (IBlockState)((Object)list), 2);
        }
    }

    private void func_205040_i() {
        if (this.field_205048_k == null) {
            this.field_205047_j = null;
        } else if (this.field_205047_j == null || !this.field_205047_j.func_110124_au().equals(this.field_205048_k)) {
            this.field_205047_j = this.func_205035_k();
            if (this.field_205047_j == null) {
                this.field_205048_k = null;
            }
        }
    }

    private AxisAlignedBB func_205034_j() {
        int n = this.field_174879_c.func_177958_n();
        \u2603 = this.field_174879_c.func_177956_o();
        \u2603 = this.field_174879_c.func_177952_p();
        return new AxisAlignedBB(n, \u2603, \u2603, n + 1, \u2603 + 1, \u2603 + 1).func_186662_g(8.0);
    }

    @Nullable
    private EntityLivingBase func_205035_k() {
        List<EntityLivingBase> list = this.field_145850_b.func_175647_a(EntityLivingBase.class, this.func_205034_j(), entityLivingBase -> entityLivingBase.func_110124_au().equals(this.field_205048_k));
        if (list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    private void func_205037_l() {
        float \u26037;
        Random random = this.field_145850_b.field_73012_v;
        float \u26032 = MathHelper.func_76126_a((float)(this.field_205041_a + 35) * 0.1f) / 2.0f + 0.5f;
        \u26032 = (\u26032 * \u26032 + \u26032) * 0.3f;
        Vec3d \u26033 = new Vec3d((float)this.field_174879_c.func_177958_n() + 0.5f, (float)this.field_174879_c.func_177956_o() + 1.5f + \u26032, (float)this.field_174879_c.func_177952_p() + 0.5f);
        for (BlockPos blockPos : this.field_205046_i) {
            if (random.nextInt(50) != 0) continue;
            \u26037 = -0.5f + random.nextFloat();
            \u26038 = -2.0f + random.nextFloat();
            \u2603 = -0.5f + random.nextFloat();
            BlockPos \u26034 = blockPos.func_177973_b(this.field_174879_c);
            Vec3d \u26035 = new Vec3d(\u26037, \u26038, \u2603).func_72441_c(\u26034.func_177958_n(), \u26034.func_177956_o(), \u26034.func_177952_p());
            this.field_145850_b.func_195594_a(Particles.field_205167_W, \u26033.field_72450_a, \u26033.field_72448_b, \u26033.field_72449_c, \u26035.field_72450_a, \u26035.field_72448_b, \u26035.field_72449_c);
        }
        if (this.field_205047_j != null) {
            Vec3d vec3d = new Vec3d(this.field_205047_j.field_70165_t, this.field_205047_j.field_70163_u + (double)this.field_205047_j.func_70047_e(), this.field_205047_j.field_70161_v);
            float \u26036 = (-0.5f + random.nextFloat()) * (3.0f + this.field_205047_j.field_70130_N);
            \u26037 = -1.0f + random.nextFloat() * this.field_205047_j.field_70131_O;
            float \u26038 = (-0.5f + random.nextFloat()) * (3.0f + this.field_205047_j.field_70130_N);
            \u2603 = new Vec3d(\u26036, \u26037, \u26038);
            this.field_145850_b.func_195594_a(Particles.field_205167_W, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c, \u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c);
        }
    }

    public boolean func_205039_c() {
        return this.field_205045_h;
    }

    private void func_205739_a(boolean bl) {
        if (bl != this.field_205045_h) {
            this.func_205738_a(bl ? SoundEvents.field_206933_aM : SoundEvents.field_206937_aQ);
        }
        this.field_205045_h = bl;
    }

    private void func_207736_b(boolean bl) {
        this.field_207738_h = bl;
    }

    public void func_205738_a(SoundEvent soundEvent) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, soundEvent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }
}

