/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.state;

import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.state.IProperty;
import net.minecraft.state.IStateHolder;

public abstract class AbstractStateHolder<O, S>
implements IStateHolder<S> {
    private static final Function<Map.Entry<IProperty<?>, Comparable<?>>, String> field_177233_b = new Function<Map.Entry<IProperty<?>, Comparable<?>>, String>(){

        @Override
        public String apply(@Nullable Map.Entry<IProperty<?>, Comparable<?>> entry) {
            if (entry == null) {
                return "<NULL>";
            }
            IProperty<?> iProperty = entry.getKey();
            return iProperty.func_177701_a() + "=" + this.func_185886_a(iProperty, entry.getValue());
        }

        private <T extends Comparable<T>> String func_185886_a(IProperty<T> iProperty, Comparable<?> comparable) {
            return iProperty.func_177702_a(comparable);
        }

        @Override
        public /* synthetic */ Object apply(@Nullable Object object) {
            return this.apply((Map.Entry)object);
        }
    };
    protected final O field_206876_a;
    private final ImmutableMap<IProperty<?>, Comparable<?>> field_206877_c;
    private final int field_206878_d;
    private Table<IProperty<?>, Comparable<?>, S> field_206879_e;

    protected AbstractStateHolder(O o, ImmutableMap<IProperty<?>, Comparable<?>> immutableMap) {
        this.field_206876_a = o;
        this.field_206877_c = immutableMap;
        this.field_206878_d = immutableMap.hashCode();
    }

    @Override
    public <T extends Comparable<T>> S func_177231_a(IProperty<T> iProperty) {
        return this.func_206870_a(iProperty, (Comparable)AbstractStateHolder.func_177232_a(iProperty.func_177700_c(), this.func_177229_b(iProperty)));
    }

    protected static <T> T func_177232_a(Collection<T> collection, T t) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(t)) continue;
            if (iterator.hasNext()) {
                return iterator.next();
            }
            return collection.iterator().next();
        }
        return iterator.next();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.field_206876_a);
        if (!this.func_206871_b().isEmpty()) {
            stringBuilder.append('[');
            stringBuilder.append(this.func_206871_b().entrySet().stream().map(field_177233_b).collect(Collectors.joining(",")));
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    @Override
    public Collection<IProperty<?>> func_206869_a() {
        return Collections.unmodifiableCollection(this.field_206877_c.keySet());
    }

    @Override
    public <T extends Comparable<T>> boolean func_196959_b(IProperty<T> iProperty) {
        return this.field_206877_c.containsKey(iProperty);
    }

    @Override
    public <T extends Comparable<T>> T func_177229_b(IProperty<T> iProperty) {
        Comparable comparable = (Comparable)this.field_206877_c.get(iProperty);
        if (comparable == null) {
            throw new IllegalArgumentException("Cannot get property " + iProperty + " as it does not exist in " + this.field_206876_a);
        }
        return (T)((Comparable)iProperty.func_177699_b().cast(comparable));
    }

    @Override
    public <T extends Comparable<T>, V extends T> S func_206870_a(IProperty<T> iProperty, V v) {
        Comparable comparable = (Comparable)this.field_206877_c.get(iProperty);
        if (comparable == null) {
            throw new IllegalArgumentException("Cannot set property " + iProperty + " as it does not exist in " + this.field_206876_a);
        }
        if (comparable == v) {
            return (S)this;
        }
        Object \u26032 = this.field_206879_e.get(iProperty, v);
        if (\u26032 == null) {
            throw new IllegalArgumentException("Cannot set property " + iProperty + " to " + v + " on " + this.field_206876_a + ", it is not an allowed value");
        }
        return (S)\u26032;
    }

    public void func_206874_a(Map<Map<IProperty<?>, Comparable<?>>, S> map) {
        if (this.field_206879_e != null) {
            throw new IllegalStateException();
        }
        HashBasedTable hashBasedTable = HashBasedTable.create();
        for (Map.Entry entry : this.field_206877_c.entrySet()) {
            IProperty iProperty = (IProperty)entry.getKey();
            for (Comparable comparable : iProperty.func_177700_c()) {
                if (comparable == entry.getValue()) continue;
                hashBasedTable.put((Object)iProperty, (Object)comparable, map.get(this.func_206875_b(iProperty, comparable)));
            }
        }
        this.field_206879_e = hashBasedTable.isEmpty() ? hashBasedTable : ArrayTable.create((Table)hashBasedTable);
    }

    private Map<IProperty<?>, Comparable<?>> func_206875_b(IProperty<?> iProperty, Comparable<?> comparable) {
        HashMap hashMap = Maps.newHashMap(this.field_206877_c);
        hashMap.put(iProperty, comparable);
        return hashMap;
    }

    @Override
    public ImmutableMap<IProperty<?>, Comparable<?>> func_206871_b() {
        return this.field_206877_c;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.field_206878_d;
    }
}

